/*
 *  /vol/src/devel/gated/master/gated/src/isis_mib_tables.c,v 1.1 1993/01/07 22:39:42 jch Exp
 */

/*
**	isis_mib_tables.c
**
**	This file contains tables storing the isis mib and prodedures manipulating
**	the data.
**
**
**	John Chu <jychu@watson.ibm.com>
**
*/

/************************
*			*
*    Include Files 	*
*			*
************************/


#include "include.h"

#if	defined(PROTO_ISIS) && defined(PROTO_SNMP)


#include "isis_includes.h"
#include "isis_test.h"


#include "isis_mib.h"


/************************
*			*
*   External References *
*			*
************************/

extern Boolean l1HippityBit;
extern Boolean l2HippityBit;



/************************
*			*
*   Memory Allocation   *
*			*
************************/

/* Maximum Number of Area Addresses, per ISO/IEC 10589:1992 (E), 7.1.5 */
int	maximumAreaAddresses = MAXAREAADDRESSES;   /* at least 3, setable by sys mgmnt */


/* The IS-IS MIB all-instances table */
IsisMibTable 	isisMibTable;



/************************
*			*
*      Procedures	*
*			*
************************/


/*
**	Init Short or Long Octet String
*/
void initOctetString(poctetstring, maxsize)
LongOctetString	*poctetstring;
int		maxsize;
{
    poctetstring->len = 0;
    poctetstring->maxlen = maxsize;		/* per isis mib var defs */

} /* end of initOctetString() */


/*
**	Copy an octet string
*/
int copyOctetString(poctetstring, from, fromlen)
LongOctetString	*poctetstring;
unsigned char 	*from;
int		fromlen;
{
    int		lencopied;

    lencopied = ((unsigned short)fromlen <= poctetstring->maxlen)? fromlen :
								   poctetstring->maxlen;
    bcopy(from, poctetstring->contents, lencopied);

    return(poctetstring->len = lencopied);


} /* end of copyOctetString() */


/*
**	Extend an octet string
*/
int extendOctetString(poctetstring, from, fromlen)
LongOctetString	*poctetstring;
unsigned char 	*from;
int		fromlen;
{
    int		lencopied;

    lencopied = ((unsigned short)fromlen <= poctetstring->maxlen - poctetstring->len)? 
					fromlen :
					poctetstring->maxlen - poctetstring->len;

    bcopy(from, poctetstring->contents+poctetstring->len, lencopied);

    return(poctetstring->len += lencopied);


} /* end of extendOctetString() */


/*
**	Init the isis mib tables cold; per isis mib definition
*/
int initIsisMibCold()
{
    int		i,j,k,l;
    IsisMibEntry		*pMibEntry;
    IsisSysEntry	 	*pSysEntry;
    IsisManAreaAddrTable 	*pManAreaAddrTable;
    IsisManAreaAddrEntry 	*pManAreaAddrEntry;
    IsisAreaAddrTable 	 	*pAreaAddrTable;
    IsisAreaAddrEntry 	 	*pAreaAddrEntry;
    IsisCircTable		*pCircTable;
    IsisCircEntry		*pCircEntry;
    IsisISAdjTable		*pISAdjTable;
    IsisISAdjEntry	 	*pISAdjEntry;
    IsisISAdjAreaAddrTable	*pISAdjAreaAddrTable;
    IsisISAdjAreaAddrEntry	*pISAdjAreaAddrEntry;

    /* Zero out all tables of all instances */
    bzero(&isisMibTable, sizeof(IsisMibTable));		


    /* Initialize per instance entry */
    queueInit(&isisMibTable, MIBSYSTEM, MAXISISSYSINSTANCES);

    for (i = 0; i < MAXISISSYSINSTANCES; ++i) {	/* for all possible isis instances */
	pMibEntry = &isisMibTable.isisMibEntry[i];

	/* System Entry */
	pSysEntry = &pMibEntry->isisSysEntry;

	/* Octet strings */
	initOctetString(&pSysEntry->isisSysVersion,MAXOCTETSTRINGSIZESHORT);
	initOctetString(&pSysEntry->isisSysID, 8);
	initOctetString(&pSysEntry->isisSysAuthAreaTransPwd, 254);
	initOctetString(&pSysEntry->isisSysAuthDomainTransPwd, 254);

	/* Default valuse */
        pSysEntry->isisSysMaxPathSplits = 2;
        pSysEntry->isisSysMinLSPTransInt = 5;
        pSysEntry->isisSysMaxLSPGenInt = 900;
        pSysEntry->isisSysMinBroadLSPTransInt = 33;
        pSysEntry->isisSysCompSNPInt = 10;
        pSysEntry->isisSysOrigL1LSPBuffSize = 1492;
        pSysEntry->isisSysMaxAreaAddresses = 3;
        pSysEntry->isisSysMinLSPGenInt = 30;
        pSysEntry->isisSysPollESHelloRate = 50;
        pSysEntry->isisSysPartSNPInt = 2;
        pSysEntry->isisSysWaitTime = 60;
        pSysEntry->isisSysDRISISHelloTimer = 1;
        pSysEntry->isisSysOrigL2LSPBufSize = 1492;

	/* State variables */
       	pSysEntry->isisSysInstance = i + 1;
        pSysEntry->isisSysExistState = 1;	/* off */
        pSysEntry->isisSysOperState = 1;	/* off */
        pSysEntry->isisSysL1State = 1;	/* off */
        pSysEntry->isisSysL2State = 1;	/* off */


   	/* The Level 1 Manual Area Address Table */
    	pManAreaAddrTable = &pSysEntry->isisManAreaAddrTable;
        queueInit(pManAreaAddrTable, MIBMANAREAADDR, MAXAREAADDRESSES);

	for (j = 0; j < MAXAREAADDRESSES; ++j) {
	    
    	    pManAreaAddrEntry = &pManAreaAddrTable->isisManAreaAddrEntry[j];

	    /* Octet strings */
	    initOctetString(&pManAreaAddrEntry->isisManAreaAddr, 20);

	    /* State variables */
	    pManAreaAddrEntry->isisManAreaAddrSysInstance = i + 1;
	    pManAreaAddrEntry->isisManAreaAddrExistState = 1;
							/* off, at least one on */

  	} /* end of for all possible manual area addresses */


	/* The Level 1 Area Address Table */
    	pAreaAddrTable = &pSysEntry->isisAreaAddrTable;
        queueInit(pAreaAddrTable, MIBAREAADDR, MAXAREAADDRESSES);

	for (j = 0; j < MAXAREAADDRESSES; ++j) {
    	    pAreaAddrEntry = &pAreaAddrTable->isisAreaAddrEntry[j];

	    /* Octet strings */
	    initOctetString(&pAreaAddrEntry->isisAreaAddr, 20);

	    /* State variables */
	    pAreaAddrEntry->isisAreaAddrSysInstance = i + 1;


  	} /* end of for all possible area addresses */


	/* Circuit Table */
	pCircTable = &pMibEntry->isisCircTable;
     	queueInit(pCircTable, MIBCIRCUIT, MAXCIRCSPERINSTANCE);

	for (j = 0; j < MAXCIRCSPERINSTANCE; ++j) {
	    pCircEntry = &pCircTable->isisCircEntry[j];
	    
	    /* Octet strings */
	    initOctetString(&pCircEntry->isisCircL1CircID, 9);
	    initOctetString(&pCircEntry->isisCircL1DesIS, 8);
	    initOctetString(&pCircEntry->isisCircL2CircID, 9);
	    initOctetString(&pCircEntry->isisCircL2DesIS, 9);
	    initOctetString(&pCircEntry->isisCircPtToPtCircID, 9);
	    initOctetString(&pCircEntry->isisCircAuthTransPwd, 254);

	    /* State variables */
	    pCircEntry->isisCircSysInstance = i + 1;
	    pCircEntry->isisCircIndex = j + 1;
	    pCircEntry->isisCircOperState = 1;
	    pCircEntry->isisCircExistState = 1;

	    /* Default values */
	    pCircEntry->isisCircISISHelloTimer = 3;
    	    pCircEntry->isisCircL1DefaultMetric = 20;
	    pCircEntry->isisCircL1DelayMetric = 0;
	    pCircEntry->isisCircL1ExpenseMetric = 0;
	    pCircEntry->isisCircL1ErrorMetric = 0;
	    pCircEntry->isisCircL2DefaultMetric = 20;
	    pCircEntry->isisCircL2DelayMetric = 0;
	    pCircEntry->isisCircL2ExpenseMetric = 0;
	    pCircEntry->isisCircL2ErrorMetric = 0;
	    pCircEntry->isisCircManL2Only = 1;
	    pCircEntry->isisCircL1ISPriority = 64;
	    pCircEntry->isisCircL2ISPriority = 64;
	    pCircEntry->isisCircDACallDefMetInc = 0;
	    pCircEntry->isisCircDACallDelMetInc = 0;
	    pCircEntry->isisCircDACallErrMetInc = 0;
	    pCircEntry->isisCircDACallExpMetInc = 0;	    

	    /* IS Adjacency Table */
	    pISAdjTable = &pCircEntry->isisISAdjTable;
	    queueInit(pISAdjTable, MIBISADJ, MAXISADJPERCIRC);
	    
	    for (k = 0; k < MAXISADJPERCIRC; ++k) {
		pISAdjEntry = &pISAdjTable->isisISAdjEntry[k];

		/* Octet strings */
		initOctetString(&pISAdjEntry->isisISAdjNeighSNPAAddress, MAXOCTETSTRINGSIZESHORT);		
	        initOctetString(&pISAdjEntry->isisISAdjNeighSysID, 9);

		/* State variables */
		pISAdjEntry->isisISAdjSysInstance = i + 1;
		pISAdjEntry->isisISAdjCircIndex = j + 1;
		pISAdjEntry->isisISAdjIndex = k + 1;
		pISAdjEntry->isisISAdjState = 4;		/* down */


		/* IS Adjacency Area Address Table */
		pISAdjAreaAddrTable = &pISAdjEntry->isisISAdjAreaAddrTable;
		queueInit(pISAdjAreaAddrTable, MIBISADJAREAADDR, MAXAREAADDRESSESPERISADJ);

		for (l = 0; l < MAXAREAADDRESSESPERISADJ; ++l) {
		    pISAdjAreaAddrEntry = &pISAdjAreaAddrTable->isisISAdjAreaAddrEntry[l];
		
		    /* Octet strings */
		    initOctetString(&pISAdjAreaAddrEntry->isisISAdjAreaAddress, 20);

		    /* State variables */
		    pISAdjAreaAddrEntry->isisISAdjAreaAddrSysInstance = i + 1;
		    pISAdjAreaAddrEntry->isisISAdjAreaAddrCircIndex = j + 1;
		    pISAdjAreaAddrEntry->isisISAdjAreaAddrAdjIndex = k + 1;


		} /* end of for all possible IS adj area addresses */

	    } /* end of for all possible IS adjacencies */

	} /* end of for all possible circuits */

    } /* end of for all possible instances */



} /* end of initIsisMibCold() */


/*
**	Init the isis mib tables cool; for the isis systems running
*/
int initIsisMibCool()
{
    int		nSystems=1;		/* one isis system now */
    int		i;
    IsisMibEntry	*pMibEntry;
    IsisSysEntry	*pSysEntry;

    for (i = 0; i < nSystems; ++i) {
        /* Get a new IS system-wide mib entry */
        if ((pMibEntry = (IsisMibEntry *)queueNew(&isisMibTable)) == 
							(IsisMibEntry *)NULL) {

	    return(-1);
        }

        pSysEntry = &pMibEntry->isisSysEntry;


        /* Fill the system entry */
						/* Sys Instance has been assigned */
        pSysEntry->isisSysExistState = 2;	/* valid for an IS-IS system */


        /* Add the system-wide mib entry to its table */
        if (queueAdd(&isisMibTable, pMibEntry)) {

       	    return(-1);
        }



    } /* end of for all isis systems running */


    return(0);

} /* end of initIsisMibCool() */




/*
**	Init the isis mib tables warm; per the isis system running
*/
int 
initIsisMibWarm __PF1(initial_isis_config, int)
{
    int			i,j,k;
    IsisMibEntry	*pMibEntry;
    IsisSysEntry	*pSysEntry;
    IsisManAreaAddrTable *pManAreaAddrTable;
    IsisManAreaAddrEntry *pManAreaAddrEntry;
    IsisAreaAddrTable 	*pAreaAddrTable;
    IsisAreaAddrEntry 	*pAreaAddrEntry;
    IsisCircTable	*pCircTable;
    IsisCircEntry	*pCircEntry;    
    CircuitEntry	*pcirc;		/* to ckt control block def'ed in isis.h */
    IsisISAdjTable	*pISAdjTable;
    IsisISAdjEntry	*pISAdjEntry;
    IsisISAdjAreaAddrTable	*pISAdjAreaAddrTable;
    IsisISAdjAreaAddrEntry	*pISAdjAreaAddrEntry;


    /* Get the only IS system-wide mib entry */
    if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, 1)) == 
							(IsisMibEntry *)NULL) {

	return(-1);
    }

    pSysEntry = &pMibEntry->isisSysEntry;


    /* Fill the system entry */
						/* Sys Instance has been assigned */
    						/* existState on */

    pSysEntry->isisSysVersion.contents[0] = Version;	/* in isis_base.h */
    pSysEntry->isisSysVersion.len = 1;

    if (systemType == L1IS) pSysEntry->isisSysType = 1;
    else if (systemType == L2IS) pSysEntry->isisSysType = 2;
    else pSysEntry->isisSysType = 0;

    copyOctetString(&pSysEntry->isisSysID, systemID, 6); 

/* 	Integer         isisSysMaxPathSplits; */

    pSysEntry->isisSysMinLSPTransInt = minLSPXmitInterval;

    pSysEntry->isisSysMaxLSPGenInt = maxLSPGenInterval;

    pSysEntry->isisSysMinBroadLSPTransInt = minBLSPXmitInterval; 

    pSysEntry->isisSysCompSNPInt = completeSNPInterval;

    pSysEntry->isisSysOrigL1LSPBuffSize = origL1LSPBufSize;

    pSysEntry->isisSysMaxAreaAddresses = MaximumAreaAddresses;

    pSysEntry->isisSysMinLSPGenInt = minLSPGenInterval;

    pSysEntry->isisSysPollESHelloRate = sysPollESHelloRate;

    pSysEntry->isisSysPartSNPInt = partialSNPInterval;

    pSysEntry->isisSysWaitTime = waitingTime;

    pSysEntry->isisSysDRISISHelloTimer = sysDRIIHInterval;

    pSysEntry->isisSysOperState = 2;			/* set it on */

    if (l1HippityBit == True) pSysEntry->isisSysL1State = 3;   	/* wait */
    else if (L1LSP) pSysEntry->isisSysL1State = 2;		/* on   */
    else pSysEntry->isisSysL1State = 1;				/* off  */

    pSysEntry->isisSysCorrLSPs = isisCounters.corruptLSPDetected;

    pSysEntry->isisSysLSPL1DbaseOloads = isisCounters.l1LSPOverload;

    pSysEntry->isisSysManAddrDropFromAreas = isisCounters.manualAreaDropped;

    pSysEntry->isisSysAttemptToExMaxSeqNums = isisCounters.exceedSeqNum;

    pSysEntry->isisSysSeqNumSkips = isisCounters.seqNumSkipped;

    pSysEntry->isisSysOwnLSPPurges = isisCounters.purgeOwnLSP;

/*
        Counter         isisSysIDFieldLenMismatches;
        Counter         isisSysMaxAreaAddrMismatches;
*/

    pSysEntry->isisSysOrigL2LSPBufSize = origL2LSPBufSize;

    if (l2HippityBit == True) pSysEntry->isisSysL2State = 3;   	/* wait */
    else if (L2LSP) pSysEntry->isisSysL2State = 2;		/* on   */
    else pSysEntry->isisSysL2State = 1;				/* off  */

    pSysEntry->isisSysLSPL2DbaseOloads = isisCounters.l2LSPOverload;

/*
        LongOctetString isisSysAuthAreaTransPwd;
	LongOctetString isisSysAuthDomainTransPwd;
        Counter         isisSysAuthFails;
*/


    pManAreaAddrTable = &pSysEntry->isisManAreaAddrTable;
    /* Fill the manual area address table */
    if (initial_isis_config) {
    /* STEVE XXX - fix this to deal with reconfigs */
    for (i = 0; i < MAXAREAADDRESSES && i < systemAreaAddrs.count; ++i) {
	AreaAddr	*pAreaAddr;

        if ((pManAreaAddrEntry = (IsisManAreaAddrEntry *)queueNew(pManAreaAddrTable)) ==
							  (IsisManAreaAddrEntry *)NULL) {

 	    break;
        }

/*	Integer		isisManAreaAddrSysInstance; */

	pAreaAddr = retrieveAreaAddr(systemAreaAddrs.areaAddr[i]);
        copyOctetString(&pManAreaAddrEntry->isisManAreaAddr, 
			pAreaAddr->addr, pAreaAddr->len     );

    
      	pManAreaAddrEntry->isisManAreaAddrExistState = 2;

        if (queueAdd(pManAreaAddrTable, pManAreaAddrEntry)) {

	    return(-1);
        }

    }

    pAreaAddrTable = &pSysEntry->isisAreaAddrTable;
    /* Fill the area address table */
    for (i = 0; i < MAXAREAADDRESSES; ++i) {
        if ((pAreaAddrEntry = (IsisAreaAddrEntry *)queueNew(pAreaAddrTable)) ==
							(IsisAreaAddrEntry *)NULL) {

	    break;
        }
/*
	Integer		isisAreaAddrSysInstance;
        OSINSAddress    isisAreaAddr;
*/
        if (queueAdd(pAreaAddrTable, pAreaAddrEntry)) {
 
	    return(-1);
        }
    }
    }	/* initial_isis_config */

    pCircTable = &pMibEntry->isisCircTable;
    /* Fill the circuit table */
    for (i = 0; i < MAXCIRCSPERINSTANCE; ++i) {
	if ((pcirc = circuitList[i]) == NULL) continue;
        /* Locate circuit entry from the circuit table */
        if ((pCircEntry = (IsisCircEntry *)locateEntry(pCircTable, 
						       pcirc->localId)) == 
							(IsisCircEntry *)NULL) {

  	    continue;	/* STEVE XXX - silently ignore this? */
        }    


/*
	Integer                isisCircSysInstance;
	Integer                isisCircIndex;
*/
	pCircEntry->isisCircIfIndex = pcirc->kernindex;

	pCircEntry->isisCircOperState = (pcirc->up)? 2 : 1;

/*      isisCircExistState		has been assigned in isis_set_circuit() */

        switch (pcirc->circuitType) {
	case Broadcast: pCircEntry->isisCircType = 1; break;
	case Pt2Pt: 	pCircEntry->isisCircType = 2; break;
       	default: 	pCircEntry->isisCircType = 0; break;
        }

	pCircEntry->isisCircISISHelloTimer = pcirc->ISIShelloInterval;

	pCircEntry->isisCircL1DefaultMetric = pcirc->l1Metric.defalt & 0x3f;
	pCircEntry->isisCircL1DelayMetric   = pcirc->l1Metric.delay & 0x3f;
	pCircEntry->isisCircL1ExpenseMetric = pcirc->l1Metric.expense & 0x3f;
	pCircEntry->isisCircL1ErrorMetric   = pcirc->l1Metric.error & 0x3f;

	pCircEntry->isisCircExtDomain = 1;		/* false */

        pCircEntry->isisCircAdjChanges = pcirc->adjacencyEvents;

        pCircEntry->isisCircInitFails = pcirc->initFailures;

        pCircEntry->isisCircRejAdjs = pcirc->rejAdjs;

        pCircEntry->isisCircOutCtrlPDUs = pcirc->pdusSent;	/* control puds ??? */
        pCircEntry->isisCircInCtrlPDUs = pcirc->pdusReceived;	/* control pdus ??? */

/*
        Counter                isisCircIDFieldLenMismatches;
        Counter                isisCircMaxAreaAddrMismatches;
*/

	pCircEntry->isisCircL2DefaultMetric = pcirc->l2Metric.defalt & 0x3f;
	pCircEntry->isisCircL2DelayMetric   = pcirc->l2Metric.delay & 0x3f;
	pCircEntry->isisCircL2ExpenseMetric = pcirc->l2Metric.expense & 0x3f;
	pCircEntry->isisCircL2ErrorMetric   = pcirc->l2Metric.error & 0x3f;

	if (pcirc->manualL2Only == True) pCircEntry->isisCircManL2Only = 2;
	else pCircEntry->isisCircManL2Only = 1;

	pCircEntry->isisCircL1ISPriority = pcirc->l1Priority;

	copyOctetString(&pCircEntry->isisCircL1CircID, pcirc->circuitId, 7);


	copyOctetString(&pCircEntry->isisCircL1DesIS, pcirc->circuitId, 7);

        pCircEntry->isisCircLANL1DesISChanges = pcirc->l1DesignateChanges; /* planting */


	pCircEntry->isisCircL2ISPriority = pcirc->l2Priority;

	copyOctetString(&pCircEntry->isisCircL2CircID, pcirc->l2CircuitId, 7);

	copyOctetString(&pCircEntry->isisCircL2DesIS, pcirc->l2CircuitId, 7);

        pCircEntry->isisCircLANL2DesISChanges = pcirc->l2DesignateChanges;


/*	ShortOctetString       isisCircPtToPtCircID;
	ObjectIdentifier       isisCircStaticCallInfo;
	Integer                isisCircDACallDefMetInc;
	Integer                isisCircDACallDelMetInc;
	Integer                isisCircDACallErrMetInc;
	Integer                isisCircDACallExpMetInc;
	LongOctetString        isisCircAuthTransPwd;
        Counter                isisCircAuthFails;
*/

	/* STEVE XXX - fix this to deal with reconfigs too */
	pISAdjTable = &pCircEntry->isisISAdjTable;
        /* Fill the IS adj table */
	for (j = 0; j < MAXISADJPERCIRC; ++j) {
            if ((pISAdjEntry = (IsisISAdjEntry *)locateEntry(pISAdjTable, j+1)) ==
							    (IsisISAdjEntry *)NULL) {

	        break;
            }
/*
	Integer                isisISAdjSysInstance;
	Integer                isisISAdjCircIndex;
	Integer                isisISAdjIndex;
	Integer                isisISAdjState;
	ShortOctetString       isisISAdjNeighSNPAAddress;
	Integer                isisISAdjNeighSysType;
	ShortOctetString       isisISAdjNeighSysID;
	Integer                isisISAdjUsage;
	Integer                isisISAdjHoldTimer;
	Integer                isisISAdjNeighPriority;
*/


	    pISAdjAreaAddrTable = &pISAdjEntry->isisISAdjAreaAddrTable;
	    /* Fill the IS adj area address table */
	    for (k = 0; k < MAXAREAADDRESSESPERISADJ; ++k) {
                if ((pISAdjAreaAddrEntry = 
		    (IsisISAdjAreaAddrEntry *)queueNew(pISAdjAreaAddrTable)) ==
							(IsisISAdjAreaAddrEntry *)NULL) {

	            break;
                }
/*
	Integer 	isisISAdjAreaAddrSysInstance;
	Integer         isisISAdjAreaAddrCircIndex;
	Integer         isisISAdjAreaAddrAdjIndex;
        OSINSAddress    isisISAdjAreaAddress;
*/
                if (queueAdd(pISAdjAreaAddrTable, pISAdjAreaAddrEntry)) {
 
	            return(-1);
                }

	    }


    	} /* end of for all existing adjacencies */


    } /* end of for all existing circuits */



    return(0);



} /* end of initIsisMibWarm() */


/*
**	Locate a table entry by the instance, given the table
*/
unsigned char *
locateEntry(pq, key)
Queue		*pq;
int		key;
{
    int 	i;
    int		nentries=pq->nentries;
    int		found=FALSE;

    switch (pq->mib) {
    case MIBSYSTEM:
	for (i = 0; i < nentries; ++i) 
	    if (key == ((IsisMibEntry *)(pq->pentry[i]))->isisSysEntry.isisSysInstance) {
		found = TRUE;
		break;
	    }
	break;

    case MIBMANAREAADDR:
        if (key && key <= nentries) {	
	    return(pq->pentry[key-1]);
        }
        else {
	    return((unsigned char *)0);

        }

    case MIBAREAADDR:
        if (key && key <= nentries) {	
	    return(pq->pentry[key-1]);
        }
        else {
	    return((unsigned char *)0);

        }

    case MIBCIRCUIT:
	for (i = 0; i < nentries; ++i) 
	    if (key == ((IsisCircEntry *)(pq->pentry[i]))->isisCircIndex) {
		found = TRUE;
		break;
	    }
	break;

    case MIBISADJ:
	for (i = 0; i < nentries; ++i) 
	    if (key == ((IsisISAdjEntry *)(pq->pentry[i]))->isisISAdjIndex) {
		found = TRUE;
		break;
	    }
	break;

    case MIBISADJAREAADDR:
        if (key && key <= nentries) {	
	    return(pq->pentry[key-1]);
        }
        else {
	    return((unsigned char *)0);

        }

    default:
	break;

    }

    
    if (found) {
	return(pq->pentry[i]);
    }
    else {
	return((unsigned char *)0);
    }


} /* end of locateEntry() */



/*
**	Locate the next table entry by instance, given the table
*/
unsigned char *locateNextEntry(pq, key)
Queue	*pq;
int	key;
{
    if (key < pq->nentries) {	
	return(pq->pentry[key]);

    }
    else {
	return((unsigned char *)0);

    }

} /* end of locateNextEntry() */






/*
**	Search for the entry specified in staircase.  If found, return it.
**	Else, search for the next in tree.  If found, return it. Else,
**	return null.
*/
unsigned char * searchEntry(staircase, height, depth, pTable)
unsigned int	staircase[];
unsigned int	height;			/* MUST BE [1, 4] */
unsigned int	depth;			/* MUST BE [1, 4] */
unsigned char 	*pTable;
{
    unsigned char *pEntry;

    if (depth == 0 || depth > 4) return((unsigned char *)0);
    if (height == 0 || height > 4) return((unsigned char *)0);

    if (staircase[depth-1] == 0) staircase[depth-1] = 1;

    if (pEntry = locateEntry(pTable, staircase[depth-1])) {

        if (depth == height) return(pEntry);	/* found one */

	switch (depth) {
	case 1:			/* Mib instance */
	    pTable = (unsigned char *)&((IsisMibEntry *)pEntry)->isisCircTable;
	    break;
	case 2:			/* Circuit */
	    pTable = (unsigned char *)&((IsisCircEntry *)pEntry)->isisISAdjTable;
	    break;
	case 3:			/* IS Adjacency */
	    pTable = (unsigned char *)&((IsisISAdjEntry *)pEntry)->isisISAdjAreaAddrTable;
	    break;
  	}

	return searchEntry(staircase, height, depth+1, pTable);	/* forward */

    }
    else {
	staircase[depth-1] = 0;		/* didn't find it on this level */

	if (depth == 1) return((unsigned char *)0);

	staircase[depth-2] += 1;	/* breadth */
	return searchEntry(staircase, height, depth-1, pTable);	 /* backtrack */

    }


} /* end of searchEntry() */





/* Sorted-Queue related routines */


/*
**	Initialize a queue
*/
void 
queueInit(pq, mib, maxentries)
Queue	*pq;
int	mib;
int	maxentries;
{
    int		i;

    pq->mib = mib;
    pq->nentries = 0;
    pq->maxentries = maxentries;

    switch (mib) {
    case MIBSYSTEM:
	for (i = 0; i < maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisMibTable *)pq)->isisMibEntry[i];

	break;

    case MIBMANAREAADDR:
	for (i = 0; i < maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisManAreaAddrTable *)pq)->isisManAreaAddrEntry[i];

	break;

    case MIBAREAADDR:
	for (i = 0; i < maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisAreaAddrTable *)pq)->isisAreaAddrEntry[i];

	break;

    case MIBCIRCUIT:
	for (i = 0; i < maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisCircTable *)pq)->isisCircEntry[i];

	break;

    case MIBISADJ:
	for (i = 0; i < maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisISAdjTable *)pq)->isisISAdjEntry[i];

	break;

    case MIBISADJAREAADDR:
	for (i = 0; i < maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisISAdjAreaAddrTable *)pq)->isisISAdjAreaAddrEntry[i];

	break;

    default:
	break;

    }


} /* end of queueInit() */


/*
**	Get a new entry from a table; must be paired with queueAdd()
*/
unsigned char *queueNew(pq)
Queue	*pq;
{
    if (pq->nentries < pq->maxentries) {
	return(pq->pentry[pq->nentries]);
    }
    else {
	return((unsigned char *)0);
    }


} /* end of queueNew() */


/*
**	Add a new entry to a table; must be paired with queueNew()
*/
int queueAdd(pq, pentry)
Queue	*pq;
unsigned char *pentry;			/* ptr to entry to be added */
{
    int		i;
    int		found;		/* found the availabe entry */

    for (i = pq->nentries, found = FALSE; i < pq->maxentries; ++i) {
	if (pq->pentry[i] == pentry) {
	    found = TRUE;
	    break;
	}
    }
    
    if (found) {		/* immediately following the bucket */
	++pq->nentries;		/* enclose it into the bucket */
        
	switch (pq->mib) {
	case MIBSYSTEM:
	    qsort(pq->pentry, pq->nentries, sizeof *(pq->pentry), cmpSysEntry);
	    break;

	case MIBMANAREAADDR:
	    qsort(pq->pentry, pq->nentries, sizeof *(pq->pentry), cmpManAreaAddrEntry);
	    break;

	case MIBAREAADDR:
	    qsort(pq->pentry, pq->nentries, sizeof *(pq->pentry), cmpAreaAddrEntry);
	    break;

	case MIBCIRCUIT:
	    qsort(pq->pentry, pq->nentries, sizeof *(pq->pentry), cmpCircEntry);
	    break;

	case MIBISADJ:
	    qsort(pq->pentry, pq->nentries, sizeof *(pq->pentry), cmpISAdjEntry);
	    break;

	case MIBISADJAREAADDR:
	    qsort(pq->pentry, pq->nentries, sizeof *(pq->pentry), cmpISAdjAreaAddrEntry);
	    break;

	default:
	    --pq->nentries;
	    return(-1);

	}

	return(0);
    }
    else {
	return(-1);

    }
    

} /* end of queueAdd() */


/*
**	Comparison routines, by entry type
*/
int cmpSysEntry(a, b)
IsisSysEntry	**a;
IsisSysEntry	**b;
{
    if ((*a)->isisSysInstance < (*b)->isisSysInstance) return(-1);
    else if ((*a)->isisSysInstance > (*b)->isisSysInstance) return(1);
    else return(0);
}

int cmpManAreaAddrEntry(a, b)
IsisManAreaAddrEntry	**a;
IsisManAreaAddrEntry	**b;
{
    return(-1);
}

int cmpAreaAddrEntry(a, b)
IsisAreaAddrEntry	**a;
IsisAreaAddrEntry	**b;
{
    return(-1);
}


int cmpCircEntry(a, b)
IsisCircEntry	**a;
IsisCircEntry	**b;
{
    if ((*a)->isisCircIndex < (*b)->isisCircIndex) return(-1);
    else if ((*a)->isisCircIndex > (*b)->isisCircIndex) return(1);
    else return(0);
}


int cmpISAdjEntry(a, b)
IsisISAdjEntry	**a;
IsisISAdjEntry	**b;
{
    if ((*a)->isisISAdjIndex < (*b)->isisISAdjIndex) return(-1);
    else if ((*a)->isisISAdjIndex > (*b)->isisISAdjIndex) return(1);
    else return(0);



}


int cmpISAdjAreaAddrEntry(a, b)
IsisISAdjAreaAddrEntry	**a;
IsisISAdjAreaAddrEntry	**b;
{
    return(-1);
}





/* 
**	Delete an entry from a table
*/
int queueDelete(pq, pentry)
Queue	*pq;
unsigned char *pentry;		/* ptr to entry to be deleted from table */
{
    int		i, found;
    unsigned char *temp;

    for (i = 0, found = FALSE; i < pq->nentries; ++i) {
    	if (pq->pentry[i] == pentry) {
	    found = TRUE;		/* found entry to be deleted */
	    break;
	}
    }

    if (found) {
	for (; i < pq->nentries; ++i) {
	    pq->pentry[i] = pq->pentry[i+1];
     	}
	--pq->nentries;
        pq->pentry[pq->nentries] = pentry;

	return(0);			/* deleted the entry from table */
    }
    else {
	return(-1);			/* didn't find the entry */

    }

} /* end of queueDelete() */



/*
**	Flush a table
*/
void queueFlush(pq)
Queue	*pq;
{
    int		i;

    pq->nentries = 0;

    switch (pq->mib) {
    case MIBSYSTEM:
	for (i = 0; i < pq->maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisMibTable *)pq)->isisMibEntry[i];

	break;

    case MIBMANAREAADDR:
	for (i = 0; i < pq->maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisManAreaAddrTable *)pq)->isisManAreaAddrEntry[i];

	break;

    case MIBAREAADDR:
	for (i = 0; i < pq->maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisAreaAddrTable *)pq)->isisAreaAddrEntry[i];

	break;

    case MIBCIRCUIT:
	for (i = 0; i < pq->maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisCircTable *)pq)->isisCircEntry[i];

	break;

    case MIBISADJ:
	for (i = 0; i < pq->maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisISAdjTable *)pq)->isisISAdjEntry[i];

	break;

    case MIBISADJAREAADDR:
	for (i = 0; i < pq->maxentries; ++i) 
	    pq->pentry[i] = (unsigned char *)&((IsisISAdjAreaAddrTable *)pq)->isisISAdjAreaAddrEntry[i];

	break;

    defualt:
	break;

    }

} /* end of queueFlush() */



/*
**	Fresh an IS Adj Table entry by a gated isis AdjacencyEntry
*/
int freshISAdjEntry(pISAdjEntry, padj)
IsisISAdjEntry		*pISAdjEntry;
AdjacencyEntry		*padj;
{
    switch (padj->state) {
    case AdjInitializing:
	pISAdjEntry->isisISAdjState = 1; break;
    case AdjUp:
   	pISAdjEntry->isisISAdjState = 2; break;
    case AdjFailed:
	pISAdjEntry->isisISAdjState = 3; break;
    default:
	pISAdjEntry->isisISAdjState = 4; break;
    }

    copyOctetString(&pISAdjEntry->isisISAdjNeighSNPAAddress, padj->neighborMAC, 6);

    switch (padj->adjacencyType) {
    case Unknown: pISAdjEntry->isisISAdjNeighSysType = 1; break;
    case ES:	  pISAdjEntry->isisISAdjNeighSysType = 2; break;
    case IS:      pISAdjEntry->isisISAdjNeighSysType = 3; break;
    case L1IS:    pISAdjEntry->isisISAdjNeighSysType = 4; break;
    case L2IS:    pISAdjEntry->isisISAdjNeighSysType = 5; break;
    defualt:      pISAdjEntry->isisISAdjNeighSysType = 0; break;
    }

    copyOctetString(&pISAdjEntry->isisISAdjNeighSysID, padj->neighborSysID, 6);

    pISAdjEntry->isisISAdjUsage = 1;		/* unknown for now */

    pISAdjEntry->isisISAdjHoldTimer = padj->holdingTime;

    pISAdjEntry->isisISAdjNeighPriority = padj->LANPriority;


    return(0);

} /* end of freshISAdjEntry() */





/*
**	Fresh an IS Adj Area Address Table by a gated isis AdjacencyEntry.neighborInfo
*/
int freshISAdjAreaAddrTable(pISAdjEntry, padj)
IsisISAdjEntry		*pISAdjEntry;
AdjacencyEntry		*padj;
{
    int				i;
    IsisISAdjAreaAddrTable	*pISAdjAATable;
    IsisISAdjAreaAddrEntry	*pISAdjAAEntry;
    AreaAddrList		*pAAList;
    AreaAddr			*pAA;

    pISAdjAATable = &pISAdjEntry->isisISAdjAreaAddrTable;

    queueFlush(pISAdjAATable);

    if (padj->numIds) {		/* neighbor is ES */
	for (i = 0; i < padj->numIds; ++i) {
	    pISAdjAAEntry = (IsisISAdjAreaAddrEntry *)queueNew(pISAdjAATable);

	    if (pISAdjAAEntry) {
		copyOctetString(&pISAdjAAEntry->isisISAdjAreaAddress, 
				padj->neighborInfo+(6*i), 6          );
			       
		queueAdd(pISAdjAATable, pISAdjAAEntry);
	    }
	    else {
		trace(TR_ISIS, LOG_ERR, "freshISAdjAreaAddrTable: cannot allocate IS adj area address Entry");
		return(-1);

	    }
	}
    }
    else {			/* neighbor is IS */
	pAAList = (AreaAddrList *)padj->neighborInfo;

	for (i = 0; i < pAAList->count; ++i) {
	    pISAdjAAEntry = (IsisISAdjAreaAddrEntry *)queueNew(pISAdjAATable);

	    if (pISAdjAAEntry) {
		pAA = retrieveAreaAddr(pAAList->areaAddr[i]);
		copyOctetString(&pISAdjAAEntry->isisISAdjAreaAddress, 
							pAA->addr, pAA->len);
			       
		queueAdd(pISAdjAATable, pISAdjAAEntry);
	    }
	    else {
		trace(TR_ISIS, LOG_ERR, "freshISAdjAreaAddrTable(): cannot allocate IS adj area address Entry");
		return(-1);

	    }

      	}

    }

    return(0);

} /* end of freshISAdjAreaAddrTable() */








#endif	/* defined(PROTO_ISIS) && defined(PROTO_SNMP) */

/* end of isis_mib_tables.c */
