/*
 *  krt_rt_ioctl.c,v 1.1.2.1 1994/01/26 23:28:48 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#define	INCLUDE_IOCTL
#define	INCLUDE_ROUTE
#include "include.h"
#ifdef	PROTO_INET
#include "inet.h"
#endif	/* PROTO_INET */
#ifdef	PROTO_ISO
#include "iso.h"
#endif	/* PROTO_ISO */
#include "krt.h"
#include "krt_var.h"


int
krt_request __PF3(type, u_int,
		  rt, rt_entry *,
		  router, sockaddr_un *)
{
    int request_error = 0;
    int do_ioctl = !BIT_TEST(task_state, TASKS_TEST) && krt_install;
    struct rtentry krt;

    tracef("KERNEL %-6s %-15A",
	   (type == RTM_ADD) ? "ADD" : "DELETE",
	   rt->rt_dest);

    if (rt->rt_dest_mask) {
	tracef(" mask %-15A",
	       rt->rt_dest_mask);
    }

    tracef(" gateway %-15A %s <%s>",
	   router,
	   trace_state(rt_proto_bits, rt->rt_gwp->gw_proto),
	   trace_bits(rt_state_bits, rt->rt_state));

    bzero((caddr_t) & krt, sizeof(krt));
    krt.rt_dst = *sock2unix(rt->rt_dest, (int *) 0);	/* struct copy */
    krt.rt_gateway = *sock2unix(router, (int *) 0);	/* struct copy */
    krt.rt_flags = krt_state_to_flags(rt->rt_state);
    if (sockishost(rt->rt_dest, rt->rt_dest_mask)) {
	BIT_SET(krt.rt_flags, RTF_HOST);
    }
    if (rt->rt_ifap
	&& BIT_TEST(rt->rt_ifap->ifa_state, IFS_UP)) {
	BIT_SET(krt.rt_flags, RTF_UP);
    }
#ifdef	RTF_DYNAMIC
    if (rt->rt_gwp->gw_proto == RTPROTO_REDIRECT) {
	BIT_SET(krt.rt_flags, RTF_DYNAMIC);
    }
#endif	/* RTF_DYNAMIC */

    if (do_ioctl
	&& (task_ioctl(krt_task->task_socket, type, (caddr_t) &krt, sizeof (krt)) < 0)) {
	int pri = LOG_ERR;

	if (!BIT_TEST(krt.rt_flags, RTF_GATEWAY)
	    && ((errno == EEXIST && type == RTM_ADD)
		|| (errno == ESRCH && type == RTM_DELETE))) {
	    /* A request to change an interface route that was */
	    /* probably already changed */

	    pri = LOG_NOTICE;
	}

	request_error = errno;
	trace(TR_ALL | TR_NOSTAMP, pri, " SIOC%sRT: %m",
	      (type == RTM_ADD) ? "ADD" : "DEL");
    } else {
	trace(TR_KRT | TR_NOSTAMP, 0, NULL);
    }

    return request_error;
}

