/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	functs.H
 *
 *	Functions(s):
 *
 *	Description:
 *		External function definitions which are not class member functions
 *
 *	RCSid = "$Id: functs.H,v 4.13.1.2 1993/06/02 23:41:25 martin Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_functs_H
#define OI_functs_H

#ifndef OI_defs_H
#include <OI/defs.H>
#endif

#ifndef OI_globals_H
#include <OI/globals.H>
#endif
	// class forward reference declarations
	class	OI_lang_server;
	class	OI_cb_class;
	class	OI_obj_locator;
	struct	OI_actions_rec;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		OI_flush_process(Window) ;				/* flush X buffer and process events until none left */
			void		OI_set_wm_client() ;					/* mark this client as a window manager */
			OI_bool		OI_is_derived_type(OI_type typ1, OI_type typ2) ;	/* check if typ1 derived from typ2 */
			int		OI_cursor(char *) ;					/* convert name to cursor index */
			void		OI_register_lang_server(OI_lang_server*) ;		/* register a language server */
			OI_cb_class	*OI_reg_callback(const char*, XrmQuark*, const char*, const char*) ;	/* register a callback */
			OI_cb_class	*OI_callback_class(XrmQuark) ;				/* get ptr to class record for a callback type */
			OI_cb_class	*OI_callback_class(char *) ;				/* get ptr to class record for a callback type */
			void		OI_repaint(long =0) ;						/* flush X buffer and process all events */
			void		dmpOI_connection(OI_connection*) ;
	/* private */	void		OI_add_timeout_cb(long ms,OI_timeout_fnp,OI_callback*,OI_timeout_memfnp,void*) ;
	/* private */	void		OI_delete_timeout_cb(OI_timeout_fnp,OI_callback*,OI_timeout_memfnp,void*) ;
	/* private */	void		OI_add_wall_timeout_cb(long ms,OI_timeout_fnp,OI_callback*,OI_timeout_memfnp,void*) ;
	/* private */	void		OI_delete_wall_timeout_cb(OI_timeout_fnp,OI_callback*,OI_timeout_memfnp,void*) ;
	/* private */	OI_stat		OI_io_dispatch_insert_cb(int,int,OI_io_fnp,OI_callback*,OI_io_memfnp,void*) ;
	extern "C" const	char		*OI_error_str(OI_stat =OI_status);			/* Return string description of the error status. */
			OI_d_tech	*OI_obj_setup(const char*) ;				/* create objects from object description file */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED FUNCTIONS	
		//		Functions below this point are documented in the programmers manual, and are
		//		available to the toolkit users.  Functions not contained in user documentation
		//		are subject to change without notice and should never be used.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//		
		//-------------------------------------------------------------------------------------------------		
			OI_connection	*OI_init(int* =NULL,char** =NULL, const char* =NULL, const char* =NULL,
						XrmOptionDescRec* =NULL, int=0) ;
			void		OI_add_actions(struct OI_actions_rec *, unsigned int);
			void		OI_add_idle(OI_timeout_fnp, void* = NULL);
			void		OI_add_idle(OI_callback*, OI_timeout_memfnp, void* = NULL);
			void		OI_add_timeout(long ms,OI_timeout_fnp fp,void *argp =NULL) ; /* add timeout callback function */
			void		OI_add_timeout(long ms,OI_callback *objp,OI_timeout_memfnp mfp,void *argp =NULL) ;
			void		OI_add_wall_timeout(long ms,OI_timeout_fnp fp,void *argp =NULL) ; /* add timeout callback function */
			void		OI_add_wall_timeout(long ms,OI_callback *objp,OI_timeout_memfnp mfp,void *argp =NULL) ;
			void		OI_begin_interaction() ;				/* start interactions with user; process events */
			OI_bool		OI_call_action_proc(OI_d_tech*, const char*, const XEvent*, const char* const *, unsigned int);
			OI_class	*OI_class_tree() ;					/* ptr to top of class hierarchy */
			int		OI_command_argc() ;					/* get full contents of original cmd line */
			char		**OI_command_argv() ;					/* get full contents of original cmd line */
			int		OI_common_argc() ;					/* get parts of cmd line common to all OI apps */
			char		**OI_common_argv() ;					/* get parts of cmd line common to all OI apps */
			OI_compiled_action_table OI_compile_action_table(struct OI_actions_rec *, unsigned int);
			OI_number	OI_delete_delayed_queue_length() ;			/* get length for delete_delayed queue */
			void		OI_delete_idle() ;					/* delete the idel callback */
			void		OI_delete_timeout(OI_timeout_fnp fp,void *argp =NULL) ;	/* delete timeout callback function */
			void		OI_delete_timeout(OI_callback *objp,OI_timeout_memfnp mfp,void *argp =NULL) ;
			void		OI_delete_wall_timeout(OI_timeout_fnp fp,void *argp =NULL) ;	/* delete timeout callback function */
			void		OI_delete_wall_timeout(OI_callback *objp,OI_timeout_memfnp mfp,void *argp =NULL) ;
			void		OI_end_interaction() ;					/* end interactions with user */
			void		OI_event_loop(OI_bool *);				/* process events until flag is true */
			void		OI_fini() ;						/* clean up object interface */
			void		OI_flush(long =0) ;
			void		OI_fork(const char*);
			int		OI_fork_nowait(const char*);
	extern "C"	char		*OI_format_error(OI_stat...); /* Format the error message. ~OIc */
			void		OI_handle_event(const XEvent*) ;			/* process event */
			OI_stat		OI_io_dispatch_insert(int fd,int tm,OI_io_fnp fp,void *argp=NULL) ;
												/* insert user proc in i/o dispatch table */
			OI_stat		OI_io_dispatch_insert(int fd,int tm,OI_callback *objp,OI_io_memfnp mfp,void *argp=NULL) ;
												/* insert user proc in i/o dispatch table */
			void		OI_io_dispatch_remove(int,int) ;			/* remove user proc in i/o dispatch table */
			OI_d_tech	**OI_make_top_level( const char* = NULL, const char* = NULL, OI_number* = NULL );	/* seed top level object for this application */
			OI_bool		OI_next_event(XEvent *) ;				/* get the next X event */
			OI_obj_locator	*OI_object_locator() ;					// get object for locating backend objects
			void		OI_reg_derived_classes();				/* Dummy module for registering user derived classes */
			void		OI_reg_messages();					/* Dummy module for registering user status messages */
			void		OI_reg_layout_methods();				/* Dummy module for registering user layout methods */
			OI_stat		OI_reg_status(OI_severity, const char *, const char *);	/* register an error message */
			void		OI_refresh(OI_d_tech *);				/* cause an object to repaint */
			char		*OI_search_path(const char*, const char* const*) ;	/* Searches through the path until it finds a file */
			void		OI_pop_stderr(OI_stderr_fnp, void* =NULL) ;		/* pop stderr intercept proc */
			void		OI_pop_stderr(OI_callback*, OI_stderr_memfnp, void* =NULL) ;
			void		OI_print_error(const char*, const char* =NULL, OI_bool=OI_YES) ;	/* print error and routine it occurred in */
			void		OI_push_stderr(OI_stderr_fnp, void* =NULL) ;		/* push stderr intercept proc */
			void		OI_push_stderr(OI_callback*, OI_stderr_memfnp, void* =NULL) ;
			void		OI_set_delete_delayed_queue_length(OI_number) ;		/* set length for delete_delayed queue */
			char		*OI_translate_filename(const char *) ;
			void		OI_wait_done(OI_bool *flag) ;	/* process events until *flag == OI_NO */
		inline	int		OI_Xt_argc()		{return(OI_xt_argc);}		/* get parts of cmd line common to Xt OI apps */
		inline	char		**OI_Xt_argv()		{return(OI_xt_argv);}		/* get parts of cmd line common to Xt OI apps */

#endif /* OI_functs_H */
