/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	lmrowcol.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_layout_row_column class header
 *
 *	RCSid = "$Id: lmrowcol.H,v 1.19.1.1 1993/06/01 22:55:18 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lmrowcol_H
#define OI_lmrowcol_H

#ifndef OI_lmrc_H
#include <OI/lmrc.H>
#endif /* OI_lmrc_H */

		class	OI_lm_row_column ;
		class	OI_lm_row_column_aligned ;
		class	OI_lm_titled_row_column ;

/*
 * Definitions for master column vector
 * Note that widths do not include nominal spacing glue between columns
 */
		class	OI_lm_rc_ext		{
			OI_lm_rc_ext		*nxt;					/* next column */
			OI_lm_rc_ext		*prv;					/* previous column */
			OI_number		col ;					/* column number */
			OI_number		nom ;					/* nominal width; max of nominal width of entries in actual columns */
			OI_number		min_wid ;				/* minimum width; max of minimum width of entries in actual columns */
			OI_number		wid ;					/* actual width of column */
			OI_number		strtch ;				/* stretchability */
		 public:
						OI_lm_rc_ext(OI_number c, OI_number w) ;
			void			append(OI_lm_rc_ext*) ;
		virtual	void			clear() ;							/* reset prior to calculating size */
			OI_number		column() const				{ return(col); }
			OI_number		minimum_width() const			{ return(min_wid); }
			OI_lm_rc_ext		*next() const				{ return(nxt); }
			OI_number		nominal_width() const			{ return(nom); }
			void			prepend(OI_lm_rc_ext*) ;
			OI_lm_rc_ext		*prev() const				{ return(prv); }
			void			set_column(OI_number c)			{ col=c; }
			void			set_minimum_width(OI_number n)		{ min_wid=n; }
			void			set_next(OI_lm_rc_ext *p)		{ nxt=p; }
			void			set_nominal_width(OI_number n)		{ nom=n; if (wid < nom) wid = nom; }
			void			set_prev(OI_lm_rc_ext *p)		{ prv=p; }
			void			set_stretch(OI_number s)		{ strtch=s; }
			void			set_width(OI_number w)			{ wid=w; }
			OI_number		stretch() const				{ return(strtch); }
			OI_number		width() const				{ return(wid); }
		} ;

/*
 * Definitions for row container
 */
		class	OI_lm_row_column_box : public OI_lm_row_box	{				/* row_column major row item */
		 public:
						OI_lm_row_column_box() ;
		virtual				~OI_lm_row_column_box() ;
		virtual	OI_number		find_minor(long,OI_number) const ;			/* find minor insert position */
		virtual	OI_bool			gravity_space_sizetrack_adjust(OI_bool*,OI_bool*) ;
		virtual	void			insert_slot(OI_number,OI_lm_box*,OI_lm_glue* =NULL,OI_lm_glue* =NULL) ;
		virtual OI_bool			is_row_column_box() const ;
		virtual	void			minimum_size(OI_number*,OI_number*) const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	void			position_slots() ;
		virtual	void			set_size(OI_number,OI_number) ;
		} ;

/*
 * Definitions for slot containing actual object
 */
		class	OI_lm_row_column_obj_box : public OI_lm_row_obj_box {				/* obj_box for item in row_column layout */
				// Note -- a normal glue object is not used for the in-slot glue to save space
				// This does not effect the code generality because the glue is always referenced via special member functions anyway
			OI_number		lf_glue_nom ;						/* nominal size for left glue */
			OI_number		lf_glue_siz ;						/* actual size for left glue */
			OI_number		lf_glue_strtch ;					/* stretch for left glue */
			OI_number		rt_glue_nom ;						/* nominal size for right glue */
			OI_number		rt_glue_siz ;						/* actual size for right glue */
			OI_number		rt_glue_strtch ;					/* stretch for right glue */
		 protected:
		 public:
						OI_lm_row_column_obj_box(OI_d_tech*,OI_lm_row_column*) ;
		virtual				~OI_lm_row_column_obj_box() ;
		virtual	OI_bool			adj_minor_leading_glue() ;
		virtual	OI_bool			adj_minor_trailing_glue() ;
			OI_bool			configure_left_glue(OI_number,OI_number=OI_undefined) ;
			OI_bool			configure_right_glue(OI_number,OI_number=OI_undefined) ;
		virtual	OI_number		nominal_inslot_width() const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	OI_number		obj_offset_x() const ;					/* offset of object from OI_lm_obj_box origin */
		virtual	void			position_slots() ;
		virtual	void			size_change() ;
		} ;

/*
 * Definitions for actual layout method
 */
#define		OI_lm_row_column_redo_mstr	0x1							/* 1 => master row has a column width change */

		class	OI_lm_row_column : public OI_lm_row	{
			OI_lm_rc_ext		*mstrp ;						/* master list of all columns used */
			unsigned long		ctl_bits ;						/* control bits */
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
			void			adjust_master_columns(OI_number) ;			/* adjust master columns to be proper width */
		virtual	OI_bool			gravity_space_sizetrack_adjust(OI_bool*,OI_bool*) ;
		 protected:
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_row_column(class OI_d_tech *dtp) ;
		virtual				~OI_lm_row_column() ;
			void			clear_recompute_master()		{ ctl_bits &= ~OI_lm_row_column_redo_mstr; }
		virtual	OI_number		find_minor_in_new_major(long, OI_number, OI_number) ;
		virtual	OI_bool			glue_between_major_boxes() const ;
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
			OI_lm_rc_ext		*master_column_vec() const		{ return(mstrp); }
		virtual	OI_lm_box		*minor_box(OI_lm_rc_box*,OI_d_tech*) ;
		virtual	OI_lm_rc_ext		*new_master_column(OI_number,OI_number) ;
		virtual	OI_number		nominal_major_leading_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_trailing_inslot_space(const OI_layout_slot*) const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
			OI_bool			recompute_master()			{ return((ctl_bits & OI_lm_row_column_redo_mstr) ? OI_yes : OI_no); }
			void			set_recompute_master()			{ ctl_bits |= OI_lm_row_column_redo_mstr; }
		virtual	void			set_size(OI_number,OI_number) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual OI_number		bottom_space(OI_d_tech*)const ;
		virtual	OI_class		*class_object() const ;
		virtual	OI_number		first_column(OI_number) const ;
		virtual	OI_number		in_column(OI_number c, long p, OI_number r, OI_number pct) const ;
		virtual	void			insert(OI_d_tech*,void*,void*) ;
		virtual	OI_number		last_column(OI_number) const ;
		virtual OI_number		left_space(OI_d_tech*)const ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) const ;
		virtual	void			new_column(OI_number,OI_number) ;
		virtual	OI_number		next_column(OI_number c, OI_number r) const ;
		virtual	OI_number		prev_column(OI_number,OI_number) const ;
		virtual	void			re_layout() ;
		virtual	void			remove(OI_d_tech *) ;
		virtual OI_number		right_space(OI_d_tech*)const ;
		virtual OI_number		top_space(OI_d_tech*)const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		} ;

/******************************
 *	row_column_aligned
 ******************************/

		class	OI_lm_rc_aligned_ext : public OI_lm_rc_ext	{
			OI_number		align_x ;				/* alignment point, does not include layout method default space */
		 public:
						OI_lm_rc_aligned_ext(OI_number c, OI_number w) ;
			OI_number		alignment_loc_x() const			{ return(align_x); }
		virtual	void			clear() ;
			void			set_alignment_loc_x(OI_number a)	{ align_x = a; }
		} ;

		class	OI_lm_row_column_aligned_obj_box : public OI_lm_row_column_obj_box	{	/* obj_box for object in row_column_aligned layout */
		 public:
						OI_lm_row_column_aligned_obj_box(OI_d_tech*,OI_lm_row_column_aligned*) ;
		virtual				~OI_lm_row_column_aligned_obj_box() ;
		virtual	OI_bool			adj_minor_leading_glue() ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		} ;

		class	OI_lm_row_column_aligned : public OI_lm_row_column	{
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_row_column_aligned(class OI_d_tech *dtp) ;
		virtual				~OI_lm_row_column_aligned() ;
		virtual	OI_lm_box		*minor_box(OI_lm_rc_box*,OI_d_tech*) ;
		virtual	OI_lm_rc_ext		*new_master_column(OI_number,OI_number) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		} ;

/******************************
 *	titled_row_column
 ******************************/

		class	OI_lm_titled_row_column : public OI_lm_row_column	{
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_titled_row_column(OI_d_tech*) ;
		virtual				~OI_lm_titled_row_column() ;
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
		virtual	OI_lm_box		*minor_box(OI_lm_rc_box*,OI_d_tech*) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	void			insert(OI_d_tech*,void*,void*) ;
		virtual	void			remove(OI_d_tech*) ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		} ;

#endif /* OI_lmrowcol_H */
