/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pushpin.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_pushpin class header
 *
 *	RCSid = "$Id: pushpin.H,v 4.5.1.1 1993/06/01 22:56:14 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_pushpin_H
#define OI_pushpin_H

#ifndef OI_wldtech_H
#include <OI/wldtech.H>
#endif /* OI_wldtech_H */

#define OI_PUSHPIN_PIN_IN	0x01L			/* the pushpin is in */
#define OI_PUSHPIN_PAINTED	0x02L			/* the pushpin has been painted */

	// class forward reference declaration
	class	OI_pushpin;
	class	OI_mdl_pushpin;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

	class OI_pushpin : public OI_wl_d_tech {
			OI_mdl_pushpin	*mdl_dep ;	/* ptr to model dependent aspects of OI_pushpin object */
			unsigned long	ctl_bits;
		protected:
					OI_pushpin(OI_class*, const char*);
		virtual	void		new_model(OI_model_type) ;
		public:
		static	OI_class		*clsp ;			/* ptr to class record */
		static	XrmQuark		q_cbPin;		/* quark for pin callback */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_pushpin(const char*);
					~OI_pushpin() ;
 			void		activate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
			void		allow_painted()			{ ctl_bits |= OI_PUSHPIN_PAINTED; }
			void		allow_pin_in()			{ ctl_bits |= OI_PUSHPIN_PIN_IN; paint(NULL); }
			void		construct();
 			void		deactivate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
			void		disallow_painted()		{ ctl_bits &= ~OI_PUSHPIN_PAINTED; }
			void		disallow_pin_in()		{ ctl_bits &= ~OI_PUSHPIN_PIN_IN; paint(NULL); }
			void		down(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		virtual	void		expose_reset();
 		virtual	void		focus_in(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 		virtual	void		focus_out(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		static	OI_bool		init(OI_connection*);
			OI_bool		is_painted()			{ return ((ctl_bits&OI_PUSHPIN_PAINTED)?OI_YES:OI_NO); }
			OI_bool		is_pin_in()			{ return ((ctl_bits&OI_PUSHPIN_PIN_IN)?OI_YES:OI_NO); }
			void		left(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		static	OI_pushpin	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
		virtual	void		paint(const XEvent *, void* =NULL);
			void		paint_window(Window,int,int);			/* paint in a window */
 			void		pin(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
			void		right(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
			void		up(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			// OI_stat		set_state(OI_state) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		set_pin(OI_pin_fnp, void* =NULL) ;
			void		set_pin(OI_callback*, OI_pin_memfnp, void * =NULL) ;

	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_pushpin	*oi_create_pushpin(const char *);

#endif /* OI_pushpin_H */
