/* trimtopbot.c

   Takes a postscript 2.0 file from standard input and hopefully
generates the header and trailers.

   The 'header' is defined as everything from the top of the file down
to the first %%Page: line (which is not included).  It is written to
header.ps.

   The 'trailer' is defined as everything from the %%PageTrailer
comment to the end of the file, inclusive.  It is written to
trailer.ps.


  Written Thursday May 20, 1993 by Joel F. Klein

*/

#include <stdio.h>
#include <strings.h>

#define WIDTH 4096

void main() {
   FILE *h=fopen("header.ps", "w"), *t=fopen("trailer.ps", "w");
   char done=0;
   char line[WIDTH+1];
   char *endHeader = "%%Page:";
   int endHeaderLength = strlen(endHeader);
   char *startTrailer = "%%Trailer";
   int startTrailerLength = strlen(startTrailer);

   /* write header until header is done */

   while(!done){
      fgets(line, WIDTH, stdin);
      done = !(strncasecmp(endHeader, line, endHeaderLength));
      if(!done)
	 fprintf(h, "%s", line);
   }
   fclose(h);

   /* look for trailer */
   done=0;

   while(!done){
      fgets(line, WIDTH, stdin);
      done = !(strncasecmp(startTrailer, line, startTrailerLength));
      if(done)
	 fprintf(t, "%s", line);
   }
	 

   /* write trailer until end of file */

   while(!feof(stdin)){
      fgets(line, WIDTH, stdin);
      fprintf(t, "%s", line);
   }
   fclose(t);
}
