#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <stdio.h>



static char *selectionBuffer = 0;
static unsigned long selectionBufferLength = 0;

#ifdef _NO_PROTO
Boolean SendSelection(widget, selection, target, type_return, value_return, 
		   length_return, format_return)
Widget widget;
Atom *selection;
Atom *target;
Atom *type_return;
XtPointer *value_return;
unsigned long *length_return;
int *format_return;
#else /* _NO_PROTO */
Boolean SendSelection(Widget widget, Atom *selection, Atom *target, 
		  Atom *type_return, XtPointer *value_return, 
		  unsigned long *length_return, int *format_return )
#endif /* _NO_PROTO */
{
    /* This function only handles the XA_PRIMARY selection as a string */
    if((*selection != XA_PRIMARY) || (*target != XA_STRING) || 
       ! selectionBuffer) {
	return FALSE;
    };
    
    *type_return = XA_STRING;
    /* as we give no done_proc, this will be freed by the Intrinsics */
    *value_return = XtMalloc(selectionBufferLength);
    strcpy(*value_return, selectionBuffer);
    *length_return = selectionBufferLength;
    *format_return = 8;
    return TRUE;    
};


#ifdef _NO_PROTO
void LoseSelection(widget, selection, target)
Widget widget;
Atom *selection;
Atom *target;
#else /* _NO_PROTO */
Boolean LoseSelection(Widget widget, Atom *selection, Atom *target)
#endif /* _NO_PROTO */
{
    /* This function only handles the XA_PRIMARY selection as a string */
    if((*selection != XA_PRIMARY) || (*target != XA_STRING))
	return;
    if(selectionBuffer) {
	XtFree(selectionBuffer);
	selectionBuffer = 0;
    };
};



#ifdef _NO_PROTO
void SetSelection(widget, string)
Widget widget;
char *string;
#else /* _NO_PROTO */
void SetSelection(Widget widget, char *string)
#endif /* _NO_PROTO */
{
    if(!XtOwnSelection(widget, XA_PRIMARY, CurrentTime, 
		       SendSelection, LoseSelection, 0)) {
	fprintf(stderr, "XtOwnSelection failed\n");
	return;
    };
    if(selectionBuffer) {
	XtFree(selectionBuffer);
	selectionBuffer = 0;
    };
    selectionBufferLength = strlen(string);
    selectionBuffer = XtMalloc(selectionBufferLength + 1);
    strcpy(selectionBuffer, string);
};
