.\" @(#)workman.man	1.33	11/23/93
.TH workman 1 "93/11/23"
.SH NAME
workman \- play audio compact discs on a SCSI CD player
.SH SYNOPSIS
.B workman
[
.I generic-tool-arguments
] [
.B \-bdoeXnhC
] [
.B \-p pidfile
] [
.B \-c device
] [
.B \-s cmd
] [
.B \-l n
] [
.B \-V n
]
.SH DESCRIPTION
.LP
.B workman
is a graphical
tool for playing audio compact discs on a SunCD drive or other compatible unit.
It has most of the features available on standalone CD players, such as a
shuffle mode, programmable playlists, and elapsed/remaining timers.  But it
also has extra features, foremost of which is the ability to store information
about CDs in a database, then automatically extract that information when
the CD is inserted later.
.B Workman
stores the artist's name, the disc title, the names of individual tracks, and
even remembers which tracks you don't want to hear!  All in an easy-to-use,
attractive OPEN LOOK graphical interface.
.LP
Its only weakness, in fact, is that this is the end of the Description
section of the manpage.
.SH OPTIONS
.TP
generic-tool-arguments
WorkMan should accept the generic tool arguments described in
.BR xview (1).
The exception is the -Ws argument, which can cause problems such as the
CD Info/About/Goodies buttons being whited out.  Note that olwm's "Save
Workspace" menu option puts a -Ws argument in your .openwin-init file; you
should edit it and remove -Ws and the two numbers following it.
.TP
.I \-geometry [+|-]x[+|-]y
Set WorkMan's position on the screen.  Do not try to use
.I \-geometry
to resize the window; it won't work and can mess up the display.  If the
Y coordinate is negative (e.g.
.IR "\-geometry +100-50" )
the window will be
positioned that many pixels from the bottom of the screen and will grow and
shrink from the top, rather than the bottom; this prevents the controls from
moving around when multiline track titles are displayed, and is frequently
used with the
.I \-l 0
option.  Note that the window manager will add its title bar and push the
window down.  Use something like
.I \-geometry +0-38
to position the window at the bottom of the screen.  38 is the height of the
olwm border; use other values for other window managers.
.TP
.I \-d
Don't display any title information in the main window.  This results in a
smaller main window.  The title information can still be seen and edited using
the CD Info popup.  If
.I \-d
is used twice, title information will be displayed only if it is available;
the default is to display "Unknown CD name", "Unknown artist", and
"Unknown track name" when the corresponding information is unavailable.
.TP
.I \-D filename
Set the location of the CD database file.  This is a colon-separated list of
filenames.  This option overrides the value of the WORKMANDB environment
variable and the workman.db.shared resource if either is present.  See the
ENVIRONMENT section for more details.
.TP
.I \-h
Display a summary of options.
.TP
.I \-b
Toggle the use of Dismiss buttons on all popups and a Quit button on the
main window.  Useful for users of window managers other than olwm.  On Sun
and DEC systems, Dismiss buttons are missing by default; on HP systems, they
are shown by default.
.TP
.I \-c device
Use a device other than the default
.RB ( /dev/rdsk/c0t6d0s2
or
.B /vol/dev/aliases/cdrom0
under Solaris 2,
.B /dev/sr0
under Solaris 1,
.B /dev/rsr0
under Linux, and
.B /dev/rscsi
under HPUX).  This is useful if the CD drive is on a second SCSI
controller, or more than one drive is present on the system.
.TP
.I \-s cmd
Send a command to a running workman process.  Valid values are \fBstop\fP,
\fBplay\fP, \fBpause\fP, \fBback\fP, \fBforward\fP, and \fBeject\fP.  Only
the first character is examined, except in the case of \fBplay\fP and
\fBpause\fP (which require at least two characters).  \fBmute\fP and
\fBgo\fP are aliases for \fBpause\fP and \fPplay\fP, respectively.
.TP
.I \-o
This option prevents the Solaris 2.1 version of workman from spawning a
background job to keep the CD device open.  There is a bug in Solaris 2.1
that causes the CD player to stop when its device is opened, unless some
other process on the system already has the device open.  When this option
is specified, the CD will stop playing if workman is exited then restarted.
When the background job is present (\fI\-o\fP is absent) the eject button
on the CD player does not work even after quitting from workman.  The
background job isn't started under Solaris 2.2 if the volume manager is
running.
.TP
.I \-l n
Reserve some lines for track titles in the main window.
If \fIn\fP is a positive number, that
many lines of track title will always be displayed, even if some are blank.
If \fIn\fP is zero, the main window will grow and shrink to accomodate
multiline titles.  If \fIn\fP is negative (the default), the main window will
grow when necessary, but will never shrink, even when a shorter title is
subsequently displayed.
.TP
.I \-e
Check once for the presence of a CD at startup.  If no CD is present, wait
for the user to select the square (stop) icon from the main window.  The
default is to check for a CD every 5 seconds; on some SunOS versions, the
CD-ROM driver prints a message to the console every time the tool checks
for a CD.  After a CD has been detected once, workman will revert to its
default behavior (since the driver message only occurs if workman has not
yet found a CD in the drive.)  Specify
.I \-e
more than once to disable checking for CD insertion permanently.
.TP
.I \-X
Exit automatically when the CD is ejected.
.TP
.I \-p file
Write the program's process ID to a different \fIfile\fP.  By default, the
PID is written to "/tmp/.wm_pid" to allow signals to be sent more easily
(see the SIGNALS section below.)
.TP
.I \-n
No file locking.  On some systems, workman's use of file locking is a
significant performance hit (and on older systems, file locking didn't work
too well; on those machines, workman can freeze up when it tries to lock the
database file.)  Use of this option is not recommended when several people
share a database via NFS; if two people save CD entries to the database at
the same time and one of them is not using file locking, one or both of the
new entries may be erased or stored incorrectly.
.IP
Apply Sun patch 100075 to your system (and your fileserver, if you're
NFS-mounting the database files) and you probably won't need to
use the \-n flag at all.
.TP
.I \-V n
Set minimum volume.  CD-ROM drives made by different manufacturers have
different
volume-setting methods.  On the Sun and DEC CD-ROM drives, the volume
settings range from 0 to 255, but only values of 128 or greater produce any
sound.  On some third-party
drives, though, the full range of volumes is available, in which case
running with
.I \-V 0
is desirable.  The default is 128.
.TP
.I \-C
Close the CD device when the disc is ejected.  You shouldn't need to use this
option unless you have unreliable hardware.
.SH RESOURCES
.LP
The following resources are available.  All resource names begin with
"workman.".
.TP
\fBdb.personal\fP (string, default $HOME/.workmanrc)
The pathname of a file containing personal preference information about CDs:
track volumes, playlists, and the like.  This resource overrides the
WORKMANRC environment variable, if present.
.TP
\fBdb.shared\fP (string, default $HOME/.workmandb)
A colon-separated list of database files.  This resource overrides the
WORKMANDB environment variable and in turn may be overridden by the \fI\-D\fP
command-line option.  See the ENVIRONMENT section for more
information about using lists of databases.
.TP
\fBinitialVolume\fP (integer, default varies)
When a CD is inserted for the first time, or WorkMan is started when there
is already a disc in the drive, the current volume level is read from the
drive.  On some systems the volume can't be obtained, in which case WorkMan
by default will set the volume to 100%.  This resource allows a different
initial volume to be set.  Valid values are 0 through 100.
.TP
\fBsmallButtons\fP (boolean, default varies)
If true, use small (16x16) icons for the main panel buttons.
If false, use the old 32x16 icons.  If undefined, the program will try to
use the correct size depending on how big the rest of the window is,
which can be controlled with the XView "-scale" command-line option or by
using a particular font.
.SH ENVIRONMENT
.TP
\s-2WORKMANRC\s+2
The location of the personal preferences file.
This file contains information such as the default volumes of CDs, playlists,
and the numbers of tracks to avoid playing.  It is usually not shared among
several users of workman, since it does not contain any information about the
CDs themselves.
.TP
\s-2WORKMANDB\s+2
Specifies the location of the CD database file or files.
Several files may be specified by separating them with
colons a la the PATH shell variable.  For example, setting WORKMANDB to
"$HOME/.workmandb:/home/user2/.workmandb" would cause workman to look first
in $HOME/.workmandb, then in /home/user2/.workmandb.  New entries are saved
to the first database in the list; modified entries are saved to the database
in which they were originally found, or the first database if the original
one is not writable.
.IP
This variable's value is overridden by the workman.db.shared resource and
by the \fI\-D\fP command-line option.
.SH SIGNALS
WorkMan reacts to the following signals:
.TP
\s-2SIGTTIN\s+2
Jump to the next track.
.TP
\s-2SIGTTOU\s+2
Jump to the previous track.
.TP
\s-2SIGUSR1\s+2
Pause the CD (if it's playing).
.TP
\s-2SIGUSR2\s+2
Play the CD (if it's paused or stopped).
.TP
\s-2SIGQUIT\s+2
Stop the CD if it's playing.
.TP
\s-2SIGEMT\s+2
Eject the CD.
.LP
These signals, in combination with the pidfile (see the
.I \-p
option description above), allow simple control of the CD player from
programs or scripts, and are used by the
.I \-s
option.
.SH INTERFACE
.LP
Most controls have spot help; hit the Help key (F1 on type-3 keyboards) over
a control to find out what it does.  The following is a quick rundown of the
controls; for the most part, they're pretty self-explanatory.
.SS The main window
The main window contains the basic display and most commonly-used controls.
Moving from top to bottom and reading left to right, you'll see:
.LP
The artist's name.
.LP
The name of the CD or the title of the currently-playing piece of music,
if it takes up more than one track.
.LP
The title of the current track.  This may occupy more than one row on the
screen.
.LP
The track selection buttons.  Click on these buttons to select a starting
track, or to change to a new track if the CD is playing.
.LP
The track-position slider.  This is updated once every 5 seconds while the
CD is playing; you can also use it as a sort of jog dial to move around in
a track.
.LP
The volume slider.  Up is louder; down is quiet.
.LP
The main controls (for lack of a better term.)  The buttons on the top row
move to the previous track, start playing, and move to the next track,
respectively.  The bottom buttons pause, stop, or eject the CD.  When the
CD is paused, playing may be resumed by clicking on either the pause button
or the play button.
.LP
The "stop mode" selector.  When
.B workman
is done playing a CD, it can stop, play the CD over
again (the \fIRepeat\fP setting), or eject it.  Click the MENU mouse button
to select a stop mode; or click SELECT on the pull-down item to cycle
through the available choices.
.LP
The "play mode" selector.  This determines the playing order of the tracks.
Two selections are always available: \fINormal\fP, which plays the CD from
start to end, and \fIShuffle\fP, which plays the tracks in random order.
In addition, if any playlists have been defined, they'll appear here as well.
.LP
A gauge indicating how long the CD has been playing and how much longer
is left.
.LP
Three buttons that bring up the About, CD Info, and Goodies popups.
.SS The "About" popup
There's not much to say about this; it's the credits with a couple of
dumb pictures.
.SS The "CD Info" popup
This popup is used to enter information about a CD.  Again, from the top:
.LP
The artist's name.
.LP
The title of the CD as a whole.
.LP
A scrolling list of tracks and their titles.  This can be used to view the
tracks on a CD, or to select tracks for editing using the controls below.
.LP
The name of the track that's selected on the scrolling list.  As a
shortcut, if RETURN is typed after entering a track name, the scrolling list
selection will automatically advance to the next track.  This allows
you to type in all the track titles without using the mouse.
The track title can contain several special symbols that alter the
main window's display.  "//" forces a line break; the text after the "//"
will be displayed below the text before it.  WorkMan will automatically
split lines that are too big for the main window.
If a line begins with "+", the main window's disc title display is
replaced with the text after the "+" (useful for classical CDs, with
several tracks that are part of the same work.)  If a line begins with "@", the
main window's artist display is replaced with the text after the "@" (useful
for compilation CDs with tracks by several artists.)  Both "+" and "@" may
be used alone on a line, in which case the program uses the title or
artist from the previous track.  If a line is empty, the corresponding line
from the previous track is used.  For example, a track title "@Orff//+Carmina
Burana////Stetit Puella" will replace the artist's name with "Orff", the
CD name with "Carmina Burana", and display two lines of track title, the
second "Stetit Puella" and the first copied from the first line of title
from the previous track.  (If this sounds confusing, don't worry -- play
with it for a few minutes and you'll see how it works.)
.LP
The "Continuation" selector.  If this is selected, the current track is
a continuation of the previous one.  This is taken into account when the
CD is played in shuffle mode; if, for example,
three tracks are part of the same piece of music (indicated by setting
"Continuation" on the second and third tracks), they will be played together
in shuffle mode.
.LP
The "Don't play" selector.  If this is selected, the program will avoid
the track when playing the CD (though you can still play the track by
selecting it directly using the main window's track selection buttons.)
.LP
The default volume setting.  Use this if a particular disc or track should
be played especially loudly or quietly.  If the slider is all the way to
the left, there is no default setting and the current volume will be used.
.LP
The default play mode setting.  When the CD is inserted, the main window's
play mode selector will be set according to this item.  "From List" will
select the first playlist.
.LP
The auto-play setting.  If this is selected, the CD will start playing
automatically when it's inserted (even if the main window is closed to
an icon!)
.LP
Apply and Reset buttons.  Apply will save the CD information to disk.
Reset undoes any changes you've made.
.LP
A button to bring up the "Playlists" popup.
.SS The "Playlists" popup
This contains the controls for creating user-defined playlists.  Any number
of playlists may be created, and they can be as long as you like (until your
workstation runs out of memory, anyway.)  The controls:
.LP
A scrolling list, from which you can select a playlist to edit or maim.
.LP
The name of a scrolling list to create, or the new name for the current list.
.LP
A button which creates a new list, using the name above or a boring
system-generated one if no name has been entered.
.LP
A button to rename the current list to whatever is in the Name field.
.LP
A button to delete the current list.
.LP
The tracks in the current playlist.  To add tracks, use the popup menu
(which appears when you hit the MENU mouse button over the scrolling list.)
The popup menu is pinnable, so you can keep it on the screen and select
tracks quickly.
.LP
A button to delete the currently-selected track from the playlist.
.SS The "Goodies" popup
This popup contains some infrequently-used, perhaps frivolous, controls:
.LP
The balance setting.
.LP
The time display settings.  The running times to the left of the slider and
gauge in the main window can display either elapsed time (the default) or
remaining time; use these to choose.
.LP
The auto-play setting for unknown CDs (CDs which you haven't seen before,
or which you saw before but didn't Apply to your database file from the
CD Info window.)  If this is selected, unknown CDs will be played
when they're inserted.
.LP
The controls for the A-B repeat function.  While the CD is playing, click
the Start button to mark the start of a passage to be repeated; then click
the End button when the CD reaches the end of the passage.  Click on the
"Repeat section of CD" item to start repeating the passage (and to stop,
once you've started.)
.LP
The Split button.  This button allows you to split any track
in two.  Select a track from the main window, and use the track-position
slider to choose the split point.  Then hit the Split button and the track
will be divided.  You can do everything with the new section that you can
with a regular track, including choosing a name.
Tracks may be split while the CD is stopped
or paused, or while it's playing.  This is useful if you wish to mark a
section of a song, for instance; you can listen for the start of the
section, and hit Split as soon as you hear it beginning.
.LP
The Delete button.  Use this to put a split-up track back together.  You
can't delete the first section of a track.
.LP
A button to scan for index marks.  If a CD already has sections marked via
index marks (usually indicated in the liner notes), hit this button to
search for them.  Searching for marks can take a while depending on the
particular CD.  Every time an index mark is encountered, its track will be
split as if you'd used the Split button.
.SH FILES
.TP
$HOME/.workmanrc
Default location of personal preferences file.  See \s-2WORKMANRC\s+2
under "Environment" as well as
.BR
workmandb (4).
.TP
$HOME/.workmandb
Default location of CD database file.  See \s-2WORKMANDB\s+2 under
"Environment" and
.BR
workmandb (4).
.SH BUGS
The program leaks memory with XView 3.0 (but not 3.0.1 or higher) due to a
library bug.  The leak only occurs while the About popup is displayed.
.LP
Due to another library bug, the program will dump core when the default
volume slider is wiggled back and forth under Solaris 2.  (The Sun bug ID is
1097908.)
.LP
There is no way to choose a playlist other than the first one as the default.
.LP
Some of the options and environment variables should be done with X
resources or a properties sheet.
.LP
The database should have an index of some sort for quickly looking up
CDs, since the current linear search can get a little slow on big
databases.
.LP
Interaction with data CDs, especially ones that are mounted as filesystems,
is spotty at best.  The program should unmount a CD before ejecting it.
.LP
The CD Info popup's interaction with mouseless mode is annoying.
.LP
If the volume manager (Solaris 2.2) is running and the "eject" program is
used to eject the CD, a message about loading an unnamed CD will appear
on the console.  There's nothing WorkMan can do to avoid that.
.LP
The program's name is a pretty moronic pun.
.SH AUTHOR
Steven Grimm (koreth@hyperion.com).  Feel free to send comments,
criticisms, suggestions, or unadulterated praise.
.LP
ULTRIX port by Chris Ross (cross@eng.umd.edu).
.LP
HPUX port by John Brezak (brezak@apollo.hp.com).  Note:  Hewlett Packard
supplies this without warranty or support of any kind.
.LP
Linux port by Chris Newbold (newbie@inmet.camb.inmet.com).
.LP
NEWS-OS port by Tatsuo Nagamatsu (nagamatu@sm.sony.co.jp).
.LP
Please report bugs in the HPUX and ULTRIX versions to koreth@hyperion.com, as
well as non-Linux-specific bugs in that version.
