/*
 *
 * Definitions for mount interface. This describes the in the kernel build 
 * linkedlist with mounted filesystems.
 *
 * Authors: Marco van Wieringen <v892273@si.hhs.nl> <mvw@mcs.ow.org>
 *          Edvard Tuinder <v892231@si.hhs.nl> <ed@delirium.ow.org>
 *
 * Version: $Id: mount.h,v 1.3 1994/07/20 22:01:00 mvw Exp mvw $
 *
 */
#ifndef _LINUX_MOUNT_H
#define _LINUX_MOUNT_H

#define QF_OPENING  0x01        /* Quotafile is in progress of being opened */
#define QF_CLOSING  0x02        /* Quotafile is in progress of being closed */

struct vfsmount
{
   dev_t mnt_dev;                      /* Device this applies to */
   char *mnt_devname;                  /* Name of device e.g. /dev/dsk/hda1 */
   char *mnt_dirname;                  /* Name of directory mounted on */
   unsigned int mnt_flags;             /* Flags of this device see above */
   struct semaphore mnt_sem;           /* lock device while I/O in progress */
   struct super_block *mnt_sb;         /* pointer to superblock */
   struct file *mnt_quotas[MAXQUOTAS]; /* fp's to quotafiles */
   time_t mnt_iexp[MAXQUOTAS];         /* expiretime for inodes */
   time_t mnt_bexp[MAXQUOTAS];         /* expiretime for blocks */
   struct vfsmount *mnt_next;          /* pointer to next in linkedlist */
};

struct vfsmount *lookup_vfsmnt(dev_t dev);

#endif /* _LINUX_MOUNT_H */
