

SELECTION(1)               Unix Programmer's Manual               SELECTION(1)


NNNAAAMMMEEE
    selection - the cut and paste utility for Linux virtual consoles

SSSYYYNNNTTTAAAXXX
    ssseeellleeeccctttiiiooonnn [[[-aaa aaacccccceeelll]]] [[[-bbb bbbaaauuuddd-rrraaattteee]]]  [[[-ccc  lll|||mmm|||rrr]]]  [[[-ddd  dddeeellltttaaa]]]  [[[-mmm  mmmooouuussseee---
    dddeeevvviiiccceee]]] [[[-ppp lll|||mmm|||rrr]]] [[[-sss sssaaammmpppllleee-rrraaattteee]]] [[[-ttt mmmooouuussseee-tttyyypppeee]]]

DDDEEESSSCCCRRRIIIPPPTTTIIIOOONNN
    ssseeellleeeccctttiiiooonnn is a utility that allows characters  to  be  selected  from  the
    current  Linux virtual console using the mouse and pasted into the current
    console. ssseeellleeeccctttiiiooonnn is normally invoked at boot  time  from  /etc/rc.local,
    and runs as a background process.

OOOPPPTTTIIIOOONNNSSS

     -aaa_a_c_c_e_l
         movements of more than _d_e_l_t_a pixels are multiplied by _a_c_c_e_l  (default
         2)

     -bbb_b_a_u_d-_r_a_t_e
         set the baud rate of the mouse (default 1200 baud)

     -ccc_l|_m|_r
         set the copy button to be the left, middle or right  button  (default
         left)

     -ddd_d_e_l_t_a
         movements of more than _d_e_l_t_a pixels are multiplied by _a_c_c_e_l  (default
         25)

     -mmm_m_o_u_s_e-_d_e_v_i_c_e
         specify the mouse device (default /dev/mouse)

     -ppp_l|_m|_r
         set the paste button to be the left, middle or right button  (default
         right)

     -sss_s_a_m_p_l_e-_r_a_t_e
         set the sample rate of the mouse (default 100)

     -ttt_m_o_u_s_e-_t_y_p_e
         specify the mouse type (Microsoft = `ms', Mouse Systems Corp = `msc',
         MM  Series  = `mm', Logitech = `logi', BusMouse = `bm', MSC 3-bytes =
         `sun', PS/2 = `ps2'; default = ms)

OOOPPPEEERRRAAATTTIIIOOONNN
    To invoke the selection mechanism, press and release the copy button  (the
    meaning  of  the  buttons  may  be set at startup as above). A highlighted
    block will start moving around the screen, correlated with the movement of
    the mouse.

    Move the block to the first character of the  selection,  then  press  and
    hold down the copy button.





                               17th June 1993                                1




SELECTION(1)               Unix Programmer's Manual               SELECTION(1)


    Drag out the selection;  the  selected  text  will  be  highlighted.  Then
    release  the  copy button. You can take the end of the selection to before
    the start of the selection if necessary.

    Double-clicking the copy button while the  highlighted  block  is  on  the
    screen  selects text by word boundaries; treble-clicking selects by entire
    lines. If the button  is  held  down  after  double-  or  treble-clicking,
    multiple  words  or  lines  may  be  selected. A word consists of a set of
    alphanumeric characters and underscores.

    If a trailing space after the contents of a line is  highlighted,  and  if
    there  is no other text on the remainder of the line, the rest of the line
    will be selected  automatically.  If  a  number  of  lines  are  selected,
    highlighted  trailing  spaces  on  each  line  will  be  removed  from the
    selection buffer.

    Pressing the paste button in any virtual console pastes the selected  text
    into the read queue of the associated tty.

    Any output on the virtual console holding the  selection  will  clear  the
    highlighted  selection  from  the  screen,  to  maintain  integrity of the
    display, although the contents of the paste buffer will be unaffected.

    The selection mechanism is disabled if the controlling virtual console  is
    placed  in  graphics mode, for example when running X11, and is re-enabled
    when text mode is resumed. (But see BUGS section below.)

FFFIIILLLEEESSS
    /dev/mouse - default mouse device
    /dev/tty0 - current VC device

DDDIIIAAAGGGNNNOOOSSSTTTIIICCCSSS
    ssseeellleeeccctttiiiooonnn complains if any of the devices it requires cannot be located.

BBBUUUGGGSSS
    The size of the paste buffer is set at 2048 bytes by default. This may  be
    changed at compile time; consult the installation notes.

    The selection mechanism doesn't work very well with  graphics  characters,
    or  indeed with any characters where a mapping between the typed character
    and the displayed character  is  performed  by  the  console  driver.  The
    selection  mechanism  pastes  into the input buffer the character codes as
    they are displayed on the screen, not those originally  typed  in  by  the
    user.

    Because of the way that the kernel bus mouse drivers work,  allowing  only
    one  process  to  have the mouse device open at once, ssseeellleeeccctttiiiooonnn cannot co-
    exist with X11 using ATI XL, Logitech and Microsoft bus  mice  or  with  a
    PS/2  mouse. The X server will not start while ssseeellleeeccctttiiiooonnn is running.  This
    problem is not present with serial mice.

AAAUUUTTTHHHOOORRR
    Andrew Haylett <ajh@gec-mrc.co.uk>





                               17th June 1993                                2




SELECTION(1)               Unix Programmer's Manual               SELECTION(1)


AAACCCKKKNNNOOOWWWLLLEEEDDDGGGEEEMMMEEENNNTTTSSS
    Lefty patches originally suggested by:
        Sotiris C. Vassilopoulos <scv2f@edu.Virginia.acc.honi4>
    Logitech patches from:
        Jim Winstead Jr <jwinstea@jarthur.Claremont.EDU>
    Command line options based on those from:
        Peter Macdonald <pmacdona@sanjuan>
    Patches for bus mouse from:
        Erik Troan <ewtroan@eos.ncsu.edu>
        Christoph Niemann <niemann@rubdv15.etdv.ruhr-uni-bochum.de>
        Koen Gadeyne <kmg@barco.be>
    Patches for PS/2 mouse from:
        Hans D. Fink
    Patches for Sun mouse from:
        Michael Haardt <michael@gandalf.moria>
    Run-time configurable mouse buttons suggested by:
        Charlie Brady <charlieb@au.oz.tpl.tplrd>

    Apologies to any contributors whose names I have omitted.







































                               17th June 1993                                3


