#include <stdio.h>
#include <linux/umsdos_fs.h>

/*
	J'ai remis a jour udump pour qu'il puisse marcher avec les
	record a taille variable (UMSDOS_REC_SIZE).
	Il y a une ligne un peu vilaine pour lire le reste de
	"struct umsdos_dirent entry" apres avoir lu la premiere partie.
	J'ai rajoute les champs qui manquaient (y compris spare!).
*/

/* #Specification: utilities / emddump
	emddump display the content of a --linux-.--- file (EMD file).
	Simply type:

	emddump file

	This utility could be mainly used to debug the UMSDOS file systems.
*/

/*
        Evaluate the record size needed to store of name of len character.
        The value returned is a multiple of UMSDOS_REC_SIZE.
*/
int umsdos_evalrecsize (int len)
{
        struct umsdos_dirent dirent;
        int nbrec = 1+((len-1+(dirent.name-(char*)&dirent))
                   / UMSDOS_REC_SIZE);
        return nbrec * UMSDOS_REC_SIZE;
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 2){
		fprintf (stderr,"UMSDOS EMD file dump\nudump file\n");
	}else{
		FILE *fin = fopen (argv[1],"r");
		if (fin == NULL){
			fprintf (stderr,"Can't open %s\n",argv[1]);
		}else{
			struct umsdos_dirent entry;	
			int no = 1;
			while (fread(&entry,UMSDOS_REC_SIZE,1,fin)==1){
				int size=umsdos_evalrecsize(entry.name_len);
				if (entry.name_len == 0){
					printf ("%3d - Empty.\n", no);
				}else{
					if ((size!=UMSDOS_REC_SIZE)&&
					    (fread( ( ((char *)&entry )+UMSDOS_REC_SIZE) ,size-UMSDOS_REC_SIZE,1,fin )!=1)){
						fprintf (stderr,"End of record missing.\n");
					}else{

						printf ("%3d - uid(%d) gid(%d) mode(%o) flags(%d) "
							"rdev(%d,%d)\n", no
							,entry.uid,entry.gid,entry.mode,entry.flags
							,entry.rdev>>8,entry.rdev&0xff);
						printf ("      atime(%d) mtime(%d) ctime(%d) nlink(%d)\n"
							,entry.atime,entry.mtime,entry.ctime
							,entry.nlink);
						printf ("      name_len(%d) flags(%o) spare \"%12.12s\"\n"
							,entry.name_len, entry.flags, entry.spare);
						printf ("      %*.*s\n",entry.name_len,entry.name_len
							,entry.name);
					}
				}
				no+=size/UMSDOS_REC_SIZE;
			}
			ret = 0;
			fclose (fin);
		}
	}
	return ret;
}



