#ifndef _VENDORS_H
#define _VENDORS_H

/*
 *      Copyright (C) 1993 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.9d/RCS/vendors.h,v $
 $Author: bas $
 *
 $Revision: 1.9 $
 $Date: 1994/01/16 15:44:54 $
 $State: ALPHA $
 *
 *      This file contains the supported drive types
 *      with their QIC-117 spec. vendor code and
 *      drive dependent configuration information.
 */

typedef enum {
  no_wake_up = 0,
  wake_up_colorado,
  wake_up_mountain,
  wake_up_insight,
  wake_up_limit                 /* must be last entry */
} wake_up_types;

typedef struct {
  unsigned int vendor_id;       /* vendor id from drive */
  wake_up_types wake_up;        /* see wake_up_types */
  char *name;                   /* Text describing the drive */
} vendor_struct;

#define QIC117_VENDORS { \
/* see _vendor_struct */ \
  { 0x00047, wake_up_colorado,  "Colorado DJ-10/DJ-20" }, \
  { 0x00005, wake_up_mountain,  "Archive 5580i" }, \
  { 0x10005, wake_up_insight,   "Insight 80 Mb" }, \
  { 0x0014a, wake_up_mountain,  "Archive XL9250i, Conner C250MQ" }, \
  { 0x001c1, no_wake_up,        "Wangtek 3040F" }, \
  { 0x001c8, no_wake_up,        "Wangtek 3080F" }, \
  { 0x08880, no_wake_up,        "Iomega 250" }, \
  { 0x00146, wake_up_mountain,  "Escom/Archive 31250Q" }, \
  { 0x00180, wake_up_mountain,  "Summit SE 150" }, \
  { 0x00181, wake_up_mountain,  "Summit SE 250, Mountain FS8000" }, \
}


#endif
