/* File managing
   Copyright (C) 1994 Miguel de Icaza.
   The copy code is based in GNU's cp, and was written by:
   Written by Torbjorn Granlund, David MacKenzie, and Jim Meyering.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <dirent.h>
#include <stdio.h>
#include <errno.h>
#include <ncurses.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <fcntl.h>
#include "dialog.h"
#include "global.h"
#include "main.h"
#include "util.h"

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/file.c,v 1.5 1994/08/02 04:39:46 miguel Exp $";
static char x [4096];
extern char *sys_errlist [];
int verbose = 1;

void copy_file_file (char *src_path, char *dst_path)
{
    char *buf;
    int  buf_size;
    int  dest_desc;
    int  source_desc;
    int  n_read;
    int  n_written;
    int  src_mode;		/* The mode of the source file */
    struct stat sb;
    long n_read_total = 0;

    if ((source_desc = open (src_path, O_RDONLY)) < 0){
	message (1, " Error ", sys_errlist [errno]);
	return;
    }

    if (fstat (source_desc, &sb)){
	message (1, " Error ", "%s: %s", sys_errlist [errno], dst_path);
	goto ret;
    }
    src_mode = sb.st_mode;
    
    /* Create the new regular file with small permissions initially,
       to not create a security hole.  */

    if ((dest_desc = open (dst_path, O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0){
	message (1, " Error ", "cannot create regular file `%s'", dst_path);
	goto ret2;
    }

    /* Find out the optimal buffer size.  */
    if (fstat (dest_desc, &sb)){
	message (1, " Error ", "%s: %s", sys_errlist [errno], dst_path);
	goto ret;
    }

    buf_size = 4*1024;

    buf = (char *) alloca (buf_size + sizeof (int));

    if (verbose){
	message (D_INSERT, " Copying ",
		 " %s to:                   \n"
		 " %s",
		 src_path, name_trunc (dst_path, COLS-8));
    }
    
    for (;;){
	n_read = read (source_desc, buf, buf_size);
	if (n_read < 0){
	    message (1, " Error ", "%s: %s", sys_errlist [errno], src_path);
	    goto ret;
	}
	if (n_read == 0)
	    break;

	n_read_total += n_read;

	n_written = write (dest_desc, buf, n_read);
	if (n_written < n_read){
	    message (1, " Error ", "%s: %s", sys_errlist [errno], dst_path);
	    goto ret;
	}
    }

    if (chmod (dst_path, src_mode)){
	    message (1, " Error ", "%s: chmod %s", sys_errlist [errno],
		     dst_path);
    }
    if (verbose){
	destroy_dialog ();
	repaint_screen (RP_NOCLEAR);
    }
 ret:
    if (close (dest_desc) < 0)
	message (1, " Error ", "%s: %s", sys_errlist [errno], dst_path);

ret2:
    if (close (source_desc) < 0)
	message (1, " Error ", "%s: %s", sys_errlist [errno], src_path);
}

void copy_file_dir (char *s, char *d)
{
    char *dest_file = get_full_name (d, s);
    copy_file_file (s, dest_file);
    free (dest_file);
}

int move_file (char *s, char *d)
{
    sprintf (x, "/bin/mv %s %s", s, d);
    system (x);
    return 1;
}

int move_file_dir (char *s, char *d)
{
    move_file (s, d);
    return 1;
}

int erase_file (char *s)
{
    int error;

    if (verbose)
	message (D_INSERT, " Delete ", " Deleting file %s ", s);
    error = unlink (s);
    if (verbose) destroy_dialog ();
    if (error){
	message (1, " Error ", sys_errlist [errno]);
	return 0;
    }
    return 1;
}

int erase_dir (char *s)
{
    int error = rmdir (s);
    if (error){
	message (1, " Error ", sys_errlist [errno]);
	return 0;
    }
    return 1;
}

FILE *mopen (char *filename, char *mode)
{
    FILE *f;
    
    if ((f = fopen (filename, mode)) == NULL){
	message (1, " Error ", " Can't open '%s' ", filename);
	return 0;
    }
    return f;
}
