/* Color setup
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <ncurses.h>
#include "color.h"

static char rcsid [] = "$Id: color.c,v 1.3 1994/10/06 02:18:47 miguel Exp $";

/* To avoid excesive calls to ncurses' has_colors () */
int   hascolors = 0;

/* Set to force black and white display */
int   disable_colors = 0;

int sel_mark_color [4];

void init_colors ()
{
    if (!disable_colors)
	hascolors = has_colors ();
    if (hascolors){
	start_color ();
	init_pair (1, COLOR_WHITE, COLOR_BLUE);	  /* normal */
	init_pair (2, COLOR_BLACK, COLOR_CYAN);   /* selected */
	init_pair (3, COLOR_YELLOW, COLOR_BLUE);  /* marked */
	init_pair (4, COLOR_YELLOW, COLOR_CYAN);  /* marked/selected */
	init_pair (5, COLOR_WHITE, COLOR_RED);	  /* errors */
	init_pair (6, COLOR_WHITE, COLOR_CYAN);	  /* menu entry */
	init_pair (7, COLOR_BLACK, COLOR_WHITE);  /* reverse b&w */
    }
    sel_mark_color [0] = NORMAL_COLOR;
    sel_mark_color [1] = SELECTED_COLOR;
    sel_mark_color [2] = MARKED_COLOR;
    sel_mark_color [3] = MARKED_SELECTED_COLOR;
}

