#define MIN_FILES 128
#define RESIZE_STEPS 128

typedef struct {

    /* File attributes */

    int  fnamelen;
    char *fname;
    struct stat  buf;

    /* Flags */
    struct { 
	unsigned int marked:1;		/* File marked in pane window */
	unsigned int exists:1;		/* Use for rereading file */
	unsigned int link_to_dir:1;	/* If this is a link, does it point to directory? */
    } f;
} file_entry;

typedef struct {
    file_entry *list;
    int         size;
} dir_list;

typedef int sortfn (const void *, const void*);
int do_load_dir (dir_list *list, sortfn *sort, int reverse, char *filter);
void do_sort (dir_list *list, sortfn *sort, int top, int reverse);
dir_list *do_collect_stat (dir_list *dir, int top);
int do_reload_dir (dir_list *list, sortfn *sort, int count, int reverse, char *filter);
void clean_dir (dir_list *list, int count);
int set_zero_dir (dir_list *list);

/* Sorting functions */
int unsorted (const void *a, const void *b);
int sort_name (const file_entry *a, const file_entry *b);
int sort_ext (const file_entry *a, const file_entry *b);
int sort_time (const file_entry *a, const file_entry *b);
int sort_size (const file_entry *a, const file_entry *b);

int link_isdir (file_entry *);
extern int show_backups;
extern int show_dot_files;
extern int show_backups;
extern int mix_all_files;
