/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#define MBASE_C         /* Global variables go here */

#include <mbase.h>
#include "internal.h"


/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

 static relation *_fill_info   XARGS( (relation *, long, long, int) );
 static int       _struct_type XARGS( (void) );
 static void      _struct_line XARGS( (int, int, int *, int *, int *, int *) );
 static bool      _check_key   XARGS( (relation *) );


/*
 * VARIABLES ------------------------------------------------------------------
 *
 */

static bool fReally   = TRUE;    /* TRUE if mb_test() is called by the user */
static bool fReadOnly = FALSE;   /* TRUE if mb_test() opened file read-only */
static bool fMulti    = FALSE;   /* TRUE if relation has a mchar or mbyte   */
static file fh;                  /* File handle determined by mb_test()     */
static file fhDat;               /* File handle for RELATION.DAT; mb_test() */


/*
 * ROUTINES -------------------------------------------------------------------
 *
 * mb_open() isn't called directly by the user--instead, two wrapper functions
 * are provided for past-compatibility:
 *
 *     #define mb_inc(file,key)  mb_open(file,key,FALSE)
 *     #define mb_old(file,key)  mb_open(file,key,TRUE)
 *
 * This way, the final flag is set automatically, based on function name--if
 * mb_inc() is used, pre- version 5.1 relations won't be accessible; if instead
 * mb_old() is used, any relation can be OPENED, but you can't work with
 * anything before version 5.0.
 *
 */

relation *
mb_open (filename, key, fUseOld)
char    *filename;
char              *key;
bool                    fUseOld;
{
   relation     *rel = NULL;      /* Relation structure; from malloc().      */
   bool          fZero = FALSE;   /* TRUE if we need to create and zero .LCK */
   long          fld, idx;        /* Positions of fields/indices in header   */
   char          buf[256], *pch;
   long          tlong;
   short         tshort;
   int           i, iRel;


   fReally = FALSE;
   if (mb_test (filename, fUseOld) != MB_OKAY)
      {
      Error (mb_errno);
      }

   if ((rel = New (relation)) == RNULL)
      {
      Error (MB_NO_MEMORY);
      }

   rel->fReadOnly = fReadOnly;
   rel->fhRel = fh;
   rel->fhDat = fhDat;


/*
 * Great--we've now set  rel->fhRel  to the filehandle returned by mb_test().
 * The remaining code here gathers information from the relation.
 *
 */

   lseek (rel->fhRel, 0L, 0);
   readx (rel->fhRel, buf, 1);

   rel->pos = 0L;
   rel->pid = (short)getpid();
   rel->ver = (int)buf[0];
   rel->fExclusive = 0;

   for (i = 0; i < MAX_REL; i++)     /* This is guaranteed to find a slot,   */
      if (aRel[i] == RNULL)          /* because the same test is made during */
         break;                      /* the call to mb_test().               */
   aRel[i] = rel;
   iRel = i;


   if ((pch = strrchr (filename, DIRSEP)) == NULL)
      strcpy (buf, filename);
   else
      strcpy (buf, 1+pch);

   if ((pch = strrchr (buf, '.')) != NULL)
      *pch = 0;
   strcpy (rel->relname, buf);


   if (rel->ver == verMINIMUM)                    /* If this is version 4.0, */
      lseek (rel->fhRel, POS_OLDFIELDPTR, 0);     /* we have to use the old  */
   else                                           /* position of FIELDPTR.   */
      lseek (rel->fhRel, POS_FIELDPTR, 0);

   readx (rel->fhRel, &fld, 4);
   readx (rel->fhRel, &idx, 4);
   readx (rel->fhRel, &rel->posRecZ, 4);
   readx (rel->fhRel, &tlong,  4);
   readx (rel->fhRel, &tlong,  4);
   readx (rel->fhRel, &tshort, 2);  rel->nFld = tshort;
   readx (rel->fhRel, &tshort, 2);  rel->nIdx = tshort;


/*
 * Now divine the encryption key, from the string passed in.  Note that we
 * skip any leading spaces or tabs!  Gotta try to be user friendly here...
 *
 */

   for (pch = key; *pch == ' ' || *pch == '\t'; pch++)
      ;

   i = 0;
   for ( ; pch && *pch; pch++)
      {
      i = (i + (int)*pch) % 240 + 15;
      }

   rel->mask = (char)( ((i & (int)0x04) << 5) |    /* 00000100 -> 10000000 */
                       ((i & (int)0x30) << 1) |    /* 00110000 -> 01100000 */
                       ((i & (int)0x80) >> 3) |    /* 10000000 -> 00010000 */
                       ((i & (int)0x03) << 2) |    /* 00000011 -> 00001100 */
                       ((i & (int)0x40) >> 5) |    /* 01000000 -> 00000010 */
                       ((i & (int)0x08) >> 3)  );  /* 00001000 -> 00000001 */


/*
 * The relation might have been opened read-only; at which point we don't have
 * to create a .LCK file for controlling locking.
 *
 */

   if (rel->ver >= verLOWEST && ! rel->fReadOnly)
      {
      if (! * (GetTmpDir (buf)))
         {
         aRel[iRel] = RNULL;
         Error (MB_TMPDIR);
         }
      strcat (buf, rel->relname);   /* Remember, rel->relname has no path or */
      strcat (buf, ".lck");         /* extension... so provide them.         */

      if (access (buf, 0) == -1)
         {
         if ((rel->fhLock = creatx (buf)) > 0)
            {
            close (rel->fhLock);
            fZero = TRUE;
            }
         }

      modex (buf, 0666);

      if ((rel->fhLock = openx (buf, OPENMODE)) <= 0)
         {
         aRel[iRel] = RNULL;
         Error (MB_TMPERR);
         }

      if (fZero)
         {                               /* The 100 bytes consist of:    */
         for (i = 0; i < 100; i++)       /*   2 : Number of users in rel */
            buf[i] = 0;                  /*   2 : Exclustive lock        */
         lseek (rel->fhLock, 0L, 0);     /*   6 : 3 Hacklock positions   */
         writx (rel->fhLock, buf, 100);  /*  60 : 30 Queue positions     */
         }                               /*  30 : 30 Strobe positions    */

/*
 * Lock file has been created; keep going.
 *
 */

      if (_set_lck (rel))
         {
         aRel[iRel] = RNULL;
         Error (mb_errno);
         }
      }

   rel->fMulti = fMulti;

   return _fill_info (rel, fld, idx, iRel);


lblERROR:
   if (rel != NULL)
      {
      free (rel);
      rel = NULL;
      }
   if (fh < 0)
      {
      close (fh);
      fh = -1;
      }
   fReally = TRUE;
   return RNULL;
}


mb_err
mb_test (filename, fUseOld)
char    *filename;
bool               fUseOld;
{
   int     i;
   int     ver;
   char    buffer[256], *pch;

   if (! fStarted)
      {
      fStarted = TRUE;
      for (i = 0; i < MAX_REL; i++)  /* Initialize list */
         aRel[i] = RNULL;            /* (oh boy fun!)   */
      }

   for (i = 0; i < MAX_REL; i++)
      if (aRel[i] == RNULL)
         break;

   if (i == MAX_REL)
      {
      Error (MB_NO_ROOM);
      }


   strcpy (buffer, filename);
   if (! strcmp ( (pch = &buffer[strlen(buffer)-4]), ".rel"))
      *pch = 0;
   strcat (buffer, ".rel");

   fReadOnly = FALSE;

   if ((fh = openx (buffer, OPENMODE)) == -1)
      {
      if ((fh = openx (buffer, READMODE)) == -1)          /* Can we open it? */
         {
         Error (MB_NO_OPEN);
         }

      fReadOnly = TRUE;
      }
   if (readx (fh, buffer, 1) != 1)                        /* Can we read it? */
      {
      Error (MB_NO_READ);
      }

   ver = (int)buffer[0];

   if ( (! fUseOld && ver < verLOWEST)  ||
        (  fUseOld && ver < verMINIMUM) || (ver > verCURRENT) )
      {
      Error (MB_FORMAT);
      }

   lseek (fh, POS_WORKFLAG, 0);
   readx (fh, &buffer[0], 1);

   if (buffer[0] & 5)          /* Is is corrupt?  Was a process interrupted? */
      {
      Error (MB_CORRUPT);
      }
   if (buffer[0] & 8)          /* Is the datafile corrupt?                   */
      {
      Error (MB_BAD_DATA);
      }


   fMulti = (buffer[0] & 2) ? TRUE : FALSE;


/*
 * Make sure we can find the .DAT file, if we need it...
 *
 */

   fhDat = 0;

   if (fMulti)
      {
      strcpy (buffer, filename);
      if (! strcmp ( (pch = &buffer[strlen(buffer)-4]), ".rel"))
         *pch = 0;
      strcat (buffer, ".dat");

      if ((fhDat = openx (buffer, OPENMODE)) == -1)
         {
         SetError (MB_NO_DATA);
         }

      if (fReally)
         {
         close (fhDat);
         }
      }


   SetError (MB_OKAY);

/*
 * If the user called this function, we don't want to leave the filehandle
 * open.  However, if we got here from mb_open() [ mb_inc() or mb_old() ],
 * we need to leave the filehandle open (there's no reason to close it and
 * reopen the thing in mb_open()).
 *
 */

lblERROR:
   if (fReally)
      {
      if (fh > 0)
         {
         close (fh);
         }
      fh = 0;
      }

   return mb_errno;
}

static relation *
_fill_info (rel, fld, idx, iRel)
relation   *rel;
long             fld, idx;
int                        iRel;
{
   register int  i, j;
   bool          fResize;
   char          buf[128];
   short         tshort;
   int           strtype;

   switch (strtype = _struct_type ())
      {
      case 0:   Error (MB_STRUCT);
               break;
      case 4:   fResize = FALSE;
               break;
      default:  fResize = TRUE;
               break;
      }

   rel->iSerial = rel->nFld;  /* Until we find otherwise */

   rel->cbRecord = 0;

   for (i = 0; i < rel->nFld; i++)
      {
      if (lseek (rel->fhRel, fld, 0) != fld)
         {
         Error (MB_FORMAT);
         }

      readx (rel->fhRel,  buf,    1);
      readx (rel->fhRel, &tshort, 2);

      rel->fldType[i] = (ftype)buf[0];

      switch (rel->fldType[i])
         {
         case T_SHORT:   rel->cbLen[i] =  2;  /* sizeof(ushort) */   break;
         case T_USHORT:  rel->cbLen[i] =  2;  /* sizeof(short)  */   break;
         case T_FLOAT:   rel->cbLen[i] =  4;  /* sizeof(float)  */   break;
         case T_DOUBLE:  rel->cbLen[i] =  8;  /* sizeof(double) */   break;
         case T_MONEY:   rel->cbLen[i] =  8;  /* sizeof(double) */   break;
         case T_TIME:    rel->cbLen[i] =  4;  /* sizeof(long)   */   break;
         case T_LONG:    rel->cbLen[i] =  4;  /* sizeof(long)   */   break;
         case T_ULONG:   rel->cbLen[i] =  4;  /* sizeof(ulong)  */   break;
         case T_DATE:    rel->cbLen[i] =  4;  /* sizeof(long)   */   break;
         case T_PHONE:   rel->cbLen[i] = 20;  /* char[20]       */   break;
         case T_SERIAL:  rel->cbLen[i] =  4;  /* sizeof(long)   */
                         rel->iSerial = i;
                        break;
         case T_MCHAR:   rel->cbLen[i] = cbMULTI;
                        break;
         case T_MBYTE:   rel->cbLen[i] = cbMULTI;
                        break;
         default:        rel->cbLen[i] = (int)tshort;
                        break;
         }

      if (rel->fldType[i] != T_CHAR &&
          rel->fldType[i] != T_BYTE && rel->fldType[i] != T_PHONE)
         {
         switch (strtype)
            {
            case  1:
               switch (rel->cbLen[i])
                  {
                  case  8:  rel->cbRecord = round8(rel->cbRecord);  break;
                  case  4:  rel->cbRecord = round4(rel->cbRecord);  break;
                  default:  rel->cbRecord = round2(rel->cbRecord);  break;
                  }
              break;

            case  3:
               switch (rel->cbLen[i])
                  {
                  case  2:  rel->cbRecord = round2(rel->cbRecord);  break;
                  default:  rel->cbRecord = round4(rel->cbRecord);  break;
                  }
              break;

            case  4:
               fResize = TRUE;
               rel->cbRecord = round2(rel->cbRecord);
              break;
            }
         }

      rel->cbStart[i]  = rel->cbRecord;
      rel->cbRecord   += rel->cbLen[i];

      readx (rel->fhRel, buf, 20);

      for (j = 0; buf[j] != '|'; j++)
         ;
      fld += (long)j +4L;  /* Advance to next field */

      buf[j] = 0;
      strcpy (rel->fldName[i], buf);
      }

   if (fResize)
      {
      switch (strtype)
         {
         case  1:  rel->cbRecord = round8 (rel->cbRecord);  break;
         case  3:  rel->cbRecord = round4 (rel->cbRecord);  break;
         case  4:  rel->cbRecord = round2 (rel->cbRecord);  break;
         }
      }

   if (lseek (rel->fhRel, idx, 0) != idx)
      {
      Error (MB_FORMAT);
      }

   for (i = 0; i < rel->nIdx; i++)
      { 
      readx (rel->fhRel, buf,  2);
      idx += 2;

      rel->fDups[i]   = (bool)buf[0];
      rel->nIdxFld[i] =  (int)buf[1];

      readx (rel->fhRel, buf, 20);

      for (j = 0; buf[j] != ':'; j++)
         ;
      buf[j] = 0;

      strcpy (rel->idxName[i], buf);

      idx += (long)j +1;   /* (plus one for the colon) */

      lseek (rel->fhRel, idx, 0);         /* Advance to index' fields */

      for (j = 0; j < rel->nIdxFld[i]; j++)
         {
         readx (rel->fhRel, &tshort, 2);
         rel->idxFld[i][j] = tshort;
         }

      idx = lseek (rel->fhRel, 0L, 1);    /* Get current position */
      }

   rel->posRes = idx;  /* Current position == reserved segment */


   if (! _check_key (rel))
      {
      Error (MB_ENCRYPT);
      }

   SetError (MB_OKAY);
   _clr_lck (rel);

   return rel;

lblERROR:
   aRel[iRel] = RNULL;
   _clr_lck (rel);
   free (rel);
   return RNULL;
}

static bool
_check_key (rel)
relation   *rel;
{
   char  mask;

   lseek (rel->fhRel, rel->posRes, 0);
   readx (rel->fhRel, &mask, 1);

   if (mask == (char)0)                    /* If encryption key's not set, */
      {
      lseek (rel->fhRel, rel->posRes, 0);  /* Backup to the keylock byte & */
      mask = (char)1;                      /* indicate that the encryption */
      writx (rel->fhRel, &mask, 1);        /* has been chosen now.         */
      mask = rel->mask;
      writx (rel->fhRel, &mask, 1);        /* Then write the new key.      */
      }
   else
      {
      readx (rel->fhRel, &mask, 1);        /* Otherwise, just compare keys */
      }

   return (mask == rel->mask) ? TRUE : FALSE;
}


/******************************************************************************
 *
 * In general (and this is not an exhaustive list of compatibility at all):
 *
 * Structure type #1 -- SunOS 4, DECStation/ULTRIX
 *
 * Structure type #2 -- COHERENT, DOS/Zortec C
 *
 * Structure type #3 -- SunOS 3, Xenix (and NeXT, if I remember)
 *
 * Structure type #4 -- DOS/Microsoft C, Mac Programmers' Workshop
 *
 */

static int array[][4] =
 { {  0,    0,    0,    0 },      /* Each column represents one of the four  */
   { 16,   13,   16,   14 },      /* supported structure types; each row,    */
   { 20,   17,   20,   18 },      /* the various values which would be found */
   { 32,   24,   28,   26 },      /* by querying structure element #n's      */
   { 40,   32,   36,   34 },      /* offset from the beginning of the struct */
   { 48,   35,   40,   38 }  };   /* "test" (the 6th is the structure size). */

#define STDPOS(x) (          x - (char *)&test )
#define CHRPOS(x) ( (char *)&x - (char *)&test )

static int
_struct_type ()
{
   int match_1 = 0;  /* Incremented 1 for each that matches */
   int match_2 = 0;  /* Incremented 1 for each that matches */
   int match_3 = 0;  /* Incremented 1 for each that matches */
   int match_4 = 0;  /* Incremented 1 for each that matches */

   struct
    { char   a[13];
      long   b;
      char   c[7];
      double d;
      char   e[3];
    } test;

   _struct_line (STDPOS(test.a), 0, &match_1, &match_2, &match_3, &match_4);
   _struct_line (CHRPOS(test.b), 1, &match_1, &match_2, &match_3, &match_4);
   _struct_line (STDPOS(test.c), 2, &match_1, &match_2, &match_3, &match_4);
   _struct_line (CHRPOS(test.d), 3, &match_1, &match_2, &match_3, &match_4);
   _struct_line (STDPOS(test.e), 4, &match_1, &match_2, &match_3, &match_4);
   _struct_line (sizeof(test),   5, &match_1, &match_2, &match_3, &match_4);

   if (match_1 == 6)  return 1;
   if (match_2 == 6)  return 2;
   if (match_3 == 6)  return 3;
   if (match_4 == 6)  return 4;

   return 0;  /* Zero == unknown structure type */
}

static void
_struct_line (found, lineno,  match_1,  match_2,  match_3,  match_4)
int           found, lineno, *match_1, *match_2, *match_3, *match_4;
{
   if (found == array[lineno][0])  (*match_1)++;
   if (found == array[lineno][1])  (*match_2)++;
   if (found == array[lineno][2])  (*match_3)++;
   if (found == array[lineno][3])  (*match_4)++;
}

