/* Useful includes, definitions etc. */

#ifndef __STDWDEFI_H__    /* Guard against multiple inclusion */
#define __STDWDEFI_H__


#include "stdwconf.h"   /* Figure out on which system we are */
#include "ports.h"      /* and which ports of STDWIN we implement */
#include "_ARGS.h"      /* Define _ARGS() macro appropriately */


/****************************/
/* Auto-configuration tests */
/****************************/

#ifdef __GNUC__
#define nonreturning __volatile__
#else
#define nonreturning
#endif

#ifdef __STDC__
#define VOID_PTR
#define HAVE_STDLIB
#endif

#ifdef THINK_C
#ifdef THINK_C_3_0
#define NO_STRING_H
#else
#define HAVE_STDLIB
#endif
#endif

#ifdef THINK_C
#define VOID_PTR
#endif

#ifdef SYSV
#define VOID_PTR
#endif

#ifdef AMOEBA
/* Amoeba has its own way of telling which one we want: */
#ifndef VOIDSTAR
#define VOID_PTR
#endif
#endif


/*********************/
/* Universal pointer */
/*********************/

#ifdef VOID_PTR
#define UNIVPTR void *
#else
#define UNIVPTR char *
#endif


/*************/
/* C library */
/*************/

#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#ifdef HAVE_STRING_H
#include <string.h>
#else
/* Systems that don't have <string.h> should at least have <strings.h> */
#include <strings.h>
#endif

#ifdef HAVE_STRCHR
#include <string.h> /* declares strchr() */
#else
/* Systems that don't have strchr should at least have index */
#define strchr index
extern char* strchr();
#endif

#ifdef HAVE_STRRCHR
#include <string.h> /* declares strrchr() */
#else
/* Systems that don't have strrchr should at least have rindex */
#define strrchr rindex
extern char* strrchr();
#endif

#ifdef HAVE_MEMCPY
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <memory.h>
#endif
#else
/* Systems that don't have memcpy/memcmp should at least have bcopy/bcmp */
#define memcpy(dest, src, n)    bcopy(src, dest, n)
#define memcmp(a, b, cnt)       bcmp(a, b, cnt)
#endif

#ifdef THINK_C
#ifdef THINK_C_3_0
#include <proto.h>
#endif
#endif


#ifdef HAVE_STDLIB

#include <stdlib.h>

#else

#include <sys/types.h> /* For size_t -- hope it doesn't break other things */

UNIVPTR malloc _ARGS((size_t));
UNIVPTR calloc _ARGS((size_t, size_t));
UNIVPTR realloc _ARGS((UNIVPTR, size_t));

#ifndef NO_VOID_FREE
void free _ARGS((UNIVPTR));
#endif

#ifndef NO_VOID_EXIT
void exit _ARGS((int));
#endif

char *getenv _ARGS((char *));

#endif /* !HAVE_STDLIB */

/* According to the C Standard, errno may be a macro on systems with
   multiple threads.  But on older systems, it may not be declared at
   all in <errno.h>.  So we declare it here, except if it is a macro. */

#ifndef errno
extern int errno;
#endif


#ifdef HAVE_SELECT

#include <sys/types.h> /* needed for fd_set */
#include <sys/time.h>  /* needed for struct timeval */

#ifndef FD_SETSIZE

/* provide default definitions for the FD_SETSIZE, FD_SET, FD_CLR etc. macros */

#if (defined(hpux) || defined(__hpux)) && !defined(fd_set)
#define fd_set  my_fd_set               /* avoid collision with HP-UX fd_set */
#endif

#define FD_SETSIZE  256                 /* maximum number of file descriptors */
typedef int  fd_mask;                   /* a bunch of bits */
#define NFDBITS  (sizeof(fd_mask) * 8)  /* number of bits per bunch */

typedef struct fd_set { fd_mask fds_bits[(FD_SETSIZE+NFDBITS-1)/NFDBITS]; } fd_set;

#define FD_SET(n,p)  ((p)->fds_bits[(n)/NFDBITS] |= (1L<<((n)%NFDBITS)))
#define FD_CLR(n,p)  ((p)->fds_bits[(n)/NFDBITS] &= ~(1L<<((n)%NFDBITS)))
#define FD_ISSET(n,p)  ((p)->fds_bits[(n)/NFDBITS] & (1L<<((n)%NFDBITS)))

#define FD_ZERO(p)  bzero((char*)(p),sizeof(*(p)))
#ifdef HAVE_STRING_H
/* provide an alternate definition of bzero(): */
#include <string.h>
extern void* memset (void* ptr, int c, size_t len);
#define bzero(ptr,len)  memset(ptr,0,len)
#else
extern void bzero (void* ptr, int len);
#endif /* HAVE_STRING_H */

#endif /* ! FD_SETSIZE */

extern int select _ARGS((SELECT_WIDTH_T width, SELECT_SET_T* readfds,
                         SELECT_SET_T* writefds, SELECT_SET_T* exceptfds,
                         SELECT_CONST struct timeval * timeout));

#endif /* HAVE_SELECT */


/*************************************/
/* Miscellaneous useful declarations */
/*************************************/

#ifdef HAVE_GETOPT
/* Interface to system's getopt(): */
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
extern int optind;
extern char *optarg;
extern int getopt _ARGS((int, char **, char *));
#endif
#else
/* Interface to getopt() from Tools/getopt.c : */
extern int optind;
extern char *optarg;
extern int getopt _ARGS((int, char **, char *));
#endif

/* Boolean data type: */
#ifndef bool
#define bool int        /* For single variable, argument or return value */
#define tbool char      /* Tiny bool, used in structs or arrays */
#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif
#endif

/* Character shorthands: */
#define EOS '\0'
#define EOL '\n'

/* Copy string to malloc'ed memory: */
char *strdup _ARGS((const char *));

/* Other useful macros: */

#define CNTRL(x) ((x) & 0x1f) /* Usage: CNTRL('X') */

#define ABS(x) ((x) < 0 ? -(x) : (x))

#ifndef MIN
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#endif

#define CLIPMIN(var, min) if ((var) >= (min)) ; else (var)= (min)
#define CLIPMAX(var, max) if ((var) <= (max)) ; else (var)= (max)

/* Memory allocation macros: */

#define ALLOC(type) ((type*) malloc(sizeof(type)))
#define FREE(p) do { if ((p) != 0) { free((UNIVPTR)p); p = 0; } } while (0)

/* Array (re)allocation macros.
   RESIZE yields nonzero if the realloc succeeded. */

#define NALLOC(type, n) ((type*) malloc((unsigned int)(n) * sizeof(type)))
#define RESIZE(var, type, n) \
        (var = (type *) realloc((UNIVPTR)var, (unsigned int)(n) * sizeof(type)))

/* Dynamic array macros: */

#include "lists.h"

#endif /* __STDWDEFI_H__ */
