/* X11 STDWIN -- error and debugging messages */

#include "x11.h"


/* Undocumented globals to reduce the output volume */

bool _wnoerrors;                /* Suppress errors and warnings if set */
bool _wnowarnings;              /* Suppress warnings if set */
int _wtracelevel;               /* Amount of trace output wanted */
int _wdebuglevel;               /* Amount of debug output wanted */


#if defined(__STDC__) && defined(HAVE_STDARG_H)

#include <stdarg.h>

/* Fatal error message aborting the program (use for unrecoverable errors) */

void _wfatal(char* str, ...)
{       va_list args;

        va_start(args,str);
        fprintf(stderr, "%s: fatal error: ", _wprogname);
        vfprintf(stderr, str, args);
        fprintf(stderr, "\n");
        va_end(args);
        exit(1);
        /*NOTREACHED*/
}

/* Error message (use for recoverable serious errors) */

/*VARARGS1*/
void _werror(char* str, ...)
{       va_list args;

        va_start(args,str);
        if (!_wnoerrors || _wdebuglevel > 0 || _wtracelevel > 0) {
                fprintf(stderr, "%s: error: ", _wprogname);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

/* Warning message (use for informative messages) */

/*VARARGS1*/
void _wwarning(char* str, ...)
{       va_list args;

        va_start(args,str);
        if ((!_wnoerrors && !_wnowarnings) || _wdebuglevel>0 || _wtracelevel>0) {
                fprintf(stderr, "%s: warning: ", _wprogname);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

/* Trace message (use to trace user-level routine calls) */

/*VARARGS2*/
void _wtrace(int level, char* str, ...)
{       va_list args;

        va_start(args,str);
        if (_wtracelevel >= level) {
                fprintf(stderr, "%s: trace %d: ", _wprogname, level);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

/* Debug message (use for misc. debugging output) */

/*VARARGS2*/
void _wdebug(int level, char* str, ...)
{       va_list args;

        va_start(args,str);
        if (_wdebuglevel >= level) {
                fprintf(stderr, "%s: debug %d: ", _wprogname, level);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

#else

#ifdef HAVE_VARARGS_H

#include <varargs.h>

/* Fatal error message aborting the program (use for unrecoverable errors) */

/*VARARGS1*/
void _wfatal(va_alist)
  va_dcl
{       va_list args;
        char* str;

        va_start(args);
        str = va_arg(args,char*);
        fprintf(stderr, "%s: fatal error: ", _wprogname);
        vfprintf(stderr, str, args);
        fprintf(stderr, "\n");
        va_end(args);
        exit(1);
        /*NOTREACHED*/
}

/* Error message (use for recoverable serious errors) */

/*VARARGS1*/
void _werror(va_alist)
  va_dcl
{       va_list args;
        char* str;

        va_start(args);
        str = va_arg(args,char*);
        if (!_wnoerrors || _wdebuglevel > 0 || _wtracelevel > 0) {
                fprintf(stderr, "%s: error: ", _wprogname);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

/* Warning message (use for informative messages) */

/*VARARGS1*/
void _wwarning(va_alist)
  va_dcl
{       va_list args;
        char* str;

        va_start(args);
        str = va_arg(args,char*);
        if (!_wnoerrors && !_wnowarnings || _wdebuglevel>0 || _wtracelevel>0) {
                fprintf(stderr, "%s: warning: ", _wprogname);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

/* Trace message (use to trace user-level routine calls) */

/*VARARGS2*/
void _wtrace(va_alist)
  va_dcl
{       va_list args;
        int level;
        char* str;

        va_start(args);
        level = va_arg(args,int);
        str = va_arg(args,char*);
        if (_wtracelevel >= level) {
                fprintf(stderr, "%s: trace %d: ", _wprogname, level);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

/* Debug message (use for misc. debugging output) */

/*VARARGS2*/
void _wdebug(va_alist)
  va_dcl
{       va_list args;
        int level;
        char* str;

        va_start(args);
        level = va_arg(args,int);
        str = va_arg(args,char*);
        if (_wdebuglevel >= level) {
                fprintf(stderr, "%s: debug %d: ", _wprogname, level);
                vfprintf(stderr, str, args);
                fprintf(stderr, "\n");
        }
        va_end(args);
}

#else /* neither stdargs nor varargs */

/* Fatal error message aborting the program (use for unrecoverable errors) */

/*VARARGS1*/
void _wfatal(str, arg1, arg2, arg3, arg4)
        char *str;
{
        fprintf(stderr, "%s: fatal error: ", _wprogname);
        fprintf(stderr, str, arg1, arg2, arg3, arg4);
        fprintf(stderr, "\n");
        exit(1);
        /*NOTREACHED*/
}

/* Error message (use for recoverable serious errors) */

/*VARARGS1*/
void _werror(str, arg1, arg2, arg3, arg4)
        char *str;
{
        if (!_wnoerrors || _wdebuglevel > 0 || _wtracelevel > 0) {
                fprintf(stderr, "%s: error: ", _wprogname);
                fprintf(stderr, str, arg1, arg2, arg3, arg4);
                fprintf(stderr, "\n");
        }
}

/* Warning message (use for informative messages) */

/*VARARGS1*/
void _wwarning(str, arg1, arg2, arg3, arg4)
        char *str;
{
        if (!_wnoerrors && !_wnowarnings || _wdebuglevel>0 || _wtracelevel>0) {
                fprintf(stderr, "%s: warning: ", _wprogname);
                fprintf(stderr, str, arg1, arg2, arg3, arg4);
                fprintf(stderr, "\n");
        }
}

/* Trace message (use to trace user-level routine calls) */

/*VARARGS2*/
void _wtrace(level, str, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
        int level;
        char *str;
{
        if (_wtracelevel >= level) {
                fprintf(stderr, "%s: trace %d: ", _wprogname, level);
                fprintf(stderr, str,
                        arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
                fprintf(stderr, "\n");
        }
}

/* Debug message (use for misc. debugging output) */

/*VARARGS2*/
void _wdebug(level, str, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
        int level;
        char *str;
{
        if (_wdebuglevel >= level) {
                fprintf(stderr, "%s: debug %d: ", _wprogname, level);
                fprintf(stderr, str,
                        arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
                fprintf(stderr, "\n");
        }
}

#endif /* HAVE_VARARGS_H */

#endif /* HAVE_STDARG_H */

