/*
	ttysnoop.c
	
	ttysnoop is the client to ttysnoops. it can only be used on ptys
	that are snooped via a socket 'device' in /etc/snooptab.
	
	v0.00	9-1-94	Carl Declerck	- first version
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <grp.h>
#include <utmp.h>
#include <errno.h>

#include "config.h"
#include "common.h"

#define BUFF_SIZE	256

char buff[BUFF_SIZE];

int main (int argc, char *argv[])
{
	fd_set readset;
	struct sockaddr sock_addr;
	int sockfd, fdmax, quit = 0, n;
	char sockname[32];
	
	if (argc < 2)
		errorf ("Usage: ttysnoop <pty>\n");
	
	/* create the client socket */
	
	if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
		errorf ("can't create client socket\n");
	
	sprintf (sockname, "/tmp/%s", argv[1]);
	sock_addr.sa_family = AF_UNIX;
	strncopy (sock_addr.sa_data, sockname);
	if (connect(sockfd, &sock_addr, sizeof(sock_addr)) < 0)
		errorf ("can't connect to server\n");
	
	/* put stdin into raw mode */
	
	stty_initstore ();
	atexit (stty_orig);
	if (isatty(STDIN_FILENO))
		stty_raw (STDIN_FILENO);

	/* calc max file descriptor for select() */
	
	fdmax = max(STDIN_FILENO, sockfd);
	
	/* do our thing */
	
	printf ("Snoop on %s started, use %s (ASCII %d) to terminate\r\n",
		argv[1], TC_STRING, TERM_CHAR);
	
	while (!quit)
	{
		__FD_ZERO (&readset);
		__FD_SET (STDIN_FILENO, &readset);
		__FD_SET (sockfd, &readset);
		
		select (fdmax + 1, &readset, NULL, NULL, NULL);
		
		if (__FD_ISSET(STDIN_FILENO, &readset))
		{
			n = read(STDIN_FILENO, buff, BUFF_SIZE);
			write (sockfd, buff, n);
			
			if ((*buff == TERM_CHAR) && (n == 1))
				quit = 1;
		}
		
		if (__FD_ISSET(sockfd, &readset))
		{
			n = read(sockfd, buff, BUFF_SIZE);
			write (STDOUT_FILENO, buff, n);
		}
	}
	
	printf ("\r\nSnoop on %s terminated\r\n", argv[1]);
}
