# targets.make -- we don't want these to be the default, naturally.

# These are used to make and install kpathsea from the program directory.
makeargs = $(MFLAGS) SHELL='$(SHELL)' CC='$(CC)' CFLAGS='$(CFLAGS)' $(MAKEARGS)
installargs = INSTALL='$(INSTALL)' INSTALL_DATA='$(INSTALL_DATA)'

$(kpathsea): $(kpathsea_srcdir)/*.c $(kpathsea_srcdir)/*.h \
	     $(kpathsea_srcdir)/texmf.cnf.in \
             $(kpathsea_dir)/texmf.cnf $(top_srcdir)/../make/paths.make
	cd $(kpathsea_dir); $(MAKE) $(makeargs)

MakeTeXPK: MakeTeXPK.in $(top_srcdir)/../make/paths.make \
             $(top_srcdir)/../make/targets.make
	rm -f $@
	sed -e 's,@datadir@,$(datadir),' \
	    -e 's,@psheaderdir@,$(psheaderdir),' \
	    -e 's,@fontnamedir@,$(fontnamedir),' \
	    -e 's,@fontdir@,$(fontdir),' \
	    -e 's,@dcfontdir@,$(dcfontdir),' \
	    -e 's,@sauterdir@,$(sauterdir),' \
	<$(srcdir)/MakeTeXPK.in >$@
	-chmod a+x $@
default: MakeTeXPK

install-MakeTeXPK: MakeTeXPK
	$(SHELL) $(top_srcdir)/../mkdirchain $(scriptdir)
	if grep 'original MakeTeXPK --' $(scriptdir)/MakeTeXPK >/dev/null 2>&1\
	   || test ! -r $(scriptdir)/MakeTeXPK; then			\
	  $(INSTALL_PROGRAM) MakeTeXPK $(scriptdir)/MakeTeXPK;	\
	else true; fi

# End of targets.make.
