/* Term name pollution avoiding.
   Copyright (C) 1994 Miguel de Icaza
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#define INCLUDE_TERM
#include <ncurses.h>

/* This is not redundant: on BSD systems we don't do auto including */
#ifdef SUNOS_CURSES
     #include <term.h>
#else
     #ifndef TERM_INCLUDED
          #include <nterm.h>
     #endif
#endif

/* We have these functions here because main.c has a polluted name space */
/* and the definitions in term.h/nterm.h often cause problems with main. */

/* Maybe-FIXME: I think Janne said that putp will fail if the enter_ca_mode
   string isn't defined in the database.  I only used putp in do_exit_ca_mode
   for symmetry with do_enter_ca_mode, so if it causes trouble please change
   it to "write (STDOUT_FILENO, enter_ca_mode, strlen (enter_ca_mode))" etc. */

void do_enter_ca_mode (void)
{
    putp (enter_ca_mode);
}

void do_exit_ca_mode (void)
{
    putp (exit_ca_mode);
}
