#define C_BOOL		1
#define C_CHANGE	2

/* Widget_Items */

typedef struct WButton {
    Widget widget;
    int action;			/* what to do when pressed */
    unsigned int selected;	/* button state */
    char *text;			/* text of button */
    int  hotkey;                /* hot KEY */
    int  hotpos;                /* offset hot KEY char in text */
    int  (*callback)(int, void*); /* Callback function */
    void *callback_data;
} WButton;

typedef struct WRadio {
    Widget widget;
    unsigned int state;		/* radio button state */
    int pos, sel;
    int count;			/* number of members */
    char **texts;		/* texts of labels */
    int upper_letter_is_hotkey; /* If true, then the capital letter is a hk */
} WRadio;

typedef struct WCheck {
    Widget widget;
    unsigned int state;		/* check button state */
    char *text;			/* text of check button */
    int hotkey;                 /* hot KEY */                    
    int hotpos;			/* offset hot KEY char in text */
} WCheck;

typedef struct {
    Widget widget;
    Input  *in;
    int    updated;
} WInput;

typedef struct WLEntry {
    char *text;			/* Text to display */
    int  hotkey;
    void *data;			/* Client information */
    struct WLEntry *next;
    struct WLEntry *prev;
} WLEntry;

enum {
    listbox_begin, listbox_end
} listbox_insert;

/* Listbox actions when selecting an option: */
enum {
    listbox_nothing,
    listbox_finish,		/* finish dialog */
    listbox_cback		/* call the callback routine */
} listbox_action;

typedef int (*lcback) (void *);

typedef struct {
    Widget widget;
    WLEntry *list;		/* Pointer to the circular double linked list. */
    WLEntry *top;		/* The first element displayed */
    WLEntry *current;		/* The current element displayed */
    int pos;			/* Cur. pos, must be kept in sync with current */
    int count;			/* Number of items in the listbox */
    int width;
    int height;			/* Size of the widget */
    int action;			/* Action type */
    lcback cback;		/* The callback function */
} WListbox;

/* Constructors */
WButton *button_new (int y, int x, int action, char *text, int hkey, int hpos,
		     int (*callback)(int, void *), void *extra);
WRadio  *radio_new  (int y, int x, int count, char **text, int use_hotkey);
WCheck  *check_new  (int y, int x, int state,  char *text, int hkey, int hpos);
WInput *input_new (WINDOW *w, int y, int x, int color, int len, char *text);
WListbox *listbox_new (int x, int y, int width, int height, int action,
		       lcback);

/* Buttons */
void button_set_text (WButton *b, char *text);

/* Listbox manager */
char *listbox_add_item (WListbox *l, int pos, int hotkey, char *text,
		       void *data);
WLEntry *listbox_get_data (WListbox *l, int pos);

/* search text int listbox entries */
WLEntry *listbox_search_text (WListbox *l, char *text);
void listbox_select_entry (WListbox *l, WLEntry *dest);
void listbox_select_by_number (WListbox *l, int n);
void listbox_draw (WINDOW *w, WListbox *l, Dlg_head *h, int focused);
void listbox_select_last (WListbox *l, int set_top);
void listbox_get_current (WListbox *l, char **string, char **extra);
