------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             F I X _ U T I L                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                             $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Specific subprograms using universal real arithmetic for fixed point types

with Types; use Types;

package Fix_Util is

   -----------------
   -- Subprograms --
   -----------------

   procedure UR_Normal_Form
     (Real   : Ureal;
      Normal : out Ureal;
      Scale  : out Uint);
   --  Gives the parameters of the normal form of a real value
   --  (see Hilfinger algorithms for fixed types).
   --
   --  Normal is in the interval [1/2, 1[ and we have the following relation:
   --    (2 ** Scale) * Normal =  Real.

   function UR_Round (Real : Ureal; N : Uint) return Ureal;
   --  Returns a value with an accuracy equivalent to N digits of the
   --  given real value.

   function UR_Sign (Real : Ureal) return Uint;
   --  Returns -1 if real strictly negative and 1 otherwise.

   function UR_Sign_Plus (Real : Ureal) return Uint;
   --  Returns 1 if Input >= 0.0 and 0 otherwise.

end Fix_Util;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Wed May 25 16:56:41 1994;  author: crozes
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Thu May 26 02:34:36 1994;  author: dewar
--  Minor reformatting
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
