/* 
   Unix SMB/Netbios implementation.
   Version 1.8.
   Copyright (C) Andrew Tridgell 1992,1993,1994
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "includes.h"

/*
This is a wrapper around the system call to allow commands to run correctly 
as non root from a program which is switching between root and non-root 

It takes one argument as argv[1] and runs it after becoming a non-root
user
*/
int main(int argc,char *argv[])
{
  close(0);
  close(1);
  close(2);

  if (getuid() != geteuid())
    {
      int uid,gid;
      
      if (getuid() < geteuid())
	uid = geteuid();
      else
	uid = getuid();
      
      if (getgid() < getegid())
	gid = getegid();
      else
	gid = getgid();
      
#ifdef USE_SETRES
      setresgid(0,0,0);
      setresuid(0,0,0);
      setresgid(gid,gid,gid);
      setresuid(uid,uid,uid);      
#else      
      setuid(0);
      seteuid(0);
      setgid(gid);
      setegid(gid);
      setuid(uid);
      seteuid(uid);
#endif

      if (getuid() != uid)
	return(3);
    }

  if (geteuid() != getuid())
    return(1);

  if (argc < 2)
    return(2);

  return(system(argv[1]));
}
