/* #module    IdxMaster    "3-001"
 ***********************************************************************
 *                                                                     *
 * The software was developed at the Monsanto Company and is provided  *
 * "as-is".  Monsanto Company and the auther disclaim all warranties   *
 * on the software, including without limitation, all implied warran-  *
 * ties of merchantabilitiy and fitness.                               *
 *                                                                     *
 * This software does not contain any technical data or information    *
 * that is proprietary in nature.  It may be copied, modified, and     *
 * distributed on a non-profit basis and with the inclusion of this    *
 * notice.                                                             *
 *                                                                     *
 ***********************************************************************
 */

/*
 * Module Name:	IdxMaster
 *
 * Author:	R L Aurbach	CR&DS MIS Group    09-Apr-1987
 *
 * Function:
 *	File processing routines for IdxTex
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	09-Apr-1987	Original Code
 * 1-002	RLA	15-Apr-1987	Add support for cross-referencing
 * 3-001	F.H.	17-May-1991	converted to portable C
 */
/*
 * Module IdxMaster - Module-Wide Data Description Section
 *
 * Include Files:
 */
#ifdef MSDOS
#include <stdlib.h>
#include <io.h>
#define F_OK		0	/* access(): File exists */
#else
#include <sys/file.h>
/* extern char *sprintf(); */
#endif
#include <string.h>
/*#include <malloc.h>*/
#include <stdio.h>
#include "IdxDef.h"
/*
 * Module Definitions:
 */
#define	TRUE	    1
#define	FALSE	    0
#define	linebfsize  133		/* Maximum line buffer size */
/*
 * Global Declarations:
 */
/*
 * Static Declarations:
 */
#ifdef MSDOS
void idx_process_file(char *filename, char *vol);
int idx_parse_master(char *linebf, char *filename, char *vol_ptr);
#else
void idx_process_file();
int idx_parse_master();
#endif
/*
 * External References:
 */
#ifdef MSDOS
extern void idx_parse(char *linebf, char *token_1, char *token_2,
	char *token_3, char *page_no, int *token_ct, int *flag);
extern void idx_build_tree(char *token_1, char *token_2, char *token_3,
	char *page_no, char token_ct, char *vol, int flag);
extern int idx_extract(char *string, int *start, int *length);
#else
extern void idx_parse();
extern void idx_build_tree();
extern int idx_extract();
#endif
/*
 * Functions Called:
 */
/*
 * Function Idx_Process_File - Documentation Section
 *
 * Discussion:
 *	Process an input file, building the internal tree structure.
 *
 * Calling Synopsis:
 *	call Idx_Process_File (filename, vol)
 *
 * Inputs:
 *	filename    ->	is a character string containing the file specification
 *			of the file to be processed.
 *
 *	vol	    ->	is a pointer to a character string descriptor for the
 *			volume name string of this volume.  Used for processing
 *			master indices.
 *
 * Outputs:
 *	none
 *
 * Return Value:
 *	none
 *
 * Global Data:
 *	none
 *
 * Files Used:
 *	The specified input file is read.
 *
 * Assumed Entry State:
 *	none
 *
 * Normal Exit State:
 *	none
 *
 * Error Conditions:
 *	If the file does not exist, the file is ignored.
 *
 * Algorithm:
 *	A. Open the file.
 *	B. For all records in the file,
 *	    1. Read the next record.
 *	    2. Call Idx_Parse to parse the record into tokens.
 *	    3. Call Idx_Build_Tree to enter the information into the Index Tree.
 *	C. Close the file.
 *
 * Special Notes:
 *	none
 */
/*
 * Function Idx_Process_File - Code Section
 */
void idx_process_file(filename, vol)
     char    *filename;	/* Filename string	 */
     char    *vol;	/* Volume string pointer */
{
/*
 * Local Declarations
 */
  FILE	    *file;		    /* File pointer	*/
  char	    linebf[linebfsize];	    /* I/O line buffer	*/
  char	    tok_1[linebfsize];	    /* 1st token	*/
  char	    tok_2[linebfsize];	    /* 2nd token	*/
  char	    tok_3[linebfsize];	    /* 3rd token	*/
  char	    pg_no[linebfsize];	    /* Page number ref	*/
  int	    tok_ct;		    /* Token count	*/
  int	    flag;		    /* Xref flag	*/
  char      dna[133];
/*
 * Module Body
 */
  (void)sprintf(dna, "%s.idx", filename);
  if ((file = fopen(dna, "r")) == NULL) {
    (void)printf("Could not open input file %s -- File ignored\n",
		 filename);
    return;
  }
  while (fgets(linebf, linebfsize, file) != 0) {
    idx_parse (linebf, tok_1, tok_2, tok_3, pg_no, &tok_ct, &flag);
    idx_build_tree (tok_1, tok_2, tok_3, pg_no, (char)tok_ct, vol, flag);
  }
  (void)fclose(file);
}
/*
 * Function Idx_Parse_Master - Documentation Section
 *
 * Discussion:
 *	Parse a line of the Master Index file and return a flag indicating
 *	whether a valid line of input was found.
 *
 * Calling Synopsis:
 *	ok = Idx_Parse_Master (linebf, filename, vol_ptr);
 *
 * Inputs:
 *	linebf	    ->	is the input line buffer, passed as an ASCIZ string.
 *
 * Outputs:
 *	filename    ->	is the file specification of the input file to be
 *			processed, passed as an ASCIZ string.
 *
 *	vol_ptr	    ->	is a pointer to a character string descriptor which
 *			describes the label associated with this file, passed
 *			by reference.
 *
 * Return Value:
 *	ok	    ->	is a boolean flag
 *
 * Global Data:
 *	none
 *
 * Files Used:
 *	In practice, the source of the input linebf is a file.  However, the
 *	routine does no file I/O itself.
 *
 * Assumed Entry State:
 *	none
 *
 * Normal Exit State:
 *	ok = TRUE	A valid line was seen and parsed.
 *	ok = FALSE	The line was not valid -- it is treated as a comment.
 *
 * Error Conditions:
 *	none
 *
 * Algorithm:
 *	A. Verify that the line has the form "\usefile{label}{file}"
 *	B. Parse "label" as the volume string.
 *	C. Parse "file" as the filename.
 *
 * Special Notes:
 *	none
 */
/*
 * Function Idx_Parse_Master - Code Section
 */
int idx_parse_master(linebf, filename, vol_ptr)
     char	*linebf;	/* Input line buffer	    */
     char	*filename;	/* Filename string	    */
     char	*vol_ptr;	/* Volume string pointer    */
{
/*
 * Local Declarations
 */
  int		i;		/* Start of String index    */
  int		len;		/* Length of string	    */
  int		next;		/* next substring index	    */
/*
 * Module Body
 */
  if (strncmp(linebf, "\\usefile{", 9) != 0) return (FALSE);
  if (vol_ptr == 0) return (FALSE);
  i = 8;
  next = idx_extract(linebf, &i, &len);
  if (len > 0) (void)strncpy(vol_ptr,&linebf[i],len);
  i = next;
  next = idx_extract(linebf, &i, &len);
  if (len == 0)	return (FALSE);
  (void)strncpy (filename, &linebf[i], len);
  filename[len] = '\0';
  return (TRUE);
}
