'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/send.n,v 1.6 93/04/26 16:32:07 ouster Exp $ SPRITE (Berkeley)
'/" 
.so man.macros
.HS send tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
send \- Execute a command in a different interpreter
.SH SYNOPSIS
\fBsend \fIinterp cmd \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command arranges for \fIcmd\fR (and \fIarg\fRs) to be executed in the
interpreter named by \fIinterp\fR.  It returns the result or
error from that command execution.  \fIInterp\fR must be the
name of an interpreter registered on the display associated with
the interpreter in which the command is invoked;  it need not
be within the same process or application.  If no \fIarg\fR
arguments are present, then the command to be executed is
contained entirely within the \fIcmd\fR argument.  If one or
more \fIarg\fRs are present, they are concatenated to form the
command to be executed, just as for the \fBeval\fR Tcl command.

.SH SECURITY
.PP
.VS
The \fBsend\fR command is potentially a serious security loophole,
since any application that can connect to your X server can send
scripts to your applications.
These incoming scripts can use Tcl to read and
write your files and invoke subprocesses under your name.
Host-based access control such as that provided by \fBxhost\fR
is particularly insecure, since it allows anyone with an account
on particular hosts to connect to your server, and if disabled it
allows anyone anywhere to connect to your server.
In order to provide at least a small amount of
security, Tk checks the access control being used by the server
and rejects incoming sends unless (a) \fBxhost\fR-style access control
is enabled (i.e. only certain hosts can establish connections) and (b) the
list of enabled hosts is empty.
This means that applications cannot connect to your server unless
they use some other form of authorization
such as that provide by \fBxauth\fR.
.VE

.SH KEYWORDS
interpreter, remote execution, security, send
