/* Color setup
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <ncurses.h>
#include <stdlib.h>
#include <string.h>
#include "mad.h"
#include "setup.h"		/* For the externs */
#include "color.h"

static char rcsid [] = "$Id: color.c,v 1.5 1995/01/27 02:34:19 miguel Exp $";

/* To avoid excessive calls to ncurses' has_colors () */
int   hascolors = 0;

/* Set to force black and white display at program startup */
int   disable_colors = 0;

/* Set if we are actually using colors */
int use_colors = 0;

int sel_mark_color [4];

#define ELEMENTS(arr) ( sizeof(arr) / sizeof((arr)[0]) )

struct colorpair {
    char *name;			/* Name of the entry */
    int fg;			/* foreground color */
    int bg;			/* background color */
};

static struct colorpair color_map [] = {
    { "normal=",     COLOR_WHITE, COLOR_BLUE },             /* normal */
    { "selected=",   COLOR_BLACK, COLOR_CYAN },             /* selected */
    { "marked=",     COLOR_YELLOW, COLOR_BLUE },            /* marked */
    { "markselect=", COLOR_YELLOW, COLOR_CYAN },         /* marked/selected */
    { "errors=",     COLOR_WHITE, COLOR_RED },              /* errors */
    { "menu=",       COLOR_WHITE, COLOR_CYAN },             /* menu entry */
    { "reverse=",    COLOR_BLACK, COLOR_WHITE },            /* reverse */

    /* Dialog colors */
    { "dnormal=",    COLOR_BLACK, COLOR_WHITE },     /* Dialog normal */
    { "dfocus=",     COLOR_BLACK, COLOR_CYAN  },     /* Dialog focused */
    { "dhotnormal=", COLOR_YELLOW,COLOR_WHITE },     /* Dialog normal/hot */
    { "dhotfocus=",  COLOR_YELLOW,COLOR_CYAN }      /* Dialog focused/hot */
};

struct color_table_s {
    char *name;
    int  value;
};

struct color_table_s color_table [] = {
    { "black",   COLOR_BLACK   },
    { "red",     COLOR_RED     },
    { "green",   COLOR_GREEN   },
    { "yellow",  COLOR_YELLOW  },
    { "blue",    COLOR_BLUE    },
    { "magenta", COLOR_MAGENTA },
    { "cyan",    COLOR_CYAN    },
    { "white",   COLOR_WHITE   }
};

static void get_color (char **cpp, int *colp)
{
    int i;
    
    for (i = 0; i < ELEMENTS(color_table); i++){
	int klen = strlen (color_table[i].name);
	
	if (strncmp (*cpp, color_table [i].name, klen) == 0){
	    *cpp += klen;
	    *colp = color_table [i].value;
            return;
	}
    }
}

static void get_two_colors (char **cpp, struct colorpair *colorpairp)
{
    get_color (cpp, &colorpairp->fg);
    for(;;){
	if (!**cpp || **cpp == ':')
	    return;
	if (*(*cpp)++ == ',')
	    break;
    }
    get_color (cpp, &colorpairp->bg);
}

void configure_colors_string (char *color_string)
{
    int  i;
    
    while (color_string && *color_string){
	while (*color_string == ' ' || *color_string == '\t')
	    color_string++;

	for (i = 0; i < ELEMENTS(color_map); i++){
	    int klen = strlen (color_map [i].name);

	    if (strncmp (color_string, color_map [i].name, klen) == 0){
		color_string += klen;
		get_two_colors (&color_string, &color_map [i]);
	    }
	}
	while(*color_string && *color_string++ != ':')
	    ;
    }
}

static void configure_colors (void)
{
    /* read colors from environment variable MC_COLOR_TABLE */

    configure_colors_string (setup_color_string);
    configure_colors_string (term_color_string);
    configure_colors_string (getenv ("MC_COLOR_TABLE"));
}

void init_colors (void)
{
    int i;
    
    hascolors = has_colors ();

    if (!disable_colors && hascolors)
	use_colors = 1;

    if (use_colors){
	start_color ();
	configure_colors ();
	for (i = 0; i < ELEMENTS (color_map); i++)
	    init_pair (i+1, color_map [i].fg, color_map [i].bg);
    }

    sel_mark_color [0] = NORMAL_COLOR;
    sel_mark_color [1] = SELECTED_COLOR;
    sel_mark_color [2] = MARKED_COLOR;
    sel_mark_color [3] = MARKED_SELECTED_COLOR;
}

void toggle_color_mode (void)
{
    if (hascolors)
	use_colors = !use_colors;
}
