/* Extension dependent execution.
   Copyright (C) 1994 Miguel de Icaza.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <ncurses.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <malloc.h>
#include <string.h>
#include <errno.h>
#include "mad.h"
#include "user.h"
#include "main.h"
#include "util.h"
#include "dialog.h"
#include "global.h"
#include "ext.h"

static char rcsid [] = "$Id: ext.c,v 1.9 1995/01/27 02:34:47 miguel Exp $";

void exec_extension (char *data)
{
    char *file_name = tmpnam (0);
    FILE *cmd_file;
    int  expand_prefix_found = 0;
    int parameter_found = 0;
    char prompt [80];
    
    if ((cmd_file = fopen (file_name, "w+")) == NULL){
	message (1, " Error ", " Can't create temporary command file \n %s ",
		 unix_error_string (errno));
	return;
    }
    prompt [0] = 0;
    for (;*data && *data != '\n'; data++){
	if (parameter_found){
	    if (*data == '}'){
		char *parameter;
		parameter_found = 0;
		parameter = input_dialog (" Parameter ", prompt, "");
		if (!parameter){
		    /* User canceled */
		    fclose (cmd_file);
		    unlink (file_name);
		    return;
		}
		fputs (parameter, cmd_file);
		free (parameter);
	    } else {
		int len = strlen (prompt);
		prompt [len] = *data;
		prompt [len+1] = 0;
	    }
	} else if (expand_prefix_found){
	    expand_prefix_found = 0;
	    if (*data == '{')
		parameter_found = 1;
	    else {
		char *text = expand_format (*data);
		fputs (text, cmd_file);
		free (text);
	    }
	} else {
	    if (*data == '%')
		expand_prefix_found = 1;
	    else
		fputc (*data, cmd_file);
	}
    }
    fclose (cmd_file);
    chmod (file_name, S_IRWXU);
    execute (file_name);
    unlink (file_name);
}

void regex_command (char *filename)
{
    char *extension_file;
    char *data;
    char *p;
    int  col;
    char *buffer;
    int old_patterns;
    int  file_len = strlen (filename);

    buffer = copy_strings (home_dir, "/.mc.ext", 0);
    if (exist_file (buffer))
	extension_file = buffer;
    else
	extension_file = LIBDIR "mc.ext";

    if ((data = load_file (extension_file)) == NULL){
	free (buffer);
	return;
    }
    
    free (buffer);
    
    col = 0;
    old_patterns = easy_patterns;
    for (p = check_patterns (data); *p; p++){
	if (*p == '\n'){
	    col = 0;
	    continue;
	}
	col++;
	if (col > 0 && (*p == ' ' || *p == '\t')){
	    *p = 0;
	    if (*(p-(col-1)) == '.'){
		if (strcmp (p-(col-1), (filename+file_len-(col-1))) == 0){
		    exec_extension (p+1);
		    break;
		}
	    } else {
		if (regexp_match (p-(col-1), filename, match_file)){
		    exec_extension (p+1);
		    break;
		}
	    }
	    if ((p = strchr (p+1, '\n'))){
		col = 0;
	    }
	    else
		break;
	}
    }
    easy_patterns = old_patterns;
    free (data);
}
