
/* If you add a view type to this enum, please modify the relevant
   macros is_view_* */

enum {
    view_full, view_brief, view_long,
    view_info, view_tree, view_quick,
    view_user, view_nothing };

#define is_view_file_listing(x)              \
    ((x == view_full) || (x == view_brief) || \
     (x == view_long) || (x == view_user))

#define is_view_special(x) ((x == view_info) || (x == view_quick))

enum { show_dates, show_perm };
enum { brief_mode, full_mode, long_mode };

#define J_LEFT  0
#define J_RIGHT 1

typedef struct {
    int  field_len;
    char *(*string_fn)(file_entry *);
    int  just_mode;
    char *title;
} format_e;

enum panel_display_enum {
    frame_full,
    frame_half
};

typedef struct {
    dir_list dir;		/* Directory contents */
    
    int      view_type;		/* type of view */
    int      active;		/* If panel is currently selected */
    char     cwd [MAXPATHLEN];	/* Current Working Directory */
    char     lwd [MAXPATHLEN];	/* Last Working Directory */
    int      count;		/* Number of files in dir structure */
    int      lines;		/* Available panel lines for display */
    int      cols;		/* Current panel columns */
    int      half_cols;		/* Columns in half screen mode */
    int      full_cols;		/* Columns in full screen mode */
    int      marked;		/* Count of marked files */
    int      dirs_marked;	/* Count of marked directories */
    long int total;		/* Bytes in marked files */
    int      top_file;		/* The file showed on the top of the panel */
    int      selected;		/* Index to the selected file */
    int      is_status;		/* Is the panel a status display? */
    int      reverse;		/* Show listing in reverse? */
    int      split;		/* Split panel to allow two columns */
    sortfn   *sort_type;	/* Sort type */
    char     *filter;		/* File name filter */

    char     *user_format;	/* User format */
    int	     user_mini_status;  /* Is mini_status_format used */
    char    *mini_status_format;/* User format for mini status line */
    format_e *format;		/* Display format */
    
    int      fmt_count;		/* Number of formats */
    WINDOW   *win_file;		/* Where the files are listed */
    
    WINDOW   *small_frame;	/* Default small frame */
    WINDOW   *big_frame;	/* For long display */

    struct   stat dir_stat;	/* Stat of current dir: used by execute () */
    int      dont_reload;       /* Flag: special filelisting, can't reload */
} Panel;

void do_init_panel (Panel *panel);
void init_panel (Panel *panel, int x1, int y1, int x2, int y2);
void paint_panel (Panel *panel);
void panel_refresh (Panel *panel);
void set_attr (Panel *panel, int hilight, int marked);
void Xtry_to_select (Panel *panel, char *name);

extern int show_mini_info;

extern file_entry *selection;

extern int fast_reload;

extern int extra_info;

/*#define ITEMS(p) ((p)->view_type == view_brief ? (p)->lines *2 : (p)->lines)
*/
/* The return value of panel_reload */
#define CHANGED 1

#define PANEL_ISVIEW(p) (p->view_type == view_brief || \
			 p->view_type == view_full  || \
			 p->view_type == view_long  || \
			 p->view_type == view_user  || \
			 p->view_type == view_tree)

#define RP_ONLY_PAINT 0
#define RP_SETPOS 1

void set_colors (Panel *panel);
void repaint_file (Panel *panel, int file_index, int move);
void display_mini_info (Panel *panel);
void panel_reload (Panel *panel);
void paint_dir (Panel *panel);
void show_dir (Panel *panel);

void change_view (Panel *panel, int view_type);
void brief_frame (Panel *panel);
void full_frame (Panel *panel);
void long_frame (Panel *panel);
extern void paint_info_panel (Panel *);
extern void paint_quick_view_panel (Panel *);
void info_frame (Panel *panel);
extern Panel *the_info_panel;
void paint_frame (Panel *panel);

format_e *parse_display_format (Panel *panel, char *format, 
				    int *frame_size, char **error, int isstatus);
char *panel_format (Panel *panel);
char *set_panel_format (Panel *p, char *format);


extern Panel *current_panel;
extern Panel *other_panel;

extern Panel left_panel;
extern Panel right_panel;
void try_to_select (Panel *panel, char *name);

#define DEFAULT_USER_FORMAT "half type,name,|,size,|,perm"

/* Defined in main */
void unmark_file (Panel *panel);
void select_item (Panel *panel);
