/* Window utilities */

void wclrn (WINDOW *w, int i);
void wprint_bytesize (WINDOW *w, int size, int scale);

/* Labels at the screen bottom */
void define_label (WINDOW *fkeys, int index, char *text, void (*)(void));
void set_label_text (WINDOW *fkeys, int index, char *text);
void define_label_quit (WINDOW *fkeys, int index, char *text, int (*cback)(void));

/* Keys managing */
int check_fkeys (int c);
WINDOW *push_fkey (int has_labels);
void pop_fkey (WINDOW *w);
typedef void (*movefn)(int);
int check_movement_keys (int c, int additional, int page_size,
    movefn backfn, movefn forfn, movefn topfn, movefn bottomfn);

/* Terminal managing */
void do_enter_ca_mode (void);
void do_exit_ca_mode (void);
#define wclr(w) wclrn(w, 0)

#define winpos(y_size,x_size) (LINES-y_size)/2, (COLS-x_size)/2
#define centerwin(y_size,x_size) \
    newwin (y_size, x_size, (LINES-y_size)/2, (COLS-x_size)/2)
