/****************************************************************************/
/*                                                                          */
/*                         GNAT RUN-TIME COMPONENTS                         */
/*									    */
/*		        Text_IO Auxiliary C functions                       */
/*									    */
/*				    Body				    */
/*                                                                          */
/*                            $Revision: 1.3 $                              */
/*                                                                          */
/*             Copyright (c) 1992,1993, NYU, All Rights Reserved            */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms  of the GNU  General  Public  License  as  published  by the  Free */
/* Software  Foundation;  either version 2,  or (at your option)  any later */
/* version.  GNAT is distributed  in the hope  that it will be useful,  but */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- */
/* ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public */
/* License  for  more details.  You should have received  a copy of the GNU */
/* General Public License along with GNAT;  see file COPYING. If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>

/* Function wrappers are needed to access the values from Ada which are */
/* defined as C macros.                                                 */

FILE *c_stdin  (void) { return stdin; }
FILE *c_stdout (void) { return stdout;}
FILE *c_stderr (void) { return stderr;}

#ifndef SEEK_SET    /* Symbolic constants for the "fseek" function: */
#define SEEK_SET 0  /* Set file pointer to offset */
#define SEEK_CUR 1  /* Set file pointer to its current value plus offset */
#define SEEK_END 2  /* Set file pointer to the size of the file plus offset */
#endif

int   seek_set_function (void)  { return SEEK_SET; }
int   seek_end_function (void)  { return SEEK_END; }
void *null_function     (void)  { return NULL;     }

int c_fileno (FILE *s) { return fileno (s); }
