/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985 by Supoj Sutanthavibul
 *
 * "Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both the copyright
 * notice and this permission notice appear in supporting documentation. 
 * No representations are made about the suitability of this software for 
 * any purpose.  It is provided "as is" without express or implied warranty."
 */

#include "fig.h"
#include "mode.h"
#include "resources.h"

#define MAXERRORS 6
#define MAXERRMSGLEN 512

static int	error_cnt = 0;

/* VARARGS1 */
put_err(format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
    char	   *format, *arg1, *arg2, *arg3, *arg4, *arg5, *arg6, *arg7,
		   *arg8;
{
    fprintf(stderr, format, arg1, arg2, arg3, arg4, arg5,
	    arg6, arg7, arg8);
    put_msg(format, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
}

error_handler(err_sig)
    int		    err_sig;
{
    switch (err_sig) {
    case SIGHUP:
	fprintf(stderr, "\nxfig: SIGHUP signal trapped\n");
	break;
    case SIGFPE:
	fprintf(stderr, "\nxfig: SIGFPE signal trapped\n");
	break;
#ifndef NO_SIBGUS
    case SIGBUS:
	fprintf(stderr, "\nxfig: SIGBUS signal trapped\n");
	break;
#endif
    case SIGSEGV:
	fprintf(stderr, "\nxfig: SIGSEGV signal trapped\n");
	break;
    }
    emergency_quit();
}

X_error_handler(d, err_ev)
    Display	   *d;
    XErrorEvent	   *err_ev;
{
    char	    err_msg[MAXERRMSGLEN];

    XGetErrorText(tool_d, (int) (err_ev->error_code), err_msg, MAXERRMSGLEN - 1);
    (void) fprintf(stderr,
	   "xfig: X error trapped - error message follows:\n%s\n", err_msg);
    emergency_quit();
}

emergency_quit()
{
    if (++error_cnt > MAXERRORS) {
	fprintf(stderr, "xfig: too many errors - giving up.\n");
	exit(-1);
    }
    signal(SIGHUP, SIG_DFL);
    signal(SIGFPE, SIG_DFL);
#ifndef NO_SIBGUS
    signal(SIGBUS, SIG_DFL);
#endif
    signal(SIGSEGV, SIG_DFL);

    aborting = 1;
    if (figure_modified && !emptyfigure()) {
	fprintf(stderr, "xfig: attempting to save figure\n");
	if (emergency_save("xfig.SAVE") == -1)
	    if (emergency_save(strcat(TMPDIR,"/xfig.SAVE")) == -1)
		fprintf(stderr, "xfig: unable to save figure\n");
    } else
	fprintf(stderr, "xfig: figure empty or not modified - exiting\n");

    goodbye();	/* finish up and exit */
}

/* ARGSUSED */
void my_quit(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    extern Atom wm_delete_window;
    if (event && event->type == ClientMessage &&
	event->xclient.data.l[0] != wm_delete_window)
    {
	return;
    }
    emergency_quit();
}
