/*
 *  t460_cs.h $Revision$ $Date$ (David Hinds)
 */

#ifndef T460_CS_H
#define T460_CS_H

#ifndef CMD_PER_LUN
#define CMD_PER_LUN 2
#endif

#ifndef CAN_QUEUE
#define CAN_QUEUE 16
#endif

#define NCR5380_implementation_fields \
    int port

#define NCR5380_local_declare() \
register int port

#define NCR5380_setup(instance) \
    port = (instance)->io_port

#define NCR5380_read(reg) (inb(port + (reg)))
#define NCR5380_write(reg, value) (outb((value), (port + (reg))))

#define NCR5380_intr t460_intr
#define NCR5380_queue_command t460_queue_command
#define NCR5380_abort t460_abort
#define NCR5380_reset t460_reset
#define NCR5380_pread t460_pread
#define NCR5380_pwrite t460_pwrite

#define BOARD_NCR5380	0
#define BOARD_NCR53C400	1

#endif /* T460_CS_H */
