% idl mode --- primitive --- does not define any indentation.

create_syntax_table ("IDL");

define_syntax (";", "", '%', "IDL");
define_syntax ("([{", ")]}", '(', "IDL");
define_syntax ('"', '"', "IDL");
define_syntax ('\'', '\'', "IDL");
define_syntax ('\\', '\\', "IDL");
define_syntax ("0-9a-zA-Z_", 'w', "IDL");        % words
define_syntax ("-+0-9a-fA-F.xXL", '0', "IDL");   % Numbers
define_syntax (",.?:", ',', "IDL");
define_syntax ("%-+/&*=<>|!~^", '+', "IDL");
define_syntax ('@', '#', "IDL");

set_syntax_flags ("IDL", 1);	       %  case insensitive

% These are IDL reserved words
() = define_keywords ("IDL", "doeqgegtifleltneofor", 2);
() = define_keywords ("IDL", "andendformodnotproxor", 3);
() = define_keywords ("IDL", "caseelsegotothen", 4);
() = define_keywords ("IDL", "beginendifuntilwhile", 5);
() = define_keywords ("IDL", "commonendforendrependwhirepeatreturn", 6);
() = define_keywords ("IDL", "endcaseendelse", 7);
() = define_keywords ("IDL", "endwhilefunctionon_error", 8);
() = define_keywords ("IDL", "ennrepeat", 9);
() = define_keywords ("IDL", "on_ioerror", 10);

define idl_mode ()
{
   variable idl = "IDL";
   setmode (idl, 0);
   use_syntax_table (idl);
   runhooks ("idl_mode_hook");
   % This is called after the hook to give the hook a chance to load the
   % abbrev table.
   if (abbrev_table_p (idl)) use_abbrev_table (idl);
}
