/*
 * seejpeg.h
 *
 * Copyright (C) 1993, 1994 Evan Harris
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#include <stdlib.h>
#include <stdio.h>
#include <jconfig.h>
#include <jpegdata.h>

/* display.c */
void display_init(int image_width, int image_height, int components);
void display_set_palette(int num_colors, JSAMPARRAY colormap, int components);
void display_set_greyscale_palette(void);
void display_rows(int num_rows, JSAMPIMAGE pixel_data, int image_width,
		  int components);
void scroll_until_end(void);
void display_shutdown(void);

/* image.c */
int read_image_file (char *filename);

/* jpeg.c */
int read_JPEG_file (char *filename);
void error_exit (const char *msgtext);
void trace_message (const char *msgtext);

/* cmap.c */
void translate_init(void);
void translate_row(int width, JSAMPARRAY rgb_row, JSAMPARRAY cmap_row);

/* variables */
extern int opt_greyscale, opt_onepass, opt_quantize, opt_verbose;
extern int opt_forcemode, opt_widthonly, opt_doublex, opt_doubley;
extern int opt_slideshow, opt_cycle;
extern double opt_fuzz;

/*
 * The video mode we test for to see if hicolor or truecolor modes are
 * available.
 *
 * If this mode is not available we assume that only colour mapped
 * (256 colour) modes are available and we automatically set two pass
 * quantization for the user.  Unfortunately, two pass quantization in
 * JPEG is a memory pig.
 */

#ifndef TESTMODE
#define TESTMODE G640x480x32K
#endif
