#include <syscall.h>
#include <sys/signal.h>

int sigsuspend(sigset_t *sigmask)
{
	int res;

	__asm__("movel %1,%/d0\n\t"
		"clrl  %/d1\n\t"
		"clrl  %/d2\n\t"
		"movel %2,%/d3\n\t"
		"trap  #0\n\t"
		"movel %/d0,%0"
		:"=g" (res)
		:"i" (SYS_sigsuspend), "g" (*sigmask)
		: "%d0", "%d1", "%d2", "%d3");
	if (res >= 0)
		return res;
	errno = -res;
	return -1;
}
