/* os.h -- Routines defined in os.c */

/* Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if !defined (_OS_H_)
#define _OS_H_

#include <packet.h>

/* Return a NULL terminated array of (FINGER_PACKET *) which represents
   the list of interesting users on *this* machine.  Single argument
   ALL_USERS when zero means don't place any user in the output list twice. */
FINGER_PACKET **get_finger_data ();

/* Return a NULL terminated array of (FINGER PACKET *) manufactured
   from the members of UTMPLIST (a NULL terminated array of struct utmp *). */
FINGER_PACKET **utmp_to_packets ();

/* Return an array of the users which are using this machine.  If UNIQUE
   is non-zero, we only return one entry per each user; the one with the
   least idle time.  The utmp entry which corresponds to the user who is
   on the console has the first character of the name or'ed with 0x80. */
struct utmp **make_utmp_array ();

/* Return the time that TTY was last accessed.  TTY is the name of the
   terminal device, as in "ttyp0", or "console". */
long get_last_access ();

/* Return a string which is the location of the terminal in utmp ENTRY. */
char *tty_location ();


#endif /* _OS_H_ */
