#ifndef _Wlib_h_
#define _Wlib_h_
/*
 * Wlib.h
 * 
 * Include file for the Windowing interface.
 * 
 * Kevin P. Smith  6/11/89
 * 
 * The deal is this: Call W_Initialize(), and then you may call any of the
 * listed fuinctions. Also, externals you are allowed to pass or use include
 * W_BigFont, W_RegularFont, W_UnderlineFont, W_HighlightFont, W_White,
 * W_Black, W_Red, W_Green, W_Yellow, W_Cyan, W_Grey, W_Textwidth, and
 * W_Textheight.
 */
#include "copyright2.h"

typedef int (*W_Callback) ();

extern W_Callback W_GetWindowKeyDownHandler ();
extern W_Callback W_GetWindowKeyUpHandler ();
extern W_Callback W_GetWindowButtonHandler ();
extern W_Callback W_GetWindowExposeHandler ();
extern W_Callback W_SetWindowKeyDownHandler ();
extern W_Callback W_SetWindowKeyUpHandler ();
extern W_Callback W_SetWindowButtonHandler ();
extern W_Callback W_SetWindowExposeHandler ();

typedef char   *W_Window;
typedef char   *W_Icon;
typedef char   *W_Font;
typedef int     W_Color;

extern W_Font   W_BigFont, W_RegularFont, W_UnderlineFont, W_HighlightFont;
extern W_Color  W_White, W_Black, W_Red, W_Green, W_Yellow, W_Cyan, W_Grey;
extern int      W_Textwidth, W_Textheight;
extern int      W_FastClear;

#ifdef EXTRAFONTS
extern W_Font   W_MyPlanetFont, W_FriendlyPlanetFont, W_EnemyPlanetFont;
#endif

extern void     W_Initialize( /* display */ );
extern W_Window W_MakeWindow(	/* name, x, y, width, height, parent, border,
			          color */ );
extern W_Icon   W_StoreBitmap( /* width, height, data, window */ );
extern W_Window W_MakeTextWindow(	/* name, x, y, width, height, parent,
				      border */ );
extern W_Window W_MakeScrollingWindow(	/* name, x, y, width, height,
					   parent,border */ );
extern W_Window W_MakeMenu( /* name, x, y, width, height, parent, border */ );
extern void     W_WriteText( /* window, x, y, color, str, length, font */ );
extern void     W_MaskText( /* window, x, y, color, str, length, font */ );
extern void     W_WriteBitmap( /* x, y, icon, color */ );
extern void     W_ClearArea( /* window, x, y, width, height, color */ );
extern void     W_MakeLine( /* window, x0, y0, x1, y1, color */ );
extern void     W_MapWindow( /* window */ );
extern void     W_UnmapWindow( /* window */ );
extern int      W_EventsPending( /* void */ );
extern void     W_NextEvent( /* W_Event *event */ );
extern void     W_TileWindow( /* window, bitmap */ );
extern void     W_UnTileWindow( /* window */ );
extern void     W_ChangeBorder( /* window, color */ );
extern void     W_DefineCursor(	/* window, width, height, data, mask, xhot,
				    yhot */ );
extern int      W_IsMapped( /* window */ );
extern void     W_Beep( /* void */ );
extern void     W_DestroyWindow( /* window */ );
extern int      W_WindowWidth( /* window */ );
extern int      W_WindowHeight( /* window */ );
extern int      W_Socket( /* void */ );
extern void     W_ClearWindow( /* window */ );
extern void     W_SetIconWindow( /* mainwindow, iconwindow */ );

#define W_EV_EXPOSE	1
#define W_EV_KEY	2
#define W_EV_BUTTON	3
#define W_EV_CM_BUTTON	4

#define W_LBUTTON	1
#define W_MBUTTON	2
#define W_RBUTTON	3

#ifdef SHIFTED_MOUSE
#define W_LBUTTON2	4
#define W_MBUTTON2	5
#define W_RBUTTON2	6

#define W_LBUTTON3	7
#define W_MBUTTON3	8
#define W_RBUTTON3	9

#define W_LBUTTON4	10
#define W_MBUTTON4	11
#define W_RBUTTON4	12
#endif

typedef struct event {
   int             type;
   W_Window        Window;
   int             key;
   int             x, y, width, height;
}               W_Event;

#define W_BoldFont W_HighlightFont
#endif
