#ifndef _data_h_
#define _data_h_
/*
 * data.h
 * 
 * $Log: data.h,v $
 * Revision 1.6  1993/10/05  16:40:38  hadley
 * checkin
 *
 * Revision 1.6  1993/10/05  16:38:08  hadley
 * checkin
 *
 */
#include "copyright.h"

#define EX_FRAMES 		5
#define SBEXPVIEWS 		7
#define NUMDETFRAMES		5	/* # frames in torp explosion */
#define ex_width        	64
#define ex_height       	64
#define sbexp_width        	80
#define sbexp_height       	80
#define cloud_width 		9
#define cloud_height 		9
#define plasmacloud_width 	13
#define plasmacloud_height 	13
#define etorp_width 		3
#define etorp_height 		3
#define eplasmatorp_width 	7
#define eplasmatorp_height 	7
#define mplasmatorp_width 	5
#define mplasmatorp_height 	5
#define mtorp_width 		3
#define mtorp_height 		3
#define crossmask_width 	16
#define crossmask_height 	16
#define planet_width 		30
#define planet_height 		30
#define mplanet_width 		16
#define mplanet_height 		16
#define shield_width 		20
#define shield_height 		20
#define cloak_width		20
#define cloak_height		20
#define icon_width 		112
#define icon_height 		80

extern struct player *players;
extern struct player *me;
extern struct torp *torps;
extern struct plasmatorp *plasmatorps;
extern struct status *status;
extern struct ship *myship;
extern struct stats *mystats;
extern struct planet *planets;
extern struct phaser *phasers;
extern struct message *messages;
extern struct mctl *mctl;
extern struct team *teams;
extern struct memory universe;
extern struct planet pdata[];

extern int	fastQuit;
extern int	F_gen_distress;

extern int      oldalert;
extern int      remap[];
extern int      udcounter;
extern char    *title;
extern struct plupdate pl_update[];
extern char     buttonmap[];
extern int      messpend;
extern int      lastcount;
extern int      mdisplayed;
extern int      redrawall;
extern int      nopilot;
extern int      watch;
extern int      selfdest;
extern int      lastm;
extern int      delay;
extern int      rdelay;
extern int      mapmode;
extern int      namemode;
extern int      showShields;
extern int      showStats;
extern int      msgBeep;	/* ATM - msg beep */
extern int      warncount;
extern int      warntimer;
extern int      infomapped;
#ifdef SCAN
extern int      scanmapped;	/* ATM - scanner stuff */
#endif				/* ATM */
extern int      mustexit;
extern int      messtime;
extern int      keeppeace;
#ifdef GATEWAY
extern unsigned LONG netaddr;	/* for blessing */
#endif

extern int      messageon;
extern int      warp;

#ifdef RSA
/* extern char testdata[]; Not needed in RSA 2.0 */
extern int      RSA_Client;
#endif

#ifdef NBT
extern struct macro_list macro[];	/* NBT 2/26/93 */
extern int      MacroMode;
extern int      macrocnt;
#endif

#ifdef NBTDIST
extern struct distress_list distress[];
#endif

#ifdef ROTATERACE
extern int      rotate;
extern int      rotate_deg;
#endif

#ifdef NETSTAT
extern int      netstat;
extern int      netstatfreq;
extern W_Window netstatWin, lMeter;
extern int      updatespeed;
#endif

extern int      showlocal, showgalactic;
extern char    *shipnos;
extern int      sock;
extern int      xtrekPort;
extern int      queuePos;
extern int      pickOk;
extern int      lastRank;
extern int      promoted;
extern int      loginAccept;
extern unsigned localflags;
extern int      tournMask;
extern int      nextSocket;
extern int      updatePlayer[];
extern char    *serverName;
extern int      loggedIn;
extern int      reinitPlanets;
extern int      redrawPlayer[];
extern int      lastUpdate[];
extern int      timerDelay;
extern int      reportKills;
extern int	phaserWindow;

/* Just more variables :)  <isae> */
#ifdef RECORD
extern FILE    *recordFile;
extern int      recordGame;
#endif
#ifdef LOGMESG
extern FILE    *logFile;
extern int      logMess;
#endif
#ifdef MOO
extern int      sortPlayers;
#ifdef MOOBITMAPS
extern int      myPlanetBitmap;
#endif
extern int      continueTractor;
extern int      showMotdOnQ;
#endif

extern int      scanplayer;
extern int      showTractor;
extern int      commMode;	/* UDP */
extern int      commModeReq;	/* UDP */
extern int      commStatus;	/* UDP */
extern int      commSwitchTimeout;	/* UDP */
extern int      udpTotal;	/* UDP */
extern int      udpDropped;	/* UDP */
extern int      udpRecentDropped;	/* UDP */
extern int      udpSock;	/* UDP */
extern int      udpDebug;	/* UDP */
extern int      udpClientSend;	/* UDP */
extern int      udpClientRecv;	/* UDP */
extern int      udpSequenceChk;	/* UDP */
#ifdef GATEWAY
extern int      gw_serv_port, gw_port, gw_local_port;	/* UDP */
extern char    *gw_mach;	/* UDP */
#endif

extern int      showTractorPressor;
extern int      showLock;
extern int      autoKey;
extern int      extraBorder;
extern int      fillTriangle;
/* udp options */
extern int      tryUdp;

extern int      debug;

extern double   Sin[], Cos[];

extern W_Icon   stipple, clockpic, icon;

#define VIEWS 16
#ifdef GALAXY
#define NUM_TYPES 8
#else
#define NUM_TYPES 7
#endif				/* GALAXY */
extern W_Icon   expview[EX_FRAMES];
extern W_Icon   sbexpview[SBEXPVIEWS];
extern W_Icon   cloud[NUMDETFRAMES];
extern W_Icon   plasmacloud[NUMDETFRAMES];
extern W_Icon   etorp, mtorp;
extern W_Icon   eplasmatorp, mplasmatorp;
#ifdef VSHIELD_BITMAPS
#define SHIELD_FRAMES 5
extern W_Icon   shield[SHIELD_FRAMES], cloakicon;
extern int      VShieldBitmaps;
#else
extern W_Icon   shield, cloakicon;
#endif

#ifndef DYNAMIC_BITMAPS
extern W_Icon   fed_bitmaps[NUM_TYPES][VIEWS], kli_bitmaps[NUM_TYPES][VIEWS], rom_bitmaps[NUM_TYPES][VIEWS], ori_bitmaps[NUM_TYPES][VIEWS], ind_bitmaps[NUM_TYPES][VIEWS];
#else
#include "bitmapstuff.h"
extern W_Icon   ship_bitmaps[NUM_BITMAP_TYPES][VIEWS];
#endif

#ifdef MOO
/* ISAE: use #define */
extern W_Icon   bplanets[NUM_PLANET_BITMAPS];
extern W_Icon   mbplanets[NUM_PLANET_BITMAPS];
extern W_Icon   bplanets2[NUM_PLANET_BITMAPS2];
extern W_Icon   mbplanets2[NUM_PLANET_BITMAPS2];

#ifdef MOOBITMAPS
extern W_Icon   bplanets3[NUM_PLANET_BITMAPS2];	/* isae: added this */
extern W_Icon   mbplanets3[NUM_PLANET_BITMAPS2];	/* isae: added this */
#endif				/* MOOBITMAPS */

#else				/* MOO */

extern W_Icon   bplanets[6];
extern W_Icon   mbplanets[6];
extern W_Icon   bplanets2[8];
extern W_Icon   mbplanets2[8];
#endif				/* MOO */

extern W_Color  borderColor, backColor, textColor, myColor, warningColor,
                shipCol[5], rColor, yColor, gColor, unColor, foreColor;

extern char lastMessage[100];

extern char    *classes[];
extern char     teamlet[];
extern char    *teamshort[];
extern char     pseudo[PSEUDOSIZE];
extern char     loginnam[PSEUDOSIZE];
#ifdef AUTOLOGIN
extern char     defpasswd[PSEUDOSIZE];
#endif

extern struct rank ranks[NUMRANKS];

extern W_Window messagew, w, mapw, statwin, baseWin, infow, iconWin, tstatw, war,
                warnw, helpWin, teamWin[4], qwin, messwa, messwt, messwi, messwk,
                planetw, rankw, playerw, optionWin, reviewWin;
#ifdef XTREKRC_HELP
W_Window	defWin;
#endif
#ifdef SCAN
extern W_Window scanw, scanwin;
#endif				/* ATM */
extern W_Window	udpWin;

extern W_Window	phaserwin;

#ifdef SHORT_PACKETS
extern W_Window spWin;
#endif

#ifdef EM
extern int      sortPlayers;

#endif

#ifdef CURSORFIX
#define MAXCURSORS 10
#define MESGCURSOR 1
#define TMAPCURSOR 2
#define GMAPCURSOR 2		/* note these are the same! */
#endif

#ifdef PING
extern int      ping;		/* to ping or not to ping */
extern LONG     packets_sent;	/* # all packets sent to server */
extern LONG     packets_received;	/* # all packets received */
extern W_Window pStats;
#endif

extern int      use_msgw;
extern int      phas_msg;
extern int      phas_msgi;

/* tmp */
#ifdef BD
extern int      bd;
#endif

#ifdef SHORT_PACKETS
extern int      tryShort;
extern int      recv_short;
extern int	recv_short_opt;

/* OLD */
extern int      recv_mesg;
extern int      recv_kmesg;
extern int      recv_threshold;
extern char     recv_threshold_s[];
extern int      recv_warn;
#endif

extern int	tclock;

#ifdef NEW_PL
extern int	new_playerlist;
#endif

extern int	new_messages;

#ifdef XSIG
extern int	critical;
#endif

extern int	max_fd;

#ifdef FEATURE
extern int report_features;
extern int	MacroNum;
extern int      F_UseNewMacro;
extern int      F_UseSmartMacro;
extern int      F_why_dead;
extern W_Window	macroWin;
extern int	macrokey;
extern char *singleMacro;


extern struct dmacro_list *distmacro;
extern struct dmacro_list dist_defaults[];
extern struct dmacro_list dist_prefered[];
extern int sizedist;

#ifdef BEEPLITE
extern char *distlite[];
extern int UseLite;
extern int DefLite;
extern int     emph_planet_seq_n[];
extern int     emph_player_seq_n[];
extern W_Icon emph_planet_seq[] ;
extern W_Icon emph_player_seq[] ;
extern W_Icon emph_player_seql [] ;
#define emph_planet_seq_frames 5
#define emph_planet_seq_width 24
#define emph_planet_seq_height 24
#define emph_player_seq_frames 3
#define emph_player_seq_width 24
#define emph_player_seq_height 24
#define emph_player_seql_frames 3
#define emph_player_seql_width 30
#define emph_player_seql_height 30
extern int beep_lite_cycle_time_player;
extern int beep_lite_cycle_time_planet;

extern int beep_lite_enablable;
extern int lite_players_map;
extern int lite_players_local;
extern int lite_self;
extern int lite_planets;
extern int lite_sounds;
#endif /* BEEPLITE */

#endif

extern int	abbr_kmesg;
#endif

extern char	*malloc();

extern int	maskrecip;

#ifdef DASHBOARD
extern int	dashboard;
#endif

extern int	plshowstatus;

#ifdef NEW_DASHBOARD_2
/* KRP */
/* Variation on dashboard. */
extern int cup_half_full;
#endif

#ifdef IGNORE_SIGNALS_SEGV_BUS
/* Handle (hopefully) non-fatal segmentation and bus faults. */
extern int ignore_signals;
#endif

#ifdef MOTION_MOUSE
extern int motion_mouse;
extern int steering_mouse;
extern int user_motion_thresh;
extern int motion_mouse_enablable;
#endif

#ifdef SHIFTED_MOUSE
extern int extended_mouse;
#endif

#ifdef TNG_FED_BITMAPS
extern int use_tng_fed_bitmaps;
extern W_Icon tng_fed_bitmaps [NUM_TYPES][VIEWS];
#endif

#ifdef VARY_HULL
extern W_Icon hull[];
extern int vary_hull;
#endif

#ifdef DOC_WIN
extern W_Window docwin, xtrekrcwin;
extern int maxdoclines, maxxtrekrclines;
#endif

#ifdef ZZ_BITMAPS
extern W_Icon bplanets4 [8];    
extern W_Icon mbplanets4 [8];           
#endif

#ifdef REFRESH_INTERVAL
extern int refresh_interval;
#endif

#ifdef PLIST
extern char 	plist[80];
extern int newPlist;
extern int no_init_plist;
#endif

#ifdef KEEP_INFO
extern int keepInfo;	/* how many updates to keep infowins 6/1/93 LAB */
#endif

#ifdef CLOAK_CHARS
extern char cloakChars[3];
#endif

#ifdef SHOW_IND
extern int showIND;
#endif

extern int enemyPhasers;
extern char timebuf [];

#ifdef CONTROL_KEY
extern int use_control_key;
#endif

#ifdef META
extern int usemeta;
extern int num_servers;
extern struct servers serverlist[];
extern char *keystrings[];
extern W_Window metaWin;
extern char meta_server [];
#endif

#ifdef ROMVLVS_BITMAPS
extern int ROMVLVS;
extern W_Icon ROMVLVS_bitmap [];
#endif

#ifdef MAKE_XTREKRC
extern int showDefaults;
extern int use_cow_literc;
extern int cow_literc_override;
#endif

#ifdef BUTTON_KEYMAP_WINDOW
extern W_Window but_key_win;
#endif

#ifdef USE_TR_PORTS
extern int useTRPorts;
#endif

#ifdef MAP_NAMES
extern int draw_map_names;

extern int show_owner_tact;
extern int show_owner_map;
extern W_Icon show_owner_map_bitmaps [];
#endif

#ifdef SHOW_MY_SPEED
extern int showMySpeed;
#endif

#ifdef SBHOURS
extern int SBhours;
#endif

#ifdef JUBILEE_PHASERS
extern int jubilee_phasers;
#endif

#ifdef MULTILINE_MACROS
extern int multiline_enabled;
extern int ignore_multilines;
#endif

/* When you enter game, send request for full update SRS 3/15/94 */
extern int askforUpdate;

#ifdef CLOAK_MAXWARP
extern int cloak_maxwarp;
#endif

#ifdef WARP_DEAD
extern int dead_warp;
#endif

#ifdef SHOW_FUEL_ON_LOCAL
extern int show_fuel_on_local;
#endif
