/*
 * entrywin.c
 * 
 * The original newwin.c split into two sections this one handling all the motd
 * and entry window stuff
 * 
 */
#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <sys/types.h>
#ifdef hpux
#include <time.h>
#else				/* hpux */
#include <sys/time.h>
#endif				/* hpux */
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

#include "bitmaps/clockbitmap.h"

static int      line = 0;
int             MaxMotdLine = 0;

#ifdef EM
/*
 * if a motd line from the server is this, the client will junk all motd *
 * data it currently has.  New data may be received
 */
#define MOTDCLEARLINE  "\033\030CLEAR_MOTD\000"
#endif

#define SIZEOF(a)	(sizeof (a) / sizeof (*(a)))

#define BOXSIDE		(WINSIDE / 5)
#define TILESIDE	16
#define MESSAGESIZE	20
#define STATSIZE	(MESSAGESIZE * 2 + BORDER)
#define YOFF		0

#define stipple_width 16
#define stipple_height 16
static char     stipple_bits[] =
{
   0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08,
   0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80,
   0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08,
   0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80};

/* This routine throws up an entry window for the player. */

entrywindow(team, s_type)
    int            *team, *s_type;
{
   int             typeok = 0, i = 0;
   long            startTime;
   W_Event         event;
   int             lastplayercount[4];
   int             okayMask, lastOkayMask;
   int             resetting = 0;
   int             tiled = 0;
   long            lasttime = -1;
   int             spareTime = 240;	/* Allow them an extra 240 seconds,
					 * as long as they are active */
   int             elapsed;
   struct timeval  tv;
   fd_set          mask;

   /* The following allows quick choosing of teams */

   if(fastQuit){
      *team = -1;
      return;
   }

   lastOkayMask = okayMask = tournMask;

   for (i = 0; i < 4; i++) {
      if (okayMask & (1 << i)) {
	 tiled = 0;
      } else {
	 tiled = 1;
      }

      if (tiled) {
	 W_TileWindow(teamWin[i], stipple);
      } else {
	 W_UnTileWindow(teamWin[i]);
      }
      W_MapWindow(teamWin[i]);
      lastplayercount[i] = -1;	/* force redraw first time through */
   }
   W_MapWindow(qwin);

   *team = -1;
   startTime = time(0);
   if (me->p_whydead != KWINNER && me->p_whydead != KGENOCIDE)
      showMotd(w, line);

   if (W_IsMapped(playerw))
      playerlist();

   do {
      while (!W_EventsPending()) {

#ifdef PING
	 /*
	  * changes here so that client reads from server whenever available
	  * instead of waiting 1 second each time.  This has no affect on
	  * anything since we time(0) autoquit anyway
	  */
#endif
	 me->p_ghostbuster = 0;
	 tv.tv_sec = 1;
	 tv.tv_usec = 0;

	 FD_ZERO(&mask);
	 FD_SET(W_Socket(), &mask);
	 FD_SET(sock, &mask);
	 if (udpSock >= 0)
	    FD_SET(udpSock, &mask);
	 select(32, &mask, 0, 0, &tv);

	 if (FD_ISSET(sock, &mask) ||
	     (udpSock >= 0 && FD_ISSET(udpSock, &mask))){
	    readFromServer(&mask);
	 }

	 elapsed = time(0) - startTime;
	 if (elapsed > AUTOQUIT) {
	    printf("Auto-Quit.\n");
	    *team = 4;
	    break;
	 }
	 if (lasttime != time(0)) {
	    if (W_IsMapped(playerw))
	       playerlist2();

	    showTimeLeft(elapsed, AUTOQUIT);
	    lasttime = time(0);
	 }
	 okayMask = tournMask;

	 for (i = 0; i < 4; i++) {
	    if ((okayMask ^ lastOkayMask) & (1 << i)) {
	       if (okayMask & (1 << i)) {
		  W_UnTileWindow(teamWin[i]);
	       } else {
		  W_TileWindow(teamWin[i], stipple);
	       }
	       lastplayercount[i] = -1;	/* force update */
	    }
	    redrawTeam(teamWin[i], i, &lastplayercount[i]);
	 }
	 lastOkayMask = okayMask;
      }
      if (*team == 4)
	 break;

      if (time(0) - startTime <= spareTime) {
	 spareTime -= time(0) - startTime;
	 startTime = time(0);
      } else {
	 startTime += spareTime;
	 spareTime = 0;
      }
      if (!W_EventsPending())
	 continue;
      W_NextEvent(&event);
      typeok = 1;
      switch ((int) event.type) {
      case W_EV_KEY:
	 switch (event.key) {
	 case 's':
	    *s_type = SCOUT;
	    break;
	 case 'd':
	    *s_type = DESTROYER;
	    break;
	 case 'c':
	    *s_type = CRUISER;
	    break;
	 case 'b':
	    *s_type = BATTLESHIP;
	    break;
#ifdef GALAXY
	 case 'g':
	    *s_type = SGALAXY;
	    break;
#endif				/* GALAXY */
	 case 'X':
	    *s_type = ATT;
	    break;
	 case 'a':
	    *s_type = ASSAULT;
	    break;
	 case 'o':
	    *s_type = STARBASE;
	    break;
	 default:
	    typeok = 0;
	    break;
	 }
	 if (event.Window == w) {
	    switch (event.key) {
	    case 'y':
	       if (resetting) {
		  sendResetStatsReq('Y');
		  warning("OK, your stats have been reset.");
		  resetting = 0;
	       }
	       break;
	    case 'n':
	       if (resetting) {
		  warning("I didn't think so.");
		  resetting = 0;
	       }
	       break;
	    case 'R':
	       warning("Are you sure you want to reset your stats?");
	       resetting = 1;
	       break;
	    case 'f':		/* Scroll motd forward */
	       line = line + 28;
	       if (line > MaxMotdLine) {
		  line = line - 28;
		  break;
	       }
	       W_ClearWindow(w);
	       showMotd(w, line);
	       break;
	    case 'b':		/* Scroll motd backward */
	       if (line == 0)
		  break;
	       line = line - 28;
	       if (line < 0)
		  line = 0;
	       W_ClearWindow(w);
	       showMotd(w, line);
	       break;
#ifdef EM
	    case 'S':
	       SaveMotd();
	       break;
#endif
	    }
	 }
	 /* No break, we just fall through */
      case W_EV_BUTTON:
	 if (typeok == 0)
	    break;
	 for (i = 0; i < 4; i++)
	    if (event.Window == teamWin[i]) {
	       *team = i;
	       break;
	    }
	 if (event.Window == qwin /* new */ &&
	     event.type == W_EV_BUTTON) {
	    *team = 4;
	    break;
	 }
	 if (*team != -1 && !teamRequest(*team, *s_type)) {
	    *team = -1;
	 }
	 break;
      case W_EV_EXPOSE:
	 for (i = 0; i < 4; i++)
	    if (event.Window == teamWin[i]) {
	       lastplayercount[i] = -1;	/* force update */
	       redrawTeam(teamWin[i], i, &lastplayercount[i]);
	       break;
	    }
	 if (event.Window == qwin)
	    redrawQuit();
	 else if (event.Window == tstatw)
	    redrawTstats();
	 else if (event.Window == iconWin)
	    drawIcon();
	 else if (event.Window == w)
	    showMotd(w, line);
	 else if (event.Window == helpWin)
	    fillhelp();
#ifdef XTREKRC_HELP
	 else if (defWin && (event.Window == defWin))
	    showdef();
#endif
	 else if (event.Window == playerw)
	    playerlist();
	 else if (event.Window == warnw)
	    W_ClearWindow(warnw);
	 else if (event.Window == messagew)
	    W_ClearWindow(messagew);
	 break;
      }
   } while (*team < 0);
   if (event.Window != qwin)
      warning("Welcome aboard Captain!");

   if (*team == 4) {
      *team = -1;
      return;
   }
   for (i = 0; i < 4; i++)
      W_UnmapWindow(teamWin[i]);
   W_UnmapWindow(qwin);
}

/* Attempt to pick specified team & ship */
teamRequest(team, ship)
    int             team, ship;
{
   int             lastTime;

   pickOk = -1;
   sendTeamReq(team, ship);
   lastTime = time(NULL);
   while (pickOk == -1) {
      if (lastTime + 3 < time(NULL)) {
	 sendTeamReq(team, ship);
      }
      socketPause();
      readFromServer(NULL);
      if (isServerDead()) {
	 printf("Whoops!  We've been ghostbusted!\n");
	 printf("Pray for a miracle!\n");
	 /* UDP fail-safe */
	 commMode = commModeReq = COMM_TCP;
	 commSwitchTimeout = 0;
	 if (udpSock >= 0)
	    closeUdpConn();
	 if (udpWin) {
	    udprefresh(UDP_CURRENT);
	    udprefresh(UDP_STATUS);
	 }
	 connectToServer(nextSocket);
	 printf("Yea!  We've been resurrected!\n");
	 pickOk = 0;
	 break;
      }
   }
   return (pickOk);
}

numShips(owner)
{
   int             i, num = 0;
   struct player  *p;

   for (i = 0, p = players; i < MAXPLAYER; i++, p++)
      if (p->p_status == PALIVE && p->p_team == owner)
	 num++;
   return (num);
}

realNumShips(owner)
{
   int             i, num = 0;
   struct player  *p;

   for (i = 0, p = players; i < MAXPLAYER; i++, p++)
      if (p->p_status != PFREE &&
	  p->p_team == owner)
	 num++;
   return (num);
}

deadTeam(owner)
    int             owner;
    /* The team is dead if it has no planets and cannot coup it's home planet */
{
   int             i, num = 0;
   struct planet  *p;

   if (planets[remap[owner] * 10 - 10].pl_couptime == 0)
      return (0);
   for (i = 0, p = planets; i < MAXPLANETS; i++, p++) {
      if (p->pl_owner & owner) {
	 num++;
      }
   }
   if (num != 0)
      return (0);
   return (1);
}

static char    *AUTHOR[] =
{
   "",
   "---  XtrekII Release Version 6.1 ---",
   "By Chris Guthrie, Ed James,",
   "Scott Silvey, and Kevin Smith",
   "Amdahl UDP Revision",	/* UDP */
};

checkBold(line)
    /* Determine if that line should be highlighted on sign-on screen */
    /* Which is done when it is the players own score being displayed */
    char           *line;
{
   char           *s, *t;
   int             i;
   int             end = 0;

   if (strlen(line) < 60)
      return (0);
   if (me == NULL)
      return (0);

   s = line + 4;
   t = me->p_name;


   for (i = 0; i < 16; i++) {
      if (!end) {
	 if (*t == '\0')
	    end = 1;
	 else if (*t != *s)
	    return (0);
      }
      if (end) {
	 if (*s != ' ')
	    return (0);
      }
      s++;
      t++;
   }
   return (1);
}

struct list {
   char            bold;
   struct list    *next;
   char           *data;
};

static struct list *motddata = NULL;	/* pointer to first bit of motddata */
static int      first = 1;

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* entrywin.c */
static showValues P_((struct list *data));

#undef P_

showMotd(motdwin, atline)
    W_Window        motdwin;
    int             atline;
{
   FILE           *fopen();
   int             i, length, top, center;
   struct list    *data;
   int             count;

   W_ClearWindow(motdwin);
   for (i = 0; i < SIZEOF(AUTHOR); i++) {
      length = strlen(AUTHOR[i]);
      center = WINSIDE / 2 - (length * W_Textwidth) / 2;
      W_WriteText(motdwin, center, i * W_Textheight, textColor, AUTHOR[i],
		  length, W_RegularFont);
   }
   top = SIZEOF(AUTHOR) + 5;

   if (first) {
      first = 0;
      data = motddata;
      while (data != NULL) {
	 data->bold = checkBold(data->data);
	 data = data->next;
      }
   }
   data = motddata;
   for (i = 0; i < atline; i++) {
      if (data == NULL) {
	 atline = 0;
	 data = motddata;
	 break;
      }
      data = data->next;
   }
   count = 28;			/* Magical # of lines to display */
   for (i = top; i < 50; i++) {
      if (data == NULL)
	 break;
      if (!strcmp(data->data, "\t@@@"))	/* ATM */
	 break;
      if (data->bold) {
	 W_WriteText(motdwin, 20, i * W_Textheight, textColor, data->data,
		     strlen(data->data), W_BoldFont);
      } else {
	 W_WriteText(motdwin, 20, i * W_Textheight, textColor, data->data,
		     strlen(data->data), W_RegularFont);
      }
      data = data->next;
      count--;
      if (count <= 0)
	 break;
   }

   showValues(data);
}

/*
 * ATM: show the current values of the .sysdef parameters.
 */
static
showValues(data)
    struct list    *data;
{
   int             i;
   static char    *msg = "OPTIONS SET WHEN YOU STARTED WERE:";

   /* try to find the start of the info */
   while (1) {
      if (data == NULL)
	 return;
      if (!strcmp(data->data, STATUS_TOKEN))
	 break;
      data = data->next;
   }
   data = data->next;

   W_WriteText(mapw, 20, 14 * W_Textheight, textColor, msg,
	       strlen(msg), W_RegularFont);
   for (i = 16; i < 50; i += 2) {
      if (data == NULL)
	 break;
      if (data->data[0] == '+')	/* quick boldface hack */
	 W_WriteText(mapw, 20, i * W_Textheight, textColor, data->data + 1,
		     strlen(data->data) - 1, W_BoldFont);
      else
	 W_WriteText(mapw, 20, i * W_Textheight, textColor, data->data,
		     strlen(data->data), W_RegularFont);
      data = data->next;
   }
}

newMotdLine(line)
    char           *line;
{
   static struct list **temp = &motddata;
   static int      statmode = 0;/* ATM */

   if (!statmode && !strcmp(line, STATUS_TOKEN))
      statmode = 1;
   if (!statmode)
      MaxMotdLine++;		/* ATM - don't show on left */
   (*temp) = (struct list *) malloc(sizeof(struct list));
   if ((*temp) == NULL) {	/* malloc error checking -- 10/30/92 EM */
      printf("Warning:  Couldn't malloc space for a new motd line!");
      return;
   }
#ifdef EM
   /* Motd clearing code */
   if (strcmp(line, MOTDCLEARLINE) == 0) {
      ClearMotd();
      return;
   }
#endif

   (*temp)->next = NULL;
   (*temp)->data = malloc(strlen(line) + 1);
   strcpy((*temp)->data, line);
   temp = &((*temp)->next);
}
#ifdef EM
/* Free the current motdData */
ClearMotd()
{
   struct list    *temp, *temp2;

   temp = motddata;		/* start of motd information */
   while (temp != NULL) {
      temp2 = temp;
      temp = temp->next;
      free(temp2->data);
      free(temp2);
   }

   first = 1;			/* so that it'll check bold next time around */
}
#endif

/* ARGSUSED */
getResources(prog)
    char           *prog;
{
   getColorDefs();
   getTiles();
}

getTiles()
{
   stipple = W_StoreBitmap(stipple_width, stipple_height, stipple_bits, w);
}

redrawTeam(win, teamNo, lastnum)
    W_Window        win;
    int            *lastnum;
{
   char            buf[BUFSIZ];
   static char    *teams[] =
   {"Federation", "Romulan", "Klingon", "Orion"};
   int             num = numShips(1 << teamNo);

   /* Only redraw if number of players has changed */
   if (*lastnum == num)
      return;

   W_ClearWindow(win);
   W_WriteText(win, 5, 5, shipCol[teamNo + 1], teams[teamNo],
	       strlen(teams[teamNo]), W_RegularFont);
   (void) sprintf(buf, "%d", num);
   W_MaskText(win, 35, 46, shipCol[teamNo + 1], buf, strlen(buf),
	      W_BigFont);
   *lastnum = num;
}

redrawQuit()
{
   W_WriteText(qwin, 5, 5, textColor, "Quit xtrek", 10, W_RegularFont);
}

#ifndef EM
char           *help_message[] =
{
   "0-9   Set speed",
   ")     speed = 10",
   "!     speed = 11",
   "@     speed = 12",
   "k     Set course",
   "p     Fire phaser",
   "t     Fire photon torpedo",
   "f     Fire plasma torpedo",
#ifdef SCAN
   "a     Use scanning beam",
#endif				/* ATM */
   "d     detonate enemy torps",
   "D     detonate own torps",
   "L     List players",
   "P     List planets",
   "S     Status graph toggle",
   "M     Turn on/off map window updating",
   "]     Put up shields",
   "[     Put down shields",
   "u     Shield toggle",
   "i     Info on player/planet",
   "I     Extended info on player",
   "b     Bomb planet",
   "z     Beam up armies",
   "x     Beam down armies",
   "T     Toggle tractor beam",
   "y     Toggle pressor beam",
   "R     Enter repair mode",
   "o     Orbit planet or dock to outpost",
   "e     Docking permission toggle",
   "r     Change vessels (ship type)",
   "Q     Quit",
   "?     Message window toggle",
   "m     Warp to message window",
   "c     Cloaking device toggle",
   "C     Coup a planet",
   "l     Lock on to player/planet",
   "h     Help window toggle",
   "w     War declarations window",
   "N     Planet names toggle",
   "V     Rotate local planet display",
   "B     Rotate galactic planet display",
   "E     Send distress call",
   "*     Send in practice robot",
   "U     Show rankings window",
   "+     Show UDP options window",
   "=     Update all",
   "Space Remove info, planet, rank windows",
   0,
};

#define MAXHELP 40

fillhelp()
{
   register int    i = 0, row, column;

   W_ClearWindow(helpWin);
   for (column = 0; column < 4; column++) {
      for (row = 1; row < 12; row++) {
	 if (help_message[i] == 0)
	    break;
	 else {
	    W_WriteText(helpWin, MAXHELP * column, row, textColor,
		   help_message[i], strlen(help_message[i]), W_RegularFont);
	    i++;
	 }
      }
      if (help_message[i] == 0)
	 break;
   }
}

#endif				/* EM */

drawIcon()
{
   W_WriteBitmap(0, 0, icon, W_White);
}

#define CLOCK_WID	(BOXSIDE * 9 / 10)
#define CLOCK_HEI	(BOXSIDE * 2 / 3)
#define CLOCK_BDR	0
#define CLOCK_X		(BOXSIDE / 2 - CLOCK_WID / 2)
#define CLOCK_Y		(BOXSIDE / 2 - CLOCK_HEI / 2)

#ifndef PI
#define PI		3.141592654
#endif

showTimeLeft(time, max)
    int             time, max;
{
   char            buf[BUFSIZ], *cp;
   int             cx, cy, ex, ey, tx, ty;

   if ((max - time) < 10 && time & 1) {
      W_Beep();
   }
   /* XFIX */
   W_ClearArea(qwin, CLOCK_X, CLOCK_Y, CLOCK_WID, CLOCK_HEI);

   cx = CLOCK_X + CLOCK_WID / 2;
   cy = CLOCK_Y + (CLOCK_HEI - W_Textheight) / 2;
   ex = cx - clock_width / 2;
   ey = cy - clock_height / 2;
   W_WriteBitmap(ex, ey, clockpic, foreColor);

   ex = cx - clock_width * sin(2 * PI * time / max) / 2;
   ey = cy - clock_height * cos(2 * PI * time / max) / 2;
   W_MakeLine(qwin, cx, cy, ex, ey, foreColor);

   sprintf(buf, "%d", max - time);
   tx = cx - W_Textwidth * strlen(buf) / 2;
   ty = cy - W_Textheight / 2;
   W_WriteText(qwin, tx, ty, textColor, buf, strlen(buf), W_RegularFont);

   cp = "Auto Quit";
   tx = CLOCK_X + cx - W_Textwidth * strlen(cp) / 2;
   ty = CLOCK_Y + CLOCK_HEI - W_Textheight;
   W_WriteText(qwin, tx, ty, textColor, cp, strlen(cp), W_RegularFont);
}


do_refit(type)
    int             type;
{
   sendRefitReq(type);
   localflags &= ~PFREFIT;
}

#ifdef EM
#define DEFAULT_SAVEFILE  "/tmp/netrek_motd"
/* default file to save motd into */

/* save all the motd data into a save file! */
SaveMotd()
{
   FILE           *fp;
   struct list    *mtd_ptr = NULL;
   char           *nameptr;
   time_t          time_clock;

   if ((nameptr = getdefault("motd.savefile")) == NULL)
      nameptr = DEFAULT_SAVEFILE;
#ifdef SHOW_DEFAULTS
   show_defaults("string", "motd.savefile", DEFAULT_SAVEFILE,
      "Name of file to save motd in if 'S' typed in entry window.");
#endif

   fp = fopen(nameptr, "a");

   if (fp == NULL) {
      fprintf(stderr, "Couldn't open motd save file %s!\n", nameptr);
      perror("fopen() error");
      return;
   }
   time_clock = time(NULL);

   if (fprintf(fp, "Motd data captured at %s\n", ctime(&time_clock)) < 0) {
      fprintf(stderr, "Error saving motd!\n");
      perror("fprintf error");
      fclose(fp);
   }
   for (mtd_ptr = motddata; mtd_ptr != NULL; mtd_ptr = mtd_ptr->next) {
      if (fprintf(fp, "%s\n", mtd_ptr->data) < 0) {
	 fprintf(stderr, "Error writing motd!\n");
	 perror("fprintf error");
	 fclose(fp);
      }
   }
   printf("Netrek motd saved in %s\n", nameptr);
   fclose(fp);
}
#endif
