/*
 * Feature.c 
 *
 * March, 1994.    Joe Rumsey, Tedd Hadley
 *
 * most of the functions needed to handle SP_FEATURE/CP_FEATURE
 * packets.  fill in the features list below for your client, and 
 * add a call to reportFeatures just before the RSA response is sent.
 * handleFeature should just call checkFeature, which will search the
 * list and set the appropriate variable.  features unknown to the
 * server are set to the desired value for client features, and off
 * for server/client features.
 *
 * feature packets look like:

struct feature_cpacket
{              
   char                 type;
   char                 feature_type;
   char                 arg1,
                        arg2;
   int                  value;
   char                 name[80];
};

 *  type is CP_FEATURE, which is 60.  feature_spacket is identical.
 */


#ifdef FEATURE
#include "copyright.h"

#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"


/* not the actual packets: this holds a list of features to report for */
/* this client. */
struct feature
{
  char   *name;
  int    *var; /* holds allowed/enabled status*/
  char   feature_type;  /* 'S' or 'C' for server/client */ 
  int    value; /* desired status */
  char   *arg1, *arg2;  /* where to copy args, if non-null */
};

struct int_range
{
   int             min_value;   /* value is >= this */
   int             max_value;   /* value is <= this */
   int             increment;   /* a click raises/lowers this amount */
};

extern struct int_range motion_mouse_range;
extern struct int_range beeplite_range;

int feature_packets = 1;
char beep_lite_flags = 0;

struct feature features[] = {
    {"FEATURE_PACKETS", &feature_packets, 'S', 1, 0, 0},
#ifdef MOTION_MOUSE
    {"CONTINUOUS_MOUSE", &motion_mouse_enablable, 'C', 1, 0, 0},
    {"CONTINUOUS_STEER", &steering_mouse, 'C', 1, 0, 0},
#endif
    {"NEWMACRO",&F_UseNewMacro, 'C', 1, 0, 0}, 
    {"SMARTMACRO",&F_UseSmartMacro, 'C', 1, 0, 0}, 
    {"WHY_DEAD", &F_why_dead, 'S', 1, 0, 0},
    {"RC_DISTRESS", &F_gen_distress, 'S', 1, 0, 0},
#ifdef MULTILINE_MACROS
    {"MULTIMACROS", &multiline_enabled, 'S', 1, 0, 0},
#endif
#ifdef SBHOURS
    {"SBHOURS", &SBhours, 'S', 1, 0, 0},
#endif
#ifdef CLOAK_MAXWARP
    {"CLOAK_MAXWARP", &cloak_maxwarp, 'S', 1, 0, 0},
#endif
#ifdef WARP_DEAD
    {"DEAD_WARP", &dead_warp, 'S', 1, 0, 0},
#endif
#ifdef BEEPLITE
    {"BEEPLITE", &beep_lite_enablable, 'C', 1, &beep_lite_flags, 0},
#endif
    {0, 0, 0, 0, 0, 0}
};


void checkFeaturePacket (packet)
  struct feature_cpacket       *packet;
{
  int i;
  int value;

#ifdef DEBUG
  if(packet->type != SP_FEATURE)
  {
    printf("Packet type %d sent to checkFeature!\n",packet->type);
    return;
  }
#endif
  value = ntohl(packet->value);
  printf("%s: %s(%d)\n", &packet->name[0],
	 ((value == 1)?"ON":
	  (value == 0)?"OFF":"UNKNOWN"),
	 value);

  for (i=0; features[i].name!=0; i++)
  {
    if (strcmpi (packet->name, features[i].name) == 0)
    {
      /* if server returns unknown, set to off for server mods, 
	 desired value for client mods. Otherwise,  set to value from
	 server. */
      *features[i].var = (value == -1 ? 
			  (features[i].feature_type=='S' ? 0
			   : features[i].value)
			  : value);
      if (features[i].arg1)
	*features[i].arg1=packet->arg1;
      
      if (features[i].arg2)
	*features[i].arg2=packet->arg2;

      /* Ensure proper continous mouse setup. */
      if (strcmpi (packet->name, "CONTINUOUS_STEER") == 0 && !steering_mouse)
      {
	motion_mouse_enablable = 0;
	steering_mouse = 0;
	motion_mouse_range.increment = 0;
      }
      
      /* BeepLite configuration. */
      if (strcmpi (packet->name, "BEEPLITE") == 0)
      {
        int beeplite_flags = beep_lite_flags;
	char buf[80];
/*
	printf("BEEPLITE flags: %x\n", beeplite_flags);
*/
	
	strcpy(buf,"disabled  ");
	/* Handle incorrectly configured server. */
	if (value == 1 && beeplite_flags == 0)
	{
	  beep_lite_enablable = 1;
	  lite_players_map = 1;
	  lite_players_local = 1;
	  lite_self = 1;
	  lite_planets = 1;
	  lite_sounds = 1;
	  strcpy(buf,"Enabled: map, local, self, planets, sound  ");
	}
	else
	  switch (value)
	  {
	  case (-1):
	    beep_lite_enablable = 1;
	    lite_players_map = 1;
	    lite_players_local = 1;
	    lite_self = 1;
	    lite_planets = 1;
	    lite_sounds = 1;
	    strcpy(buf,"Enabled: map, local, self, planets, sound  ");
	    break;
	  case 1:
	    beep_lite_enablable = 1;
	    strcpy(buf,"Enabled: ");

	    if (beeplite_flags & LITE_PLAYERS_MAP) {
	      strcat(buf, "map, ");
	      lite_players_map = 1;
	    } else 
	      lite_players_map = 0;
	    
	    if (beeplite_flags & LITE_PLAYERS_LOCAL) {
	      strcat(buf, "local, ");
	      lite_players_local = 1;
	    } else
	      lite_players_local = 0;

	    if (beeplite_flags & LITE_SELF) {
	      strcat(buf, "self, ");
	      lite_self = 1;
	    } else
	      lite_self = 0;

	    if (beeplite_flags & LITE_PLANETS) {
	      strcat(buf,"planets, ");
	      lite_planets = 1;
	    } else
	      lite_planets = 0;

	    if (beeplite_flags & LITE_SOUNDS) {
	      strcat(buf,"sounds, ");
	      lite_sounds = 1;
	    } else
	      lite_sounds = 0;

	    break;
	  case 0:
	    beep_lite_enablable = 0;
	    lite_players_map = 0;
	    lite_players_local = 0;
	    lite_self = 0;
	    lite_planets = 0;
	    lite_sounds = 0;
	  }

	if (beep_lite_enablable == 0)
	  beeplite_range.increment = 0;
	buf[strlen(buf)-2] = '\0';
	printf("BEEPLITE %s\n",buf);
      }
      break;
    }
  }

  if (F_gen_distress)
  {
    distmacro = dist_prefered;
  }      

  if (features[i].name == 0)
  {
    printf("Feature %s from server unknown to client!\n",packet->name);
  }
}

/* call this from handleRSAKey, before sending the response. */
void reportFeatures()
{
  struct feature *f;

  for(f=features;f->name!=0;f++)
  {
    sendFeature(f->name,
		f->feature_type,
		f->value,
		(f->arg1 ? *f->arg1 : 0),
		(f->arg2 ? *f->arg2 : 0));
#ifdef DEBUG
    printf("(C->S) %s (%c): %d\n",f->name,f->feature_type,f->value);
#endif
  } 
}

sendFeature (name, feature_type, value, arg1, arg2)
  char *name;
  char feature_type;
  int  value;
  char arg1,arg2;
{
  struct feature_cpacket       packet;

  strncpy(packet.name, name, sizeof(packet.name));
  packet.type = CP_FEATURE;
  packet.name[sizeof(packet.name)-1] = 0;
  packet.feature_type = feature_type;
  packet.value = htonl(value);
  packet.arg1 = arg1;
  packet.arg2 = arg2;
  sendServerPacket((struct player_spacket *)&packet);
}

int handleFeature (packet)
  struct feature_cpacket *packet;
{
  report_features = 1;
  checkFeaturePacket (packet);
}
#endif  /* FEATURE */ 


