/*
 * input.c
 * 
 * Modified to work as client in socket based protocol
 */
#include "copyright.h"

#include <stdio.h>
#include <math.h>
#include <sys/types.h>

#ifdef hpux
#include <time.h>
#else				/* hpux */
#include <sys/time.h>
#endif				/* hpux */

#include <signal.h>
#include <errno.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

#ifdef FEATURE
static struct timeval curtp;
static struct timeval lasttp;
#endif

#ifdef KEEP_INFO
static int      opened_info = -2;	/* counter for infowin popup, 6/1/93
					 * LAB */
#endif

#ifdef XSIG
int             Xpending = 0;
#endif

#define MAXKEY 224
#define MAXASCII 128

unsigned char getctrlkey (s)
  unsigned char **s;
{
  unsigned char *str = *s;
  unsigned char c;

  /* Character is control key. */
  if (*str == '^')
    {
      str++;
      /* check for '^' key being specified with "^^" */
      if (*str != '^')
        c = *str + 96;
      else
        c = *str;
    }
  else
    c = *str;
  
  *s = str;
  return (c);
}

initkeymap ()
{
  unsigned char  *str;

  if ((str = (unsigned char *) getdefault ("keymap")) != NULL)
  {
    while (*str != '\0')
    {
      if (*str >= 32 && *str < MAXASCII)
      {
	mystats->st_keymap[*str - 32] = *(str + 1);
      }
      str += 2;
    }
  }

#ifdef SHOW_DEFAULTS
  show_defaults ("input", "keymap", "aabbcc",
		 "Maps new keys to old keys. Format: <new key><old key><new key><old key>...");
#endif

#ifdef CONTROL_KEY
  if ((str = (unsigned char *) getdefault ("ckeymap")) != NULL)
  {
    int             mfoff = 0, mtoff = 0, mfi = 0, mti = 0;

    while (*str != '\0')
    {
      mfoff = mtoff = mfi = mti = 0;

      if (*str >= 32 && *str < MAXASCII)
      {
	/* Mapped from character is control key. */
	if (*str == '^')
	{
	  /* check for '^' key being specified with "^^" */
	  if (*(str + 1) != '^')
	  {
	    mfoff = 96;
	    mfi = 1;
	  }
	  else
	  {
	    mfoff = 0;
	    mfi = 1;
	  }
	}

	/* Mapped to character is control key */
	if (*(str + 1 + mfi) == '^')
	{
	  /* check for '^' key being specified with "^^" */
	  if (*(str + 1 + 1 + mfi) != '^')
	  {
	    mtoff = 96;
	    mti = 1;
	  }
	  else
	  {
	    mtoff = 0;
	    mti = 1;
	  }
	}


	mystats->st_keymap[*(str + mfi) - 32 + mfoff] =
	  ((char) *(str + 1 + mfi + mti) + mtoff);

#ifdef DEBUG_KRP
	printf ("mapped: %c%c to: %c%c\n", *(str), *(str + mfi), *(str + 1 + mfi),
		*(str + 1 + mfi + mti));
#endif
      }

      str += (2 + mti + mfi);
    }
  }
#endif

  /* note: not stored on server */
  if ((str = (unsigned char *) getdefault ("buttonmap")) != NULL)
  {
    while (*str != '\0')
    {
      switch (*str++)
      {
	case '1':
	  buttonmap[1] = getctrlkey (&str);
	  break;
	case '2':
	  buttonmap[2] = getctrlkey (&str);
	  break;
	case '3':
	  buttonmap[3] = getctrlkey (&str);
	  break;

#ifdef SHIFTED_MOUSE
	case '4':
	  buttonmap[4] = getctrlkey (&str);
	  break;
	case '5':
	  buttonmap[5] = getctrlkey (&str);
	  break;
	case '6':
	  buttonmap[6] = getctrlkey (&str);
	  break;
	case '7':
	  buttonmap[7] = getctrlkey (&str);
	  break;
	case '8':
	  buttonmap[8] = getctrlkey (&str);
	  break;
	case '9':
	  buttonmap[9] = getctrlkey (&str);
	  break;
	case 'a':
	  buttonmap[10] = getctrlkey (&str);
	  break;
	case 'b':
	  buttonmap[11] = getctrlkey (&str);
	  break;
	case 'c':
	  buttonmap[12] = getctrlkey (&str);
	  break;
#endif

	default:
	  fprintf (stderr, "%c ignored in buttonmap\n", *(str - 1));
	  break;
      }
      str++;
    }
  }

#ifdef SHOW_DEFAULTS
  show_defaults ("input", "buttonmap", "1t2p3k",
		 "Maps buttons to key functions.  Format: <button><key>...");
#endif

}

initinput ()
{
  /* Nothing doing... */
}

input ()
{
  fd_set          readfds;

#ifndef XSIG
  register
  int             xsock = W_Socket ();	/* put it in a register */
#endif
  register
  int             doflush = 0;

#ifdef XSIG
  xsig_on ();
#endif

  while (1)
  {

#ifdef nodefXSIG
    if (Xpending)
    {
      Xpending = 0;
      if (W_ReadEvents ())
      {				/* force read into event queue */
	if (process_event ())
	  W_Flush ();
      }
    }
#endif

#ifdef KEEP_INFO
    if (keepInfo > 0 && opened_info != -2 &&	/* 6/1/93 LAB */
	opened_info < 0 && infomapped)
      destroyInfo ();
    if (keepInfo > 0 && opened_info != -2)
      opened_info--;
#endif

    FD_ZERO (&readfds);

#ifndef XSIG
    FD_SET (xsock, &readfds);
#endif

    FD_SET (sock, &readfds);
    if (udpSock >= 0)
      FD_SET (udpSock, &readfds);

#ifdef XSIG
    if (select (max_fd, &readfds, 0, 0, 0) < 0)
    {
      continue;
    }
#else
    select (max_fd, &readfds, 0, 0, 0);
#endif

#ifndef XSIG
    if (FD_ISSET (xsock, &readfds))
    {
      process_event ();
      /* NOTE: we're no longer calling XPending(), need this */
      doflush = 1;
    }
#endif

    if (FD_ISSET (sock, &readfds) ||
	(udpSock >= 0 && FD_ISSET (udpSock, &readfds)))
    {
      intrupt (&readfds);
      /* NOTE: we're no longer calling XPending(), need this */
      doflush = 1;
      if (isServerDead ())
      {
	printf ("Whoops!  We've been ghostbusted!\n");
	printf ("Pray for a miracle!\n");
	/* UDP fail-safe */
	commMode = commModeReq = COMM_TCP;
	commSwitchTimeout = 0;
	if (udpSock >= 0)
	  closeUdpConn ();
	if (udpWin)
	{
	  udprefresh (UDP_CURRENT);
	  udprefresh (UDP_STATUS);
	}
	connectToServer (nextSocket);
	printf ("Yea!  We've been resurrected!\n");
      }
    }

    /* NOTE: we're no longer calling XPending(), need this */
    if (doflush)
    {
      W_Flush ();
      doflush = 0;
    }
  }
}

#ifdef XSIG
sigio_handler ()
{
  if (critical)
  {
    Xpending = 1;
    return;
  }
  Xpending = 0;

  if (!W_ReadEvents ())		/* force read into event queue */
    return;

  if (process_event ())
    W_Flush ();
}

#endif

int motion_event = 0;

process_event ()
{
  W_Event         data;
  int             loop = 0;

#ifdef XSIG
  while (W_EventsQueued ())
#else
  do
#endif

  {
    loop++;
    if (!W_SpNextEvent (&data))
      continue;			/* continues at loop bottom */

    switch ((int) data.type)
    {
      case W_EV_KEY:
	if (data.Window == optionWin)
	{
	  optionaction (&data);
	}
	else if (messageon || data.Window == messagew)
	{
	  smessage (data.key);
	}
	else
	{
	  keyaction (&data);
	}
	break;
      case W_EV_BUTTON:
	if (data.Window == war)
	{
	  waraction (&data);
	}
	else if (data.Window == optionWin)
	{
	  optionaction (&data);
	}
	else if (data.Window == udpWin)
	{
	  udpaction (&data);	/* UDP */
	}
	else
	  buttonaction (&data);
	break;
      case W_EV_CM_BUTTON:
	if (data.Window == war)
	{
	  waraction (&data);
	}
	else if (data.Window == optionWin)
	{
	  optionaction (&data);
	}
	else if (data.Window == udpWin)
	{
	  udpaction (&data);	/* UDP */
	}
	else
	{
	  if (motion_mouse && motion_mouse_enablable && steering_mouse)
	    buttonaction (&data);
	  else if (steering_mouse && motion_mouse)
	  {
	    motion_event = 1;
	    buttonaction (&data);
	    motion_event = 0;
	  }
	}
	break;
    case W_EV_EXPOSE:
	/* most common first */
	if (data.Window == mapw)
	{
	  setup_redraw_map (data.x, data.y,
			    data.x + data.width, data.y + data.height);

#ifdef nodef
	  if (!redrawall)
	    redrawall = 2;	/* no need to clear */
#endif
	}
	else if (data.Window == w)	/* nothing special to do here */
	  break;
	else if (data.Window == statwin)
	  redrawStats ();

#ifdef NETSTAT
	else if (data.Window == lMeter)
	  redrawLMeter ();
#endif

#ifdef PING
	else if (data.Window == pStats)
	  redrawPStats ();
#endif

	else if (data.Window == tstatw)
	  redrawTstats ();
	else if (data.Window == iconWin)
	  drawIcon ();
	else if (data.Window == helpWin)
	  fillhelp ();

#ifdef XTREKRC_HELP
	else if (defWin && (data.Window == defWin))
	  showdef ();
#endif

	else if (data.Window == playerw)
	  playerlist ();
	else if (data.Window == planetw)
	  planetlist ();
	else if (data.Window == rankw)
	  ranklist ();
	else if (data.Window == warnw)
	  W_ClearWindow (warnw);
	else if (data.Window == messagew)
	  W_ClearWindow (messagew);

#ifdef BUTTON_KEYMAP_WINDOW
	else if (but_key_win && data.Window == but_key_win)
	  showkeymaps ();
#endif

#ifdef FEATURE
	else if (macroWin && data.Window == macroWin)
	  fillmacro ();
#endif

	break;
      default:
	break;
    }
  }

#ifndef XSIG
  while (W_EventsQueued ());
#endif

  return loop;
}

#ifdef XTRA
xinput ()

{
  static
  struct timeval  timeout = {0, 0};
  fd_set          readfds;
  int             xsock = W_Socket ();

  FD_ZERO (&readfds);
  FD_SET (xsock, &readfds);
  if (select (max_fd, &readfds, 0, 0, &timeout) == 1)
  {
    process_event ();
  }
}

#endif

keyaction (data)
  W_Event        *data;
{
  unsigned char   course;
  struct obtype  *gettarget (), *target;
  unsigned char   key = data->key;


  /* input received!  cancel autoquit!! */
  fastQuit = 0;

  if (data->Window != mapw && data->Window != w && (!infow || data->Window != infow)

#ifdef SCAN
      && data->Window != scanw
#endif				/* ATM */

    )
    return;

#ifdef nodef
  if (infow && data->Window == infow)
  {
    int             x, y;
    if (findMouseInWin (&x, &y, w))
    {				/* local window */
      data->Window = w;
      data->x = x;
      data->y = y;
    }
    else if (findMouseInWin (&x, &y, mapw))
    {				/* galactic window */
      data->Window = mapw;
      data->x = x;
      data->y = y;
    }
  }
#endif

#ifdef FEATURE
  if (key == macrokey)
    key = 'X';
#endif

  if (!index ("sbogadc", key) || !(localflags & PFREFIT))
  {
    if (key >= 32 && key < MAXKEY)
    {
      key = mystats->st_keymap[key - 32];
    }
  }

#ifdef FEATURE
  if (!MacroMode && singleMacro)
  {
    if (INDEX (singleMacro, data->key))
      MacroMode = 1;
  }

  if (MacroMode)
  {
    doMacro (data->key, data);
    return;
  }
#endif

  switch (key)
  {

#ifdef FEATURE
    case 'X':
      gettimeofday (&curtp, NULL);
      if (0 /* curtp.tv_sec < lasttp.tv_sec + 6 */ )
      {
	warning ("Chill out with the messages!!");
      }
      else
      {
	warning ("In Macro Mode");
	if (F_UseNewMacro)
	  MacroNum = -1;
	MacroMode = 1;
      }
      lasttp = curtp;
      break;
#endif

    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      set_speed (key - '0');
      localflags &= ~(PFREFIT);
      break;
    case 'e':			/* Turn off docking permission, eject docked
				 * vessels. */
      if (me->p_flags & PFDOCKOK)
	sendDockingReq (0);
      else
	sendDockingReq (1);
      break;
    case 'r':
      localflags |= PFREFIT;

#ifdef GALAXY
      warning ("s=scout, d=destroyer, c=cruiser, b=battleship, a=assault, g=galaxy, o=starbase/outpost");
#else
      warning ("s=scout, d=destroyer, c=cruiser, b=battleship, a=assault, o=starbase/outpost");
#endif				/* GALAXY */

      break;
    case ')':
      set_speed (10);
      localflags &= ~(PFREFIT);
      break;
    case '!':
      set_speed (11);
      localflags &= ~(PFREFIT);
      break;
    case '@':
      set_speed (12);
      localflags &= ~(PFREFIT);
      break;
    case '#':
      set_speed (me->p_ship.s_maxspeed / 2);
      localflags &= ~(PFREFIT);
      break;
    case '%':
      set_speed (99);		/* Max speed... */
      localflags &= ~(PFREFIT);
      break;

#ifdef EM
    case '>':
      set_speed (me->p_speed + 1);
      break;
    case '<':
      set_speed (me->p_speed - 1);
      break;
    case '{':
      cloak_on ();
      break;
    case '}':
      cloak_off ();
      break;
#endif				/* EM */

    case 'a':
      if (localflags & PFREFIT)
      {
	do_refit (ASSAULT);
      }

#ifdef SCAN
      else
      {
	if (!W_IsMapped (scanwin))
	{
	  scan (data->Window, data->x, data->y);
	}
	else
	{
	  if (scanmapped)
	    W_UnmapWindow (scanwin);
	  scanmapped = 0;
	}
      }
#endif				/* ATM */

      break;

#ifdef GALAXY
    case 'g':
      if (localflags & PFREFIT)
      {
	do_refit (SGALAXY);
      }
      break;
#endif				/* GALAXY */

    case 'm':			/* new from galaxy -- works here too */
      message_on ();
      break;

    case 'k':			/* k = set course */
      course = getcourse (data->Window, data->x, data->y);
      set_course (course);
      me->p_flags &= ~(PFPLOCK | PFPLLOCK);
      localflags &= ~(PFREFIT);
      break;
    case 'p':			/* p = fire phasers */
      course = getcourse (data->Window, data->x, data->y);
      sendPhaserReq (course);
      break;
    case 't':			/* t = launch torps */
      course = getcourse (data->Window, data->x, data->y);
      sendTorpReq (course);
      break;
    case 'f':
      /* f = launch plasma torpedos */
      course = getcourse (data->Window, data->x, data->y);
      sendPlasmaReq (course);
      break;
    case 'd':			/* d = detonate other torps */
      if (localflags & PFREFIT)
	do_refit (DESTROYER);
      else
	sendDetonateReq ();
      break;
    case 'D':			/* D = detonate my torps */
      detmine ();
      break;
    case '[':
      shield_down ();
      break;
    case ']':
      shield_up ();
      break;
    case 'u':			/* u = toggle shields */
      shield_tog ();
      break;
    case 's':			/* For Serge */
      if (localflags & PFREFIT)
	do_refit (SCOUT);
      else
	shield_tog ();
      break;
    case 'b':			/* b = bomb planet */
      if (localflags & PFREFIT)
	do_refit (BATTLESHIP);
      else
	bomb_planet ();
      break;
    case 'z':			/* z = beam up */
      beam_up ();
      break;
    case 'x':			/* x = beam down */
      beam_down ();
      break;
    case 'R':			/* R = Go into repair mode */
      sendRepairReq (1);
      break;
    case 'y':
    case 'T':
      if (me->p_flags & (PFTRACT | PFPRESS))
      {
	sendTractorReq (0, me->p_no);
	break;
      }
      target = gettarget (data->Window, data->x, data->y, TARG_PLAYER);
      me->p_tractor = target->o_num;
      if (key == 'T')
      {
	sendTractorReq (1, target->o_num);
      }
      else
      {
	sendRepressReq (1, target->o_num);
      }
      break;

      /*
       * Alternative tractor/pressor.  These keys will nearly always be
       * remapped.
       */
    case '_':
      if (me->p_flags & (PFTRACT | PFPRESS))
	sendTractorReq (0, me->p_no);
      target = gettarget (data->Window, data->x, data->y, TARG_PLAYER);
      me->p_tractor = target->o_num;
      sendTractorReq (1, target->o_num);
      break;

    case '^':
      if (me->p_flags & (PFTRACT | PFPRESS))
	sendRepressReq (0, me->p_no);
      target = gettarget (data->Window, data->x, data->y, TARG_PLAYER);
      me->p_tractor = target->o_num;
      sendRepressReq (1, target->o_num);
      break;
    case '$':
      sendTractorReq (0, me->p_no);
      break;

    case 'o':			/* o = dock at nearby starbase or orbit
				 * nearest planet */
      if (localflags & PFREFIT)
      {
	do_refit (STARBASE);
      }
      else
      {
	sendOrbitReq (1);
      }
      break;
    case 'O':			/* O = options Window */
      if (optionWin != NULL && W_IsMapped (optionWin))
	optiondone ();
      else
	optionwindow ();
      break;
    case 'q':
      fastQuit = 1;
    case 'Q':
      sendQuitReq ();

#ifdef XSIG
      if (sock < 0)
      {
	printf ("Giving up on ghostbust recovery.\n");
	exit (0);
      }
#endif

      break;
    case 'V':
      showlocal++;
      if (showlocal == 3)
	showlocal = 0;
      if (optionWin)
	optionredrawoption (&showlocal);

      break;
    case 'B':
      showgalactic++;
      if (showgalactic == 3)
	showgalactic = 0;
      if (!redrawall)
	redrawall = 2;
      if (optionWin)
	optionredrawoption (&showlocal);
      break;
    case '?':			/* ? = Redisplay all message windows */
      if (W_IsMapped (phaserwin))
	phaserWindow = 1;

      if (!W_IsMapped (reviewWin))
      {
	if (W_IsMapped (messwa))
	{
	  W_UnmapWindow (messwa);
	  W_UnmapWindow (phaserwin);
	  W_UnmapWindow (messwt);
	  W_UnmapWindow (messwi);
	  W_UnmapWindow (messwk);
	}
	else
	{
	  W_MapWindow (reviewWin);
	}
      }
      else
      {
	W_UnmapWindow (reviewWin);
	W_MapWindow (messwa);
	W_MapWindow (messwt);
	W_MapWindow (messwi);
	W_MapWindow (messwk);
	if (phaserWindow)
	  W_MapWindow (phaserwin);
      }
      if (optionWin)
      {
	optionredrawtarget (reviewWin);
	optionredrawtarget (messwa);
	optionredrawtarget (phaserwin);
	optionredrawtarget (messwt);
	optionredrawtarget (messwi);
	optionredrawtarget (messwk);
      }
      break;
    case 'c':			/* c = cloak */
      if (localflags & PFREFIT)
	do_refit (CRUISER);
      else
	cloak ();
      break;
    case 'C':			/* C = coups */
      sendCoupReq ();
      break;
    case 'l':			/* l = lock onto */
      target = gettarget (data->Window, data->x, data->y,
			  TARG_PLAYER | TARG_PLANET);
      if (target->o_type == PLAYERTYPE)
      {
	sendPlaylockReq (target->o_num);
	me->p_playerl = target->o_num;
	redrawPlayer[me->p_playerl] = 1;

      }
      else
      {				/* It's a planet */
	sendPlanlockReq (target->o_num);
	me->p_planet = target->o_num;
	planets[me->p_planet].pl_flags |= PLREDRAW;
      }
      break;
    case '*':
      sendPractrReq ();
      break;
      /* Start of display functions */
    case ' ':			/* ' ' = clear special windows */
      W_UnmapWindow (planetw);
      W_UnmapWindow (rankw);
      if (infomapped)
	destroyInfo ();
      W_UnmapWindow (helpWin);

#ifdef XTREKRC_HELP
      if (defWin)
	W_UnmapWindow (defWin);
#endif

      W_UnmapWindow (war);
      if (optionWin)
	optiondone ();

#ifdef SCAN
      if (scanmapped)
      {
	W_UnmapWindow (scanwin);
	scanmapped = 0;
      }
#endif

      if (udpWin)
	udpdone ();
      break;
    case 'E':			/* E = send emergency call */

#ifdef FEATURE
      rcd (generic, data);
#else
      emergency ();
#endif

      break;

#ifdef EM
    case 'F':			/* F = send armies carried report */

#ifdef FEATURE
      rcd (carrying, data);
#else
      army_report ();
#endif

      break;
#endif				/* EM */

    case 'L':			/* L = Player list */
      if (W_IsMapped (playerw))
      {
	W_UnmapWindow (playerw);
      }
      else
      {
	W_MapWindow (playerw);
      }
      break;
    case 'P':			/* P = Planet list */
      if (W_IsMapped (planetw))
      {
	W_UnmapWindow (planetw);
      }
      else
      {
	W_MapWindow (planetw);
      }
      break;
    case 'U':			/* U = Rank list */
      if (W_IsMapped (rankw))
      {
	W_UnmapWindow (rankw);
      }
      else
      {
	W_MapWindow (rankw);
      }
      break;
    case 'S':			/* S = toggle stat mode */
      if (W_IsMapped (statwin))
      {
	W_UnmapWindow (statwin);
      }
      else
      {
	W_MapWindow (statwin);
      }
      break;

#ifdef nodef
    case 'M':			/* M = Toggle Message Logging */
      break;
#endif

    case 'N':			/* N = Toggle Name mode */
      namemode = !namemode;
      if (optionWin)
	optionredrawoption (&namemode);
      break;
    case 'i':			/* i = get information */
    case 'I':			/* I = get extended information */

#ifdef KEEP_INFO
      if (!infomapped)
      {
	inform (data->Window, data->x, data->y, key);
	opened_info = keepInfo;	/* 5/31/93 LAB */
      }
      else
      {
	destroyInfo ();
	opened_info = -2;
      }
#else
      if (!infomapped)
	inform (data->Window, data->x, data->y, key);
      else
	destroyInfo ();
#endif

      break;
    case 'h':			/* h = Map help window */
      if (W_IsMapped (helpWin))
      {
	W_UnmapWindow (helpWin);
      }
      else
      {

#ifdef EM
	fillhelp ();
#endif				/* EM */

	W_MapWindow (helpWin);
      }
      if (optionWin)
	optionredrawtarget (helpWin);
      break;
    case 'w':			/* w = map war stuff */
      if (W_IsMapped (war))
	W_UnmapWindow (war);
      else
	warwindow ();
      break;
    case '+':			/* UDP: pop up UDP control window */
      if (udpWin != NULL && W_IsMapped (udpWin))
	udpdone ();
      else
      {
	char            buf[80];
	udpwindow ();
	sprintf (buf, "UDP client version %.1f",
		 (float) UDPVERSION / 10.0);
	warning (buf);
      }
      if (optionWin)
	optionredrawtarget (udpWin);
      break;
    case '=':			/* UDP: request for full update */
      sendUdpReq (COMM_UPDATE);
      break;

#ifdef SHORT_PACKETS
    case '-':
      sendShortReq (SPK_SALL);
      break;
#endif

#ifdef NETSTAT
    case '/':
      netstat = !netstat;
      if (netstat && !W_IsMapped (lMeter))
      {
	ns_init (1);
	W_MapWindow (lMeter);
      }
      else if (!netstat && W_IsMapped (lMeter))
      {
	W_UnmapWindow (lMeter);
      }
      break;
#endif				/* NETSTAT */

#ifdef NEW_PL
    case '\\':
      newPlist = !newPlist;
      W_ClearWindow (playerw);
      playerlist ();
      break;
#endif

#ifdef MAKE_XTREKRC
    case '~':
      showDefaults = 1;
      warning ("Writing $(HOME)/.cow-literc");
      make_xtrekrc (1);
      showDefaults = 0;
      break;
#endif

#ifdef MOO
    case '|':
      sortPlayers = (!sortPlayers);
      if (sortPlayers)
	warning ("Using sorted player list, Captain!");
      else
	warning ("Using regular player list, Captain!");
      W_ClearWindow (playerw);
      playerlist ();
      break;

#ifdef LOGMESG
    case 'M':
      logMess = !logMess;
      if (logMess)
	warning ("Message logging is ON, Captain!");
      else
	warning ("Message logging is OFF, Captain!");
      break;
#endif

#ifdef nodef			/* my attempt to control the recorder during
				 * the game <isae> */
    case '`':
      recordGame = !recordGame;
      if (recordGame)
	warning ("Recorder is ON, Captain!");
      else
	warning ("Recorder is OFF, Captain!");
      break;
#endif				/* nodef */

    case '&':
    case ':':			/* Re-read the values from rc file -- only
				 * nifty values are affected */
      warning ("Re-reading nifty configurations ...");
      readDefaults ();
      break;

#ifdef nodef			/* was MOO bitmaps -- need the key for more
				 * important things */
    case ';':
      myPlanetBitmap = !myPlanetBitmap;
      if (myPlanetBitmap)
	warning ("Using NEW planet bitmaps ...");
      else
	warning ("Using OLD planet bitmaps ...");
      break;
#endif				/* MOOBITMAPS */

    case ';':
      lockPlanetOrBase (data->Window, data->x, data->y);
      break;


#ifdef PING
    case ',':
      if (W_IsMapped (pStats))
      {
	W_UnmapWindow (pStats);
      }
      else
      {
	W_MapWindow (pStats);
	redrawPStats ();
      }
      break;
#endif

#endif				/* MOO */

#ifdef FEATURE
    case 131:
      rcd (other2, data);
      break;
    case 144:
      rcd (pop, data);
      break;
    case 145:
      rcd (save_planet, data);
      break;
    case 146:
      rcd (base_ogg, data);
      break;
    case 147:
      rcd (help3, data);
      break;
    case 148:
      rcd (help4, data);
      break;
    case 149:
      rcd (asw, data);
      break;
    case 150:
      rcd (asbomb, data);
      break;
    case 151:
      rcd (doing3, data);
      break;
    case 152:
      rcd (doing4, data);
      break;
    case 153:
      rcd (pickup, data);
      break;
    case 160:
      rcd (other1, data);
      break;
    case 162:
      rcd (bombing, data);
      break;
    case 163:
      rcd (controlling, data);
      break;
    case 175:
      rcd (ogging, data);
      break;
    case 180:
      rcd (take, data);
      break;
    case 194:
      rcd (bomb, data);
      break;
    case 195:
      rcd (space_control, data);
      break;
    case 197:
      rcd (escorting, data);
      break;
    case 198:
      rcd (free_beer, data);
      break;
    case 200:
      rcd (crippled, data);
      break;
    case 204:
      rcd (controlling, data);
      break;
    case 205:
      rcd (ogging, data);
      break;
    case 206:
      rcd (no_gas, data);
      break;
    case 207:
      rcd (ogg, data);
      break;
    case 208:
      rcd (ogging, data);
      break;
    case 212:
      rcd (take, data);
      break;
#ifdef XTREKRC_HELP

    case ('x' + 96):
      if (W_IsMapped (defWin))
	W_UnmapWindow (defWin);
      else
	showdef ();
      break;
    case ('s' + 96):
      if (W_IsMapped (macroWin))
	W_UnmapWindow (macroWin);
      else
	showMacroWin ();
      break;
#endif

#ifdef BUTTON_KEYMAP_WINDOW
    case ('k' + 96):
      if (W_IsMapped (but_key_win))
	W_UnmapWindow (but_key_win);
      else
	showkeymaps ();
      break;
#endif
#endif				/* FEATURE */

    default:
      W_Beep ();
      break;
  }
}

buttonaction (data)
  W_Event        *data;
{
  unsigned char   course;
  struct obtype  *gettarget ();

  /* input received!  cancel autoquit!! */
  fastQuit = 0;

  if (messageon)
    message_off ();		/* ATM */

  if (data->Window != w && data->Window != mapw
      && (!infow || data->Window != infow)

#ifdef SCAN
      && data->Window != scanwin
#endif				/* ATM */

    )
    return;

#ifdef SHIFTED_MOUSE
  if (data->key >= W_LBUTTON && data->key <= W_RBUTTON4)
  {
    if (buttonmap[data->key] != '\0')
    {
      data->key = buttonmap[data->key];

      if (motion_event)
      {
	if (data->key == 'k')
	  keyaction (data);
      }
      else
	keyaction (data);
      
      return;
    }
  }
#else
  if (data->key > 0 && data->key <= 3)
  {
    if (buttonmap[data->key] != '\0')
    {
      data->key = buttonmap[data->key];
      keyaction (data);
      return;
    }
  }
#endif

  if (infow && data->Window == infow)
  {
    int             x, y;
    if (findMouseInWin (&x, &y, w))
    {				/* local window */
      data->Window = w;
      data->x = x;
      data->y = y;
    }
    else if (findMouseInWin (&x, &y, mapw))
    {				/* galactic window */
      data->Window = mapw;
      data->x = x;
      data->y = y;
    }
  }

  if (motion_event)
  {
    if (data->key == W_RBUTTON)
    {
      course = getcourse (data->Window, data->x, data->y);
      set_course (course);
      return;
    }

    return;
  }
  
  if (data->key == W_RBUTTON)
  {
    course = getcourse (data->Window, data->x, data->y);
    set_course (course);
  }
  else if (data->key == W_LBUTTON)
  {
    course = getcourse (data->Window, data->x, data->y);
    sendTorpReq (course);
  }
  else if (data->key == W_MBUTTON)
  {
    course = getcourse (data->Window, data->x, data->y);
    sendPhaserReq (course);
  }

#ifdef SHIFTED_MOUSE
  else if (data->key == W_RBUTTON2)
  {
    set_speed (me->p_ship.s_maxspeed / 2);
    localflags &= ~(PFREFIT);
  }
  else if (data->key == W_LBUTTON2)
  {
    set_speed (99);		/* Max speed... */
    localflags &= ~(PFREFIT);
  }
  else if (data->key == W_MBUTTON2)
  {
    detmine ();
  }
  else if (data->key == W_RBUTTON3)
  {
    if (!infomapped)
    {
      inform (data->Window, data->x, data->y, 'i');

#ifdef KEEP_INFO
      opened_info = keepInfo;	/* 5/31/93 LAB */
#endif
    }
    else
    {
      destroyInfo ();

#ifdef KEEP_INFO
      opened_info = -2;		/* 5/31/93 LAB */
#endif
    }
  }
  else if (data->key == W_LBUTTON3)
  {
    shield_tog ();
  }
  else if (data->key == W_MBUTTON3)
  {
    cloak ();
  }
  else if (data->key == W_RBUTTON4)
  {
    lockPlanetOrBase (data->Window, data->x, data->y);
  }
  else if (data->key == W_LBUTTON4)
  {
    struct obtype  *gettarget (), *target;
    if (me->p_flags & (PFTRACT | PFPRESS))
      sendTractorReq (0, me->p_no);
    target = gettarget (data->Window, data->x, data->y, TARG_PLAYER);
    me->p_tractor = target->o_num;
    sendTractorReq (1, target->o_num);
  }
  else if (data->key == W_MBUTTON4)
  {
    struct obtype  *gettarget (), *target;
    if (me->p_flags & (PFTRACT | PFPRESS))
      sendRepressReq (0, me->p_no);
    target = gettarget (data->Window, data->x, data->y, TARG_PLAYER);
    me->p_tractor = target->o_num;
    sendRepressReq (1, target->o_num);
  }
#endif
}

/*
 * changed from unsigned char to irint() for precise rounding (from Leonard
 * Dickens)
 */
getcourse (ww, x, y)
  W_Window        ww;
  int             x, y;
{
  extern double   rint ();
  if (ww == mapw)
  {
    int             me_x, me_y;

    me_x = me->p_x * WINSIDE / GWIDTH;
    me_y = me->p_y * WINSIDE / GWIDTH;
    return (int) rint (atan2 ((double) (x - me_x),
			      (double) (me_y - y)) / 3.14159 * 128.);
  }
  else
    return (int) rint (atan2 ((double) (x - WINSIDE / 2),
			      (double) (WINSIDE / 2 - y))
		       / 3.14159 * 128.);
}

#ifdef SCAN
scan (w, x, y)
  W_Window        w;
  int             x, y;
{
}

#endif				/* ATM */
