/*
 * option.c
 */
#include "copyright.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

int             notdone;	/* not done flag */
int             old_showgalactic;
int             old_draw_map_names;
int             old_show_owner_map;
int             dummy = 1;
int             write_configuration = 1;

#ifdef LOGMESG
extern char    *logFileName;	/* from main.c */
extern char    *defaultsFile;	/* from main.c */
#endif

#ifdef ROTATERACE
static int      old_rotate, old_rotate_deg;
#endif

#ifndef DEFAULT_UPDATE_SPEED
#define DEFAULT_UPDATE_SPEED 4
#endif

int             updateSpeed = DEFAULT_UPDATE_SPEED;
static int      lastUpdateSpeed = DEFAULT_UPDATE_SPEED;

static char     newkeys[17];
static char     newckeys[17];
static char     newbuttons[17];
char            cname[17] = "";
static char     oplist[80];
static char     nplist[80];
static char     macro_key[4];
static char     logfile[65];
static char     xtrekrcfile[65];
static char     singlemacros[33];

#if (defined( DEBUG) || defined (BITMAP_DEBUG)) && defined(DYNAMIC_BITMAPS)
extern int      OwnBitmapNum;
#endif

char           *localmes[] =
{"Show owner on local planets",
  "Show resources on local planets",
  "Show nothing on local planets",
""};

char           *galacticmes[] =
{"Show owner on galactic map",
  "Show resources on galactic map",
  "Show nothing on galactic map",
""};

char	       *phasermes[] = 
{"Don't show phaser messages",
 "Show phaser messages on all window",
 "Show phaser messages on team window",
 "Show phaser messages on indiv window",
 "Show phaser messages on kill window",
 "Show phaser messages on total window",
 ""
};

#ifdef ROTATERACE
char           *rotatemess[] =
{"Don't rotate galaxy",
  "Rotate galaxy 90 degrees",
  "Rotate galaxy 180 degrees",
  "Rotate galaxy 270 degrees",
  ""
};

#endif

char           *mapupdates[] =
{"Don't update galactic map",
  "Update galactic map rarely",
  "Update galactic map frequently",
""};

static char    *lockoptions[] =
{"Don't show lock icon",
  "Show lock icon on galactic map only",
  "Show lock icon on tactical map only",
"Show lock icon on both map windows", ""};

/* useful for options that are an int with a range */
struct int_range
{
  int             min_value;	/* value is >= this */
  int             max_value;	/* value is <= this */
  int             increment;	/* a click raises/lowers this amount */
};


/*
 * Only one of op_option, op_targetwin, and op_string should be defined. If
 * op_string is defined, op_size should be too and op_text is used without a
 * "Don't" prefix. if op_range is defined, there should be a %d in op_text
 * for it, op_size will be non-useful, and the 'Don't ' prefix won't appear
 */
struct option
{
  int             op_num;
  char           *op_text;	/* text to display when on */
  int            *op_option;	/* variable to test/modify (optional) */
  W_Window       *op_targetwin;	/* target window to map/unmap (optional) */
  char           *op_string;	/* string to modify (optional) */
  int             op_size;	/* size of *op_string (optional) */
  char          **op_array;	/* array of strings to switch between */
  struct int_range *op_range;	/* struct definint an integer range option */
};

/* for the paged options menus */
struct option_menu
{
  int             page_num;	/* page number of this menu */
  struct option_menu *Next;
  struct option  *menu;		/* pointers to arrary of options */
  int             numopt;	/* number of options in this menu page */
  int             updated;	/* 1 if options can be changed externally */
};

/* pointer to first entry in the options menu list */
struct option_menu *FirstMenu = NULL;
struct option_menu *CurrentMenu = NULL;	/* menu currently looked at */
int             MenuPage = 0;	/* current menu page */
int             MaxOptions = 0;	/* maximum number of options in all menu
				 * pages */
struct int_range MenuPages =
{0, 1, 1};


/* updates: use of the int range thing... */
struct int_range updates_range =
{1, 10, 1};

/* range of menus. Will be updated when menu list is assembled */
struct int_range Menus_Range =
{0, 1, 1};

#if (defined( DEBUG) || defined (BITMAP_DEBUG)) && defined(DYNAMIC_BITMAPS)
struct int_range bitmap_range =
{0, 50, 1};

#endif

struct int_range dummy_range =
{1, 1, 0};

struct int_range write_configuration_range =
{1, 1, 0};

char           *clockmes[] =
{"No clock",
  "Clock format hours:minutes",
  "Clock format hours:minutes:seconds",
  ""};

struct int_range keep_info_range =
{0, 60, 1};

struct int_range phaser_range =
{0, 60, 1};

struct int_range motion_thresh_range =
{0, 64, 1};

struct int_range motion_mouse_range =
{0, 1, 1};
static char    *motion_mouse_options[] =
{"Don't use continuous mouse mode",
  "Use continuous mouse mode",
""};

struct int_range multiline_macro_range =
{0, 1, 0};
static char    *multiline_macro_options[] =
{"Don't ignore multi-line macros",
  "Ignore multi-line macros",
""};

struct int_range beeplite_planet_range =
{0, 50, 1};
struct int_range beeplite_player_range =
{0, 50, 1};

struct int_range beeplite_range =
{0, 1, 1};
static char    *beeplite_options[] =
{"Don't use RCD highlighting",
  "Use RCD highlighting",
""};

static char    *moo_bitmap_options[] =
{"Don't use moo bitmaps",
  "Use rabbit ear bitmaps",
  "Use ZZ minimal bitmaps",
""};


/* menus */
struct option   Window_Menu[] =
{
  {0, "Window Menu", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {1, "Page %d (click to change)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {2, "show \"all\" message window", 0, &messwa, 0, 0, NULL, NULL},
  {4, "show \"team\" message window", 0, &messwt, 0, 0, NULL, NULL},
  {5, "show \"your\" message window", 0, &messwi, 0, 0, NULL, NULL},
  {6, "show \"kill\" message window", 0, &messwk, 0, 0, NULL, NULL},
  {7, "show \"total\" message window", 0, &reviewWin, 0, 0, NULL, NULL},
  {7, "show phaser log window", &phaserWindow, &phaserwin, 0, 0, NULL},
  {8, "show statistic window", 0, &statwin, 0, 0, NULL, NULL},
  {11,  "", &phas_msg, 0, 0, 0, phasermes, NULL},

#ifdef NETSTAT
  {8, "show LagMeter ", &netstat, 0, 0, 0, NULL, NULL},
#endif

#ifdef PING
  {8, "show ping stats window", 0, &pStats, 0, 0, NULL},
#endif
  {9, "show UDP control window", 0, &udpWin, 0, 0, NULL, NULL},
  {9, "show help window", 0, &helpWin, 0, 0, NULL, NULL},

#ifdef XTREKRC_HELP
  {9, "show xtrekrc defaults window", 0, &defWin, 0, 0, NULL, NULL},
#endif
#ifdef MAKE_XTREKRC
  {17, "write configuration", &write_configuration, 0, 0, 0, NULL,
  &write_configuration_range},
#endif
  {10, "done", &notdone, 0, 0, 0, NULL, NULL},
  {-1, NULL, 0, 0, 0, 0, NULL, NULL}
};

struct option   Features_Menu[] =
{
  {0, "Features Menu", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {1, "Page %d (click to change)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {2, "show tactical planet names", &namemode, 0, 0, 0, NULL, NULL},
  {3, "show shields", &showShields, 0, 0, 0, NULL, NULL},
  {4, "", &mapmode, 0, 0, 0, mapupdates, NULL},
  {5, "stay peaceful when reborn", &keeppeace, 0, 0, 0, NULL, NULL},
  {6, "new keymap entries: %s", 0, 0, newkeys, 13, NULL, NULL},
  {7, "", &showlocal, 0, 0, 0, localmes, NULL},
  {8, "", &showgalactic, 0, 0, 0, galacticmes, NULL},
  {9, "%d updates per second", &updateSpeed, 0, 0, 0, 0, &updates_range},
  {10, "report kill messages", &reportKills, 0, 0, 0, NULL, NULL},
  {12, "show tractor/pressor", &showTractorPressor, 0, 0, 0, NULL, NULL},

#ifdef SHORT_PACKETS
  {13, "receive short packets", &recv_short_opt, 0, 0, 0, NULL, NULL},
  {14, "receive threshold: %s", 0, 0, recv_threshold_s, 13, NULL, NULL},
#endif

#ifdef NEW_PL
  {15, "show new playerlist", &newPlist, 0, 0, 0, NULL, NULL},
#endif
  {16, "use new message flags", &new_messages, 0, 0, 0, NULL, NULL},

#ifdef DASHBOARD
  {17, "use dashboard", &dashboard, 0, 0, 0, NULL, NULL},
#endif

#ifdef NEW_DASHBOARD_2
  {17, "use new dashboard", &cup_half_full, 0, 0, 0, NULL, NULL},
#endif

#ifdef MAKE_XTREKRC
  {17, "write configuration", &write_configuration, 0, 0, 0, NULL,
  &write_configuration_range},
#endif
  {17, "done", &notdone, 0, 0, 0, NULL, NULL},
  {-1, NULL, 0, 0, 0, 0, NULL, NULL}
};


struct option   SillyFeatures_Menu[] =
{
  {0, "Extra Features Menu (0)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {1, "Page %d (click to change)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {13, "", &showLock, 0, 0, 0, lockoptions, NULL},
  {11, "sort players in player window", &sortPlayers, 0, 0, 0, NULL, NULL},
  {12, "show tractor/pressor beams", &showTractorPressor, 0, 0, 0, NULL, NULL},
  {12, "show tractors after lock ", &continueTractor, 0, 0, 0, NULL, NULL},

#ifdef MOOBITMAPS

#ifdef ZZ_BITMAPS
  {12, "", &myPlanetBitmap, 0, 0, 0, moo_bitmap_options, NULL},
#else
  {12, "Use 'Moo' planet bitmaps", &myPlanetBitmap, 0, 0, 0, NULL, NULL},
#endif

#endif
  {12, "alert on extra border(s)", &extraBorder, 0, 0, 0, NULL, NULL},

#ifdef LOGMESG
  {12, "log messages", &logMess, 0, 0, 0, NULL, NULL},
#endif

#ifdef ROTATERACE
  {14, "", &rotate, 0, 0, 0, rotatemess, NULL},
#endif
  {12, "use message warp", &warp, 0, 0, 0, NULL, NULL},

#if (defined( DEBUG) || defined (BITMAP_DEBUG)) && defined(DYNAMIC_BITMAPS)
  {10, "Own bitmap number: %d", &OwnBitmapNum, 0, 0, 0, NULL, &bitmap_range},
#endif

#ifdef VSHIELD_BITMAPS
  {12, "show shield damage", &VShieldBitmaps, 0, 0, 0, NULL, NULL},
#endif
  {12, "show last msg in msg win", &use_msgw, 0, 0, 0, NULL, NULL},

#ifdef ROMVLVS_BITMAPS
  {10, "use ROMVLVS bitmap", &ROMVLVS, 0, 0, 0, NULL, NULL},
#endif

#ifdef SHOW_MY_SPEED
  {2, "show speed on tactical", &showMySpeed, 0, 0, 0, NULL, NULL},
#endif

/* SRS 3/15/94 -- When you enter game, send request for full update */

  {13, "request update on enter", &askforUpdate, 0,0,0, NULL, NULL},

#ifdef MAKE_XTREKRC
  {17, "write configuration", &write_configuration, 0, 0, 0, NULL,
  &write_configuration_range},
#endif
  {17, "done", &notdone, 0, 0, 0, NULL, NULL},
  {-1, NULL, 0, 0, 0, 0, NULL, NULL}
};

struct option   SillyFeatures_Menu1[] =
{
  {0, "Extra Features Menu (1)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {1, "Page %d (click to change)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {3, "show stats", &showStats, 0, 0, 0, NULL, NULL},
  {3, "fill lock-on triangle", &fillTriangle, 0, 0, 0, NULL, NULL},
  {3, "clock mode: %d", &tclock, 0, 0, 0, clockmes, NULL},
  {3, "align kill messages", &abbr_kmesg, 0, 0, 0, NULL, NULL},

#ifdef TNG_FED_BITMAPS
  {3, "use TNG style bitmaps", &use_tng_fed_bitmaps, 0, 0, 0, NULL, NULL},
#endif

#ifdef VARY_HULL
  {3, "warn hull", &vary_hull, 0, 0, 0, NULL, NULL},
#endif

#ifdef KEEP_INFO
  {3, "updates to keep info windows: %d", &keepInfo, 0, 0, 0, NULL, &keep_info_range},
#endif
  {3, "show player status", &plshowstatus, 0, 0, 0, NULL, NULL},

#ifdef SHOW_IND
  {3, "show independant planets with X", &showIND, 0, 0, 0, NULL, NULL},
#endif
#ifdef MAP_NAMES
  {2, "show map planet names", &draw_map_names, 0, 0, 0, NULL, NULL},
  {2, "show owner on map", &show_owner_map, 0, 0, 0, NULL, NULL},
#endif
  {3, "enemy phaser width: %d", &enemyPhasers, 0, 0, 0, NULL, &phaser_range},

#ifdef MOTION_MOUSE
  {3, "", &motion_mouse, 0, 0, 0, motion_mouse_options, &motion_mouse_range},
  {3, "Motion threshold for continuous mouse: %d", &user_motion_thresh, 0, 0, 0, NULL, &motion_thresh_range},
#endif

#ifdef SHIFTED_MOUSE
  {3, "use shifted mouse for more buttons", &extended_mouse, 0, 0, 0, NULL, NULL},
#endif
  {3, "show motd when on wait queue", &showMotdOnQ, 0, 0, 0, NULL, NULL},

#ifdef SHOW_FUEL_ON_LOCAL
  {3, "show fuel level on local", &show_fuel_on_local, 0, 0, 0, NULL, NULL},
#endif
 
#ifdef MAKE_XTREKRC
  {17, "write configuration", &write_configuration, 0, 0, 0, NULL,
  &write_configuration_range},
#endif
  {17, "done", &notdone, 0, 0, 0, NULL, NULL},
  {-1, NULL, 0, 0, 0, 0, NULL, NULL}
};

struct option   SillyFeatures_Menu2[] =
{
  {0, "Extra Features Menu (2)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},
  {1, "Page %d (click to change)", &MenuPage, 0, 0, 0, NULL, &Menus_Range},

#ifdef MAP_NAMES
  {2, "show owner on tactical", &show_owner_tact, 0, 0, 0, NULL, NULL},
#endif
  
#ifdef JUBILEE_PHASERS
  {6, "use colorful phasers", &jubilee_phasers, 0, 0, 0, NULL, NULL},
#endif
 
#ifdef MAKE_XTREKRC
  {6, "name: %s", 0, 0, cname, 16, NULL, NULL},
  {3, " ", &dummy, 0, 0, 0, NULL, &dummy_range},
#endif
  {6, "new buttonmap entries: %s", 0, 0, newbuttons, 16, NULL, NULL},

#ifdef CONTROL_KEY
  {6, "new ckeymap entries: %s", 0, 0, newckeys, 16, NULL, NULL},
#endif

#ifdef CLOAK_CHARS
  {6, "map cloak chars: %s", 0, 0, cloakChars, 3, NULL, NULL},
#endif

#ifdef PLIST
  {6, "playerlist: %s", 0, 0, oplist, 16, NULL, NULL},
#endif

#ifdef FEATURE
  {6, "macrokey: %s", 0, 0, macro_key, 4, NULL, NULL},
  {6, "single macros: %s", 0, 0, singlemacros, 33, NULL, NULL},
#endif
  {3, " ", &dummy, 0, 0, 0, NULL, &dummy_range},

#ifdef LOGMESG
  {6, "log file name: %s", 0, 0, logfile, 65, NULL, NULL},
#endif
  {6, "xtrekrc file name: %s", 0, 0, xtrekrcfile, 65, NULL, NULL},
#ifdef BEEPLITE
  {3, "", &UseLite, 0, 0, 0, beeplite_options, &beeplite_range},
  {2, "highlight/use default RCDs", &DefLite, 0, 0, 0, NULL, NULL},
  {3, "No. of updates to highlight player: %d", &beep_lite_cycle_time_player,
     0, 0, 0, NULL, &beeplite_player_range},
  {3, "No. of updates to highlight planet: %d", &beep_lite_cycle_time_planet,
     0, 0, 0, NULL, &beeplite_planet_range},
#endif

#ifdef MAKE_XTREKRC
  {17, "write configuration", &write_configuration, 0, 0, 0, NULL,
  &write_configuration_range},
#endif
  {17, "done", &notdone, 0, 0, 0, NULL, NULL},
  {-1, NULL, 0, 0, 0, 0, NULL, NULL}
};

#define NUMOPTIONS(menu) ((sizeof((menu))/sizeof((menu)[0]))-1)

#if __STDC__ || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* option.c */
static optionrefresh P_ ((register struct option * op));
static AddOptMenu P_ ((struct option NewMenu[], int updated));
static int NumOptions P_ ((struct option OpMenu[]));

#undef P_


/* option menu sizes and such */
#define OPTIONBORDER	2
#define OPTIONLEN	48

/* Set up the option menus and window. */
optionwindow ()
{
  register int    i;
  char           *home = (char *) getenv ("HOME");
  char           *name = getdefault ("name");
  /* Init not done flag */
  notdone = 1;

  strcpy (cname, me->p_name);
  *newkeys = '\0';
  newckeys[0] = '\0';

#ifdef SHORT_PACKETS
  *recv_threshold_s = 0;
#endif

#ifdef FEATURE
  if (macrokey == 27)
    strcpy (macro_key, "ESC");
  else if (macrokey == 9)
    strcpy (macro_key, "TAB");
  else
  {
    macro_key[0] = (char) macrokey;
    macro_key[1] = '\0';
  }
  
  make_singlemacrokeys (singlemacros);
#endif

#ifdef PLIST
  if (plist && strcmp (oplist, plist)) {
    strcpy (oplist, plist);
    strcpy (nplist, plist);
  }
#endif

#ifdef LOGMESG
  if (logFileName)
    strcpy (logfile, logFileName);
  else
    logfile[0] = '\0';

  if (defaultsFile)
    strcpy (xtrekrcfile, defaultsFile);
  else if (!home || !findDefaults (home, xtrekrcfile))
    xtrekrcfile[0] = '\0';
#endif

  if (FirstMenu == NULL)
  {
    MaxOptions = InitOptionMenus ();
    if (MaxOptions < 0)
    {
      fprintf (stderr, "InitOptionMenus() error %d!\n", MaxOptions);
      notdone = 0;
      return;
    }
  }

#ifdef MAP_NAMES
  old_draw_map_names = draw_map_names;
  old_show_owner_map = show_owner_map;
#endif

  /* Create window big enough to hold option windows */
  if (optionWin == NULL)
  {

    optionWin = W_MakeMenu ("option", WINSIDE + 10, -BORDER + 10, OPTIONLEN,
			    MaxOptions, baseWin, OPTIONBORDER);

#ifdef TCURSORS
    W_DefineArrowCursor (optionWin);
#endif

    CurrentMenu = FirstMenu;

    RefreshOptions ();
  }
  W_ResizeMenu (optionWin, OPTIONLEN, CurrentMenu->numopt);
  /* Map window */
  W_MapWindow (optionWin);
}

/* refresh all current options */
RefreshOptions ()
{
  int             i;
  struct option_menu *option;

  if (notdone == 0 || (option = CurrentMenu) == NULL)
    return;

  for (i = 0; i < option->numopt; i++)
  {
    optionrefresh (&(option->menu[i]));
  }

#ifdef nodef
  if (option->numopt < MaxOptions)
    for (i = option->numopt; i < MaxOptions; i++)
    {
      OptionClear (i);
    }
#endif
}

#ifdef nodef
/* blank out option line 'i' */
OptionClear (i)
{
  char           *blanktext = "                                               ";
  if (optionWin && notdone)
    W_WriteText (optionWin, 0, i, textColor, blanktext, OPTIONLEN, 0);
}

#endif

/* Redraw the specified option entry */
optionredrawtarget (win)
  W_Window        win;
{
  register struct option *op;

#ifdef nodef
  if (notdone == 0)
    return;
#endif

  for (op = CurrentMenu->menu; op->op_text; op++)
  {
    if (op->op_targetwin && win == *op->op_targetwin)
    {
      optionrefresh (op);
      break;
    }
  }
}

/* Redraw the specified option option */
optionredrawoption (ip)
  int            *ip;
{
  register struct option *op;

  if (notdone == 0)
    return;

  for (op = CurrentMenu->menu; op->op_num >= 0; op++)
  {
    if (ip == op->op_option)
    {
      optionrefresh (op);
      break;
    }
  }
}

/* Refresh the option window given by the option struct */
static
                optionrefresh (op)
  register struct option *op;
{
  register int    on;
  char            buf[BUFSIZ];

  if (op == NULL || notdone == 0)
    return;

  if (op->op_string)
  {
    (void) sprintf (buf, op->op_text, op->op_string);
  }
  else if (op->op_array)
  {				/* Array of strings */
    strcpy (buf, op->op_array[*op->op_option]);
  }
  else if (op->op_range)
  {
    (void) sprintf (buf, op->op_text, *(op->op_option));
  }
  else
  {
    /* Either a boolean or a window */
    if (op->op_option)
      on = *op->op_option;	/* use int for status */
    else if (op->op_targetwin)
      on = W_IsMapped (*op->op_targetwin);	/* use window for status */
    else
      on = 1;			/* shouldn't happen */

    if (!on)
      strcpy (buf, "Don't ");
    else
      buf[0] = '\0';
    strcat (buf, op->op_text);
  }

  if (islower (buf[0]))
    buf[0] = toupper (buf[0]);

  if (op->op_num == 0)
  {				/* title */
    W_WriteText (optionWin, 0, op->op_num, W_Yellow, buf, strlen (buf), 0);
  }
  else if (op->op_num == 1)
  {				/* "click" entry */
    W_WriteText (optionWin, 0, op->op_num, W_Green, buf, strlen (buf), 0);
  }
  else
    W_WriteText (optionWin, 0, op->op_num, textColor, buf, strlen (buf), 0);
}

/* deal with events sent to the option window */
optionaction (data)
  W_Event        *data;
{
  register struct option *op;
  int             i;
  register char  *cp;

  if (data->y >= CurrentMenu->numopt)
  {
    W_Beep ();
    return (0);
  }
  if (notdone == 0)
    return (0);

  op = &(CurrentMenu->menu[data->y]);

#ifdef MAKE_XTREKRC
  if (op->op_option == &write_configuration)
  {
    showDefaults = 1;
    warning ("Writing configuration file: $(HOME)/.cow-literc");
    make_xtrekrc (1);
    showDefaults = 0;
  }
#endif

  /* Update string; don't claim keystrokes for non-string options */
  /* deal with options with string input first */
  if (op->op_string == 0)
  {
    if (data->type == W_EV_KEY)
      return (0);
  }
  else
  {
    if (data->type == W_EV_BUTTON)
      return (0);
    switch (data->key)
    {

      case '\b':		/* delete character */
      case '\177':
	cp = op->op_string;
	i = strlen (cp);
	if (i > 0)
	{
	  cp += i - 1;
	  *cp = '\0';
	}
	break;

      case '\027':		/* word erase */
	cp = op->op_string;
	i = strlen (cp);
	/* back up over blanks */
	while (--i >= 0 && isspace (cp[i]));
	i++;
	/* back up over non-blanks */
	while (--i >= 0 && !isspace (cp[i]));
	i++;
	cp[i] = '\0';
	break;

      case '\025':		/* kill line */
      case '\030':
	op->op_string[0] = '\0';
	break;

      default:			/* add character to the list */
	if (data->key < 32 || data->key > 127)
	  break;
	cp = op->op_string;
	i = strlen (cp);
	if (i < (op->op_size - 1) && !iscntrl (data->key))
	{
	  cp += i;
	  cp[1] = '\0';
	  cp[0] = data->key;
	}
	else
	  W_Beep ();
	break;
    }
  }

  /* Toggle int, if it exists */
  if (op->op_array)
  {
    if (op->op_range)
    {
      if (data->key == W_RBUTTON)
      {
	(*op->op_option) += op->op_range->increment;
      }
      else if (data->key == W_MBUTTON)
      {
	(*op->op_option) = op->op_range->min_value;
      }
      else if (data->key == W_LBUTTON)
      {
	(*op->op_option) -= op->op_range->increment;
      }
      /* wrap value around within option range */
      if (*(op->op_option) > op->op_range->max_value)
	*(op->op_option) = op->op_range->min_value;

      if (*(op->op_option) < op->op_range->min_value)
	*(op->op_option) = op->op_range->max_value;
    }
    else if (data->key == W_RBUTTON)
    {
      (*op->op_option)++;
      if (*(op->op_array)[*op->op_option] == '\0')
      {
	*op->op_option = 0;
      }
    }
    else if (data->key == W_MBUTTON)
    {
      /* set option number to zero on the middle key to ease shutoff */
      *op->op_option = 0;
    }
    else if (data->key == W_LBUTTON)
    {
      /* if left button, decrease option  */
      (*op->op_option)--;
      /* if decreased too far, set to top option */
      if (*(op->op_option) < 0)
      {
	*op->op_option = 0;
	while (*(op->op_array)[*op->op_option] != '\0')
	{
	  (*op->op_option)++;
	}
	(*op->op_option)--;
      }
    }

#ifdef ROTATERACE
    if (op->op_option == &rotate && rotate != old_rotate)
    {
      register        i;
      register struct planet *l;
      register struct player *j;

      redrawall = 1;
      reinitPlanets = 1;

      for (i = 0, l = planets; i < MAXPLANETS; i++, l++)
      {
	if (rotate)
	{
	  rotate_deg = -old_rotate_deg + rotate * 64;
	  rotate_coord (&l->pl_x, &l->pl_y, rotate_deg,
			GWIDTH / 2, GWIDTH / 2);
	  rotate_deg = rotate * 64;
	}
	else
	{
	  rotate_deg = -old_rotate_deg;
	  rotate_coord (&l->pl_x, &l->pl_y, rotate_deg,
			GWIDTH / 2, GWIDTH / 2);
	  rotate_deg = 0;
	}
      }

      /*
       * we could wait for the server to do this but looks better if we do it
       * now.
       */
      for (i = 0, j = players; i < MAXPLAYER; i++, j++)
      {
	if (j->p_status != PALIVE)
	  continue;
	if (rotate)
	{
	  rotate_deg = -old_rotate_deg + rotate * 64;
	  rotate_coord (&j->p_x, &j->p_y, rotate_deg,
			GWIDTH / 2, GWIDTH / 2);
	  rotate_dir (&j->p_dir, rotate_deg);

	  rotate_deg = rotate * 64;
	}
	else
	{
	  rotate_deg = -old_rotate_deg;
	  rotate_coord (&j->p_x, &j->p_y, rotate_deg,
			GWIDTH / 2, GWIDTH / 2);
	  rotate_dir (&j->p_dir, rotate_deg);
	  rotate_deg = 0;
	}
      }
      /* phasers/torps/etc .. wait for server */

      old_rotate = rotate;
      old_rotate_deg = rotate_deg;
    }
#endif
  }
  else if (op->op_range)
  {
    if (data->key == W_RBUTTON)
    {
      (*op->op_option) += op->op_range->increment;
    }
    else if (data->key == W_MBUTTON)
    {
      (*op->op_option) = op->op_range->min_value;
    }
    else if (data->key == W_LBUTTON)
    {
      (*op->op_option) -= op->op_range->increment;
    }
    /* wrap value around within option range */
    if (*(op->op_option) > op->op_range->max_value)
      *(op->op_option) = op->op_range->min_value;
    if (*(op->op_option) < op->op_range->min_value)
      *(op->op_option) = op->op_range->max_value;
  }
  else if (op->op_option)
  {
    *op->op_option = !*op->op_option;

#ifdef NETSTAT
    /* XXXXXX KLUDGE */
    if (op->op_option == &netstat)
    {
      if (netstat && !W_IsMapped (lMeter))
      {
	ns_init (1);
	W_MapWindow (lMeter);
      }
      else if (!netstat && W_IsMapped (lMeter))
      {
	W_UnmapWindow (lMeter);
      }
    }
#endif

#ifdef PLIST
    /* XXXXXX KLUDGE */
    if (op->op_option == &newPlist)
    {
      W_ClearWindow (playerw);
      playerlist ();
    }
#endif

    if (op->op_option == &sortPlayers)
    {
      W_ClearWindow (playerw);
      playerlist ();
    }

#ifdef DASHBOARD
    if (op->op_option == &dashboard)
    {
      W_ClearWindow (tstatw);
      redrawTstats ();
    }
#endif

#ifdef NEW_DASHBOARD_2
    if (op->op_option == &cup_half_full)
    {
      W_ClearWindow (tstatw);
      redrawTstats ();
    }
#endif
  }
  /* Map/unmap window, if it exists */
  if (op->op_targetwin)
  {
    if (W_IsMapped (*op->op_targetwin))
      W_UnmapWindow (*op->op_targetwin);
    else
    {

#ifdef XTREKRC_HELP
      if (op->op_targetwin == &defWin)
	showdef ();
      else
#endif

      {
	W_MapWindow (*op->op_targetwin);
	if (*op->op_targetwin == udpWin)
	  udpwindow ();

#ifdef PING
	if (*op->op_targetwin == pStats)
	  redrawPStats ();
#endif
      }
    }
  }
  /* deal with possible menu change */
  if (MenuPage != CurrentMenu->page_num)
  {
    SetMenuPage (MenuPage);
    RefreshOptions ();
  }
  if (!notdone)			/* if done, that is */
    optiondone ();
  else
    optionrefresh (op);


  return (1);
}

/*
 * find the menu in the menus linked list that matches the one in the *
 * argument
 */
SetMenuPage (pagenum)
  int             pagenum;
{
  int             i = 1;
  if (FirstMenu != NULL)
    for (CurrentMenu = FirstMenu; CurrentMenu->Next != NULL &&
    CurrentMenu->page_num != pagenum; i++, CurrentMenu = CurrentMenu->Next);
  W_ResizeMenu (optionWin, OPTIONLEN, CurrentMenu->numopt);
}

optiondone ()
{
  char           *str;

  /* Unmap window */
  W_UnmapWindow (optionWin);

  /* update keymap */
  for (str = newkeys; *str != '\0'; str += 2)
  {
    if ((*str >= 32 && *str < 127) || *str == 'O')
    {
      if (*(str + 1) == '\0')
	break;
      mystats->st_keymap[*str - 32] = *(str + 1);
    }
    if (*(str + 1) == '\0')
      break;
  }
  *newkeys = '\0';

#ifdef CONTROL_KEY
  /* update ckeymap */
  if (newckeys[0] == '^')
    for (str = newckeys; *str != '\0';)
    {
      if (*str == '^')
	str++;
      else
	break;

      if (*str >= 32 && *str < 127)
      {
	if (*(str + 1) == '\0')
	  break;

	if (*(str + 1) == '^')
	{
	  if (*(str + 2) == '\0')
	    break;

	  mystats->st_keymap[*str - 32 + 96] = (char) (*(str + 2) + 96);
	  str += 3;
	}
	else
	{
	  mystats->st_keymap[*str - 32 + 96] = *(str + 1);
	  str += 2;
	}
      }
      else
	break;
    }

  newckeys[0] = '\0';
#endif

#ifdef FEATURE
  if (DefLite)
    litedefaults ();
#endif
  
  /* update buttonmap */
  if ((str = newbuttons) != NULL)
  {
    while (*str != '\0')
    {
      switch (*str++)
      {
	case '1':
	  buttonmap[1] = *str;
	  break;
	case '2':
	  buttonmap[2] = *str;
	  break;
	case '3':
	  buttonmap[3] = *str;
	  break;

#ifdef SHIFTED_MOUSE
	case '4':
	  buttonmap[4] = *str;
	  break;
	case '5':
	  buttonmap[5] = *str;
	  break;
	case '6':
	  buttonmap[6] = *str;
	  break;
	case '7':
	  buttonmap[7] = *str;
	  break;
	case '8':
	  buttonmap[8] = *str;
	  break;
	case '9':
	  buttonmap[9] = *str;
	  break;
	case 'a':
	  buttonmap[10] = *str;
	  break;
	case 'b':
	  buttonmap[11] = *str;
	  break;
	case 'c':
	  buttonmap[12] = *str;
	  break;
#endif

	default:
	  fprintf (stderr, "%c ignored in buttonmap\n", *(str - 1));
	  break;
      }
      str++;
    }
  }
  newbuttons[0] = '\0';

#ifdef PLIST
  if (plist && strcmp (oplist, nplist) && newPlist)
  {
    strcpy (plist, oplist);
    no_init_plist = 1;
    playerlistnum ();
    playerlist ();
    no_init_plist = 0;
  }
#endif

#ifdef FEATURE
  if (!strcmp (macro_key, "ESC"))
    macrokey = 27;
  else if (!strcmp (macro_key, "TAB"))
    macrokey = 9;
  else if (macro_key[0] != '\0')
    macrokey = macro_key[0];

  if (singlemacros [0])
  {    
    int i;
    char *str = singlemacros, buf [33];
    
    for (i = 0; *str; str++)
      if (*str == '^')
        buf [i++] = (char) (*(++str) + 96);
      else
        buf [i++] = *str;
        
    buf [i] = '\0';

    if (singleMacro)
      strcpy (singleMacro, buf);
    else
      singleMacro = (char *) strdup (buf);
  }
#endif

#ifdef LOGMESG
  if (logFileName && strcmp (logFileName, logfile))
    logFileName = logfile;
  else if (logFileName == NULL && logfile[0] != '\0')
    logFileName = logfile;
#endif

#ifdef LOGMESG
  if (defaultsFile && strcmp (defaultsFile, xtrekrcfile))
    defaultsFile = xtrekrcfile;
  else if (defaultsFile == NULL && xtrekrcfile[0] != '\0')
    defaultsFile = xtrekrcfile;
#endif

#ifdef SHORT_PACKETS
  {
    int             nt = atoi (recv_threshold_s);
    if (recv_threshold != nt)
    {
      recv_threshold = nt;
      sendThreshold (recv_threshold);
    }
    *recv_threshold_s = 0;
  }
#endif

  /* optionrefresh(&(option[KEYMAP])); Not sure why this is really needed */

  sendOptionsPacket ();		/* update server as to the client's options */

  if (updateSpeed != lastUpdateSpeed)
  {
    sendUpdatePacket (1000000 / updateSpeed);
    lastUpdateSpeed = updateSpeed;

#ifdef NETSTAT
    updatespeed = updateSpeed;
#endif				/* NETSTAT */
  }

#ifdef BUTTON_KEYMAP_WINDOW
  if (W_IsMapped (but_key_win))
    {
      W_ClearWindow (but_key_win);
      showkeymaps ();
    }
#endif

#ifdef SHORT_PACKETS
  if (recv_short != recv_short_opt)
  {
    /* we don't set recv_short .. that's done in socket.c */
    if (recv_short_opt)
      sendShortReq (SPK_VON);
    else
      sendShortReq (SPK_VOFF);
  }
#endif

#ifdef MAP_NAMES
  if (old_draw_map_names != draw_map_names)
    redrawall = 2;
    
  if (old_show_owner_map != show_owner_map)
    redrawall = 2;
#endif

  if (old_showgalactic != showgalactic)
  {
    old_showgalactic = showgalactic;
    if (!redrawall)
      redrawall = 2;
  }
}

/* set up menus linked list */
int
                InitOptionMenus ()
{
  int             i = 1;
  int             maxopts = 0;

#ifdef PLIST
  if (getdefault ("playerlist") == NULL)
  {
    if (newPlist)
      strcpy (oplist, "nTR N  K lrSd");
    else {
      strcpy (oplist, "nTRNKWLr O D d ");
  }
    strcpy(nplist,oplist);
  }
  else {
    strcpy (oplist, getdefault ("playerlist"));
    strcpy (nplist, oplist);
  }
#endif

  IFDEBUG (printf ("Adding OptionMenus\n");
  )
  /* AddOptMenu( &OptionsMenu, 0); */
    AddOptMenu (Features_Menu, 0);
  AddOptMenu (Window_Menu, 0);
  AddOptMenu (SillyFeatures_Menu, 0);
  AddOptMenu (SillyFeatures_Menu1, 0);
  AddOptMenu (SillyFeatures_Menu2, 0);

  for (i = 0, CurrentMenu = FirstMenu; CurrentMenu != NULL;
       i++, CurrentMenu = CurrentMenu->Next)
  {
    CurrentMenu->page_num = i;	/* repage the menus.. */
    if (CurrentMenu->numopt > maxopts)
      maxopts = CurrentMenu->numopt;
  }
  CurrentMenu = FirstMenu;
  Menus_Range.max_value = i - 1;
  IFDEBUG (printf ("OptionMenus Added! Maxopt = %d \n", i);
  )
    return maxopts;
}

static
                AddOptMenu (NewMenu, updated)
  struct option   NewMenu[];
  int             updated;
{
  struct option_menu *menuptr;
  struct option_menu *newmenu;
  int             i = 0;

  IFDEBUG (printf ("AddOptMenu\n");
  )
    menuptr = FirstMenu;

  newmenu = (struct option_menu *) malloc (sizeof (struct option_menu));
  if (newmenu == NULL)
  {
    perror ("Malloc Error adding a menu");
    return;
  }
  /* add to list */
  if (FirstMenu == NULL)
  {
    FirstMenu = newmenu;
  }
  else
  {
    for (i = 0, menuptr = FirstMenu; menuptr->Next != NULL; menuptr = menuptr->Next)
      i++;
    menuptr->Next = newmenu;
  }
  newmenu->page_num = i;
  newmenu->Next = NULL;
  newmenu->numopt = NumOptions (NewMenu);
  newmenu->menu = NewMenu;
  newmenu->updated = updated;
  IFDEBUG (printf ("Menu Added! \n", i);
  )
}

static int
                NumOptions (OpMenu)
  struct option   OpMenu[];
{
  int             i = 0;
  struct option  *ptr;

  ptr = &OpMenu[0];
  for (i = 0; ptr->op_num != -1 && ptr->op_option != &notdone; i++)
  {
    IFDEBUG (printf ("Option #%d..\n", i);
    )
      IFDEBUG (if (ptr->op_text != NULL) printf ("OP_Text:%s\n", ptr->op_text);
    )
      ptr = &OpMenu[i];
    ptr->op_num = i;
  }

  IFDEBUG (printf ("NumOptions in this menu: %d\n", i);
  )
    return i;
}

/*
 * a function that could be called regularly, to deal with menus that * might
 * be updated by external events. I.e. the udp menu!
 */
UpdateOptions ()
{
  if (notdone == 0)
    return;			/* don't update if menu isn't in use */
  if (CurrentMenu->updated)
    RefreshOptions ();
}
