/*
 * redraw.c
 */
#include "copyright.h"

#include <stdio.h>
#include <signal.h>
#include <math.h>
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "packets.h"

static int      clearzone[4][(MAXTORP + 1) * MAXPLAYER +
		                  (MAXPLASMA + 1) * MAXPLAYER + MAXPLANETS];
static int      clearcount;
static int      clearline[4][MAXPLAYER + 2 * MAXPLAYER];
static int      clearlmark[4];
static int      clearlmcount;
static int      clearlcount;

#define NORMALIZE(d) (((d) + 256) % 256)

#ifndef FOR_MORONS
static int      mclearzone[6][MAXPLAYER];	/* For map window */

#else				/* FOR_MORONS */

static int      mclearzone[6][MAXPLAYER + MAXPLANETS];	/* For map window */
int             For_Morons = 0;	/* set this to 1 for defaulting to MORON mode */
short           FlashChange = 1;
static time_t   lastflash;
#define BOLD_ON		( lastread % 2)	/* whether to show flash this update */
#endif				/* FOR_MORONS */

static short    nplayers;

#ifdef FOR_MORONS
static time_t   lastread;
#endif

intrupt (readfds)
  fd_set         *readfds;
{
  time_t          time ();
  extern int      errcount;

  udcounter++;
  if (readFromServer (readfds))
  {

#ifdef XTRA
    xinput ();
#endif

#ifdef FOR_MORONS
    lastread = time (NULL);
#endif

#ifndef NO_TRAP
    errcount = 0;		/* reset the signal handler error counters */
#endif

#ifdef FOR_MORONS
    if (For_Morons)
    {
      if (lastread != lastflash)
      {
	FlashChange = 1;
	lastflash = lastread;
      }
      else
      {
	FlashChange = 0;
      }
    }
    /* cache RealNumShips */
    (void) RealNumShips (-1);
#endif

#ifdef EM
    if (sortPlayers)
      Sorted_playerlist2 ();
    else
      playerlist2 ();
#endif

    redraw ();
    /* regular player list called from redraw */
  }
  if (reinitPlanets)
  {
    initPlanets ();
    reinitPlanets = 0;
  }

#ifdef FOR_MORONS		/* my thinking is is you haven't heard from
				 * the server, no amount of pinging is going
				 * to help */
  if (lastread + 3 < time (NULL))
  {
    /*
     * We haven't heard from server for awhile... Strategy:  send a useless
     * packet to "ping" server.
     */
    printf ("Server might be dead, pinging with a war req!\n");
    sendWarReq (me->p_hostile);
  }
#endif

  /*
   * New: scrolling windows updated every other update instead of for every
   * message packet
   */
  if ((udcounter % 2) == 0)
  {
    W_FlushScrollingWindow (messwa);
    W_FlushScrollingWindow (messwt);
    W_FlushScrollingWindow (messwi);
    W_FlushScrollingWindow (messwk);
    W_FlushScrollingWindow (reviewWin);
  }

  if (me->p_status == POUTFIT)
  {
    death ();
  }
}

redraw ()
{
  /* erase warning line if necessary */
  if (warncount && (warntimer <= udcounter))
  {
    W_ClearArea (warnw, 5, 5, W_Textwidth * warncount, W_Textheight);
    warncount = 0;
  }
  if (W_FastClear)
  {
    W_ClearWindow (w);
    clearcount = 0;
    clearlcount = 0;
  }
  else
  {
    while (clearcount)
    {
      clearcount--;
      W_CacheClearArea (w, clearzone[0][clearcount],
			clearzone[1][clearcount], clearzone[2][clearcount],
			clearzone[3][clearcount]);

      /*
       * W_ClearArea(w, clearzone[0][clearcount], clearzone[1][clearcount],
       * clearzone[2][clearcount], clearzone[3][clearcount]);
       */
    }
    while (clearlcount)
    {
      clearlcount--;
      W_CacheLine (w, clearline[0][clearlcount], clearline[1][clearlcount],
		   clearline[2][clearlcount], clearline[3][clearlcount],
		   backColor);
      /*
       * W_MakeLine(w, clearline[0][clearlcount], clearline[1][clearlcount],
       * clearline[2][clearlcount], clearline[3][clearlcount], backColor);
       */
    }
    W_FlushClearAreaCache (w);
    W_FlushLineCaches (w);
  }

  local ();			/* redraw local window */

#ifdef XTRA
  xinput ();
#endif

  W_FlushLineCaches (w);

#ifdef DASHBOARD
  if (dashboard)
    db_redraw (0);
  else
#endif

  {
    stline (0);

#ifdef MOO
    updateMaxStats (0);		/* Update the max stats <isae> */
#endif
  }

  if (W_IsMapped (statwin))
    updateStats ();

  if (mapmode)
    map ();

#ifdef MOO
  if (tclock)
    run_clock ();		/* I want it where I'm looking dammit */
#endif
}

#ifndef FONT_BITMAPS
W_Icon
planetBitmap (p)
  register struct planet *p;
{
  int             i;

  if (showlocal == 2)
  {

#ifdef MOOBITMAPS
    if ((p->pl_armies < 5) && (p->pl_info & me->p_team))
      return (bplanets[6]);
    else
#endif

      return (bplanets[0]);
  }
  else if (p->pl_info & me->p_team)
  {
    if (showlocal == 1)
    {
      i = 0;
      if (p->pl_armies > 4)
	i += 4;
      if (p->pl_flags & PLREPAIR)
	i += 2;
      if (p->pl_flags & PLFUEL)
	i += 1;
      return (bplanets2[i]);
    }
    else
    {
      return (bplanets[remap[p->pl_owner]]);
    }
  }
  else
  {
    return (bplanets[5]);
  }
}


W_Icon
planetmBitmap (p)
  register struct planet *p;
{
  int             i;

  if (showgalactic == 2)
  {
    return (mbplanets[0]);
  }
  else if (p->pl_info & me->p_team)
  {
    if (showgalactic == 1)
    {
      i = 0;
      if (p->pl_armies > 4)
	i += 4;
      if (p->pl_flags & PLREPAIR)
	i += 2;
      if (p->pl_flags & PLFUEL)
	i += 1;
      /* MOOBITMAPS */

#ifdef ZZ_BITMAPS
      if (myPlanetBitmap == 1)
	return (mbplanets3[i]);
      else if (myPlanetBitmap == 2)
	return (mbplanets4[i]);
#else

#ifdef MOOBITMAPS
      if (myPlanetBitmap)
	return (mbplanets3[i]);	/* <isae> new bitmaps */
      else
#endif

#endif

	return (mbplanets2[i]);
    }
    else
    {
      return (mbplanets[remap[p->pl_owner]]);
    }
  }
  else
  {
    return (mbplanets[5]);
  }
}

#endif

/* draw out the 'tactical' map */
local ()
{
  register int    h, i, my_x = me->p_x, my_y = me->p_y;
  register struct player *j;
  register struct torp *k;
  register struct planet *l;
  register struct phaser *php;
  register struct plasmatorp *pt;
  static int      tcounter = 2;

  int             dx, dy, px, py, wx, wy, redraw_plist = 0;
  int             view;
  char            idbuf[10];
  static W_Color ph_col;

#ifndef DYNAMIC_BITMAPS
  W_Icon (*ship_bits)[VIEWS];
#endif

  if (my_x < 0)
    return;

  /*
   * Kludge to try to fix missing ID chars on tactical (short range) display.
   */
  idbuf[0] = '0';
  idbuf[1] = '\0';
  /* Draw Planets */
  view = SCALE * WINSIDE / 2;
  for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++)
  {
    dx = l->pl_x - my_x;
    if (dx > view || dx < -view)
      continue;
    dy = l->pl_y - my_y;
    if (dy > view || dy < -view)
      continue;
    dx = dx / SCALE + WINSIDE / 2;
    dy = dy / SCALE + WINSIDE / 2;

#ifdef MOOBITMAPS
    /*
     * if using 'moo' bitmaps, and showing owner/nothing on local map, use
     * moo bitmap too!
     */
    if (myPlanetBitmap && (showlocal == 0 || showlocal == 2)
	&& l->pl_info & me->p_team)
    {
      int             bitmi = 0;
      if (l->pl_armies > 4)
	bitmi += 4;
      if (l->pl_flags & PLREPAIR)
	bitmi += 2;
      if (l->pl_flags & PLFUEL)
	bitmi += 1;

#ifdef FONT_BITMAPS
      W_MaskText (w, dx - (planet_width / 2), dy - (planet_height / 2),
		  planetColor (l), F_planetCharMoo (l), 1, F_planetFont (l));
#else				/* FONT_BITMAPS */

#ifdef ZZ_BITMAPS
      if (myPlanetBitmap == 1)
	W_WriteBitmap (dx - (planet_width / 2), dy - (planet_height / 2), bplanets3[bitmi], planetColor (l));
      else
	W_WriteBitmap (dx - (planet_width / 2), dy - (planet_height / 2), bplanets4[bitmi], planetColor (l));
#else				/* ZZ_BITMAPS */
      W_WriteBitmap (dx - (planet_width / 2), dy - (planet_height / 2), bplanets3[bitmi], planetColor (l));
#endif				/* ZZ_BITMAPS */

#endif				/* FONT_BITMAPS */
    }

#ifdef FONT_BITMAPS
    else
      W_MaskText (w, dx - (planet_width / 2), dy - (planet_height / 2),
		  planetColor (l), F_planetChar (l), 1, F_planetFont ());
#else				/* FONT_BITMAPS */
    else
      W_WriteBitmap (dx - (planet_width / 2), dy - (planet_height / 2),
		     planetBitmap (l), planetColor (l));
#endif				/* FONT_BITMAPS */

#else				/* MOOBITMAPS */

#ifdef FONT_BITMAPS
    W_MaskText (w, dx - (planet_width / 2), dy - (planet_height / 2),
		planetColor (l), F_planetChar (l), 1, F_planetFont ());
#else				/* FONT_BITMAPS */
    W_WriteBitmap (dx - (planet_width / 2), dy - (planet_height / 2),
		   planetBitmap (l), planetColor (l));
#endif				/* FONT_BITMAPS */

#endif				/* MOOBITMAPS */

    clearzone[0][clearcount] = dx - (planet_width / 2);
    clearzone[1][clearcount] = dy - (planet_height / 2);
    clearzone[2][clearcount] = planet_width;
    clearzone[3][clearcount] = planet_height;
    clearcount++;

#ifdef SHOW_IND
    if (showIND && (l->pl_info & me->p_team) && (l->pl_owner == NOBODY))
    {
      W_CacheLine (w, dx - (planet_width / 2), dy - (planet_height / 2),
		   dx + (planet_width / 2 - 1), dy + (planet_height / 2 - 1),
		   W_White);
      W_CacheLine (w, dx + (planet_width / 2 - 1), dy - (planet_height / 2),
		   dx - (planet_width / 2), dy + (planet_height / 2 - 1),
		   W_White);
    }
#endif

#ifdef MAP_NAMES
    if (show_owner_tact && l->pl_info)
      switch (l->pl_owner)
      {
        case FED:
	  W_CacheLine (w, dx - 17, dy - 1, dx - 17, dy - 1,
		      planetColor (l));
	  clearline[0][clearlcount] = dx - 17;
	  clearline[1][clearlcount] = dy - 1;
	  clearline[2][clearlcount] = dx - 17;
	  clearline[3][clearlcount] = dy - 1;
	  clearlcount++;
        break;
        case ROM:
	  W_CacheLine (w, dx - 1, dy - 17, dx - 1, dy - 17,
		      planetColor (l));
	  clearline[0][clearlcount] = dx - 1;
	  clearline[1][clearlcount] = dy - 17;
	  clearline[2][clearlcount] = dx - 1;
	  clearline[3][clearlcount] = dy - 17;
	  clearlcount++;
        break;
        case KLI:
	  W_CacheLine (w, dx + 15, dy - 1, dx + 15, dy - 1,
		      planetColor (l));
	  clearline[0][clearlcount] = dx + 15;
	  clearline[1][clearlcount] = dy - 1;
	  clearline[2][clearlcount] = dx + 15;
	  clearline[3][clearlcount] = dy - 1;
	  clearlcount++;
        break;
        case ORI:
	  W_CacheLine (w, dx - 1, dy + 15, dx - 1, dy + 15,
		      planetColor (l));
	  clearline[0][clearlcount] = dx - 1;
	  clearline[1][clearlcount] = dy + 15;
	  clearline[2][clearlcount] = dx - 1;
	  clearline[3][clearlcount] = dy + 15;
	  clearlcount++;
        break;
      }
#endif

    if (namemode)
    {
      W_MaskText (w, dx - (planet_width / 2), dy + (planet_height / 2),
		  planetColor (l), l->pl_name, l->pl_namelen,
		  planetFont (l));
      clearzone[0][clearcount] = dx - (planet_width / 2);
      clearzone[1][clearcount] = dy + (planet_height / 2);
      clearzone[2][clearcount] = W_Textwidth * l->pl_namelen;
      clearzone[3][clearcount] = W_Textheight;
      clearcount++;
    }
  }

#ifndef EM
  /* This used to be in the redraw loop, don't know why. */
  playerlist2 ();
#endif

#ifdef SHOW_FUEL_ON_LOCAL
  if (show_fuel_on_local && me->p_status == PALIVE)
  {
    int tx, ty;
    int mag = (10*me->p_fuel)/me->p_ship.s_maxfuel;
    unsigned char dir = me->p_dir;
    int odir = me->p_dir - 64;
    W_Color color;

    odir = NORMALIZE (odir);
    dx = WINSIDE / 2 + shield_width * Cos[odir];
    dy = WINSIDE / 2 + shield_width * Sin[odir];
    
    if (mag <= 2) /* 16% */
      color = W_Red;
    else if (mag <= 6) /* 66% */
      color = W_Yellow;
    else
      color = W_Green;

    tx = dx + mag * Cos[dir];
    ty = dy + mag * Sin[dir];
    dx = dx - mag * Cos[dir];
    dy = dy - mag * Sin[dir];
    W_CacheLine (w, dx, dy, tx, ty, color);
    clearline[0][clearlcount] = dx;
    clearline[1][clearlcount] = dy;
    clearline[2][clearlcount] = tx;
    clearline[3][clearlcount] = ty;
    clearlcount++;    
  }
#endif
  
  /* Draw ships */
  nplayers = 0;
  view = SCALE * WINSIDE / 2;
  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
  {
    if ((j->p_status != PALIVE) && (j->p_status != PEXPLODE))
      continue;
    nplayers++;
    if (j->p_flags & PFCLOAK)
    {
      if (j->p_cloakphase < (CLOAK_PHASES - 1))
      {
	j->p_cloakphase++;
      }
    }
    else
    {
      if (j->p_cloakphase)
      {
	j->p_cloakphase--;
      }
    }
    dx = j->p_x - my_x;
    if (dx > view || dx < -view)
      continue;
    dy = j->p_y - my_y;
    if (dy > view || dy < -view)
      continue;
    dx = dx / SCALE + WINSIDE / 2;
    dy = dy / SCALE + WINSIDE / 2;

    if (j->p_flags & PFCLOAK && (j->p_cloakphase == (CLOAK_PHASES - 1)))
    {
      if (myPlayer (j))
      {

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (cloak_width / 2), dy - (cloak_height / 2),
		    myColor, F_cloakChar (), 1, F_playerFont ());
#else
	W_WriteBitmap (dx - (cloak_width / 2), dy - (cloak_height / 2),
		       cloakicon, myColor);
#endif

#ifdef VARY_HULL
	clearzone[0][clearcount] = dx - (shield_width / 2 + 1);
	clearzone[1][clearcount] = dy - (shield_height / 2 + 1);
	clearzone[2][clearcount] = shield_width + 3;
	clearzone[3][clearcount] = shield_height + 3;
	clearcount++;
#else
	clearzone[0][clearcount] = dx - (shield_width / 2);
	clearzone[1][clearcount] = dy - (shield_height / 2);
	clearzone[2][clearcount] = shield_width;
	clearzone[3][clearcount] = shield_height;
	clearcount++;
#endif

	/* hmm... I guess this is ok now */

#ifdef VARY_HULL
	if (j == me && vary_hull)
	{
	  int             hull_left = (100 * (me->p_ship.s_maxdamage -
		      me->p_damage)) / me->p_ship.s_maxdamage, hull_num = 7;
	  int             hull_color;

	  if (hull_left <= 16)
	  {
	    hull_num = 0;
	    hull_color = W_Red;
	  }
	  else if (hull_left <= 28)
	  {
	    hull_num = 1;
	    hull_color = W_Yellow;
	  }
	  else if (hull_left <= 40)
	  {
	    hull_num = 2;
	    hull_color = W_Green;
	  }
	  else if (hull_left <= 52)
	  {
	    hull_num = 3;
	    hull_color = W_Green;
	  }
	  else if (hull_left <= 64)
	  {
	    hull_num = 4;
	    hull_color = W_Green;
	  }
	  else if (hull_left <= 76)
	  {
	    hull_num = 5;
	    hull_color = W_White;
	  }
	  else if (hull_left <= 88)
	  {
	    hull_num = 6;
	    hull_color = W_White;
	  }
	  else
	    hull_color = playerColor (j);

	  W_WriteBitmap (dx - (shield_width / 2 + 1),
			 dy - (shield_height / 2 + 1),
			 hull[hull_num], hull_color);
	}
#endif

	if (showShields && (me->p_flags & PFSHIELD))
	{

#ifdef VSHIELD_BITMAPS
	  int             color;
	  int             shieldnum;
	  if (VShieldBitmaps)
	  {
	    shieldnum = SHIELD_FRAMES * me->p_shield / me->p_ship.s_maxshield
	      ;
	    if (shieldnum >= SHIELD_FRAMES)
	      shieldnum = SHIELD_FRAMES - 1;
	    color = gColor;
	    if (shieldnum < SHIELD_FRAMES * 2 / 3)
	    {
	      color = yColor;
	      if (shieldnum < SHIELD_FRAMES * 2 / 3)
	      {
		color = rColor;
	      }
	    }
	  }
	  else
	  {
	    color = playerColor (me);
	    shieldnum = 2;
	  }

#ifdef FONT_BITMAPS
	  W_MaskText (w, dx - (shield_width / 2), dy - (shield_width / 2),
		      color, F_shieldChar (shieldnum), 1, F_playerFont ());
#else
	  W_WriteBitmap (dx - (shield_width / 2),
			 dy - (shield_height / 2), shield[shieldnum], color);
#endif

#else

#ifdef FONT_BITMAPS
	  W_MaskText (w, dx - (shield_width / 2), dy - (shield_width / 2),
		      playerColor (j), F_shieldChar (0), 1, F_playerFont ());
#else
	  W_WriteBitmap (dx - (shield_width / 2),
			 dy - (shield_height / 2), shield, playerColor (j));
#endif

#endif				/* nodef */

	}
      }
      continue;
    }
    if (j->p_status == PALIVE)
    {

#if !defined(DYNAMIC_BITMAPS) && !defined(FONT_BITMAPS)
      switch (j->p_team)
      {
	case FED:

#ifdef TNG_FED_BITMAPS
	  if (use_tng_fed_bitmaps)
	    ship_bits = tng_fed_bitmaps;
	  else
	    ship_bits = fed_bitmaps;
#else
	  ship_bits = fed_bitmaps;
#endif

	  break;
	case ROM:
	  ship_bits = rom_bitmaps;
	  break;
	case KLI:
	  ship_bits = kli_bitmaps;
	  break;
	case ORI:
	  ship_bits = ori_bitmaps;
	  break;
	default:
	  ship_bits = ind_bitmaps;
	  break;
      }
#endif

#if defined (VARY_HULL) || defined (BEEPLITE)
      clearzone[0][clearcount] = dx - (shield_width / 2 + 6);
      clearzone[1][clearcount] = dy - (shield_height / 2 + 6);
      clearzone[2][clearcount] = shield_width + 12;
      clearzone[3][clearcount] = shield_height + 12;
      clearcount++;
#else
      clearzone[0][clearcount] = dx - (shield_width / 2);
      clearzone[1][clearcount] = dy - (shield_height / 2);
      clearzone[2][clearcount] = shield_width;
      clearzone[3][clearcount] = shield_height;
      clearcount++;
#endif

      /* we wait til after drawing text number to increment clearcount */

#ifdef FONT_BITMAPS
      W_MaskText (w, dx - (shield_width / 2), dy - (shield_width / 2),
		  playerColor (j), F_shipChar (j), 1, F_playerFont ());
#else

#ifdef ROMVLVS_BITMAPS
      if (j->p_team == ROM && j->p_ship.s_type == CRUISER &&
	  ROMVLVS)
	W_WriteBitmap (dx - (j->p_ship.s_width / 2),
	  dy - (j->p_ship.s_height / 2), ROMVLVS_bitmap[rosette (j->p_dir)],
		       playerColor (j));
      else
#endif

	W_WriteBitmap (dx - (j->p_ship.s_width / 2),
		       dy - (j->p_ship.s_height / 2),

#ifndef DYNAMIC_BITMAPS
		       ship_bits[j->p_ship.s_type][rosette (j->p_dir)],
#else
		       ship_bitmaps[PlayerBitmap (j)][rosette (j->p_dir)],
#endif

		       playerColor (j));
#endif				/* FONT_BITMAPS */

      IFDEBUG (if (j == me) printf ("Dir #%d\n", rosette (j->p_dir));
      )
	if (j->p_cloakphase > 0)
      {

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (cloak_height / 2), dy - (cloak_width / 2),
		    playerColor (j), F_cloakChar (), 1, F_playerFont ());
#else
	W_WriteBitmap (dx - (cloak_width / 2),
		       dy - (cloak_height / 2), cloakicon, playerColor (j));
#endif

	clearcount++;
	continue;
      }

#ifdef BEEPLITE
      if (UseLite && lite_players_local && emph_player_seq_n [j->p_no] > 0)
      {
        int seq_n = emph_player_seq_n [j->p_no] % emph_player_seql_frames;
 
        W_WriteBitmap (dx - (emph_player_seql_width/2), 
		       dy - (emph_player_seql_height/2),
		       emph_player_seql [seq_n], 
		       W_White);
      }
#endif
      
#ifdef VARY_HULL
      if (j == me && vary_hull)
      {
	int             hull_left = (100 * (me->p_ship.s_maxdamage -
		      me->p_damage)) / me->p_ship.s_maxdamage, hull_num = 7;
	int             hull_color;

	if (hull_left <= 16)
	{
	  hull_num = 0;
	  hull_color = W_Red;
	}
	else if (hull_left <= 28)
	{
	  hull_num = 1;
	  hull_color = W_Yellow;
	}
	else if (hull_left <= 40)
	{
	  hull_num = 2;
	  hull_color = W_Green;
	}
	else if (hull_left <= 52)
	{
	  hull_num = 3;
	  hull_color = W_Green;
	}
	else if (hull_left <= 64)
	{
	  hull_num = 4;
	  hull_color = W_Green;
	}
	else if (hull_left <= 76)
	{
	  hull_num = 5;
	  hull_color = W_White;
	}
	else if (hull_left <= 88)
	{
	  hull_num = 6;
	  hull_color = W_White;
	}
	else
	  hull_color = playerColor (j);

	W_WriteBitmap (dx - (shield_width / 2 + 1),
		       dy - (shield_height / 2 + 1),
		       hull[hull_num], hull_color);
      }
#endif

      if (showShields && (j->p_flags & PFSHIELD))
      {

#ifdef VSHIELD_BITMAPS
	int             color;
	int             shieldnum;
	if (j == me && VShieldBitmaps)
	{
	  shieldnum = SHIELD_FRAMES * me->p_shield / me->p_ship.s_maxshield;
	  if (shieldnum >= SHIELD_FRAMES)
	    shieldnum = SHIELD_FRAMES - 1;
	  color = gColor;
	  if (shieldnum < SHIELD_FRAMES * 2 / 3)
	  {
	    color = yColor;
	    if (shieldnum < SHIELD_FRAMES * 2 / 3)
	    {
	      color = rColor;
	    }
	  }
	}
	else
	{
	  color = playerColor (j);
	  shieldnum = 2;
	}

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (shield_width / 2), dy - (shield_height / 2),
		    color, F_shieldChar (shieldnum), 1, F_playerFont ());
#else
	W_WriteBitmap (dx - (shield_width / 2),
		       dy - (shield_height / 2), shield[shieldnum], color);
#endif				/* FONT_BITMAPS */

#else

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (shield_width / 2), dy - (shield_height / 2),
		    playerColor (j), F_shieldChar (0), 1, F_playerFont ());
#else
	W_WriteBitmap (dx - (shield_width / 2),
		       dy - (shield_height / 2), shield, playerColor (j));
#endif				/* FONT_BITMAPS */

#endif				/* nodef */
      }
      {
	int             color = playerColor (j), buflen = 1;
	idbuf[0] = *(shipnos + j->p_no);

	if (j == me)
	{
	  switch (me->p_flags & (PFGREEN | PFYELLOW | PFRED))
	  {
	    case PFGREEN:
	      color = gColor;
	      break;
	    case PFYELLOW:
	      color = yColor;
	      break;
	    case PFRED:
	      color = rColor;
	      break;
	  }

#ifdef SHOW_MY_SPEED
	  if (showMySpeed)
	  {
	    if (j->p_speed < 10)
	    {
	      idbuf[1] = ',';
	      idbuf[2] = j->p_speed + '0';
	      idbuf[3] = '\0';
	      buflen = 3;
	    }
	    else
	    {
	      idbuf[1] = ',';
	      idbuf[2] = j->p_speed / 10 + '0';
	      idbuf[3] = j->p_speed % 10 + '0';
	      idbuf[4] = '\0';
	      buflen = 4;
	    }
	  }
#endif
	}
	W_MaskText (w, dx + (j->p_ship.s_width / 2),
		    dy - (j->p_ship.s_height / 2), color,
		    idbuf, buflen, shipFont (j));

	/* save a clearzone */
	clearzone[0][clearcount] = dx + (j->p_ship.s_width / 2);
	clearzone[1][clearcount] = dy - (j->p_ship.s_height / 2);
	clearzone[2][clearcount] = buflen*W_Textwidth;
	clearzone[3][clearcount] = W_Textheight;
	clearcount++;
      }
    }
    else if (j->p_status == PEXPLODE)
    {
      int             i;

      i = j->p_explode;
      if (i < EX_FRAMES || (i < SBEXPVIEWS && j->p_ship.s_type == STARBASE))
      {

	if (j->p_ship.s_type == STARBASE)
	{

#ifdef FONT_BITMAPS
	  W_MaskText (w, dx - (sbexp_width / 2), dy - (sbexp_height / 2),
		      playerColor (j), F_expSbChar (i), 1, F_explodeFont ());
#else
	  W_WriteBitmap (dx - (sbexp_width / 2),
			 dy - (sbexp_height / 2), sbexpview[i],
			 playerColor (j));
#endif

	  clearzone[0][clearcount] = dx - (sbexp_width / 2);
	  clearzone[1][clearcount] = dy - (sbexp_height / 2);
	  clearzone[2][clearcount] = sbexp_width;
	  clearzone[3][clearcount] = sbexp_height;
	}
	else
	{

#ifdef FONT_BITMAPS
	  W_MaskText (w, dx - (ex_width / 2), dy - (ex_height / 2),
		      playerColor (j), F_expChar (i), 1, F_explodeFont ());
#else
	  W_WriteBitmap (dx - (ex_width / 2), dy - (ex_height / 2),
			 expview[i], playerColor (j));
#endif

	  clearzone[0][clearcount] = dx - (ex_width / 2);
	  clearzone[1][clearcount] = dy - (ex_height / 2);
	  clearzone[2][clearcount] = ex_width;
	  clearzone[3][clearcount] = ex_height;
	}
	clearcount++;
	j->p_explode++;
      }
    }
    /* Now draw his phaser (if it exists) */
    php = &phasers[j->p_no];
    if (php->ph_status != PHFREE)
    {
      int             tx, ty;

      if (php->ph_status == PHMISS)
      {
	/* Here I will have to compute end coordinate */
	tx = j->p_x + PHASEDIST * j->p_ship.s_phaserdamage / 100 * Cos[php->ph_dir];
	ty = j->p_y + PHASEDIST * j->p_ship.s_phaserdamage / 100 * Sin[php->ph_dir];
	tx = (tx - my_x) / SCALE + WINSIDE / 2;
	ty = (ty - my_y) / SCALE + WINSIDE / 2;
	px = j->p_x + PHASEDIST * j->p_ship.s_phaserdamage / 100 * Cos[php->ph_dir];
	py = j->p_y + PHASEDIST * j->p_ship.s_phaserdamage / 100 * Sin[php->ph_dir];
	px = (px - me->p_x) / SCALE + WINSIDE / 2;
	py = (py - me->p_y) / SCALE + WINSIDE / 2;
      }
      else if (php->ph_status == PHHIT2)
      {
	tx = (php->ph_x - my_x) / SCALE + WINSIDE / 2;
	ty = (php->ph_y - my_y) / SCALE + WINSIDE / 2;
	px = (php->ph_x - me->p_x) / SCALE + WINSIDE / 2;
	py = (php->ph_y - me->p_y) / SCALE + WINSIDE / 2;
      }
      else
      {				/* Start point is dx, dy */

	tx = (players[php->ph_target].p_x - my_x) /
	  SCALE + WINSIDE / 2;
	ty = (players[php->ph_target].p_y - my_y) /
	  SCALE + WINSIDE / 2;
	px = (players[php->ph_target].p_x - me->p_x) /
	  SCALE + WINSIDE / 2;
	py = (players[php->ph_target].p_y - me->p_y) /
	  SCALE + WINSIDE / 2;
      }

      if (friendlyPlayer (j))
      {
#ifdef JUBILEE_PHASERS
	if (j == me && php->ph_status == PHHIT && jubilee_phasers)
	{
	  int col;

	  switch (ph_col)
	  {
	  case 0:
	    col = W_Red;
	    break;
	  case 1:
	    col = W_Green;
	    break;
	  case 2:
	    col = W_Yellow;
	    break;
	  case 3:
	    col = W_Cyan;
	    break;
	  default:
	    col = shipCol [remap[j->p_team]];
	    ph_col = 0;
	  }
	  
	  ph_col++;

	  W_CacheLine (w, dx, dy, tx, ty, col);
	}
	else
	{
/* I prefer them to just be solid white, I think most others will too
   So I take this line out and replace it */
/*	  if ((php->ph_fuse % 2) == 1)    */
	  if (php->ph_status != PHMISS)
	    W_CacheLine (w, dx, dy, tx, ty, foreColor);
	  else
	    W_CacheLine (w, dx, dy, tx, ty, shipCol [remap[j->p_team]]);
	}
#else
	if ((php->ph_fuse % 2) == 1)
	  W_CacheLine (w, dx, dy, tx, ty, foreColor);
	else
	  W_CacheLine (w, dx, dy, tx, ty, shipCol [remap[j->p_team]]);
#endif
	php->ph_fuse++;
	clearline[0][clearlcount] = dx;
	clearline[1][clearlcount] = dy;
	clearline[2][clearlcount] = tx;
	clearline[3][clearlcount] = ty;
	clearlcount++;
      }
      else
      {
	if ((enemyPhasers > 0) && (enemyPhasers <= 10))
	{
	  register int    lx, ly;

	  if (px == dx && py == dy)
	    continue;

	  wx = dx + enemyPhasers * Cos[NORMALIZE (php->ph_dir + 64)];
	  wy = dy + enemyPhasers * Sin[NORMALIZE (php->ph_dir + 64)];
	  lx = dx + enemyPhasers * Cos[NORMALIZE (php->ph_dir - 64)];
	  ly = dy + enemyPhasers * Sin[NORMALIZE (php->ph_dir - 64)];

	  W_MakePhaserLine (w, wx, wy, px, py, shipCol[remap[j->p_team]]);
	  W_MakePhaserLine (w, lx, ly, px, py, shipCol[remap[j->p_team]]);

	  php->ph_fuse++;

	  clearline[0][clearlcount] = wx;
	  clearline[1][clearlcount] = wy;
	  clearline[2][clearlcount] = px;
	  clearline[3][clearlcount] = py;
	  clearlcount++;

	  clearline[0][clearlcount] = lx;
	  clearline[1][clearlcount] = ly;
	  clearline[2][clearlcount] = px;
	  clearline[3][clearlcount] = py;
	  clearlcount++;
	}
	else
	{
	  W_MakePhaserLine (w, dx, dy, px, py, shipCol[remap[j->p_team]]);

	  php->ph_fuse++;

	  clearline[0][clearlcount] = dx;
	  clearline[1][clearlcount] = dy;
	  clearline[2][clearlcount] = px;
	  clearline[3][clearlcount] = py;
	  clearlcount++;
	}
      }

      if (php->ph_fuse++ > 10)
      {
	php->ph_status = PHFREE;
      }
    }
    /* ATM - show tractor/pressor beams (modified by James Collins) */
    /* showTractorPressor is a variable set by xtrekrc. */
    if (showTractorPressor)
    {
      if (j == me && (j->p_flags & (PFTRACT | PFPRESS)) && j->p_status == PALIVE)
      {
	double          theta;
	unsigned char   dir;
	int             lx[2], ly[2], px, py, target_width;

	struct player  *tractee;
	if (me->p_tractor < 0 || me->p_tractor >= MAXPLAYER)
	  continue;
	tractee = &players[me->p_tractor];
	if (tractee->p_status != PALIVE ||
	    ((tractee->p_flags & PFCLOAK) && (tractee->p_cloakphase == (CLOAK_PHASES - 1))))
	  continue;
	if (tcounter >= 2)
	{			/* continue tractor stuff */
	  if (!continueTractor)
	    tcounter--;
	  px = (players[me->p_tractor].p_x - my_x) / SCALE + WINSIDE / 2;
	  py = (players[me->p_tractor].p_y - my_y) / SCALE + WINSIDE / 2;
	  if (px == dx && py == dy)
	    continue;		/* this had better be last in for(..) */
#define XPI     3.1415926
	  theta = atan2 ((double) (px - dx), (double) (dy - py)) + XPI / 2.0;
	  dir = (unsigned char) (theta / XPI * 128.0);
	  if (tractee->p_flags & PFSHIELD)
	    target_width = shield_width;
	  else
	  {
	    target_width = tractee->p_ship.s_width / 2;
	  }
	  lx[0] = px + (Cos[dir] * (target_width / 2));
	  ly[0] = py + (Sin[dir] * (target_width / 2));
	  lx[1] = px - (Cos[dir] * (target_width / 2));
	  ly[1] = py - (Sin[dir] * (target_width / 2));
#undef XPI
	  if (j->p_flags & PFPRESS)
	  {
	    W_MakeTractLine (w, dx, dy, lx[0], ly[0], W_Yellow);
	    W_MakeTractLine (w, dx, dy, lx[1], ly[1], W_Yellow);
	  }
	  else
	  {
	    W_MakeTractLine (w, dx, dy, lx[0], ly[0], W_Green);
	    W_MakeTractLine (w, dx, dy, lx[1], ly[1], W_Green);
	  }
	  clearline[0][clearlcount] = dx;
	  clearline[1][clearlcount] = dy;
	  clearline[2][clearlcount] = lx[0];
	  clearline[3][clearlcount] = ly[0];
	  clearlcount++;
	  clearline[0][clearlcount] = dx;
	  clearline[1][clearlcount] = dy;
	  clearline[2][clearlcount] = lx[1];
	  clearline[3][clearlcount] = ly[1];
	  clearlcount++;
	}
	else
	  tcounter = 2;
      }
    }
  }
  /* Draw torps */
  view = SCALE * WINSIDE / 2;
  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
  {
    if (!j->p_ntorp)
      continue;
    for (h = 0, k = &torps[MAXTORP * i + h]; h < MAXTORP; h++, k++)
    {
      if (!k->t_status)
	continue;

      dx = k->t_x - my_x;
      if (dx > view || dx < -view)
      {
	/* Call any torps off screen "free" (if owned by other) */
	if (k->t_status == TEXPLODE && j != me)
	{
	  k->t_status = TFREE;
	  j->p_ntorp--;
	}
	continue;
      }
      dy = k->t_y - my_y;
      if (dy > view || dy < -view)
      {
	/* Call any torps off screen "free" (if owned by other) */
	if (k->t_status == TEXPLODE && j != me)
	{
	  k->t_status = TFREE;
	  j->p_ntorp--;
	}
	continue;
      }
      dx = dx / SCALE + WINSIDE / 2;
      dy = dy / SCALE + WINSIDE / 2;
      if (k->t_status == TEXPLODE)
      {
	k->t_fuse--;
	if (k->t_fuse <= 0)
	{
	  k->t_status = TFREE;
	  j->p_ntorp--;
	  continue;
	}
	if (k->t_fuse >= NUMDETFRAMES)
	{
	  k->t_fuse = NUMDETFRAMES - 1;
	}

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (cloud_width / 2), dy - (cloud_height / 2),
	       torpColor (k), F_expTorpChar (k->t_fuse), 1, F_smallFont ());
#else
	W_WriteBitmap (dx - (cloud_width / 2), dy - (cloud_height / 2),
		       cloud[k->t_fuse], torpColor (k));
#endif

	clearzone[0][clearcount] = dx - (cloud_width / 2);
	clearzone[1][clearcount] = dy - (cloud_height / 2);
	clearzone[2][clearcount] = cloud_width;
	clearzone[3][clearcount] = cloud_height;
	clearcount++;
      }
      else if (k->t_owner != me->p_no && ((k->t_war & me->p_team) ||
	       (players[k->t_owner].p_team & (me->p_hostile | me->p_swar))))
      {
	/*
	 * solid.  Looks strange. W_FillArea(w, dx - (etorp_width/2), dy -
	 * (etorp_height/2), etorp_width, etorp_height, torpColor(k));
	 */

#ifndef BD
	W_CacheLine (w, dx - (etorp_width / 2), dy - (etorp_height / 2),
	    dx + (etorp_width / 2), dy + (etorp_height / 2), torpColor (k));
	W_CacheLine (w, dx + (etorp_width / 2), dy - (etorp_height / 2),
	    dx - (etorp_width / 2), dy + (etorp_height / 2), torpColor (k));
#else
	/* BORG TEST */
	W_CacheLine (w, dx - (etorp_width / 2), dy - (etorp_height / 2),
		     dx + (etorp_width / 2), dy + (etorp_height / 2),
		     (k->t_turns == 32767) ? notColor (k) : torpColor (k));
	W_CacheLine (w, dx + (etorp_width / 2), dy - (etorp_height / 2),
		     dx - (etorp_width / 2), dy + (etorp_height / 2),
		     (k->t_turns == 32767) ? notColor (k) : torpColor (k));
#endif

	/*
	 * W_WriteBitmap(dx - (etorp_width/2), dy - (etorp_height/2), etorp,
	 * torpColor(k));
	 */
	clearzone[0][clearcount] = dx - (etorp_width / 2);
	clearzone[1][clearcount] = dy - (etorp_height / 2);
	clearzone[2][clearcount] = etorp_width;
	clearzone[3][clearcount] = etorp_height;
	clearcount++;
      }
      else
      {

	W_CacheLine (w, dx - (mtorp_width / 2), dy, dx + (mtorp_width / 2), dy,
		     torpColor (k));
	W_CacheLine (w, dx, dy - (mtorp_width / 2), dx, dy + (mtorp_width / 2),
		     torpColor (k));

	/*
	 * W_WriteBitmap(dx - (mtorp_width/2), dy - (mtorp_height/2), mtorp,
	 * torpColor(k));
	 */
	clearzone[0][clearcount] = dx - (mtorp_width / 2);
	clearzone[1][clearcount] = dy - (mtorp_height / 2);
	clearzone[2][clearcount] = mtorp_width;
	clearzone[3][clearcount] = mtorp_height;
	clearcount++;
      }
    }
  }
  /* Draw plasma torps */
  view = SCALE * WINSIDE / 2;
  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
  {
    if (!j->p_nplasmatorp)
      continue;
    for (h = 0, pt = &plasmatorps[MAXPLASMA * i + h]; h < MAXPLASMA; h++, pt++)
    {
      if (!pt->pt_status)
	continue;

      dx = pt->pt_x - my_x;
      if (dx > view || dx < -view)
	continue;
      dy = pt->pt_y - my_y;
      if (dy > view || dy < -view)
	continue;
      dx = dx / SCALE + WINSIDE / 2;
      dy = dy / SCALE + WINSIDE / 2;
      if (pt->pt_status == PTEXPLODE)
      {
	pt->pt_fuse--;
	if (pt->pt_fuse <= 0)
	{
	  pt->pt_status = PTFREE;
	  j->p_nplasmatorp--;
	  continue;
	}
	if (pt->pt_fuse >= NUMDETFRAMES)
	{
	  pt->pt_fuse = NUMDETFRAMES - 1;
	}

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (plasmacloud_width / 2),
		    dy - (plasmacloud_height / 2),
		    plasmatorpColor (pt),
		    F_expPlasmaTorpChar (pt->pt_fuse), 1, F_smallFont ());
#else
	W_WriteBitmap (dx - (plasmacloud_width / 2),
		       dy - (plasmacloud_height / 2),
		       plasmacloud[pt->pt_fuse], plasmatorpColor (pt));
#endif

	clearzone[0][clearcount] = dx - (plasmacloud_width / 2);
	clearzone[1][clearcount] = dy - (plasmacloud_height / 2);
	clearzone[2][clearcount] = plasmacloud_width;
	clearzone[3][clearcount] = plasmacloud_height;
	clearcount++;
      }
      /* needmore: if(pt->pt_war & me->p_team) */
      else if (pt->pt_owner != me->p_no && ((pt->pt_war & me->p_team) ||
	     (players[pt->pt_owner].p_team & (me->p_hostile | me->p_swar))))
      {

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (eplasmacloud_width / 2),
		    dy - (eplasmacloud_height / 2),
		    plasmatorpColor (pt),
		    F_plasmaTorpEnemyChar (), 1, F_smallFont ());
#else
	W_WriteBitmap (dx - (eplasmatorp_width / 2),
		       dy - (eplasmatorp_height / 2),
		       eplasmatorp, plasmatorpColor (pt));
#endif

	clearzone[0][clearcount] = dx - (eplasmatorp_width / 2);
	clearzone[1][clearcount] = dy - (eplasmatorp_height / 2);
	clearzone[2][clearcount] = eplasmatorp_width;
	clearzone[3][clearcount] = eplasmatorp_height;
	clearcount++;
      }
      else
      {

#ifdef FONT_BITMAPS
	W_MaskText (w, dx - (mplasmacloud_width / 2),
		    dy - (mplasmacloud_height / 2),
		    plasmatorpColor (pt),
		    F_plasmaTorpChar (), 1, F_smallFont ());
#else
	W_WriteBitmap (dx - (mplasmatorp_width / 2),
		       dy - (mplasmatorp_height / 2),
		       mplasmatorp, plasmatorpColor (pt));
#endif

	clearzone[0][clearcount] = dx - (mplasmatorp_width / 2);
	clearzone[1][clearcount] = dy - (mplasmatorp_height / 2);
	clearzone[2][clearcount] = mplasmatorp_width;
	clearzone[3][clearcount] = mplasmatorp_height;
	clearcount++;
      }
    }
  }
  
  /* Draw Edges */
  if (my_x < (WINSIDE / 2) * SCALE)
  {
    int             sy, ey;

    dx = (WINSIDE / 2) - (my_x) / SCALE;
    sy = (WINSIDE / 2) + (0 - my_y) / SCALE;
    ey = (WINSIDE / 2) + (GWIDTH - my_y) / SCALE;
    if (sy < 0)
      sy = 0;
    if (ey > WINSIDE - 1)
      ey = WINSIDE - 1;
    W_CacheLine (w, dx, sy, dx, ey, warningColor);
    /*
     * W_MakeLine(w, dx, sy, dx, ey, warningColor);
     */
    clearline[0][clearlcount] = dx;
    clearline[1][clearlcount] = sy;
    clearline[2][clearlcount] = dx;
    clearline[3][clearlcount] = ey;
    clearlcount++;
  }
  
  if ((GWIDTH - my_x) < (WINSIDE / 2) * SCALE)
  {
    int             sy, ey;

    dx = (WINSIDE / 2) + (GWIDTH - my_x) / SCALE;
    sy = (WINSIDE / 2) + (0 - my_y) / SCALE;
    ey = (WINSIDE / 2) + (GWIDTH - my_y) / SCALE;
    if (sy < 0)
      sy = 0;
    if (ey > WINSIDE - 1)
      ey = WINSIDE - 1;
    W_CacheLine (w, dx, sy, dx, ey, warningColor);
    /*
     * W_MakeLine(w, dx, sy, dx, ey, warningColor);
     */
    clearline[0][clearlcount] = dx;
    clearline[1][clearlcount] = sy;
    clearline[2][clearlcount] = dx;
    clearline[3][clearlcount] = ey;
    clearlcount++;
  }
  
  if (my_y < (WINSIDE / 2) * SCALE)
  {
    int             sx, ex;

    dy = (WINSIDE / 2) - (my_y) / SCALE;
    sx = (WINSIDE / 2) + (0 - my_x) / SCALE;
    ex = (WINSIDE / 2) + (GWIDTH - my_x) / SCALE;
    if (sx < 0)
      sx = 0;
    if (ex > WINSIDE - 1)
      ex = WINSIDE - 1;
    W_CacheLine (w, sx, dy, ex, dy, warningColor);
    /*
     * W_MakeLine(w, sx, dy, ex, dy, warningColor);
     */
    clearline[0][clearlcount] = sx;
    clearline[1][clearlcount] = dy;
    clearline[2][clearlcount] = ex;
    clearline[3][clearlcount] = dy;
    clearlcount++;
  }
  
  if ((GWIDTH - my_y) < (WINSIDE / 2) * SCALE)
  {
    int             sx, ex;

    dy = (WINSIDE / 2) + (GWIDTH - my_y) / SCALE;
    sx = (WINSIDE / 2) + (0 - my_x) / SCALE;
    ex = (WINSIDE / 2) + (GWIDTH - my_x) / SCALE;
    if (sx < 0)
      sx = 0;
    if (ex > WINSIDE - 1)
      ex = WINSIDE - 1;
    W_CacheLine (w, sx, dy, ex, dy, warningColor);
    /*
     * W_MakeLine(w, sx, dy, ex, dy, warningColor);
     */
    clearline[0][clearlcount] = sx;
    clearline[1][clearlcount] = dy;
    clearline[2][clearlcount] = ex;
    clearline[3][clearlcount] = dy;
    clearlcount++;
  }
  
  /* Change border color to signify alert status */

  if (oldalert != (me->p_flags & (PFGREEN | PFYELLOW | PFRED)))
  {
    oldalert = (me->p_flags & (PFGREEN | PFYELLOW | PFRED));
    switch (oldalert)
    {
      case PFGREEN:
	if (extraBorder)
	  W_ChangeBorder (w, gColor);
	W_ChangeBorder (baseWin, gColor);
	W_ChangeBorder (iconWin, gColor);
	break;
      case PFYELLOW:
	if (extraBorder)
	  W_ChangeBorder (w, yColor);
	W_ChangeBorder (baseWin, yColor);
	W_ChangeBorder (iconWin, yColor);
	break;
      case PFRED:
	if (extraBorder)
	  W_ChangeBorder (w, rColor);
	W_ChangeBorder (baseWin, rColor);
	W_ChangeBorder (iconWin, rColor);
	break;
    }
  }
  /* show 'lock' icon on local map (Actually an EM hack ) */
  if (showLock & 2)
  {
    int             tri_x = -1, tri_y = -1, facing = 0;
    int             tri_size = 4;
    view = SCALE * WINSIDE / 2;	/** just in case it's changed */
    if (me->p_flags & PFPLOCK)
    {
      /* locked onto a ship */
      j = &players[me->p_playerl];
      if (!(j->p_flags & PFCLOAK))
      {
	dx = j->p_x - my_x;
	dy = j->p_y - my_y;
	if (ABS (dx) < view && ABS (dy) < view)
	{
	  dx = dx / SCALE + WINSIDE / 2;
	  dy = dy / SCALE + WINSIDE / 2;
	  tri_x = dx + 0;
	  tri_y = dy + 20;	/* below ship */
	  facing = 1;
	}
	/* printf("Drawing local triangle at %d %d\n", tri_x, tri_y); */
      }
    }
    else if (me->p_flags & PFPLLOCK)
    {
      /* locked onto a planet */
      struct planet  *l = &planets[me->p_planet];
      dx = l->pl_x - my_x;
      dy = l->pl_y - my_y;
      if (ABS (dx) < view && ABS (dy) < view)
      {
	dx = dx / SCALE + WINSIDE / 2;
	dy = dy / SCALE + WINSIDE / 2;
	tri_x = dx;
	tri_y = dy - 20;	/* below planet */
	facing = 0;
      }
      /* printf("Drawing local triangle at %d %d\n", tri_x, tri_y); */
    }
    if (tri_x != -1)
    {
      W_WriteTriangle (w, tri_x, tri_y, 4, facing, foreColor);
      clearzone[0][clearcount] = tri_x - tri_size - 1;
      clearzone[1][clearcount] = tri_y - 1 +
	(facing ? 0 : -tri_size);
      clearzone[2][clearcount] = tri_size * 2 + 2;
      clearzone[3][clearcount] = tri_size + 2;
      clearcount++;
    }
  }
}

/* map out the 'galactic' map */
map ()
{
  register int    i;
  register struct player *j;
  register struct planet *l;
  register int    dx, dy, odx, ody;
  int             color, pl;

  if (redrawall == 1)
  {
    W_ClearWindow (mapw);
  }
  /* Erase ships */
  else
  {
    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
    {
      lastUpdate[i]++;
      /*
       * Erase the guy if: redrawPlayer[i] is set and the mapmode setting
       * allows it.
       */
      if (!redrawPlayer[i] || (mapmode == 1 && lastUpdate[i] < 5))
	continue;
      lastUpdate[i] = 0;
      /* Clear his old image... */
      if (mclearzone[2][i])
      {
	W_CacheClearArea (mapw, mclearzone[0][i], mclearzone[1][i],
			  mclearzone[2][i], mclearzone[3][i]);
	/* Redraw the hole just left next update */
	checkRedraw (mclearzone[4][i], mclearzone[5][i]);
	mclearzone[2][i] = 0;
      }
    }
    W_FlushClearAreaCache (mapw);
    /* this also clears planet lock triangle */
    if (clearlmcount)
    {
      W_WriteTriangle (mapw, clearlmark[0], clearlmark[1], clearlmark[2],
		       clearlmark[3], backColor);
      clearlmcount = 0;
    }
  }

  /* Draw Planets */
  for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++)
  {
    if (!(l->pl_flags & PLREDRAW) && (!redrawall))
      continue;
    l->pl_flags &= ~PLREDRAW;	/* Turn redraw flag off! */
    dx = l->pl_x * WINSIDE / GWIDTH;
    dy = l->pl_y * WINSIDE / GWIDTH;

    /* moving planets */
    if (pl_update[l->pl_no].plu_update == 1)
    {

      odx = pl_update[l->pl_no].plu_x * WINSIDE / GWIDTH;
      ody = pl_update[l->pl_no].plu_y * WINSIDE / GWIDTH;

      W_ClearArea (mapw, odx - (mplanet_width / 2), ody - (mplanet_height / 2),
		   mplanet_width, mplanet_height);

#ifdef MAP_NAMES
    if (!draw_map_names || show_owner_map)
      if (l->pl_info && l->pl_owner != NOBODY)
	W_WriteBitmap (dx - 10, dy - 10, show_owner_map_bitmaps[l->pl_owner],
		       planetColor (l));

      if (draw_map_names)
#endif

	W_WriteText (mapw, odx - (mplanet_width / 2), ody + (mplanet_height / 2),
		     backColor, l->pl_name, 3, planetFont (l));

      pl_update[l->pl_no].plu_update = 0;
    }
    else if (redrawall == 2 || (l->pl_flags & PLCLEAR))
    {
      W_ClearArea (mapw, dx - (mplanet_width / 2 + 4),
		   dy - (mplanet_height / 2 + 4),
		   mplanet_width + 8, mplanet_height + 8);
      l->pl_flags &= ~PLCLEAR;
    }

#ifdef BEEPLITE
    if (UseLite && emph_planet_seq_n [l->pl_no] > 0)
    {
      int seq_n = emph_planet_seq_n [l->pl_no] % emph_planet_seq_frames;
      
      W_OverlayBitmap (dx - (emph_planet_seq_width/2 + 1), 
		       dy - (emph_planet_seq_height/2),
		       emph_planet_seq [seq_n], 
		       W_White);
      emph_planet_seq_n [l->pl_no] -= 1 ;
      W_WriteBitmap (dx - (mplanet_width/2), dy - (mplanet_height/2),
		     planetmBitmap(l), planetColor(l));
      l->pl_flags |= PLREDRAW ;   /* Leave redraw on until done highlighting */
      l->pl_flags |= PLCLEAR ;   /* Leave redraw on until done highlighting */
    }
    else
    {
      W_OverlayBitmap (dx - (mplanet_width/2), dy - (mplanet_height/2),
		       planetmBitmap(l), planetColor(l));
      l->pl_flags &= ~PLREDRAW;   /* Turn redraw flag off! */
    }
#else
#ifdef FONT_BITMAPS
    W_MaskText (mapw, dx - (mplanet_width / 2), dy - (mplanet_height / 2),
		planetColor (l), F_planetMapChar (l), 1, F_planetMapFont ());
#else
    W_WriteBitmap (dx - (mplanet_width / 2), dy - (mplanet_height / 2),
		   planetmBitmap (l), planetColor (l));
#endif
#endif
    
#ifdef MAP_NAMES
    if (!draw_map_names || show_owner_map)
      if (l->pl_info && l->pl_owner != NOBODY)
	W_WriteBitmap (dx - 10, dy - 10, show_owner_map_bitmaps[l->pl_owner],
		       planetColor (l));

    if (draw_map_names)
#endif

      W_WriteText (mapw, dx - (mplanet_width / 2), dy + (mplanet_height / 2),
		   planetColor (l), l->pl_name, 3, planetFont (l));

#ifdef SHOW_IND
    if (showIND && (l->pl_info & me->p_team) && (l->pl_owner == NOBODY))
    {
      W_MakeLine (mapw, dx + (mplanet_width / 2 - 1), dy + (mplanet_height / 2 - 1),
		  dx - (mplanet_width / 2), dy - (mplanet_height / 2),
		  W_White);
      W_MakeLine (mapw, dx - (mplanet_width / 2), dy + (mplanet_height / 2 - 1),
		  dx + (mplanet_width / 2 - 1), dy - (mplanet_height / 2),
		  W_White);
    }
#endif
  }
  
  /* Draw ships */
  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
  {
    /*
     * We draw the guy if redrawall, or we just erased him. Also, we redraw
     * if we haven't drawn for 30 frames. (in case he was erased by other
     * ships).
     */
    if (lastUpdate[i] != 0 && (!redrawall) &&
    /* people are rarely motionless -- I think it's ok to reduce this */
	lastUpdate[i] < 10)
      continue;
    if (j->p_status != PALIVE)
      continue;
    lastUpdate[i] = 0;
    dx = j->p_x * WINSIDE / GWIDTH;
    dy = j->p_y * WINSIDE / GWIDTH;

    if (j->p_flags & PFCLOAK)
    {

#ifdef CLOAK_CHARS
      W_WriteText (mapw, dx - W_Textwidth,
		   dy - W_Textheight / 2, unColor, cloakChars,
		   (cloakChars[1] == '\0' ? 1 : 2), W_RegularFont);
#else
      W_WriteText (mapw, dx - W_Textwidth,
		   dy - W_Textheight / 2, unColor, "??", 2, W_RegularFont);
#endif
    }
    else
    {
      W_WriteText (mapw, dx - W_Textwidth,
		   dy - W_Textheight / 2, playerColor (j), j->p_mapchars, 2,
		   shipFont (j));
    }

#ifdef BEEPLITE
    if (UseLite && lite_players_map && emph_player_seq_n [i] > 0)
    {
      int seq_n = emph_player_seq_n [i] % emph_player_seq_frames;

      W_WriteBitmap (dx - (emph_player_seq_width/2 - 1), 
		     dy - (emph_player_seq_height/2  + 1),
		     emph_player_seq [seq_n], 
		     W_White);
      emph_player_seq_n [i] -= 1;
      mclearzone[0][i] = dx - (emph_player_seq_width/2 - 1);
      mclearzone[1][i] = dy - (emph_player_seq_height/2 + 1);
      mclearzone[2][i] = emph_player_seq_width;
      mclearzone[3][i] = emph_player_seq_height;
      mclearzone[4][i] = j->p_x;
      mclearzone[5][i] = j->p_y;
      /* Force redraw for this guy no matter what.
       * Even if stationary.
       */
      lastUpdate[i] = 30;
      /* Leave redraw on until done highlighting */
      redrawPlayer[i] = 1;
    }
    else
    {
      mclearzone[0][i] = dx - W_Textwidth;
      mclearzone[1][i] = dy - W_Textheight / 2;
      mclearzone[2][i] = W_Textwidth * 2;
      mclearzone[3][i] = W_Textheight;
      /* Set these so we can checkRedraw() next time */
      mclearzone[4][i] = j->p_x;
      mclearzone[5][i] = j->p_y;
      redrawPlayer[i] = 0;
    }
#else
    mclearzone[0][i] = dx - W_Textwidth;
    mclearzone[1][i] = dy - W_Textheight / 2;
    mclearzone[2][i] = W_Textwidth * 2;
    mclearzone[3][i] = W_Textheight;
    /* Set these so we can checkRedraw() next time */
    mclearzone[4][i] = j->p_x;
    mclearzone[5][i] = j->p_y;
    redrawPlayer[i] = 0;
#endif
  }

  if ((me->p_flags & PFPLOCK) && (showLock & 1))
  {
    j = &players[me->p_playerl];

    if (j->p_status == PALIVE && !(j->p_flags & PFCLOAK))
    {
      dx = j->p_x * WINSIDE / GWIDTH;
      dy = j->p_y * WINSIDE / GWIDTH;
      W_WriteTriangle (mapw, dx, dy + 6, 4, 1, foreColor);

      clearlmark[0] = dx;
      clearlmark[1] = dy + 6;
      clearlmark[2] = 4;
      clearlmark[3] = 1;
      clearlmcount++;
    }
  }
  else if ((me->p_flags & PFPLLOCK) && (showLock & 1))
  {
    struct planet  *l = &planets[me->p_planet];

    dx = l->pl_x * WINSIDE / GWIDTH;
    dy = l->pl_y * WINSIDE / GWIDTH;
    W_WriteTriangle (mapw, dx, dy - (mplanet_height) / 2 - 4, 4, 0, foreColor);

    clearlmark[0] = dx;
    clearlmark[1] = dy - (mplanet_height) / 2 - 4;
    clearlmark[2] = 4;
    clearlmark[3] = 0;
    clearlmcount++;
  }

  redrawall = 0;
}

stline (flag)
  int             flag;
{
  static char     buf1[80];
  register char  *buf = buf1;
  register unsigned int flags = me->p_flags;

  *buf++ = (flags & PFSHIELD ? 'S' : ' ');
  if (me->p_flags & PFGREEN)
    *buf++ = 'G';
  else if (flags & PFYELLOW)
    *buf++ = 'Y';
  else if (flags & PFRED)
    *buf++ = 'R';
  *buf++ = (flags & (PFPLLOCK | PFPLOCK) ? 'L' : ' ');
  *buf++ = (flags & PFREPAIR ? 'R' : ' ');
  *buf++ = (flags & PFBOMB ? 'B' : ' ');
  *buf++ = (flags & PFORBIT ? 'O' : ' ');
  if (me->p_ship.s_type == STARBASE)
    *buf++ = (flags & PFDOCKOK ? 'D' : ' ');
  else
    *buf++ = (flags & PFDOCK ? 'D' : ' ');
  *buf++ = (flags & PFCLOAK ? 'C' : ' ');
  *buf++ = (flags & PFWEP ? 'W' : ' ');
  *buf++ = (flags & PFENG ? 'E' : ' ');
  if (flags & PFPRESS)
    *buf++ = 'P';
  else if (flags & PFTRACT)
    *buf++ = 'T';
  else
    *buf++ = ' ';
  if (flags & PFBEAMUP)
    *buf++ = 'u';
  else if (flags & PFBEAMDOWN)
    *buf++ = 'd';
  else
    *buf++ = ' ';
  *buf++ = (status->tourn) ? 't' : ' ';
  *buf++ = ' ';
  *buf = '0' + ((me->p_speed % 100) / 10);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (me->p_speed % 10);	/* speed */
  *buf++ = ' ';
  *buf++ = ' ';
  *buf = '0' + (me->p_damage / 100);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + ((me->p_damage % 100) / 10);
  if ((*buf == '0') && (me->p_damage < 100))
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (me->p_damage % 10);
  *buf++ = ' ';
  *buf = '0' + (me->p_shield / 100);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + ((me->p_shield % 100) / 10);
  if ((*buf == '0') && (me->p_shield < 100))
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (me->p_shield % 10);
  *buf++ = ' ';
  *buf++ = ' ';
  *buf = '0' + ((me->p_ntorp % 100) / 10);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (me->p_ntorp % 10);
  *buf++ = ' ';
  *buf++ = ' ';
  *buf++ = ' ';
  *buf++ = ' ';
  *buf = '0' + ((int) (me->p_kills / 10));
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (((int) me->p_kills) % 10);
  *buf++ = '.';
  *buf++ = '0' + (((int) (me->p_kills * 10)) % 10);
  *buf++ = '0' + (((int) (me->p_kills * 100)) % 10);
  *buf++ = ' ';
  *buf++ = ' ';
  *buf++ = ' ';
  *buf++ = ' ';
  *buf = '0' + ((me->p_armies % 100) / 10);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (me->p_armies % 10);
  *buf++ = ' ';
  *buf++ = ' ';

  *buf = '0' + (me->p_fuel / 100000);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + ((me->p_fuel % 100000) / 10000);
  if ((*buf == '0') && (me->p_fuel < 100000))
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + ((me->p_fuel % 10000) / 1000);
  if ((*buf == '0') && (me->p_fuel < 10000))
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + ((me->p_fuel % 1000) / 100);
  if ((*buf == '0') && (me->p_fuel < 1000))
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + ((me->p_fuel % 100) / 10);
  if ((*buf == '0') && (me->p_fuel < 100))
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + (me->p_fuel % 10);
  *buf++ = ' ';
  *buf++ = ' ';
  *buf++ = ' ';

  *buf = '0' + ((me->p_wtemp / 10) / 100);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + (((me->p_wtemp / 10) % 100) / 10);
  if ((*buf == '0') && (me->p_wtemp < 1000))
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + ((me->p_wtemp / 10) % 10);

  *buf++ = ' ';
  *buf++ = ' ';
  *buf++ = ' ';

  *buf = '0' + ((me->p_etemp / 10) / 100);
  if (*buf == '0')
    *buf++ = ' ';
  else
    buf++;
  *buf = '0' + (((me->p_etemp / 10) % 100) / 10);
  if ((*buf == '0') && (me->p_etemp < 1000))
    *buf++ = ' ';
  else
    buf++;
  *buf++ = '0' + ((me->p_etemp / 10) % 10);

  W_WriteText (tstatw, 50, 16, textColor, buf1, 64, W_RegularFont);
}

#ifdef MOO
redrawTstats ()
{

#ifdef DASHBOARD
  if (dashboard)
    db_redraw (1);
  else
#endif

  {
    stline (1);			/* This is for refresh.  We redraw player
				 * stats too */
    updateMaxStats (1);		/* <isae> Seperated it */
  }
}

/* update stat window record for max speed, army capacity */
updateMaxStats (redraw)
  int             redraw;
{
  char            buf[BUFSIZ];
  static int      lastdamage = -1;
  static int      lastkills = -1;
  static int      lastship = -1;
  int             maxspeed;
  int             troop_capacity;
  int             mykills = (int) (10. * me->p_kills);

  /* don't really need a update if nothing's changed! */
  if (!redraw && lastkills == mykills && lastship == me->p_ship.s_type &&
      lastdamage == me->p_damage)
    return;

  lastkills = (int) (10. * me->p_kills);
  lastdamage = me->p_damage;
  lastship = me->p_ship.s_type;

  if (me->p_ship.s_type == ASSAULT)
    troop_capacity = (((me->p_kills * 3) > me->p_ship.s_maxarmies) ?
		      me->p_ship.s_maxarmies : (int) (me->p_kills * 3));
  else if (me->p_ship.s_type != STARBASE)
    troop_capacity = (((me->p_kills * 2) > me->p_ship.s_maxarmies) ?
		      me->p_ship.s_maxarmies : (int) (me->p_kills * 2));
  else
    troop_capacity = me->p_ship.s_maxarmies;

  maxspeed = (me->p_ship.s_maxspeed + 2) -
    (me->p_ship.s_maxspeed + 1) *
    ((float) me->p_damage / (float) (me->p_ship.s_maxdamage));
  if (maxspeed > me->p_ship.s_maxspeed)
    maxspeed = me->p_ship.s_maxspeed;
  if (maxspeed < 0)
    maxspeed = 0;


  if (tclock)
    strcpy (buf, "Flags        Warp Dam Shd Torps  Kills Armies   Fuel  Wtemp Etemp  Time");
  else
    strcpy (buf, "Flags        Warp Dam Shd Torps  Kills Armies   Fuel  Wtemp Etemp");

  W_WriteText (tstatw, 50, 5, textColor, buf, strlen (buf), W_RegularFont);

#ifdef NO_SPRINTF
#define SPACE	"                                                    "
  {
    extern char    *itoa ();
    register char  *s = buf;
    strncpy (s, "Maximum:   ", 11);
    s += 11;
    s = itoa (s, maxspeed, 2, 1);
    *s++ = '/';
    s = itoa (s, me->p_ship.s_maxspeed, 2, 1);
    *s++ = ' ';
    *s++ = ' ';
    s = itoa (s, me->p_ship.s_maxdamage, 3, 1);
    *s++ = ' ';
    s = itoa (s, me->p_ship.s_maxshield, 3, 1);
    strncpy (s, SPACE, 14);
    s += 14;
    s = itoa (s, troop_capacity, 2, 1);
    *s++ = '/';
    s = itoa (s, me->p_ship.s_maxarmies, 2, 1);
    *s++ = ' ';
    *s++ = ' ';
    *s++ = ' ';
    s = itoa (s, me->p_ship.s_maxfuel, 6, 1);
    *s++ = ' ';
    *s++ = ' ';
    *s++ = ' ';
    s = itoa (s, me->p_ship.s_maxwpntemp / 10, 3, 1);
    *s++ = ' ';
    *s++ = ' ';
    *s++ = ' ';
    s = itoa (s, me->p_ship.s_maxegntemp / 10, 3, 1);
    *s++ = '\0';
  }
#else
  sprintf (buf,
	"Maximum:   %2d/%2d  %3d %3d              %2d/%2d  %6d   %3d   %3d",
	   maxspeed, me->p_ship.s_maxspeed,
	   me->p_ship.s_maxdamage, me->p_ship.s_maxshield,
	   troop_capacity, me->p_ship.s_maxarmies,
	   me->p_ship.s_maxfuel, me->p_ship.s_maxwpntemp / 10,
	   me->p_ship.s_maxegntemp / 10);
#endif

  W_WriteText (tstatw, 50, 27, textColor, buf, strlen (buf), W_RegularFont);
}

#else				/* MOO */
redrawTstats ()
{
  char            buf[BUFSIZ];

  /*
   * W_ClearWindow(tstatw);
   */
  stline (1);			/* This is for refresh.  We redraw player
				 * stats too */
  sprintf (buf,
       "Flags        Warp Dam Shd Torps  Kills Armies   Fuel  Wtemp Etemp");
  W_WriteText (tstatw, 50, 5, textColor, buf, strlen (buf), W_RegularFont);
  sprintf (buf,
	   "Maximum:      %2d  %3d %3d               %3d   %6d   %3d   %3d",
	   me->p_ship.s_maxspeed, me->p_ship.s_maxdamage,
	   me->p_ship.s_maxshield, me->p_ship.s_maxarmies,
	   me->p_ship.s_maxfuel, me->p_ship.s_maxwpntemp / 10,
	   me->p_ship.s_maxegntemp / 10);
  W_WriteText (tstatw, 50, 27, textColor, buf, strlen (buf), W_RegularFont);
}

#endif				/* MOO */



#ifdef FOR_MORONS
/* a cached realNumShips */
RealNumShips (owner)
{
  int             i, num = 0;
  struct player  *p;
  static          numonteam[ALLTEAM];	/* 'cached' data */

  /* just clear cached data. Useful for when updated */
  if (owner == -1)
  {
    for (i = 0; i < ALLTEAM; i++)
      numonteam[i] = -1;
    return (-1);
  }
  if (numonteam[owner] != -1)
    return (numonteam[owner]);

  for (i = 0, p = players; i < MAXPLAYER; i++, p++)
    if (p->p_status != PFREE &&
	p->p_team == owner)
      num++;

  numonteam[owner] = num;
  return (num);
}

#endif

/*
 * buf -- string space n   -- number w   -- field width
 * 
 * sp = 0, no space (lj) sp = 1, space    (rj) sp = 2, 0 instead of space.
 */

char           *
                itoa (buf, n, w, sp)
  char           *buf;
  int             n;
  int             w, sp;
{
  register char  *s = buf;

  if (w > 4)
  {
    *s = '0' + n / 10000;
    if (*s != '0' || sp == 2)
      s++;
    else if (sp == 1)
      *s++ = ' ';
  }
  if (w > 3)
  {
    *s = '0' + (n % 10000) / 1000;
    if (*s != '0' || n >= 10000 || sp == 2)
      s++;
    else if (*s == '0' && sp)
      *s++ = ' ';
  }
  if (w > 2)
  {
    *s = '0' + (n % 1000) / 100;
    if (*s != '0' || n >= 1000 || sp == 2)
      s++;
    else if (*s == '0' && sp)
      *s++ = ' ';
  }
  if (w > 1)
  {
    *s = '0' + (n % 100) / 10;
    if (*s != '0' || n >= 100 || sp == 2)
      s++;
    else if (*s == '0' && sp)
      *s++ = ' ';
  }
  *s = '0' + (n % 10);

  return ++s;
}

/* s1 NOT NULL TERMINATED */
char           *
                strcpy_return (s1, s2)

  register
  char           *s1, *s2;
{
  while (*s2)
    *s1++ = *s2++;
  return s1;
}

char           *
                strcpyp_return (s1, s2, length)

  register
  char           *s1, *s2;
  register
  int             length;
{
  while (length && *s2)
  {
    *s1++ = *s2++;
    length--;
  }
  if (length > 0)
  {
    while (length--)
      *s1++ = ' ';
  }
  return s1;
}

char           *
                itof42 (s, f)

  char           *s;
  float           f;
{
  *s = '0' + (int) f / 1000;
  if (*s == '0')
    *s = ' ';
  *++s = '0' + ((int) f % 1000) / 100;
  if (*s == '0' && (int) f < 1000)
    *s = ' ';
  *++s = '0' + ((int) f % 100) / 10;
  if (*s == '0' && (int) f < 100)
    *s = ' ';
  *++s = '0' + ((int) f % 10);
  *++s = '.';
  *++s = '0' + ((int) (f * 10)) % 10;
  *++s = '0' + ((int) (f * 100)) % 10;

  return ++s;
}

char           *
                itof22 (s, f)

  char           *s;
  float           f;
{
  *s = '0' + ((int) f % 1000) / 100;
  if (*s == '0')
    *s = ' ';
  *++s = '0' + ((int) f % 100) / 10;
  if (*s == '0' && (int) f < 100)
    *s = ' ';
  *++s = '0' + ((int) f % 10);
  *++s = '.';
  *++s = '0' + ((int) (f * 10)) % 10;
  *++s = '0' + ((int) (f * 100)) % 10;

  return ++s;
}

/*
 * Why go to this trouble?  Because it seems to be a waste of X overhead to
 * redraw the entire map just because an info window -- used very frequently
 * by players -- was popped down.
 */

/* borrowed from planets.c: */
#define DETAIL 40		/* Size of redraw array */
#define SIZE	(GWIDTH/DETAIL)

#define BoxXBox(xl1, yu1, xr1, yd1, xl2, yu2, xr2, yd2) \
                                \
      (!(                       \
         ( xr1 <= xl2)  ||      \
         ( xl1 >= xr2)  ||      \
         ( yd1 <= yu2)  ||      \
         ( yu1 >= yd2)))


setup_redraw_map (xl, yu, xr, yd)

  register int    xl, yu, xr, yd;
{
  if (redrawall)
    return;

  if (xr - xl > WINSIDE / 2 && yd - yu > WINSIDE / 2)
  {
    redrawall = 2;
    return;
  }
  else
  {
    register        i, k, l, x, y;
    register struct player *j;

    xl *= (GWIDTH / WINSIDE);
    yu *= (GWIDTH / WINSIDE);
    xr *= (GWIDTH / WINSIDE);
    yd *= (GWIDTH / WINSIDE);

    for (i = xl; i < xr; i += SIZE)
    {
      for (k = yu; k < yd; k += SIZE)
      {
	checkRedraw (i, k);	/* borrowing from planets.c */
      }
    }
    k = (W_Textwidth) * (GWIDTH / WINSIDE);
    l = (W_Textheight / 2) * (GWIDTH / WINSIDE);

    for (i = 0, j = players; i < MAXPLAYER; i++, j++)
    {
      if (j->p_status != PALIVE)
	continue;

      x = j->p_x;
      y = j->p_y;

      if (BoxXBox (x - k, y - l, x + k, y + l, xl, yu, xr, yd))
      {
	redrawPlayer[i] = 1;
      }
    }
  }
}
