################################################################################
##  A Tk interface to YART LookatCamera.                                      ##  
##  LAST EDIT: Thu Aug  4 10:11:38 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1993 - 1995 YART team                                        ##
################################################################################

IOM_CmpTopBox ?

Tcl_Object IOM_CameraBox IOM_CmpTopBox {xcurrentCamera xScales} {Name} {String} {
Creates a new camera interface.
} {
    global IOM_DIR
    $THIS -buildCameraLabel
    wm title [set $THIS->tkTop] "IOM.camera"
    wm minsize  [set $THIS->tkTop] 200 300
    wm maxsize  [set $THIS->tkTop] 1024 768
    
    $THIS -addScale near Near.xbm -get_znear -znear 0.1 200.0
    $THIS -addScale far  Far.xbm  -get_zfar  -zfar  0.1 200.0
    $THIS -addScale angle  Angle.xbm  -get_angle  -angle  1.0 179.0
    $THIS -addScale radius Radius.xbm -get_radius -radius 0.1 100.0
    $THIS -addScale twist  Twist.xbm  -get_twist  -twist  0.0 360.0

    set path [set $THIS->frCenter]
    $path configure -border 5

    $THIS -addMenuSeparator help	
    $THIS -addMenuEntry help "LookatCamera" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage LookatCamera"	
}

Tcl_Method IOM_CameraBox ~IOM_CameraBox {} {} {Destroy the object and his part objects.} {
    foreach scale [set $THIS->xScales] {delete $scale}
}

Tcl_Method IOM_CameraBox -addScale {Name Bitmap getCmd setCmd bMin bMax} {String String String String Double Double} {!! internal Method !! \n\n Add a new {ARG 1 Scale} with the {ARG 2 Bitmap} the {ARG 3 setCmd} and the {ARG 4 getCmd}. The border values of the scale are {ARG 5 bMin} and {ARG 6 bMax}. } {
    global IOM_DIR
    
    set path [set $THIS->frCenter]

    # replace the . at the begin of path:
    set base [string range $path 1 end]
    
    IOM_EScale $base.$Name
    $base.$Name -packT
    $base.$Name -sborder
    lappend $THIS->xScales $base.$Name
    $base.$Name -bitmap @$IOM_DIR/bitmaps/$Bitmap
	
    if [string match -radius $setCmd] {
	# special method:
	$base.$Name -setCommand "$THIS -radius"
    } {
	# camera method:
	$base.$Name -setCommand "$THIS -callCamera $setCmd"
    }

    if [string match -get_radius $getCmd] {
	# special method: 
	$base.$Name -getCommand "$THIS -get_radius"
    } {
	# camera method:
	$base.$Name -getCommand "$THIS -callCamera $getCmd"
    }

    $base.$Name -setBorder   $bMin $bMax
    
    # if xautoUpdate call the update method of the scale 
    # and this method call the $setCmd
    # this command string is set to the updateCMD of the scale (from frame class)
    # and will be called after each change of the value.
    
    # build the command:
    set cmd [format {if {[set %s->xautoUpdate]} {%s -update; %s -callCBs} } \
	    $THIS $base.$Name $THIS]
    
    # set the command:
    $base.$Name -updateCMD $cmd
}

Tcl_Method IOM_CameraBox -update {} {} {Send the widget data to the camera object.} {
    foreach scale [set $THIS->xScales] {
	$scale -update
    }
}

Tcl_Method IOM_CameraBox -rescan {} {} {Update the data representation of the widgets.} {
    foreach scale [set $THIS->xScales] {$scale -rescan}
}

# now some methods to handle the camera object
Tcl_Method IOM_CameraBox -buildCameraLabel {} {} {Build the label widget to the current camera variable of this box } {
    set top [set $THIS->frTop] 
    label $top.object1 -text "Camera:" -anchor e
    label $top.object2 -textvariable $THIS->xcurrentCamera -anchor w
    pack append $top \
	    $top.object1  {expand left fill} \
	    $top.object2  {expand right fill}
    
}

Tcl_Method IOM_CameraBox  -currentCamera {Name} {String}  {Set the current Camera.} {
    if [string compare [set $THIS->xcurrentCamera] $Name] {
	set $THIS->xcurrentCamera $Name
	$THIS -rescan
    }
}

Tcl_Method IOM_CameraBox  -get_currentCamera {} {}  {Get the current Camera.} { 
    return [set $THIS->xcurrentCamera]
}

Tcl_Method IOM_CameraBox -callCamera {} {}  {If there is a current Camera, the arguments of callCamera will send to this Camera.} { 
    if [string length [set $THIS->xcurrentCamera]] {
	if $argc {
	    eval  "[set $THIS->xcurrentCamera] $argv"
	}
    }
}

Tcl_Method IOM_CameraBox -radius rad Double {Set a new {ARG 1 Z} Value in the cameras viewpoint. All other values are assumed to be zero, also the reference point.} {
    if [string length [set $THIS->xcurrentCamera]] {
	set cam [set $THIS->xcurrentCamera]
	set vp [$cam -get_viewpoint]
	set nvp "[lindex $vp 0] [lindex $vp 1] $rad"
	$cam -viewpoint $nvp
    }
}

Tcl_Method IOM_CameraBox -get_radius {} {} {Return the current z coordinate of the cameras viewpoint.} {
    if [string length [set $THIS->xcurrentCamera]] {
	return [lindex [[set $THIS->xcurrentCamera] -get_viewpoint] 2]
    }
    return 0
}

IOM_CameraBox -description {An interface to the YART lookat camera class.}

IOM_CameraBox -keywords {IOM UserInterface}

