################################################################################
##  A tree-oriented dialog for indirect interactions with the primitives.     ##  
##  LAST EDIT: Thu Aug  4 11:17:33 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_InterfaceWidget ?

Tcl_Object IOM_Tree IOM_InterfaceWidget {canvas tree nodePopup objectTree nodeSelectionMode selectionList} {Name} {String } \
	{Creates a new tree widget called {ARG 1 Name}.} \
	{
    #set the wPath,canvas,tree to local variables
    set wPath [set $THIS->frCenter]
    $wPath configure -border 4
    set canvas $wPath.canvas
    set $THIS->canvas $canvas
    set tree $canvas.tree
    set $THIS->tree $tree

    # create the canvas widget and 2 scrollbars
    new_canvas  $canvas
    $canvas configure -bg gray80
    $canvas configure -selectbackground yellow -selectforeground black
    
    tree_create $tree \
	"$THIS -textProc $tree" \
	"$THIS -bitmapProc $tree"\
	$canvas.nodePopup
    
    $THIS -scanTopObjects
    $THIS -createPopup
    
    # handle the selection modes for the current object
    set $THIS->nodeSelectionMode selectIfItIsPreseent
}

Tcl_Method IOM_Tree  -createPopup {} {} {Build the popup over the tree widget} {
    #set the wPath,canvas,tree to local variables
    set wPath [set $THIS->frCenter]
    set canvas [set $THIS->canvas]
    set tree  [set $THIS->tree]
    
    # create the popup menu for the object nodes
    set $THIS->nodePopup [menu $canvas.nodePopup]

    # set the attribute menu
    $canvas.nodePopup add cascade -label "set attribute" \
	    -menu $canvas.nodePopup.setAttribute \
	    -command "popup_cascademenu_bindings [set $THIS->canvas] \
	    $canvas.nodePopup.setAttribute"
    
    menu $canvas.nodePopup.setAttribute

    # the attribute actions
    $canvas.nodePopup.setAttribute add command -label Surface  \
	    -command "$THIS -buildInterfaceDevice IOM_SurfaceBox surface"
    $canvas.nodePopup.setAttribute add command -label Resolution  \
	    -command "$THIS -buildInterfaceDevice IOM_ResolutionBox resolution"
    $canvas.nodePopup.setAttribute add command -label Fillstyle \
	    -command "$THIS -buildInterfaceDevice IOM_FillstyleBox fillstyle"
    
    # the clear attribute menu
    $canvas.nodePopup add cascade -label "clear attribute" \
	    -menu $canvas.nodePopup.clearAttribute \
	    -command "popup_cascademenu_bindings [set $THIS->canvas] \
	    $canvas.nodePopup.clearAttribute"
    
    menu $canvas.nodePopup.clearAttribute

    # the attribute actions
    $canvas.nodePopup.clearAttribute add command -label Surface  \
	    -command "$THIS -callObject -attrClear Surface"
    $canvas.nodePopup.clearAttribute add command -label Resolution \
	    -command "$THIS -callObject -attrClear Resolution"
    $canvas.nodePopup.clearAttribute add command -label Fillstyle \
	    -command "$THIS -callObject -attrClear Fillstyle"

    # the father command
    $canvas.nodePopup add command -label "set father" \
	-command "$THIS -setFather"

    # the delete command
    $canvas.nodePopup add command -label "delete" \
	-command "$THIS -deleteSelectedObject"
}

Tcl_Method IOM_Tree  -addNode {Parent Name} {String String} {Add an object node with the {ARG 2 Name} an the {ARG 1 Parent} to the canvas widget tree} {
    set tree [set $THIS->tree]
    global env
    set class [$Name -get_class]
    
    if [file exist $env(GOOD_ROOT_DIR)/IOM/bitmaps/$class.xbm] {
	set bitmap $env(GOOD_ROOT_DIR)/IOM/bitmaps/$class.xbm
    } {
	set bitmap $env(GOOD_ROOT_DIR)/IOM/bitmaps/Node.xbm
    }
    tree_addNode $tree   $Parent $Name  $bitmap
}

Tcl_Method IOM_Tree  -scanTopObjects {} {}  {Scan the top objects.} {
    #set the wPath,canvas,tree to local variables
    set tree  [set $THIS->tree]

    # clear the old tree
    $tree prun ""
    
    # build the ObjectTree
    foreach obj [$THIS -call RT_primitives] {
	if {{}==[$THIS -call $obj -get_father]} {
	    $THIS -addNode "" $obj 
	}
    }
    $tree draw
    tkwait visibility [set $THIS->canvas]
    tree_center $tree
}

Tcl_Method IOM_Tree -buildCompleteTree {} {}  {Scan the complete object tree.} {
    #set the canvas,tree to local variables
    set tree  [set $THIS->tree]
    set canvas [set $THIS->canvas]
    
    # clear the old tree
    $tree prun ""
    
    # build the ObjectTree
    set list [buildPrLst]
    
    # the proc draw tree with an obj and the list of the children
    proc __draw__tree {tree parent obj clds} {
	$tree -addNode $parent $obj
	foreach cld $clds {
	    __draw__tree $tree $obj "[lindex $cld 0]" "[lindex $cld 1]"
	}
    }
    
    foreach obj $list {
	__draw__tree $THIS "" "[lindex $obj 0]" "[lindex $obj 1]"
    }
    
    rename __draw__tree ""

    $tree draw
    tkwait visibility [set $THIS->canvas]
    tree_center $tree
    
    # Now select the current object if it is in the tree
    set cObj [set $THIS->xcurrentObject]
    if "[string length $cObj] && [string length [$canvas gettags $cObj:bitmap]]" {
	tree_deSelectBitmap $tree
	tree_selectNodeBitmap $tree $cObj
	
    }
}

Tcl_Method IOM_Tree -textProc {} {} {The callback procedure called when the text of a node is double-clicked} {
    global env
    set tree [set $THIS->tree]
    set obj  [tree_getCurrent $tree]
    
    if [$tree isleaf $obj] {
	foreach cld [$THIS -call $obj -get_children] {
	    $THIS -addNode $obj $cld
	}
        $tree draw
    } {
	$tree prune $obj
    }
}

Tcl_Method IOM_Tree -bitmapProc {} {} {The call-back called when bitmap of a node is double-clicked} {
    global env
    set tree [set $THIS->tree]
    set obj  [tree_getCurrent $tree]
    
    if [$tree isroot $obj] {
	if [string length [set father [$obj -get_father]]] {
	    # the object has a parent
	    $THIS -addNode "" $father
	    foreach cld [$father -get_children] {
		if {"$cld" == "$obj" } {
		    $tree movelink $obj $father
		} {
		    $THIS -addNode $father $cld
		}
	    }
	} {
	    foreach cld [$THIS -call RT_primitives] {
		if {"$cld" == "$obj" } {
		    $tree movelink $obj $father
		} {
		    $THIS -addNode $father $cld
		}
	    }
	}
    } {
	$tree root $obj
    }
    $tree draw
}

Tcl_Method IOM_Tree -bind {} {} {Make the bindings to the tree nodes} {
    set tree [set $THIS->tree]
    set canvas [set $THIS->canvas]
    set menu   [set $THIS->nodePopup]
    
    # set the default bindings of the tree widget from tree.tcl
    tree_set_default_bindings $tree
    
    set action "tree_selectBitmap $tree; \
	    $THIS -currentObject \[tree_getCurrent $tree\];\
	    set $THIS->selectionList \[tree_getCurrent $tree\]"
    
    # rebind the button 1 action
    $canvas bind text <1> $action
    $canvas bind bitmap <1> $action
    
    set shift_action "tree_selectNextBitmap $tree; \
	    $THIS -currentObject \[tree_getCurrent $tree\];\
	    lappend $THIS->selectionList \[tree_getCurrent $tree\]"
    
    $canvas bind text   <Shift-Button-1> $shift_action
    $canvas bind bitmap <Shift-Button-1> $shift_action
    
    # now bind the mark action to the nodes
    set control_action "tree_markBitmap $tree; "
    $canvas bind text    <Control-Button-1> $control_action
    $canvas bind bitmap  <Control-Button-1> $control_action
    
    $canvas bind all <Control-Button-1> "tree_deMarkBitmap $tree"
    $canvas bind all <1> "tree_deSelectBitmap $tree"

    # make the the popup bindings to the canvas
    #popup_to_canvas $canvas text $menu $text_action
    #popup_to_canvas $canvas bitmap $menu $bitmap_action
    
    popup_to_canvas $canvas all $menu
    popup_to_canvas $canvas text $menu
    popup_to_canvas $canvas bitmap $menu
}

Tcl_Method IOM_Tree  -setFather {} {}  {Set the father to the selected object.} {
    set tree [set $THIS->tree]
    set canvas [set $THIS->canvas]
    set parent [lindex [$canvas gettags marked] 0]
    set parentTree [$tree ancestors $parent]
    
    set selectedObjs [$THIS -get_selectedObjects]
    set objs {}
    
    foreach obj $selectedObjs {
	if {-1==[lsearch "$parentTree" "$obj"] && "$obj"!="$parent"}  {
	    lappend objs $obj
	} {
	    global IOM_userInterfaceMode
	    if $IOM_userInterfaceMode<2 {
		AlertBox "Sorry, cannot set the parent $parent to the object $obj!"\
			"" "300x40" Ok
		return
	    }
	}
    }
    
    if ![llength $objs] return

    global IOM_userInterfaceMode
    if $IOM_userInterfaceMode==0 {
	set ret [AlertBox "Set the father of the object(s) \n $objs \
		to \"$parent\" !" "" "" "Set a new parent!"  YES NO  ]
    } { set ret 0}
    if !$ret {
	# The list of \ before the \{ is necessary
	# to catch the nested calls of eval
	foreach obj $objs {
	    if [check_exec "$THIS -call $obj -father \\\\\{$parent\\\\\} "] {
		if [catch "$tree movelink $obj {$parent} "] {
		    $tree rmlink $obj
		}
	    }
	}
	$tree draw
	$THIS -update
    }
}

Tcl_Method IOM_Tree  -deleteAttributeOfSelected {Attribute} {String}  {Delete the attribute with the name {ARG 1 Attribute.} on all selected objects.} {
    set objs [$THIS -get_selectedObjects]
    if ![llength $objs] return

    global IOM_userInterfaceMode
    if $IOM_userInterfaceMode<2 {
	set ret [AlertBox "You will delete the $Attribute of the object(s) \n $objs!" "" "" "Delete attributes!"  YES NO  ]
    } { # dont ask set yes
	set ret 0
    }
    if !$ret {
	foreach obj $objs {
	    $THIS -call $obj -attrClear $Attribute
	}
	$THIS -update
    }
}

Tcl_Method IOM_Tree  -deleteSelectedObject {} {}  {Delete the current object.} {
    global IOM_userInterfaceMode
    set nodes [$THIS -get_selectedObjects]
    set objs {}
    foreach node $nodes {
	    lappend objs $node
    }
    # if the IOM_userInterfaceMode > 0 the ask for all objects
    if $IOM_userInterfaceMode>0 {
	if [AlertBox "You want to delete object(s) \n $objs ?" \
		"" "" "Delete objects!"  YES NO  ] return
    }
    
    for {set i 0} "\$i<[llength $nodes]" {incr i} {
	set obj [lindex $objs $i]
	if {"$obj"==".i"} continue
	# don't allow deleting the root object
	
	set node [lindex $nodes $i]
	if $IOM_userInterfaceMode==0 {
	    # if the IOM_userInterfaceMode = 0 the ask for each object
	    set ret [AlertBox "Do you really want to delete object $obj ?"\
		    "" "200x90" "Delete Objects" Yes No ]
	} { set ret 0 }
	if !$ret {
	    # TODO: Implement some functionality to inform the
	    # manipulator object, if the current object is deleted.
	    #
	    # This is a dirty way to solve the manipulator problem.
	    
	    # 1. set the current object to top
	    if {"[info commands .i]"==".i"} {
		$THIS -currentObject .i;
	    } { $THIS -currentObject "";
	    }
	    # 2. remove the link in the tree
	    catch "[set $THIS->tree] rmlink $node"
	    
	    # 3. delete the object
	    $THIS -call delete $obj;
	}
    }
    [set $THIS->tree] draw
}

Tcl_Method IOM_Tree -selectCurrentObject {} {} {Select the currentObject in the tree.} {
    set tree   [set $THIS->tree]
    set canvas [set $THIS->canvas]
    set cObj   [set $THIS->xcurrentObject]

    # do noting if the currentObject is selected
    if {"$cObj"=="[tree_getCurrent $tree]"} return

    # check the mode in which you must update the tree
    set mode [set $THIS->nodeSelectionMode]
    case $mode in {
	{showTreeToSelected showCompleteTreeToSelected} {
	    #build a full tree to the current object an his children
	    
	    # build the list of the tree objects
	    set obj $cObj
	    set objList $obj
	    while {[string length [set father [$obj -get_father]]]} {
		set objList "$father $objList"
		set obj $father
	    }
	    # now build the tree
	    set parent [lindex $objList 0]
	    $THIS -addNode "" $parent
	    set objList [lrange $objList 1 end]
	    
	    while {[string length $parent]} {
		if {"$mode"=="showCompleteTreeToSelected"} {
		    # build the children of the parent object
		    foreach cld [$THIS -call $parent -get_children] {
			$THIS -addNode $parent $cld
		    }
		} {
		    # build only the object in the list
		    if [llength  $objList] {
			$THIS -addNode $parent  [lindex $objList 0] 
		    }
		}
		set parent [lindex $objList 0]
		set objList [lrange $objList 1 end]
	    }
	    $tree draw
	}
	{showNearowOfSelected} {
	    # clear the old tree
	    $tree prun ""
	    
	    # build the tree to the father object
	    set obj $cObj
	    if [string length [set father [$THIS -call \
		    $obj -get_father]]] {
		$THIS -addNode "" $father
	    }
	    # build the curent object an his sitings
	    foreach cld [$THIS -call $father -get_children] {
		$THIS -addNode $father $cld
	    }
	    # build the children of the current object
	    foreach cld [$THIS -call $cObj -get_children] {
		$THIS -addNode $cObj $cld
	    }
	    $tree draw
	}
    }

    # Now select the current object if it is in the tree
    if "[string length $cObj] && [string length [$canvas gettags $cObj:bitmap]]" {
	tree_deSelectBitmap $tree
	tree_selectNodeBitmap $tree $cObj
    }
}

Tcl_Method IOM_Tree -update {} {} {Update the tree widget} {
    $THIS -selectCurrentObject
}

Tcl_Method IOM_Tree -toggleLayout {} {} \
	{ Toggle the layout of the tree between vertical and horizontal} {
    tree_toggleLayout [set $THIS->tree]
}

Tcl_Method IOM_Tree -get_selectedObjects {} {} {\
	Get the current selected objects.} {
    set canvas [set $THIS->canvas]
    set ids [$canvas find withtag selected]
    set objs {}
    foreach id $ids {
	lappend objs [lindex [$canvas gettags $id] 0]
    }
    return $objs
}

Tcl_Method IOM_Tree -getNodeList {} {} {Return the list of all nodes in the tree} {
    set canvas [set $THIS->canvas]
    set list [$canvas find all]
    set nodes {}
    foreach id $list {
	if {"[lindex [set tags [$canvas gettags $id] ] 1]"=="bitmap"} {
	    lappend nodes [lindex $tags 0]
	}
    }
    return $nodes
}

Tcl_Method IOM_Tree -selectNodesWithAttribute Attribute String {Select each node who define the {ARG 1 Attribute}.} {
    # get the tree widget name:
    set tree [set $THIS->tree]
    tree_deSelectBitmap $tree
    
    # get the nodes in the tree:
    set nodeList [$THIS -getNodeList]
    
    # check the attributes of the nodes and select them:
    foreach node $nodeList {
	set attrList [$node -get_attrList]
	foreach attr $attrList {
	    if {"$Attribute"==[lindex $attr 0]} {
		tree_selectNodeBitmap $tree $node
	    }
	}
    }
}

Tcl_Method IOM_Tree -setBitmapColor {Node Color} {String Color} {Set the color of the {ARG 1 Node} bitmap to the rgb {ARG 2 Color} value.} {
    set canvas [set $THIS->canvas]
    
    set r [format %3.0f [expr [lindex $Color 0]*255]]
    set g [format %3.0f [expr [lindex $Color 1]*255]]
    set b [format %3.0f [expr [lindex $Color 2]*255]]
    
    if [expr $r+$g+$b]<300 {set fgColor white} {set fgColor black}
    set bgColor [format #%02x%02x%02x $r $g $b]
    
    $canvas itemconfig $Node:bitmap \
	    -background $bgColor\
	    -foreground $fgColor
}

Tcl_Method IOM_Tree -resetBitmapColor {} {} {Reset the bitmap color values.} {
    set canvas [set $THIS->canvas]
    $canvas itemconfig bitmap \
	    -background [utilGetConfigValue $canvas -background]\
	    -foreground black
    $canvas itemconfig selected \
	    -background yellow
    $canvas itemconfig marked \
	    -background red
}

Tcl_Method IOM_Tree -setBitmapColorToDiffuseValue {} {} {Set the color of the bitmap to the color value of the diffuse color.} {
    # get the tree widget name:
    set tree [set $THIS->tree]

    # get the nodes in the tree:
    set nodeList [$THIS -getNodeList]
    
    # check the color of the nodes:
    foreach node $nodeList {
	set color [$THIS -call $node -get_diffuse] 
	$THIS -setBitmapColor $node $color
    }
}

Tcl_Method IOM_Tree -setBitmapColorToSpecularValue {} {} {Set the color of the bitmap to the color value of the specular color.} {
    
    # get the tree widget name:
    set tree [set $THIS->tree]
    
    # get the nodes in the tree:
    set nodeList [$THIS -getNodeList]
    
    # check the color of the nodes:
    foreach node $nodeList {
	set color [$THIS -call $node -get_specular] 
	$THIS -setBitmapColor $node $color
    }
}

Tcl_Method IOM_Tree -setBitmapColorToEmissionValue {} {} {Set the color of the bitmap to the color value of the emission color.} {
    
    # get the tree widget name:
    set tree [set $THIS->tree]

    # get the nodes in the tree:
    set nodeList [$THIS -getNodeList]

    # check the color of the nodes:
    foreach node $nodeList {
	set color [$THIS -call $node -get_emission] 
	$THIS -setBitmapColor $node $color
    }
}

IOM_Tree -description {Interface for the trees of YART primitives. Primitives may be selected by menu or left mouse button. Pressing additionally the Shift key is useful to select more than one primitive. An optional parent primitive may be selected with left mouse button and pressing the Control key. Result will be a red-marked primitive. The primitive .i is a pre-defined root primitive and is inserted into the global scene iom_Scene. Primitives that are children of .i are automatically visible. The user may define other root primitives, but have to insert these into the iom_Scene.}

IOM_Tree -keywords {IOM UserInterface Graph Tree}





