################################################################################
##  A rot move and scale button box.                                          ##  
##  LAST EDIT: Thu Aug  4 13:15:42 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

###########################################################################
# help procedure: blb
#
# define "-" button, label and "+" button
#
# args: name title mCMD pCMD
# 
###########################################################################

proc blb {name title mCMD pCMD} {
    set path [sframe $name]
    button $path.ml -text "-" -command "$mCMD" -relief flat -border 1 -width 4
    label  $path.la -text $title -relief flat -border 1
    button $path.pl -text "+" -command $pCMD -relief flat -border 1 -width 4
    pack append $path \
	$path.ml {left fill} $path.la {left fill expand} $path.pl {left fill}
}


###########################################################################
# build a x y z button box
###########################################################################

# getCmd is a command witch returns the value of the manipulated object
# setCmd set the value of the manipulated object
# 
# the value is in vector format: {x y z}

proc xyzButtonBox {name titel setCMD {dir top} {label_width  0}} {
    set path [boxframe $name $dir] 
    
    label $path.label -text "$titel" -width $label_width 
    pack append $path $path.label {expand fill}

    set buttonFrame [lowframe $path.buttons]
    pack append $path $path.buttons {expand fill}
    blb $buttonFrame.x x "$setCMD { -0.1 0 0 }" "$setCMD { 0.1 0 0 }"  
    blb $buttonFrame.y y "$setCMD { 0 -0.1 0 }" "$setCMD { 0 0.1 0 }"  
    blb $buttonFrame.z z "$setCMD { 0 0 -0.1 }" "$setCMD { 0 0 0.1 }"  
}    

################################################
#
# define a enum manipulator button
#
################################################
# path the path of the new widget
# name the name of the widget
# object the object
# command the command on the button

proc makeEnumButton {path name object command} {
    set methods [$object ?]
    set setCommandlist {}
    set getCommandlist {}
    foreach method $methods {
	if [string compare "-$command" [lindex $method 0]] {} {
	    set setCommandlist $method
	}
	if [string compare "-get_$command" [lindex $method 0]] {} {
	    set getCommandlist $method
	}
    }
    
    if [string length $setCommandlist]&&[string length $getCommandlist] {} {
	puts stderr "Error on command list in makeMenubutton for command $command."
	return
    }
    
    set setCMD -$command
    set getCMD -get_$command
    
    
    if ![regexp "{ENUM\[ \]*1\[ \]*\"\[^\"\]*\"\[ \]*}" $setCommandlist enumList] {
	puts stderr "The command $command has no enum value as argument 1"
    }

    regsub "{ENUM\[ \]*1\[ \]*\"" $enumList "" enumList
    regsub "\"\[ \]*}" $enumList "" enumList
    
    if ![regexp "{ARG\[ \]*1\[ \]*\[^\}\]*}" $setCommandlist argname] {
	puts stderr "The command $command has no argname for argument 1"
    }
    
    regsub "\{ARG\[ \]*1\[ \]*" $argname "" argname
    regsub "\[ \]*\}" $argname "" argname
    
    frame $path.$name -relief raised -border 1
    pack append $path $path.$name {fill expand left}
    
    frame $path.$name.f -border 5
    pack append $path.$name $path.$name.f {fill expand left}
    
    button  $path.$name.f.l -text $argname -relief flat -border 1\
	    -command "rt_Output.info $setCommandlist" 
    catch "$path.$name.f.l configure -cursor question_arrow"
    
    
    pack append $path.$name.f $path.$name.f.l {fill expand}
    
    
    menubutton $path.$name.f.b \
	    -text [lindex $enumList [$object $getCMD]]\
	    -menu $path.$name.f.b.m\
	    -width 10 -relief raised -border 1
    
    pack append $path.$name.f $path.$name.f.b {fill expand left}
    
    set mbutton $path.$name.f.b
    
    menu $mbutton.m
    
    set count 0
    foreach val $enumList {
	$mbutton.m add command -label $val \
		-command "$object $setCMD $count;\
		$mbutton configure -text [lindex $enumList $count]"
	incr count
    }
    return "$mbutton configure -text \[lindex \"$enumList\" \[$object $getCMD\]\]"
}

################################################
#
# define  a 2 button valuator
#
################################################

proc 2buttonValuator {path name object command} {
    set methods [$object ?]
    set setCommandlist {}
    set getCommandlist {}
    foreach method $methods {
	if [string compare "-$command" [lindex $method 0]] {} {
	    set setCommandlist $method
	}
	if [string compare "-get_$command" [lindex $method 0]] {} {
	    set getCommandlist $method
	}
    }
    
    if [string length $setCommandlist]&&[string length $getCommandlist] {} {
	puts stderr "Error on command list in makeMenubutton for command $command."
	return
    }
    
    set setCMD -$command
    set getCMD -get_$command

    if ![regexp "{ARG\[ \]*1\[ \]*\[^\}\]*}" $setCommandlist argname] {
	puts stderr "The command $command has no argname for argument 1"
    }
    
    regsub "\{ARG\[ \]*1\[ \]*" $argname "" argname
    regsub "\[ \]*\}" $argname "" argname
    
    frame $path.$name -relief raised -border 1
    pack append $path $path.$name {fill expand left}
    
    frame $path.$name.f -border 5
    pack append $path.$name $path.$name.f {fill expand left}
    
    button  $path.$name.f.l -text $argname -relief flat -border 1\
	    -command "rt_Output.info $setCommandlist" 
    catch "$path.$name.f.l configure -cursor question_arrow"
    
    pack append $path.$name.f $path.$name.f.l {fill expand}
    
    frame $path.$name.f.b
    pack append $path.$name.f $path.$name.f.b {fill expand}
    
    button $path.$name.f.b.b1 \
	    -text -\
	    -command "$object $setCMD \[expr \[$object $getCMD\]/1.2\];\
	    $path.$name.f.b.l configure -text \[$object $getCMD\]"\
	    -width 2 -relief raised -border 1
    
    button $path.$name.f.b.b2 \
	    -text +\
	    -command "$object $setCMD \[expr \[$object $getCMD\]*1.2\];\
	    $path.$name.f.b.l configure -text \[$object $getCMD\]"\
	    -width 2 -relief raised -border 1
    
    button $path.$name.f.b.l \
	    -text [$object $getCMD]\
	    -command "$object $setCMD 1.0;\
	    $path.$name.f.b.l configure -text \[$object $getCMD\]"\
	    -width 8 -relief raised -border 1
    
    pack append $path.$name.f.b \
	    $path.$name.f.b.b1 {fill expand left}\
	    $path.$name.f.b.l {fill expand left}\
	    $path.$name.f.b.b2 {fill expand left}
    
    return " $path.$name.f.b.l configure -text \[$object $getCMD\]"
}

################################################
#
# define a command button
#
################################################

proc makeButton {path name object command} {
    set methods [$object ?]
    set setCommandlist {}
    set getCommandlist {}
    foreach method $methods {
	if [string compare "-$command" [lindex $method 0]] {} {
	    set setCommandlist $method
	}
    }
    
    if [string length $setCommandlist] {} {
	puts stderr "Error on command list in makeMenubutton for command $command."
	return
    }
    
    set setCMD -$command
    
    set argname $command
    
    frame $path.$name -relief raised -border 1
    pack append $path $path.$name {fill expand left}

    frame $path.$name.f -border 5
    pack append $path.$name $path.$name.f {fill expand left}
    
    button  $path.$name.f.l -text $argname -relief flat -border 1\
	    -command "rt_Output.info $setCommandlist" 
    catch "$path.$name.f.l configure -cursor question_arrow"
    
    pack append $path.$name.f $path.$name.f.l {fill expand}
    
    button $path.$name.f.b \
	    -text "Do it!"\
	    -command "$object $setCMD"\
	    -width 10 -relief raised -border 1

    pack append $path.$name.f $path.$name.f.b {fill expand left}
    
    return ""
    
}




