//  LAST EDIT: Fri Jul  1 12:47:01 1994 by Barth(@prakinf.tu-ilmenau.de)
#ifndef __3DLAT_H__
#define __3DLAT_H__
////////////////////////////////////////////////////////////////////////////////
// Declarations of the Implementation Level for Sci.Visualization.            //  
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//              barth@prakinf.tu-ilmenau.de                                   //
//	        ekki@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////
#include "base.h"
#include "2d_lat.h"
#include "coord.h"

typedef void (*D3LatGetParamFunc)( const ParamSet &pS, int _x, int _y, int _z, int dimX, int dimY, double *p );

class RT_3DLattice: public RT_3DGeometry, public RT_Lattice {
static RT_ParseEntry table[];
static int walkF, parF;
static char *walkV, *parV;

protected:
  int newDims;
  double walkerShiftXY, walkerShiftXZ, walkerShiftYZ;
  D3LatGetParamFunc l3Dgetfunc[MAX_PARAM];
public:
  RT_2DPerimetricLattice *pl2d[6], *walkPlane[3];
  RT_3DLattice( char * _name): 
RT_3DGeometry(),RT_Lattice(_name) /* , RT_Scientific( _name) */ {
      char tmp[100];
      sprintf(tmp, "%s%s", _name, "_BackPlane" );
      pl2d[0] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_FrontPlane" );
      pl2d[1] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_LeftPlane" );
      pl2d[2] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_RightPlane" );
      pl2d[3] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_BottomPlane" );
      pl2d[4] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_TopPlane" );
      pl2d[5] = new RT_2DPerimetricLattice( tmp );
      for (int i=0; i<6; i++ ) {
	  pl2d[i]->father( this );
      }
      sprintf(tmp, "%s%s", _name, "_WalkPlaneXY" );
      walkPlane[ XY ] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_WalkPlaneXZ" );
      walkPlane[ XZ ] = new RT_2DPerimetricLattice( tmp );
      sprintf(tmp, "%s%s", _name, "_WalkPlaneYZ" );
      walkPlane[ YZ ] = new RT_2DPerimetricLattice( tmp );
      for ( i=0; i<3; i++ ) {
	  walkPlane[i]->father( this );
	  walkPlane[i]->invisible();
      }
      newDims = 0;
  }
  void create();
  void createGeometry();
// create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms
private:
  void printParams( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      for ( int n=0; n<MAX_PARAM; n++ ) if ( paramData[n].loaded ) {
	  fprintf( f, " -loadParameters { %i {", n );
	  double *p = new double[ dims[0] * dims[1] * dims[2]];
	  for ( int i=0; i < dims[0]; i++ ) 
	      for ( int j=0; j < dims[1]; j++ ) 
		  for ( int k=0; k < dims[2]; k++ ) 
		      getParameter( n, i, j, k, &p[ dims[0] * dims[1] * k + i * dims[1] + j] );
	  for ( i=0; i< (dims[0] * dims[1] * dims[2]); i++ ) fprintf( f, " %lf", p[i] );
	  fprintf( f, " } }" );
	  delete p;
      }
  }
public:
  void loadParameters( int _np, RT_ScType _pt, double *_p );
  void loadParameters( int _np, RT_ScType _pt, float *_p );
  void loadParameters( int _np, RT_ScType _pt, int *_p );
  void loadParameters( int _np, RT_ScType _pt, char *_p );
  void setParamType( int _pnr, RT_ScType _pt );
  void initPlanes();
  void setPlaneParameters( int _pnr );
  void setVertex(int *, double*);
  void getVertex(int *, double*)const;
  int objectCMD(char *argv[]);

  void setParameter(int pnr, int _x, int _y, int _z, double _p );
  void setParameter(int pnr, int _x, int _y, int _z, float _p );
  void setParameter(int pnr, int _x, int _y, int _z, int _p );
  void setParameter(int pnr, int _x, int _y, int _z, char _p );
  void getParameter(int pnr, int _x, int _y, int _z, double *_p )const;
  void getParExtremes( int pnr, double *pmin, double *pmax );
  void setParExtremes( int _pnr, double _pmin, double _pmax ) {
      paramData[_pnr].Pmin = _pmin;
      paramData[_pnr].Pmax = _pmax;
  }
  void updateParExtremes( int _pnr ) {
      double pmin, pmax;
      getParExtremes( _pnr, &pmin, &pmax );
      setParExtremes( _pnr, pmin, pmax );
  }
  void walkto( RT_PlaneType _ps, int _wpnr );
  void map( int _pnr, RT_MapType _mt ) {
      if ( _mt != Z_MAP ) {
	  for ( int i=0; i<6; i++ ) pl2d[i]->map( _pnr, _mt );
	  for ( i=0; i<3; i++ ) walkPlane[i]->map( _pnr, _mt );
      }
      RT_Scientific::map( _pnr, _mt );
  }
  void unmap( int _pnr, RT_MapType _mt ) {
      for ( int i=0; i<6; i++ ) pl2d[i]->unmap( _pnr, _mt );
      for ( i=0; i<3; i++ ) walkPlane[i]->unmap( _pnr, _mt );
      RT_Scientific::unmap( _pnr, _mt );
  }
  void gridmode( RT_GridMode _gm ) {
      for ( int i=0; i<6; i++ ) pl2d[i]->gridmode( _gm);
      for ( i=0; i<3; i++ ) walkPlane[i]->gridmode( _gm );
      RT_Scientific::gridmode( _gm );
  }
  void isomode( RT_IsoMode _im ) {
      for ( int i=0; i<6; i++ ) pl2d[i]->isomode( _im );
      for ( i=0; i<3; i++ ) walkPlane[i]->isomode( _im );
      RT_Scientific::isomode( _im );
  }
  void isolevel( int _nr, double _lev, RT_Color _c ) {
      for ( int i=0; i<6; i++ ) pl2d[i]->isolevel( _nr, _lev, _c );
      for ( i=0; i<3; i++ ) walkPlane[i]->isolevel( _nr, _lev, _c );
      RT_Scientific::isolevel( _nr, _lev, _c );
  }
  void hslmap( double _hmin, double _hmax, double _sat, double _val ) {
      for ( int i=0; i<6; i++ ) pl2d[i]->hslmap( _hmin, _hmax, _sat, _val );
      for ( i=0; i<3; i++ ) walkPlane[i]->hslmap( _hmin, _hmax, _sat, _val );
      RT_Scientific::hslmap( _hmin, _hmax, _sat, _val );
  }
  void print(FILE *f)const { 
      RT_Scientific::print( f );
  }
};




#define RTN_3D_U_LATTICE "3DUniformLattice"

class RT_3DUniformLattice: public RT_3DLattice {
public:
  RT_3DUniformLattice( char *_name ) : RT_3DLattice(_name) /* , RT_Scientific(_name) */ {
  }
  static RT_ParseEntry table[];
  static int ugeoF;
  static char *ugeoV;
  double x0, y0, z0, dx, dy, dz;
  void createGeometry();
  // create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms
private:
  void printGeometry( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      if ( (dims[0]) && (dims[1]) && (dims[2]) ) fprintf( f, "-loadGeometry { %i %i %i %lf %lf %lf %lf %lf %lf }", dims[0], dims[1], dims[2], x0, y0, z0, dx, dy, dz );
  }
public:
  void loadGeometry( int _nx, int _ny, int _nz, double _x0, double _y0, double _z0, double _dx, double _dy, double _dz );
  const char *get_class()const { return RTN_3D_U_LATTICE; }
  int isA(const char *)const;
  
  //#### the tcl commands:
  int objectCMD(char *argv[]);  
  static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
  const char *get_description()const { return "A 3D uniform lattice."; }
  void printCon(FILE *f)const { 
      printf(" print con \n");
      RT_Primitive::printCon( f );
  }
  void print(FILE *f)const { 
      fprintf( f, "\n");
      RT_3DLattice::print( f );
  }
};



#define RTN_3D_P_LATTICE "3DPerimetricLattice"

class RT_3DPerimetricLattice: public RT_3DLattice {
public:
  RT_3DPerimetricLattice( char *_name ) : RT_3DLattice(_name) /* , RT_Scientific(_name) */ {
  }
  static RT_ParseEntry table[];
  static int pgeoF;
  static char *pgeoV;
  void createGeometry();
  // create the geometry from file or numerical algorithms
  void createParameters();
  // create the parameters from file or numerical algorithms
private:
  void printGeometry( FILE *f )const {
      fprintf( f, "\n%s ", get_name() );
      if ( (dims[0]) && (dims[1]) && (dims[2]) ) {
	  fprintf( f, "-loadGeometry { %i %i %i { ", dims[0], dims[1], dims[2] );
	  int indices[3];
	  double vtx[4], *vx, *vy, *vz;
	  vx = new double[dims[0]]; vy = new double[dims[1]]; vz = new double[dims[2]];
	  for ( int i=0; i < dims[0]; i++ ) 
	      for ( int j=0; j < dims[1]; j++ ) 
		  for ( int k=0; k<dims[2]; k++ ) {
		      indices[0] = i; indices[1] = j; indices[2] = k;
		      getVertex( indices, vtx );
		      vx[i] = vtx[0]; vy[j] = vtx[1]; vz[k] = vtx[2];
		  }
	  for ( i=0; i<dims[0]; i++ ) fprintf( f, "%lf ", vx[i] );
	  fprintf( f, "} { " );
	  for ( i=0; i<dims[1]; i++ ) fprintf( f, "%lf ", vy[i] );
	  fprintf( f, "} { " );
	  for ( i=0; i<dims[2]; i++ ) fprintf( f, "%lf ", vz[i] );
	  fprintf( f, "} }" );
	  delete vx; delete vy; delete vz;
      }
  }
public:
  void loadGeometry( int _nx, int _ny, int _nz, double *_x, double *_y, double *_z );
  const char *get_class()const { return RTN_3D_P_LATTICE; }
  int isA(const char *)const;
  
  //#### the tcl commands:
  int objectCMD(char *argv[]);  
  static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
  const char *get_description()const { return "A 3D uniform lattice."; }
  void printCon(FILE *f)const { 
      RT_Primitive::printCon( f );
  }
  void print(FILE *f)const { 
      RT_3DLattice::print( f );
      fprintf( f, "\n");
  }
};

#endif
