/*
 * InterpStream.cc - iostream for tcl interpreters
 * 
 * -------------------------------------------------------
 * Copyright 1993 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  Allan
 * Brighton make no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 * --------------------------------------------------------
 */


#include <InterpStream.h>


/*
 * Evaluate the tcl command in the stream buffer
 */
InterpStream& InterpStream::eval()
{
   // make sure str is null terminated
   *this << ends;
   
   // eval the command and set the status
   char* s = str();
   if (Tcl_Eval(interp_, s) != TCL_OK) {
       cerr << "Warning: InterpStream::eval failed: " << s << endl;
       status_ = -1;
   }
   else {
       status_ = 0;
   }
   
   // reset the stream for the next command    
   clear(0);
   rdbuf()->freeze(0);
   seekp(0);
   
   return *this;
}


/*
 * Set the tcl result from the stream buffer
 */
InterpStream& InterpStream::result()
{
   // make sure str is null terminated
   *this << ends;
   
   Tcl_AppendResult(interp_, str(), 0);
   
   // reset the stream so we can keep using the string    
   clear(0);
   rdbuf()->freeze(0);
   seekp(0);
   
   return *this;
}


InterpStream& operator<<(ostream& os, Eval_)
{
    return ((InterpStream&)os).eval();
}

InterpStream& operator<<(ostream& os, Result_)
{
    return ((InterpStream&)os).result();
}

