# LAST EDIT: Wed Nov 30 09:55:07 1994 by ekki(@prakinf.tu-ilmenau.de)

#option add *Font 7x13

IOM_TopBox ?
	

# check tmp dir

if ![file isdir $env(HOME)/tmp] {
    catch { puts stdout "VR_USER fatal error: Couldn't open directory $env(HOME)/tmp. Create this directory and start the program again."}
    exit
}

# setup global variables:

set vr_AutoUpdate 1
set vr_UID 0
# UID will be set to non-zero if login was successful
set vr_N0 0
# NO will be set, too

Tcl_Object VR_User IOM_TopBox {lastCommand executing} {Name} {String} \
	{Creates the YART/VR dialog widget called {ARG 1 Name}.} \
	{
    wm title . "[exec whoami] in ?"
    wm protocol . WM_DELETE_WINDOW "VR_logout"
    set path [set $THIS->frCenter]

    # create YART pixmap:
    frame $path.f
    $path.f configure -width 10 -relief sunken 
    pack append $path $path.f {top fill}
    
    frame $path.f.f
    pack append $path.f $path.f.f {expand fill}

    PixmapDisplay $path.f.f.d 400 400
    pack append $path.f.f $path.f.f.d {left expand fill}
    update

    # create the following objects globally:
    LookatCamera vr_Cam {0 0 10} { 0 0 0 }
    vr_Cam -znear 0.2
    Scene sc 

    vr_Cam -scene sc -pixmap $path.f.f.d

    # zooming:
    scale $path.f.f.sc -relief raise -orient vertical\
	    -label Zoom -from 10 -to 160 -showvalue 0 -width 5 -sliderlength 15 -command "vr_Cam -angle \[$path.f.f.sc get\]; $THIS -update" 
    $path.f.f.sc set 60
    pack append $path.f.f $path.f.f.sc {right filly}

    # twist:
    scale $path.f.tw -relief raise -orient horizontal\
	    -label Twist -from -180 -to 180 -showvalue 0 -width 5 -sliderlength 15 -command "vr_Cam -twist \[$path.f.tw get\]; $THIS -update" 
    $path.f.tw set 0
    pack append $path.f $path.f.tw {expand fill}

    # create the control dialog:
    frame $path.f0
    pack append $path $path.f0 { top fill }

    label $path.f0.l0 -text "IPC" -relief raise
    global vr_Background
    set vr_Background [lindex [$path.f0.l0 configure -background] 4]
    checkbutton $path.f0.l1 -text Autoupdate -variable vr_AutoUpdate
    button $path.f0.l2 -text "Update" -command  "vr_Cam -rendering"
    button $path.f0.l3 -text "Reset" -command "$THIS -reset"
    button $path.f0.l4 -text "Clear" -command  "$THIS -clear"
    button $path.f0.l5 -text "Help" -command  "$THIS -message {Textual commands:
    say ... -> broadcast a message to all users
    call ... -> call a method of your representation
    exit -> exit the scene
  Mouse commands:
    left button down -> pick operation
    right button pressed + left motion -> turn left
    right button pressed + right motion -> turn right
    right button pressed + forward motion -> go ahead
    right button pressed + backward motion -> go back
    middle and right button pressed + forward motion -> go upwards
    middle and right button pressed + backward motion -> go downwards
  Button commands:
    Autoupdate -> turn on/off autoupdating for scene and camera changes
    Update -> force an explicit update
    Reset -> reset scene position, twist and zoom to the initial values
    Clear -> clear text and message window
    Help -> print help text
    Show me -> show your representation
    Exit -> exit the scene}"
    button $path.f0.l6 -text "Show me" -command  "VR_showMe"
    button $path.f0.l7 -text "Exit" -command  "VR_logout"

    label $path.f0.ln -relief raise

    pack append $path.f0 \
	    $path.f0.l0 {left fill}\
	    $path.f0.l1 {left fill}\
	    $path.f0.l2 {left fill}\
	    $path.f0.l3 {left fill}\
	    $path.f0.l4 {left fill}\
	    $path.f0.l5 {left fill}\
	    $path.f0.l6 {left fill}\
	    $path.f0.l7 {left fill}\
	    $path.f0.ln {expand fill left}

    # create the message window:
    frame $path.f1
    pack append $path $path.f1 { top expand fill }
    text $path.f1.t -relief raised -bd 2 -yscrollcommand " $path.f1.s set" -setgrid true -height 3
    scrollbar $path.f1.s -relief flat -command "$path.f1.t yview"
    pack append $path.f1 $path.f1.t {expand fill left} $path.f1.s {left fill} 

    # set up message text window bindings to no-op:
    bind $path.f1.t <Any-Key> {set x x}
    bind $path.f1.t <Any-Button> {set x x}

    # create the dialog window:
    frame $path.f2
    pack append $path $path.f2 { top fill }
    text $path.f2.t -relief raised -bd 2 -yscrollcommand " $path.f2.s set" -setgrid true -height 5
    scrollbar $path.f2.s -relief flat -command "$path.f2.t yview"
    pack append $path.f2 $path.f2.t {expand fill left} $path.f2.s {left fill} 

    # set up bindings for text to forward commands to the interpreter.
    bind $path.f2.t <1> {
	set tk_priv(selectMode) char
	%W mark set anchor @%x,%y
	if {[lindex [%W config -state] 4] == "normal"} {focus %W}
    }
    bind $path.f2.t <Double-1> {
	set tk_priv(selectMode) word
	tk_textSelectTo %W @%x,%y
    }
    bind $path.f2.t <Triple-1> {
	set tk_priv(selectMode) line
	tk_textSelectTo %W @%x,%y
    }
    bind $path.f2.t <Control-u> {
	%W delete "insert linestart +  3 chars" "insert lineend"
	%W yview -pickplace insert
    }
    bind $path.f2.t <Return> "%W insert insert \\n ; $THIS -invoke"
    bind $path.f2.t <BackSpace> "$THIS -backspace"
    bind $path.f2.t <Delete> "$THIS -backspace"
    bind $path.f2.t <Control-h> "$THIS -backspace"
    bind $path.f2.t <Control-v> "\
	    %W insert insert \[selection get\];\
	    %W yview -pickplace insert;\
	    if \[string match *.0 \[%W index insert\]\] {\
	    $THIS -invoke\
	} ;"
    
    bind $path.f2.t <2> "\
	    %W insert insert \[selection get\];\
	    %W yview -pickplace insert;\
	    if \[string match *.0 \[%W index insert\]\] {\
	    $THIS -invoke\
	} ;"
    
    $path.f2.t tag configure bold -font *-Courier-Bold-R-Normal-*-120-*
    set $THIS->executing 0
    
    $THIS -prompt
    focus $path.f2.t
    $path.f2.t mark set cmdStart "insert-1c"
}

Tcl_Method VR_User -prompt {} {} {The method is used to print out a prompt at the insertion point .} {
    set path [set $THIS->frCenter]

    $path.f2.t insert "insert linestart" "-> "
    $path.f2.t tag add bold "insert linestart" \
	    "insert linestart + 3 chars"
}

Tcl_Method VR_User -invoke {} {} {The method executes a command. It takes everything on the current line after the prompt and either sends it to the interpreter.} {
    set lastCommand  [set $THIS->lastCommand]
    set path [set $THIS->frCenter]

    set cmd [$path.f2.t get cmdStart+1c insert]
    incr $THIS->executing 1
    if [info complete $cmd] {
	if {$cmd == "!!\n"} {
	    set cmd $lastCommand
	} else {
	    set lastCommand $cmd
	}

	global vr_UID
	if {$vr_UID != 0} {
	    set res 0
	    if ![string length $cmd] { set res 1}
	    if {[lindex $cmd 0] == "exit"} VR_logout	    
	    if {[lindex $cmd 0] == "say"} {
		sceneEval "send $vr_UID {{[lrange $cmd 1 end]}}"
		set res 1
	    }
	    if {[lindex $cmd 0] == "call"} {
		sceneEval "command $vr_UID {{[lrange $cmd 1 end]}}"
		set res 1
	    }
	    if !$res {vr_User -message "Bad command! Allowed are \"call\", \"exit\" and \"say\"."}
	} {vr_User -message "You are not in a scene!"}
	$THIS -prompt
	$path.f2.t mark set cmdStart insert-1c
    }
    incr $THIS->executing -1
    $path.f2.t yview -pickplace insert
    
    set  $THIS->lastCommand  $lastCommand
}

Tcl_Method VR_User -backspace {} {} {The method handles backspaces, being careful not to backspace over the prompt.} {
    set path [set $THIS->frCenter]
    scan [$path.f2.t index insert] %*d.%d char
    if {$char > 3} {
	$path.f2.t delete insert-1c insert
	$path.f2.t yview -pickplace insert
    }
}

Tcl_Method VR_User -clear {} {} {Clear the text widgets.} {
    set path [set $THIS->frCenter]
    $path.f1.t delete 0.0 end
    $path.f2.t delete 0.0 end
    set $THIS->executing 0
    set $THIS->lastCommand ""
    $THIS -prompt
    $path.f2.t mark set cmdStart "insert-1c"
}

Tcl_Method VR_User -reset {} {} {Reset position, twist and zoom.} {
    set path [set $THIS->frCenter]
    $path.f.tw set 0
    $path.f.f.sc set 60
    global vr_UID
    if {$vr_UID != 0} {sceneEval "resetPosition $vr_UID" }
}

Tcl_Method VR_User -update {} {} {Update the display.} {
    global vr_AutoUpdate
    if $vr_AutoUpdate "vr_Cam -rendering"
}

Tcl_Method VR_User -message Txt String {Put {ARG 1 Message} into the message window.} {
    set path [set $THIS->frCenter]
    $path.f1.t insert end "* $Txt\n"
    set ip [$path.f1.t index insert]
    after 100 "$path.f1.t yview -pickplace $ip"
}

Tcl_Method VR_User -transfer {} {} { Switch transfer flag on and of.} {
    set path [set $THIS->frCenter]  
    global vr_Background
    $path.f0.l0 configure -background yellow
    update
    after 100 "$path.f0.l0 configure -background $vr_Background"
}

VR_User vr_User
VR_Manipulator vr_Man
vr_Man -off -father vr_Cam

proc VR_userMessage msg {
    vr_User -message $msg
}

proc VR_login {args} {
    global vr_Scene
    wm title . "[exec whoami] in $vr_Scene"
    vr_Man -on
    catch { puts stdout "VR_USER message: Now loading the initial scene description from $vr_Scene. Compressed scene dumps are usually larger than 10 kbytes. Thus be patient ..."}
    vr_User -message "Now loading the scene ..."
    update
}

proc VR_showMe {} {
    set vp [vr_Cam -get_viewpoint]
    set rp [vr_Cam -get_refpoint]

    vr_Cam -refpoint $vp
    vr_Cam -viewpoint $rp

    vr_Cam -rendering
    vr_Cam -viewpoint $vp
    vr_Cam -refpoint $rp
}

proc VR_logout {} {
    global vr_UID 
    if {$vr_UID != 0} { sceneEval "logout $vr_UID" }   
    catch { puts stdout "VR_USER message: Exiting ..." }
    exit
}

trace variable vr_UID w VR_login

vr_Cam -rendering
